/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DefaultTimeline;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCpuCapture
implements CpuCapture {
    private final int myMainThreadId;
    @NotNull
    private ClockType myClockType;
    @NotNull
    private final Set<CpuThreadInfo> myAvailableThreads;
    @NotNull
    private final Map<Integer, CaptureNode> myThreadIdToNode;
    @NotNull
    private final Timeline myTimeline;
    private final long myTraceId;
    @NotNull
    private final Cpu.CpuTraceType myType;

    /*
     * WARNING - void declaration
     */
    public BaseCpuCapture(long traceId, @NotNull Cpu.CpuTraceType type, @NotNull Range range, @NotNull Map<CpuThreadInfo, CaptureNode> map) {
        void captureTrees;
        if (type == null) {
            BaseCpuCapture.$$$reportNull$$$0(0);
        }
        if (range == null) {
            BaseCpuCapture.$$$reportNull$$$0(1);
        }
        if (map == null) {
            BaseCpuCapture.$$$reportNull$$$0(2);
        }
        this.myTimeline = new DefaultTimeline();
        this.myTraceId = traceId;
        this.myType = type;
        this.myTimeline.getDataRange().set(range);
        this.myTimeline.getViewRange().set(range);
        Preconditions.checkState((!captureTrees.isEmpty() ? 1 : 0) != 0, (Object)"Trace file contained no CPU data.");
        ImmutableSet.Builder availableThreadsBuilder = ImmutableSet.builder();
        ImmutableMap.Builder threadIdToNodesBuilder = ImmutableMap.builder();
        Integer mainThreadId = null;
        Integer longestThreadId = null;
        Long longestThreadSpan = null;
        for (Map.Entry entry : captureTrees.entrySet()) {
            availableThreadsBuilder.add((Object)((CpuThreadInfo)entry.getKey()));
            threadIdToNodesBuilder.put((Object)((CpuThreadInfo)entry.getKey()).getId(), (Object)((CaptureNode)entry.getValue()));
            if (mainThreadId == null && ((CpuThreadInfo)entry.getKey()).isMainThread()) {
                mainThreadId = ((CpuThreadInfo)entry.getKey()).getId();
                continue;
            }
            if (longestThreadSpan != null && longestThreadSpan >= ((CaptureNode)entry.getValue()).getDuration()) continue;
            longestThreadId = ((CpuThreadInfo)entry.getKey()).getId();
            longestThreadSpan = ((CaptureNode)entry.getValue()).getDuration();
        }
        this.myAvailableThreads = availableThreadsBuilder.build();
        this.myThreadIdToNode = threadIdToNodesBuilder.build();
        this.myMainThreadId = mainThreadId != null ? mainThreadId.intValue() : longestThreadId.intValue();
        CaptureNode mainNode = this.getCaptureNode(this.myMainThreadId);
        assert (mainNode != null);
        this.myClockType = mainNode.getClockType();
    }

    @Override
    public int getMainThreadId() {
        return this.myMainThreadId;
    }

    @Override
    @NotNull
    public Timeline getTimeline() {
        Timeline timeline = this.myTimeline;
        if (timeline == null) {
            BaseCpuCapture.$$$reportNull$$$0(3);
        }
        return timeline;
    }

    @Override
    @Nullable
    public CaptureNode getCaptureNode(int threadId) {
        return this.myThreadIdToNode.get(threadId);
    }

    @Override
    @NotNull
    public Set<CpuThreadInfo> getThreads() {
        Set<CpuThreadInfo> set = this.myAvailableThreads;
        if (set == null) {
            BaseCpuCapture.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<CaptureNode> getCaptureNodes() {
        Collection<CaptureNode> collection = this.myThreadIdToNode.values();
        if (collection == null) {
            BaseCpuCapture.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    public boolean containsThread(int threadId) {
        return this.getCaptureNode(threadId) != null;
    }

    @Override
    public long getTraceId() {
        return this.myTraceId;
    }

    @Override
    public void updateClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            BaseCpuCapture.$$$reportNull$$$0(6);
        }
        if (this.myClockType == clockType) {
            return;
        }
        this.myClockType = clockType;
        for (CaptureNode tree : this.getCaptureNodes()) {
            if (tree == null) continue;
            tree.getDescendantsStream().forEach(node -> node.setClockType(clockType));
        }
    }

    @Override
    public boolean isDualClock() {
        return this.myType == Cpu.CpuTraceType.ART;
    }

    @Override
    @NotNull
    public Cpu.CpuTraceType getType() {
        Cpu.CpuTraceType cpuTraceType = this.myType;
        if (cpuTraceType == null) {
            BaseCpuCapture.$$$reportNull$$$0(7);
        }
        return cpuTraceType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureTrees";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/BaseCpuCapture";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/BaseCpuCapture";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeline";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureNodes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateClockType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

