/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfilers;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Stage<T extends Timeline>
extends AspectObserver {
    protected static final long PROFILING_INSTRUCTIONS_EASE_OUT_NS = TimeUnit.SECONDS.toNanos(3L);
    private final StudioProfilers myProfilers;
    private ProfilerMode myProfilerMode;
    @Nullable
    private TooltipModel myTooltip;

    public Stage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            Stage.$$$reportNull$$$0(0);
        }
        this.myProfilerMode = ProfilerMode.NORMAL;
        this.myProfilers = profilers;
    }

    @NotNull
    public StudioProfilers getStudioProfilers() {
        StudioProfilers studioProfilers = this.myProfilers;
        if (studioProfilers == null) {
            Stage.$$$reportNull$$$0(1);
        }
        return studioProfilers;
    }

    @NotNull
    public abstract T getTimeline();

    public abstract void enter();

    public abstract void exit();

    @NotNull
    public final ProfilerMode getProfilerMode() {
        ProfilerMode profilerMode = this.myProfilerMode;
        if (profilerMode == null) {
            Stage.$$$reportNull$$$0(2);
        }
        return profilerMode;
    }

    @Nullable
    public TooltipModel getTooltip() {
        return this.myTooltip;
    }

    protected final void setProfilerMode(@NotNull ProfilerMode profilerMode) {
        if (profilerMode == null) {
            Stage.$$$reportNull$$$0(3);
        }
        if (this.myProfilerMode != profilerMode) {
            this.myProfilerMode = profilerMode;
            this.getStudioProfilers().modeChanged();
        }
    }

    public void setTooltip(TooltipModel tooltip2) {
        if (tooltip2 != null && this.myTooltip != null && tooltip2.getClass().equals(this.myTooltip.getClass())) {
            return;
        }
        if (this.myTooltip != null) {
            this.myTooltip.dispose();
        }
        this.myTooltip = tooltip2;
        this.getStudioProfilers().changed(ProfilerAspect.TOOLTIP);
    }

    @NotNull
    public Stage<?> getParentStage() {
        return new StudioMonitorStage(this.getStudioProfilers());
    }

    @NotNull
    public Class<? extends Stage> getHomeStageClass() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (clazz == null) {
            Stage.$$$reportNull$$$0(4);
        }
        return clazz;
    }

    @Nullable
    public String getConfirmExitMessage() {
        return null;
    }

    public boolean isInteractingWithTimeline() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/Stage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/Stage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStudioProfilers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilerMode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeStageClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProfilerMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

