/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.trackgroup.DefaultTrackRenderer;
import com.android.tools.adtui.trackgroup.TrackRenderer;
import com.android.tools.adtui.trackgroup.TrackRendererFactory;
import com.android.tools.profilers.ProfilerTrackRendererType;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.BufferQueueTrackRenderer;
import com.android.tools.profilers.cpu.CpuCoreTrackRenderer;
import com.android.tools.profilers.cpu.CpuFrequencyTrackRenderer;
import com.android.tools.profilers.cpu.CpuThreadTrackRenderer;
import com.android.tools.profilers.cpu.FramesTrackRenderer;
import com.android.tools.profilers.cpu.RssMemoryTrackRenderer;
import com.android.tools.profilers.cpu.SurfaceflingerTrackRenderer;
import com.android.tools.profilers.cpu.VsyncTrackRenderer;
import com.android.tools.profilers.customevent.CustomEventTrackRenderer;
import com.android.tools.profilers.event.LifecycleTrackRenderer;
import com.android.tools.profilers.event.UserEventTrackRenderer;
import org.jetbrains.annotations.NotNull;

public class ProfilerTrackRendererFactory
implements TrackRendererFactory<ProfilerTrackRendererType> {
    @NotNull
    private final StudioProfilersView myProfilersView;

    public ProfilerTrackRendererFactory(@NotNull StudioProfilersView profilersView) {
        if (profilersView == null) {
            ProfilerTrackRendererFactory.$$$reportNull$$$0(0);
        }
        this.myProfilersView = profilersView;
    }

    @NotNull
    public TrackRenderer<?, ProfilerTrackRendererType> createRenderer(@NotNull ProfilerTrackRendererType rendererType) {
        if (rendererType == null) {
            ProfilerTrackRendererFactory.$$$reportNull$$$0(1);
        }
        switch (rendererType) {
            case APP_LIFECYCLE: {
                return new LifecycleTrackRenderer();
            }
            case USER_INTERACTION: {
                return new UserEventTrackRenderer();
            }
            case FRAMES: {
                return new FramesTrackRenderer();
            }
            case SURFACEFLINGER: {
                return new SurfaceflingerTrackRenderer();
            }
            case VSYNC: {
                return new VsyncTrackRenderer();
            }
            case BUFFER_QUEUE: {
                return new BufferQueueTrackRenderer();
            }
            case CPU_THREAD: {
                return new CpuThreadTrackRenderer(this.myProfilersView);
            }
            case CPU_CORE: {
                return new CpuCoreTrackRenderer();
            }
            case CPU_FREQUENCY: {
                return new CpuFrequencyTrackRenderer();
            }
            case RSS_MEMORY: {
                return new RssMemoryTrackRenderer();
            }
            case CUSTOM_EVENTS: {
                return new CustomEventTrackRenderer();
            }
        }
        return new DefaultTrackRenderer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererType";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/ProfilerTrackRendererFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

