/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import io.grpc.StatusRuntimeException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

public abstract class PollRunner
implements RunnableFuture<Void> {
    public static final long POLLING_DELAY_NS = TimeUnit.MILLISECONDS.toNanos(250L);
    private long myPollPeriodNs;
    private boolean myIsRunning = false;
    private CountDownLatch myRunning = new CountDownLatch(1);
    private CountDownLatch myIsDone = new CountDownLatch(1);

    public PollRunner(long pollPeriodNs) {
        this.myPollPeriodNs = pollPeriodNs;
    }

    public void stop() {
        this.cancel(true);
        try {
            this.get();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.myIsRunning = true;
            while (this.myRunning.getCount() > 0L) {
                long startTimeNs = System.nanoTime();
                this.poll();
                long sleepTime = Math.max(this.myPollPeriodNs - (System.nanoTime() - startTimeNs), 0L);
                this.myRunning.await(sleepTime, TimeUnit.NANOSECONDS);
            }
        }
        catch (StatusRuntimeException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.myIsRunning = false;
            this.myIsDone.countDown();
        }
    }

    public abstract void poll();

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.myRunning.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.myRunning.getCount() == 0L;
    }

    @Override
    public boolean isDone() {
        return this.myIsDone.getCount() == 0L;
    }

    @Override
    public Void get() throws InterruptedException {
        if (this.myIsRunning) {
            this.myIsDone.await();
        }
        return null;
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.myIsRunning) {
            this.myIsDone.await(timeout, unit);
        }
        return null;
    }
}

