/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.parser;

import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.android.layoutinspector.parser.DisplayInfoFactory;
import com.android.layoutinspector.parser.ViewNodeV2Decoder;
import com.android.layoutinspector.parser.ViewPropertyParser;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0002J(\u0010\u0011\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J&\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J$\u0010\u001c\u001a\u00020\u00052\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J$\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\r2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0004H\u0002J\u0010\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\"\u001a\u00020#J(\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0004H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/layoutinspector/parser/ViewNodeV2Parser;", "", "()V", "ids", "", "", "", "mStringTable", "mViews", "", "addChildren", "", "parent", "Lcom/android/layoutinspector/model/ViewNode;", "metaProps", "Lcom/android/layoutinspector/model/ViewProperty;", "childrenProps", "createViewNode", "propMap", "getChildIndex", "", "name", "getProperty", "props", "key", "getPropertyKey", "(Ljava/lang/String;)Ljava/lang/Short;", "getPropertyName", "getStringProperty", "view", "loadProperties", "node", "viewProperties", "parse", "data", "", "reverse", "m", "android.sdktools.layoutinspector"})
public final class ViewNodeV2Parser {
    private Map<String, Short> ids;
    private Map<Short, ? extends Object> mStringTable;
    private final List<Map<Short, Object>> mViews;

    @Nullable
    public final ViewNode parse(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(data)");
        ViewNodeV2Decoder d = new ViewNodeV2Decoder(byteBuffer);
        while (d.hasRemaining()) {
            Object o = d.readObject();
            if (!(o instanceof Map)) continue;
            this.mViews.add((Map)o);
        }
        if (this.mViews.isEmpty()) {
            return null;
        }
        Map<Short, ? extends Object> map = this.mStringTable = this.mViews.remove(this.mViews.size() - 1);
        if (map == null) {
            Intrinsics.throwNpe();
        }
        this.ids = this.reverse(map);
        Map<Short, Object> rootMap = this.mViews.get(0);
        ViewNode root = ViewNodeV2Parser.createViewNode$default(this, rootMap, null, 2, null);
        root.updateNodeDrawn(true);
        return root;
    }

    private final ViewNode createViewNode(Map<Short, ? extends Object> propMap, ViewNode parent) {
        Object hashProperty = this.getProperty(propMap, "meta:__hash__");
        String hash = "";
        if (hashProperty instanceof Integer) {
            String string = Integer.toHexString(((Number)hashProperty).intValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toHexString(hashProperty)");
            hash = string;
        }
        ViewNode node = new ViewNode(parent, this.getStringProperty(propMap, "meta:__name__"), hash);
        this.loadProperties(node, propMap);
        node.setDisplayInfo(DisplayInfoFactory.INSTANCE.createDisplayInfoFromNode(node));
        return node;
    }

    static /* synthetic */ ViewNode createViewNode$default(ViewNodeV2Parser viewNodeV2Parser, Map map, ViewNode viewNode, int n, Object object) {
        if ((n & 2) != 0) {
            viewNode = null;
        }
        return viewNodeV2Parser.createViewNode(map, viewNode);
    }

    private final Object getProperty(Map<Short, ? extends Object> props, String key) {
        Map<Short, ? extends Object> map = props;
        Map<String, Short> map2 = this.ids;
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        Short s = map2.get(key);
        boolean bl = false;
        return map.get(s);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Short> reverse(Map<Short, ? extends Object> m) {
        HashMap r = new HashMap(m.size());
        Map<Short, ? extends Object> map = m;
        boolean bl = false;
        Iterator<Map.Entry<Short, ? extends Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Object value;
            Map.Entry<Short, ? extends Object> entry;
            Map.Entry<Short, ? extends Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            short s = ((Number)entry2.getKey()).shortValue();
            entry2 = entry;
            bl2 = false;
            Object object = value = entry2.getValue();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            ((Map)r).put((String)object, (short)key);
        }
        return r;
    }

    private final Short getPropertyKey(String name) {
        Map<String, Short> map = this.ids;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        return map.get(name);
    }

    private final String getPropertyName(short key) {
        Object v;
        Object object;
        Map<Short, ? extends Object> map = this.mStringTable;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        if (!((object = (v = map.get(key))) instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    private final String getStringProperty(Map<Short, ? extends Object> view, String key) {
        Map<Short, ? extends Object> map = view;
        Short s = this.getPropertyKey(key);
        boolean bl = false;
        Object v = map.get(s);
        if (v instanceof String) {
            return (String)v;
        }
        return "";
    }

    private final int getChildIndex(String name) {
        String string = name;
        int n = StringsKt.indexOf$default((CharSequence)name, (String)"__child__", (int)0, (boolean)false, (int)6, null) + 9;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        string = string3;
        n = 0;
        return Integer.parseInt(string);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadProperties(ViewNode node, Map<Short, ? extends Object> viewProperties) {
        List<ViewProperty> metaProps;
        void $this$mapTo$iv$iv;
        Object fullName;
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap()");
        Map namedProperties = hashMap;
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList()");
        List properties = arrayList;
        HashMap hashMap2 = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap2, (String)"Maps.newHashMap()");
        Map childrenProps = hashMap2;
        for (Map.Entry<Short, ? extends Object> p : viewProperties.entrySet()) {
            if (this.getPropertyName(((Number)p.getKey()).shortValue()) == null) {
                Intrinsics.throwNpe();
            }
            Object value = p.getValue();
            if (StringsKt.startsWith$default((String)fullName, (String)"meta:__child__", (boolean)false, (int)2, null)) {
                childrenProps.put(fullName, value);
                continue;
            }
            ViewProperty property = ViewPropertyParser.INSTANCE.parse((String)fullName, value.toString());
            properties.add(property);
            namedProperties.put(property.getName(), property);
        }
        node.getNamedProperties().putAll(namedProperties);
        node.getProperties().addAll(properties);
        Object $this$map$iv = node.getProperties();
        boolean $i$f$map = false;
        fullName = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ViewProperty viewProperty = (ViewProperty)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            node.addPropertyToGroup((ViewProperty)it);
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        ViewProperty viewProperty = node.getNamedProperties().get("id");
        if (viewProperty != null) {
            $this$map$iv = viewProperty;
            boolean bl = false;
            boolean bl2 = false;
            Object it = $this$map$iv;
            boolean bl3 = false;
            node.setId(((ViewProperty)it).getValue());
        }
        List<ViewProperty> list = metaProps = node.getGroupedProperties().remove("meta");
        if (list == null) {
            Intrinsics.throwNpe();
        }
        this.addChildren(node, list, childrenProps);
    }

    /*
     * WARNING - void declaration
     */
    private final void addChildren(ViewNode parent, List<ViewProperty> metaProps, Map<String, ? extends Object> childrenProps) {
        void $this$mapTo$iv$iv;
        Object v0;
        block4: {
            Iterable iterable = metaProps;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ViewProperty it = (ViewProperty)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"__childCount__")) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        ViewProperty viewProperty = v0;
        if (viewProperty == null) {
            return;
        }
        ViewProperty childCountProp = viewProperty;
        String string = childCountProp.getValue();
        boolean bl = false;
        int childCount = Integer.parseInt(string);
        Iterable $this$sortedBy$iv = childrenProps.entrySet();
        boolean $i$f$sortedBy = false;
        boolean bl4 = false;
        Object[] $this$map$iv = (Object[])CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(this){
            final /* synthetic */ ViewNodeV2Parser this$0;
            {
                this.this$0 = viewNodeV2Parser;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(ViewNodeV2Parser.access$getChildIndex(this.this$0, (String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = ViewNodeV2Parser.access$getChildIndex(this.this$0, (String)it.getKey());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            Object v = it.getValue();
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.Short, kotlin.Any>");
            }
            ViewNode viewNode = this.createViewNode((Map)v, parent);
            collection.add(viewNode);
        }
        List children = (List)destination$iv$iv;
        boolean bl6 = childCount == children.size();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "Expect view node %s to have %d children but instead found %d";
        objectArray = new Object[]{parent, childCount, children.size()};
        boolean bl7 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        Verify.verify((boolean)bl6, (String)string3, (Object[])new Object[0]);
        parent.getChildren().addAll(children);
    }

    public ViewNodeV2Parser() {
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)100);
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayListWithExpectedSize(100)");
        this.mViews = arrayList;
    }

    public static final /* synthetic */ int access$getChildIndex(ViewNodeV2Parser $this, String name) {
        return $this.getChildIndex(name);
    }
}

