/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.parser;

import com.android.layoutinspector.model.DisplayInfo;
import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u001a\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/layoutinspector/parser/DisplayInfoFactory;", "", "()V", "createDisplayInfoFromNode", "Lcom/android/layoutinspector/model/DisplayInfo;", "node", "Lcom/android/layoutinspector/model/ViewNode;", "getBoolean", "", "p", "Lcom/android/layoutinspector/model/ViewProperty;", "defaultValue", "getFloat", "", "getInt", "", "android.sdktools.layoutinspector"})
public final class DisplayInfoFactory {
    public static final DisplayInfoFactory INSTANCE;

    @NotNull
    public final DisplayInfo createDisplayInfoFromNode(@NotNull ViewNode node) {
        ViewProperty visibility;
        String contentDescription;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        int left = this.getInt(node.getProperty("mLeft", "layout:mLeft", "left"), 0);
        int top = this.getInt(node.getProperty("mTop", "layout:mTop", "top"), 0);
        int width = this.getInt(node.getProperty("getWidth()", "layout:getWidth()", "width"), 10);
        int height = this.getInt(node.getProperty("getHeight()", "layout:getHeight()", "height"), 10);
        int scrollX = this.getInt(node.getProperty("mScrollX", "scrolling:mScrollX", "scrollX"), 0);
        int scrollY = this.getInt(node.getProperty("mScrollY", "scrolling:mScrollY", "scrollY"), 0);
        boolean willNotDraw = this.getBoolean(node.getProperty("willNotDraw()", "drawing:willNotDraw()", "willNotDraw"), false);
        boolean clipChildren = this.getBoolean(node.getProperty("getClipChildren()", "drawing:getClipChildren()", "clipChildren"), true);
        float translateX = this.getFloat(node.getProperty("getTranslationX", "drawing:getTranslationX()", "translationX"), 0.0f);
        float translateY = this.getFloat(node.getProperty("getTranslationY", "drawing:getTranslationY()", "translationY"), 0.0f);
        float scaleX = this.getFloat(node.getProperty("getScaleX()", "drawing:getScaleX()", "scaleX"), 1.0f);
        float scaleY = this.getFloat(node.getProperty("getScaleY()", "drawing:getScaleY()", "scaleY"), 1.0f);
        ViewProperty descProp = node.getProperty("accessibility:getContentDescription()", "contentDescription");
        String string = contentDescription = descProp != null && Intrinsics.areEqual((Object)descProp.getValue(), (Object)"null") ^ true ? descProp.getValue() : null;
        if (contentDescription == null) {
            descProp = node.getProperty("text:mText", new String[0]);
            contentDescription = descProp != null && Intrinsics.areEqual((Object)descProp.getValue(), (Object)"null") ^ true ? descProp.getValue() : null;
        }
        boolean isVisible = (visibility = node.getProperty("getVisibility()", "misc:getVisibility()", "visibility")) == null || Intrinsics.areEqual((Object)"0", (Object)visibility.getValue()) || Intrinsics.areEqual((Object)"VISIBLE", (Object)visibility.getValue());
        return new DisplayInfo(willNotDraw, isVisible, left, top, width, height, scrollX, scrollY, clipChildren, translateX, translateY, scaleX, scaleY, contentDescription);
    }

    private final boolean getBoolean(ViewProperty p, boolean defaultValue) {
        if (p != null) {
            boolean bl;
            try {
                bl = Boolean.parseBoolean(p.getValue());
            }
            catch (NumberFormatException e) {
                bl = defaultValue;
            }
            return bl;
        }
        return defaultValue;
    }

    private final int getInt(ViewProperty p, int defaultValue) {
        if (p != null) {
            int n;
            try {
                n = Integer.parseInt(p.getValue());
            }
            catch (NumberFormatException e) {
                n = defaultValue;
            }
            return n;
        }
        return defaultValue;
    }

    private final float getFloat(ViewProperty p, float defaultValue) {
        if (p != null) {
            float f;
            try {
                f = Float.parseFloat(p.getValue());
            }
            catch (NumberFormatException e) {
                f = defaultValue;
            }
            return f;
        }
        return defaultValue;
    }

    private DisplayInfoFactory() {
    }

    static {
        DisplayInfoFactory displayInfoFactory;
        INSTANCE = displayInfoFactory = new DisplayInfoFactory();
    }
}

