/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.model;

import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0014\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u000e\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&J \u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR2\u0010\n\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00070\u0007 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rf\u0010\r\u001aZ\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \f*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u0006 \f*,\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \f*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u0006\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00100\u0010 \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/layoutinspector/model/ViewNodeTableModel;", "Ljavax/swing/table/TableModel;", "()V", "groupedProperties", "", "", "", "Lcom/android/layoutinspector/model/ViewProperty;", "getGroupedProperties", "()Ljava/util/Map;", "mEntries", "Ljava/util/ArrayList;", "kotlin.jvm.PlatformType", "mGroupedProperties", "Ljava/util/HashMap;", "mListeners", "Ljavax/swing/event/TableModelListener;", "addTableModelListener", "", "l", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "", "getColumnCount", "getColumnName", "getRowCount", "getValueAt", "", "rowIndex", "isCellEditable", "", "notifyChange", "event", "Ljavax/swing/event/TableModelEvent;", "removeTableModelListener", "setNode", "node", "Lcom/android/layoutinspector/model/ViewNode;", "setValueAt", "aValue", "android.sdktools.layoutinspector"})
public final class ViewNodeTableModel
implements TableModel {
    private final ArrayList<TableModelListener> mListeners = Lists.newArrayList();
    private final ArrayList<ViewProperty> mEntries = Lists.newArrayList();
    private final HashMap<String, List<ViewProperty>> mGroupedProperties = Maps.newHashMap();

    @NotNull
    public final Map<String, List<ViewProperty>> getGroupedProperties() {
        HashMap<String, List<ViewProperty>> hashMap = this.mGroupedProperties;
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"mGroupedProperties");
        return hashMap;
    }

    public final void setNode(@NotNull ViewNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.mEntries.clear();
        this.mEntries.addAll((Collection<ViewProperty>)node.getProperties());
        this.mGroupedProperties.clear();
        this.mGroupedProperties.putAll(node.getGroupedProperties());
        this.notifyChange(new TableModelEvent(this));
    }

    @Override
    public int getRowCount() {
        return this.mEntries.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    @NotNull
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "Property" : "Value";
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        ViewProperty p = this.mEntries.get(rowIndex);
        return columnIndex == 0 ? p.getName() : p.getValue();
    }

    @Override
    public void setValueAt(@NotNull Object aValue, int rowIndex, int columnIndex) {
        Intrinsics.checkParameterIsNotNull((Object)aValue, (String)"aValue");
    }

    @Override
    public void addTableModelListener(@NotNull TableModelListener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        this.mListeners.add(l);
    }

    @Override
    public void removeTableModelListener(@NotNull TableModelListener l) {
        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
        this.mListeners.remove(l);
    }

    private final void notifyChange(TableModelEvent event) {
        for (TableModelListener l : this.mListeners) {
            l.tableChanged(event);
        }
    }
}

