/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.model;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DebugViewDumpHandler;
import com.android.layoutinspector.LayoutInspectorCaptureOptions;
import com.android.layoutinspector.ProtocolVersion;
import com.android.layoutinspector.model.ViewNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/android/layoutinspector/model/ClientWindow;", "", "title", "", "client", "Lcom/android/ddmlib/Client;", "clientViewInspector", "Lcom/android/layoutinspector/model/ClientWindow$ClientViewInspector;", "(Ljava/lang/String;Lcom/android/ddmlib/Client;Lcom/android/layoutinspector/model/ClientWindow$ClientViewInspector;)V", "getClientViewInspector", "()Lcom/android/layoutinspector/model/ClientWindow$ClientViewInspector;", "displayName", "getDisplayName", "()Ljava/lang/String;", "getTitle", "loadViewImage", "", "node", "Lcom/android/layoutinspector/model/ViewNode;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "loadWindowData", "options", "Lcom/android/layoutinspector/LayoutInspectorCaptureOptions;", "CaptureByteArrayHandler", "ClientViewInspector", "Companion", "ListViewRootsHandler", "android.sdktools.layoutinspector"})
public final class ClientWindow {
    @NotNull
    private final String title;
    private final Client client;
    @NotNull
    private final ClientViewInspector clientViewInspector;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getDisplayName() {
        ClientData clientData = this.client.getClientData();
        Intrinsics.checkExpressionValueIsNotNull((Object)clientData, (String)"client.clientData");
        String appName = clientData.getClientDescription();
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.title, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ArrayList parts = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
        parts.remove("");
        parts.remove(appName);
        return parts.isEmpty() ? appName : (String)parts.get(parts.size() > 2 ? 1 : 0);
    }

    @Nullable
    public final byte[] loadWindowData(@NotNull LayoutInspectorCaptureOptions options, long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        return this.clientViewInspector.dumpViewHierarchy(this.client, this.title, false, true, options.getVersion() == ProtocolVersion.Version2, timeout, unit);
    }

    @Nullable
    public final byte[] loadViewImage(@NotNull ViewNode node, long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        return this.clientViewInspector.captureView(this.client, this.title, node, timeout, unit);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final ClientViewInspector getClientViewInspector() {
        return this.clientViewInspector;
    }

    public ClientWindow(@NotNull String title, @NotNull Client client, @NotNull ClientViewInspector clientViewInspector) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)clientViewInspector, (String)"clientViewInspector");
        this.title = title;
        this.client = client;
        this.clientViewInspector = clientViewInspector;
    }

    public /* synthetic */ ClientWindow(String string, Client client, ClientViewInspector clientViewInspector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            clientViewInspector = new ClientViewInspector(){

                @Override
                @Nullable
                public byte[] dumpViewHierarchy(@NotNull Client client, @NotNull String title, boolean skipChildren, boolean includeProperties, boolean useV2, long timeout, @NotNull TimeUnit timeUnit) {
                    Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
                    Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
                    return ClientViewInspector.DefaultImpls.dumpViewHierarchy(this, client, title, skipChildren, includeProperties, useV2, timeout, timeUnit);
                }

                @Override
                @Nullable
                public byte[] captureView(@NotNull Client client, @NotNull String title, @NotNull ViewNode node, long timeout, @NotNull TimeUnit timeUnit) {
                    Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
                    Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
                    return ClientViewInspector.DefaultImpls.captureView(this, client, title, node, timeout, timeUnit);
                }
            };
        }
        this(string, client, clientViewInspector);
    }

    @JvmStatic
    @Nullable
    public static final List<ClientWindow> getAll(@NotNull Client client, long timeout, @NotNull TimeUnit unit) throws IOException {
        return Companion.getAll(client, timeout, unit);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/layoutinspector/model/ClientWindow$ListViewRootsHandler;", "Lcom/android/ddmlib/DebugViewDumpHandler;", "()V", "myViewRoots", "Ljava/util/concurrent/CopyOnWriteArrayList;", "", "kotlin.jvm.PlatformType", "getWindows", "", "Lcom/android/layoutinspector/model/ClientWindow;", "c", "Lcom/android/ddmlib/Client;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "handleViewDebugResult", "", "data", "Ljava/nio/ByteBuffer;", "android.sdktools.layoutinspector"})
    private static final class ListViewRootsHandler
    extends DebugViewDumpHandler {
        private final CopyOnWriteArrayList<String> myViewRoots = Lists.newCopyOnWriteArrayList();

        /*
         * WARNING - void declaration
         */
        protected void handleViewDebugResult(@NotNull ByteBuffer data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            int nWindows = data.getInt();
            int n = 0;
            int n2 = nWindows;
            while (n < n2) {
                void i;
                int len = data.getInt();
                this.myViewRoots.add(DebugViewDumpHandler.getString((ByteBuffer)data, (int)len));
                ++i;
            }
        }

        @NotNull
        public final List<ClientWindow> getWindows(@NotNull Client c, long timeout, @NotNull TimeUnit unit) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
            c.listViewRoots((DebugViewDumpHandler)this);
            this.waitForResult(timeout, unit);
            ArrayList windows = Lists.newArrayList();
            Iterator<String> iterator = this.myViewRoots.iterator();
            while (iterator.hasNext()) {
                String root;
                String string = root = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"root");
                windows.add(new ClientWindow(string, c, null, 4, null));
            }
            ArrayList arrayList = windows;
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"windows");
            return arrayList;
        }

        public ListViewRootsHandler() {
            super(DebugViewDumpHandler.CHUNK_VULW);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/layoutinspector/model/ClientWindow$CaptureByteArrayHandler;", "Lcom/android/ddmlib/DebugViewDumpHandler;", "type", "", "(I)V", "mData", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getData", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "handleViewDebugResult", "", "data", "Ljava/nio/ByteBuffer;", "android.sdktools.layoutinspector"})
    private static final class CaptureByteArrayHandler
    extends DebugViewDumpHandler {
        private final AtomicReference<byte[]> mData = new AtomicReference();

        protected void handleViewDebugResult(@NotNull ByteBuffer data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            byte[] b = new byte[data.remaining()];
            data.get(b);
            this.mData.set(b);
        }

        @Nullable
        public final byte[] getData(long timeout, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
            this.waitForResult(timeout, unit);
            return this.mData.get();
        }

        public CaptureByteArrayHandler(int type) {
            super(type);
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001J2\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016JB\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/layoutinspector/model/ClientWindow$ClientViewInspector;", "", "captureView", "", "client", "Lcom/android/ddmlib/Client;", "title", "", "node", "Lcom/android/layoutinspector/model/ViewNode;", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "dumpViewHierarchy", "skipChildren", "", "includeProperties", "useV2", "android.sdktools.layoutinspector"})
    public static interface ClientViewInspector {
        @Nullable
        public byte[] dumpViewHierarchy(@NotNull Client var1, @NotNull String var2, boolean var3, boolean var4, boolean var5, long var6, @NotNull TimeUnit var8);

        @Nullable
        public byte[] captureView(@NotNull Client var1, @NotNull String var2, @NotNull ViewNode var3, long var4, @NotNull TimeUnit var6);

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            @Nullable
            public static byte[] dumpViewHierarchy(@NotNull ClientViewInspector $this, @NotNull Client client, @NotNull String title, boolean skipChildren, boolean includeProperties, boolean useV2, long timeout, @NotNull TimeUnit timeUnit) {
                byte[] byArray;
                Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
                Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
                Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
                CaptureByteArrayHandler handler = new CaptureByteArrayHandler(DebugViewDumpHandler.CHUNK_VURT);
                client.dumpViewHierarchy(title, skipChildren, includeProperties, useV2, (DebugViewDumpHandler)handler);
                try {
                    byArray = handler.getData(timeout, timeUnit);
                }
                catch (IOException e) {
                    byArray = null;
                }
                return byArray;
            }

            @Nullable
            public static byte[] captureView(@NotNull ClientViewInspector $this, @NotNull Client client, @NotNull String title, @NotNull ViewNode node, long timeout, @NotNull TimeUnit timeUnit) {
                byte[] byArray;
                Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
                Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
                CaptureByteArrayHandler handler = new CaptureByteArrayHandler(DebugViewDumpHandler.CHUNK_VUOP);
                client.captureView(title, node.toString(), (DebugViewDumpHandler)handler);
                try {
                    byArray = handler.getData(timeout, timeUnit);
                }
                catch (IOException e) {
                    byArray = null;
                }
                return byArray;
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/android/layoutinspector/model/ClientWindow$Companion;", "", "()V", "getAll", "", "Lcom/android/layoutinspector/model/ClientWindow;", "client", "Lcom/android/ddmlib/Client;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "android.sdktools.layoutinspector"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final List<ClientWindow> getAll(@NotNull Client client, long timeout, @NotNull TimeUnit unit) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
            ClientData cd = client.getClientData();
            return cd.hasFeature("view-hierarchy") ? new ListViewRootsHandler().getWindows(client, timeout, unit) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

