/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.FlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/types/checker/CapturedArguments;", "", "capturedArguments", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "originalType", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Ljava/util/List;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getCapturedArguments", "()Ljava/util/List;", "isSuitableForType", "", "type", "descriptors"})
final class CapturedArguments {
    @NotNull
    private final List<TypeProjection> capturedArguments;
    @NotNull
    private final KotlinType originalType;

    public CapturedArguments(@NotNull List<? extends TypeProjection> capturedArguments, @NotNull KotlinType originalType) {
        Intrinsics.checkNotNullParameter(capturedArguments, "capturedArguments");
        Intrinsics.checkNotNullParameter(originalType, "originalType");
        this.capturedArguments = capturedArguments;
        this.originalType = originalType;
    }

    @NotNull
    public final List<TypeProjection> getCapturedArguments() {
        return this.capturedArguments;
    }

    public final boolean isSuitableForType(@NotNull KotlinType type2) {
        boolean areConstructorsMatched;
        boolean areArgumentsMatched;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter(type2, "type");
            Iterable $this$all$iv = CollectionsKt.withIndex((Iterable)type2.getArguments());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    IndexedValue element$iv;
                    IndexedValue $dstr$i$typeArgumentsType = element$iv = iterator2.next();
                    boolean bl2 = false;
                    int i = $dstr$i$typeArgumentsType.component1();
                    TypeProjection typeArgumentsType = (TypeProjection)$dstr$i$typeArgumentsType.component2();
                    if (this.originalType.getArguments().size() > i && Intrinsics.areEqual(typeArgumentsType, this.originalType.getArguments().get(i))) continue;
                    bl = false;
                    break block4;
                }
                bl = areArgumentsMatched = true;
            }
        }
        if (!areArgumentsMatched) {
            return false;
        }
        boolean bl = areConstructorsMatched = Intrinsics.areEqual(this.originalType.getConstructor(), type2.getConstructor()) || FlexibleTypeBoundsChecker.INSTANCE.areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(this.originalType, type2);
        return areConstructorsMatched;
    }
}

