/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.ConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.calls.ConeSimpleConstraintSystemImpl;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureKt;
import org.jetbrains.kotlin.resolve.calls.results.SimpleConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.results.SpecificityComparisonCallbacks;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContextKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\b\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0004J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00122\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0018\u001a\u00020\u0012H\u0004J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0018\u001a\u00020\u00122\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0004J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\"H\u0004J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0018\u001a\u00020\u00122\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0004J\f\u0010%\u001a\u00020\u0017*\u00020&H\u0002R\u0016\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u0012\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractConeCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeCallConflictResolver;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "inferenceComponents", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;)V", "SpecificityComparisonWithNumerics", "org/jetbrains/kotlin/fir/resolve/calls/AbstractConeCallConflictResolver$SpecificityComparisonWithNumerics$1", "getSpecificityComparisonWithNumerics$annotations", "()V", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractConeCallConflictResolver$SpecificityComparisonWithNumerics$1;", "getInferenceComponents", "()Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "compareCallsByUsedArguments", "", "call1", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "call2", "discriminateGenerics", "computeParameterTypes", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "call", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "createEmptyConstraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/results/SimpleConstraintSystem;", "createFlatSignature", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "argumentType", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "resolve"})
public abstract class AbstractConeCallConflictResolver
extends ConeCallConflictResolver {
    @NotNull
    private final TypeSpecificityComparator specificityComparator;
    @NotNull
    private final InferenceComponents inferenceComponents;
    @NotNull
    private final SpecificityComparisonWithNumerics.1 SpecificityComparisonWithNumerics;

    public AbstractConeCallConflictResolver(@NotNull TypeSpecificityComparator specificityComparator, @NotNull InferenceComponents inferenceComponents) {
        Intrinsics.checkNotNullParameter(specificityComparator, "specificityComparator");
        Intrinsics.checkNotNullParameter(inferenceComponents, "inferenceComponents");
        this.specificityComparator = specificityComparator;
        this.inferenceComponents = inferenceComponents;
        this.SpecificityComparisonWithNumerics = new SpecificityComparisonCallbacks(){

            public boolean isNonSubtypeNotLessSpecific(@NotNull KotlinTypeMarker specific, @NotNull KotlinTypeMarker general) {
                Intrinsics.checkNotNullParameter(specific, "specific");
                Intrinsics.checkNotNullParameter(general, "general");
                TypeSystemContextKt.requireOrDescribe(specific instanceof ConeKotlinType, specific);
                TypeSystemContextKt.requireOrDescribe(general instanceof ConeKotlinType, general);
                ClassId classId = StandardClassIds.INSTANCE.getInt();
                ClassId classId2 = StandardClassIds.INSTANCE.getLong();
                ClassId classId3 = StandardClassIds.INSTANCE.getByte();
                ClassId classId4 = StandardClassIds.INSTANCE.getShort();
                ClassId uInt = StandardClassIds.INSTANCE.getUInt();
                ClassId uLong = StandardClassIds.INSTANCE.getULong();
                ClassId uByte = StandardClassIds.INSTANCE.getUByte();
                ClassId uShort = StandardClassIds.INSTANCE.getUShort();
                ClassId classId5 = ConeTypeUtilsKt.getClassId((ConeKotlinType)specific);
                if (classId5 == null) {
                    return false;
                }
                ClassId specificClassId = classId5;
                ClassId classId6 = ConeTypeUtilsKt.getClassId((ConeKotlinType)general);
                if (classId6 == null) {
                    return false;
                }
                ClassId generalClassId = classId6;
                if (Intrinsics.areEqual(specificClassId, classId)) {
                    classId6 = generalClassId;
                    if (Intrinsics.areEqual(classId6, classId2)) {
                        return true;
                    }
                    if (Intrinsics.areEqual(classId6, classId3)) {
                        return true;
                    }
                    if (Intrinsics.areEqual(classId6, classId4)) {
                        return true;
                    }
                } else {
                    if (Intrinsics.areEqual(specificClassId, classId4) && Intrinsics.areEqual(generalClassId, classId3)) {
                        return true;
                    }
                    if (Intrinsics.areEqual(specificClassId, uInt)) {
                        classId6 = generalClassId;
                        if (Intrinsics.areEqual(classId6, uLong)) {
                            return true;
                        }
                        if (Intrinsics.areEqual(classId6, uByte)) {
                            return true;
                        }
                        if (Intrinsics.areEqual(classId6, uShort)) {
                            return true;
                        }
                    } else if (Intrinsics.areEqual(specificClassId, uShort) && Intrinsics.areEqual(generalClassId, uByte)) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @NotNull
    protected final InferenceComponents getInferenceComponents() {
        return this.inferenceComponents;
    }

    protected final boolean compareCallsByUsedArguments(@NotNull FlatSignature<Candidate> call1, @NotNull FlatSignature<Candidate> call2, boolean discriminateGenerics) {
        Intrinsics.checkNotNullParameter(call1, "call1");
        Intrinsics.checkNotNullParameter(call2, "call2");
        if (discriminateGenerics) {
            boolean isGeneric1 = call1.isGeneric();
            boolean isGeneric2 = call2.isGeneric();
            if (isGeneric1 && !isGeneric2) {
                return false;
            }
            if (!isGeneric1 && isGeneric2) {
                return true;
            }
            if (isGeneric1 && isGeneric2) {
                return false;
            }
        }
        if (!call1.isExpect() && call2.isExpect()) {
            return true;
        }
        if (call1.isExpect() && !call2.isExpect()) {
            return false;
        }
        return FlatSignatureKt.isSignatureNotLessSpecific(this.createEmptyConstraintSystem(), call1, call2, this.SpecificityComparisonWithNumerics, this.specificityComparator);
    }

    @NotNull
    protected final FlatSignature<Candidate> createFlatSignature(@NotNull Candidate call2) {
        FlatSignature<Candidate> flatSignature;
        Intrinsics.checkNotNullParameter(call2, "call");
        Object declaration2 = call2.getSymbol().getFir();
        if (declaration2 instanceof FirSimpleFunction) {
            flatSignature = this.createFlatSignature(call2, (FirSimpleFunction)declaration2);
        } else if (declaration2 instanceof FirConstructor) {
            flatSignature = this.createFlatSignature(call2, (FirConstructor)declaration2);
        } else if (declaration2 instanceof FirVariable) {
            flatSignature = this.createFlatSignature(call2, (FirVariable)declaration2);
        } else if (declaration2 instanceof FirClass) {
            flatSignature = this.createFlatSignature(call2, (FirClass)declaration2);
        } else {
            String string2 = Intrinsics.stringPlus("Not supported: ", declaration2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return flatSignature;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final FlatSignature<Candidate> createFlatSignature(@NotNull Candidate call2, @NotNull FirVariable<?> variable2) {
        Boolean bl;
        ConeKotlinType coneKotlinType;
        List list2;
        FirPureAbstractElement firPureAbstractElement;
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(variable2, "variable");
        Candidate candidate2 = call2;
        FirPureAbstractElement firPureAbstractElement2 = firPureAbstractElement = variable2 instanceof FirProperty ? (FirProperty)variable2 : null;
        if (firPureAbstractElement == null) {
            list2 = null;
        } else {
            List<FirTypeParameter> list3 = ((FirProperty)firPureAbstractElement).getTypeParameters();
            if (list3 == null) {
                list2 = null;
            } else {
                Collection<ConeTypeParameterLookupTag> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list3;
                Candidate candidate3 = candidate2;
                boolean $i$f$map = false;
                void var7_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    ConeTypeParameterLookupTag coneTypeParameterLookupTag = it.getSymbol().toLookupTag();
                    collection.add(coneTypeParameterLookupTag);
                }
                collection = (List)destination$iv$iv;
                candidate2 = candidate3;
                list2 = collection;
            }
        }
        firPureAbstractElement = list2;
        boolean bl3 = false;
        Object object = firPureAbstractElement;
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        Collection collection = (Collection)object;
        firPureAbstractElement = variable2.getReceiverTypeRef();
        if (firPureAbstractElement == null) {
            coneKotlinType = null;
        } else {
            ConeKotlinType coneKotlinType2;
            FirPureAbstractElement $this$coneType$iv = firPureAbstractElement;
            boolean $i$f$getConeType = false;
            FirPureAbstractElement $this$coneTypeSafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeSafe = false;
            boolean bl4 = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType3 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType3 instanceof ConeKotlinType)) {
                coneKotlinType3 = null;
            }
            if ((coneKotlinType2 = coneKotlinType3) == null) {
                String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            coneKotlinType = coneKotlinType2;
        }
        List<Object> list4 = CollectionsKt.listOfNotNull(coneKotlinType);
        boolean bl6 = variable2.getReceiverTypeRef() != null;
        FirPureAbstractElement firPureAbstractElement3 = firPureAbstractElement = variable2 instanceof FirProperty ? (FirProperty)variable2 : null;
        if (firPureAbstractElement == null) {
            bl = null;
        } else {
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)((Object)firPureAbstractElement);
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getStatus().isExpect();
        }
        boolean bl7 = false;
        boolean bl8 = Intrinsics.areEqual(bl, true);
        int n = 0;
        boolean bl9 = false;
        boolean bl10 = bl6;
        List<Object> list5 = list4;
        Collection collection2 = collection;
        Candidate candidate4 = candidate2;
        return new FlatSignature<Candidate>(candidate4, collection2, list5, bl10, bl9, n, bl8, bl7);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final FlatSignature<Candidate> createFlatSignature(@NotNull Candidate call2, @NotNull FirConstructor constructor2) {
        boolean bl;
        boolean bl2;
        Object object;
        Collection<ConeTypeParameterLookupTag> collection;
        Candidate candidate2;
        block4: {
            void $this$any$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(call2, "call");
            Intrinsics.checkNotNullParameter(constructor2, "constructor");
            Iterable iterable = constructor2.getTypeParameters();
            candidate2 = call2;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                object = it.getSymbol().toLookupTag();
                collection.add((ConeTypeParameterLookupTag)object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = constructor2.getValueParameters();
            bl2 = false;
            object = this.computeParameterTypes(call2, constructor2);
            collection = collection;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv;
                    boolean bl4 = false;
                    if (!it.isVararg()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean bl5 = bl;
        FirMemberDeclaration $this$isExpect$iv = constructor2;
        boolean $i$f$isExpect = false;
        boolean bl6 = false;
        boolean bl7 = $this$isExpect$iv.getStatus().isExpect();
        int n = call2.getNumDefaults();
        boolean bl8 = bl5;
        boolean bl9 = bl2;
        Object object2 = object;
        Collection<ConeTypeParameterLookupTag> collection2 = collection;
        Candidate candidate3 = candidate2;
        return new FlatSignature<Candidate>(candidate3, collection2, (List<? extends KotlinTypeMarker>)object2, bl9, bl8, n, bl7, bl6);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final FlatSignature<Candidate> createFlatSignature(@NotNull Candidate call2, @NotNull FirSimpleFunction function2) {
        boolean bl;
        boolean bl2;
        Object object;
        Collection<ConeTypeParameterLookupTag> collection;
        Candidate candidate2;
        block4: {
            void $this$any$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(call2, "call");
            Intrinsics.checkNotNullParameter(function2, "function");
            Iterable iterable = function2.getTypeParameters();
            candidate2 = call2;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                object = it.getSymbol().toLookupTag();
                collection.add((ConeTypeParameterLookupTag)object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = function2.getValueParameters();
            bl2 = function2.getReceiverTypeRef() != null;
            object = this.computeParameterTypes(call2, function2);
            collection = collection;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv;
                    boolean bl4 = false;
                    if (!it.isVararg()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean bl5 = bl;
        FirMemberDeclaration $this$isExpect$iv = function2;
        boolean $i$f$isExpect = false;
        boolean bl6 = false;
        boolean bl7 = $this$isExpect$iv.getStatus().isExpect();
        int n = call2.getNumDefaults();
        boolean bl8 = bl5;
        boolean bl9 = bl2;
        Object object2 = object;
        Collection<ConeTypeParameterLookupTag> collection2 = collection;
        Candidate candidate3 = candidate2;
        return new FlatSignature<Candidate>(candidate3, collection2, (List<? extends KotlinTypeMarker>)object2, bl9, bl8, n, bl7, bl6);
    }

    private final ConeKotlinType argumentType(FirValueParameter $this$argumentType) {
        ConeKotlinType coneKotlinType;
        FirTypeRef $this$coneType$iv = $this$argumentType.getReturnTypeRef();
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeSafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) == null) {
            String string2 = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default($this$coneType$iv, null, 1, null);
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        ConeKotlinType type2 = coneKotlinType;
        if ($this$argumentType.isVararg()) {
            ConeKotlinType coneKotlinType3 = ArrayUtilsKt.arrayElementType(type2);
            Intrinsics.checkNotNull(coneKotlinType3);
            return coneKotlinType3;
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConeKotlinType> computeParameterTypes(Candidate call2, FirFunction<?> function2) {
        Object object;
        ConeKotlinType coneKotlinType;
        Collection<ConeKotlinType> collection;
        Collection collection2;
        ConeTypeProjection[] coneTypeProjectionArray;
        FirResolvedTypeRef firResolvedTypeRef;
        Object $this$coneTypeSafe$iv$iv;
        ConeKotlinType coneKotlinType2;
        ConeTypeProjection[] coneTypeProjectionArray2 = function2.getReceiverTypeRef();
        if (coneTypeProjectionArray2 == null) {
            coneKotlinType2 = null;
        } else {
            ConeKotlinType coneKotlinType3;
            ConeTypeProjection[] $this$coneType$iv = coneTypeProjectionArray2;
            boolean $i$f$getConeType = false;
            $this$coneTypeSafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
            ConeKotlinType coneKotlinType4 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType4 instanceof ConeKotlinType)) {
                coneKotlinType4 = null;
            }
            if ((coneKotlinType3 = coneKotlinType4) == null) {
                $this$coneTypeSafe$iv$iv = "Expected FirResolvedTypeRef with ConeKotlinType but was " + Reflection.getOrCreateKotlinClass($this$coneType$iv.getClass()).getSimpleName() + ' ' + FirRendererKt.render$default((FirElement)$this$coneType$iv, null, 1, null);
                $i$f$coneTypeSafe = false;
                throw (Throwable)new IllegalStateException($this$coneTypeSafe$iv$iv.toString());
            }
            coneKotlinType2 = coneKotlinType3;
        }
        Collection collection3 = CollectionsKt.listOfNotNull(coneKotlinType2);
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = call2.getResultingTypeForCallableReference();
        if (linkedHashMap == null) {
            coneTypeProjectionArray = null;
        } else {
            ConeTypeProjection[] $i$f$getConeType = ((ConeKotlinType)((Object)linkedHashMap)).getTypeArguments();
            if ($i$f$getConeType == null) {
                coneTypeProjectionArray = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$coneTypeSafe$iv$iv = $i$f$getConeType;
                collection2 = collection3;
                boolean $i$f$map2 = false;
                firResolvedTypeRef = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (Map.Entry item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    void var15_26 = item$iv$iv2;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    coneKotlinType = (ConeKotlinType)it;
                    collection.add(coneKotlinType);
                }
                collection = (ConeTypeProjection[])destination$iv$iv;
                collection3 = collection2;
                coneTypeProjectionArray = coneTypeProjectionArray2 = collection;
            }
        }
        if (coneTypeProjectionArray2 == null) {
            Collection<ConeKotlinType> collection4;
            linkedHashMap = call2.getArgumentMapping();
            if (linkedHashMap == null) {
                collection4 = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map $i$f$getConeType = linkedHashMap;
                collection2 = collection3;
                boolean $i$f$map = false;
                void $i$f$map2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                void var10_18 = $this$mapTo$iv$iv;
                boolean bl = false;
                Iterator iterator2 = var10_18.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry item$iv$iv2;
                    item$iv$iv2 = item$iv$iv = iterator2.next();
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    coneKotlinType = this.argumentType((FirValueParameter)it.getValue());
                    collection.add(coneKotlinType);
                }
                collection = (List)destination$iv$iv;
                collection3 = collection2;
                collection4 = collection;
            }
            linkedHashMap = collection4;
            boolean bl = false;
            object = linkedHashMap;
            if (object == null) {
                object = CollectionsKt.emptyList();
            }
        } else {
            object = coneTypeProjectionArray2;
        }
        return CollectionsKt.plus(collection3, (Iterable)object);
    }

    /*
     * WARNING - void declaration
     */
    private final FlatSignature<Candidate> createFlatSignature(Candidate call2, FirClass<?> klass) {
        Boolean bl;
        List list2;
        FirRegularClass firRegularClass;
        Candidate candidate2 = call2;
        FirRegularClass firRegularClass2 = firRegularClass = klass instanceof FirRegularClass ? (FirRegularClass)klass : null;
        if (firRegularClass == null) {
            list2 = null;
        } else {
            List<FirTypeParameterRef> list3 = firRegularClass.getTypeParameters();
            if (list3 == null) {
                list2 = null;
            } else {
                Collection<ConeTypeParameterLookupTag> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list3;
                Candidate candidate3 = candidate2;
                boolean $i$f$map = false;
                void var7_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    ConeTypeParameterLookupTag coneTypeParameterLookupTag = it.getSymbol().toLookupTag();
                    collection.add(coneTypeParameterLookupTag);
                }
                collection = (List)destination$iv$iv;
                candidate2 = candidate3;
                list2 = collection;
            }
        }
        firRegularClass = list2;
        boolean bl3 = false;
        Object object = firRegularClass;
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        Collection collection = (Collection)object;
        List list4 = CollectionsKt.emptyList();
        FirRegularClass firRegularClass3 = firRegularClass = klass instanceof FirRegularClass ? (FirRegularClass)klass : null;
        if (firRegularClass == null) {
            bl = null;
        } else {
            FirMemberDeclaration $this$isExpect$iv = firRegularClass;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getStatus().isExpect();
        }
        boolean bl4 = false;
        boolean bl5 = Intrinsics.areEqual(bl, true);
        int n = 0;
        boolean bl6 = false;
        boolean bl7 = false;
        List list5 = list4;
        Collection collection2 = collection;
        Candidate candidate4 = candidate2;
        return new FlatSignature<Candidate>(candidate4, collection2, list5, bl7, bl6, n, bl5, bl4);
    }

    private final SimpleConstraintSystem createEmptyConstraintSystem() {
        return new ConeSimpleConstraintSystemImpl(this.inferenceComponents.createConstraintSystem());
    }
}

