/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.backend.common.lower.InlineClassLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrFunctionKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InlineClassLowering;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "inlineClassDeclarationLowering", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "getInlineClassDeclarationLowering", "()Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "inlineClassUsageLowering", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "getInlineClassUsageLowering", "()Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "transformedFunction", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "collectTypeParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "createStaticBodilessMethod", "function", "getOrCreateStaticMethod", "toInlineClassImplementationName", "Lorg/jetbrains/kotlin/name/Name;", "ir.backend.common"})
public final class InlineClassLowering {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final Mapping.Delegate<IrFunction, IrSimpleFunction> transformedFunction;
    @NotNull
    private final DeclarationTransformer inlineClassDeclarationLowering;
    @NotNull
    private final BodyLoweringPass inlineClassUsageLowering;

    public InlineClassLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.transformedFunction = this.context.getMapping().getInlineClassMemberToStatic();
        this.inlineClassDeclarationLowering = new DeclarationTransformer(this){
            final /* synthetic */ InlineClassLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration2) {
                IrDeclaration irDeclaration2;
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                IrDeclarationParent irDeclarationParent = declaration2.getParent();
                IrClass irClass2 = irDeclaration2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (irDeclaration2 == null) {
                    return null;
                }
                IrClass irClass3 = irDeclaration2;
                if (!irClass3.isInline()) {
                    return null;
                }
                irDeclaration2 = declaration2;
                return irDeclaration2 instanceof IrConstructor ? this.transformConstructor((IrConstructor)declaration2) : (irDeclaration2 instanceof IrSimpleFunction ? this.transformMethodFlat((IrSimpleFunction)declaration2) : null);
            }

            private final List<IrDeclaration> transformConstructor(IrConstructor irConstructor2) {
                if (irConstructor2.isPrimary()) {
                    return this.transformPrimaryConstructor(irConstructor2);
                }
                IrSimpleFunction result2 = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, irConstructor2);
                this.transformConstructorBody(irConstructor2, result2);
                return CollectionsKt.listOf(result2);
            }

            private final List<IrDeclaration> transformMethodFlat(IrSimpleFunction function2) {
                if (IrFunctionKt.isStaticMethodOfClass(function2) || !AdditionalIrUtilsKt.isReal(function2)) {
                    return null;
                }
                IrSimpleFunction staticMethod = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2);
                this.transformMethodBodyFlat(function2, staticMethod);
                function2.setBody(this.delegateToStaticMethod(function2, staticMethod));
                if (function2.getOverriddenSymbols().isEmpty()) {
                    return CollectionsKt.listOf(staticMethod);
                }
                IrSimpleFunction[] irSimpleFunctionArray = new IrSimpleFunction[]{function2, staticMethod};
                return CollectionsKt.listOf(irSimpleFunctionArray);
            }

            private final List<IrDeclaration> transformPrimaryConstructor(IrConstructor irConstructor2) {
                IrClass klass = IrUtilsKt.getParentAsClass(irConstructor2);
                IrSimpleType inlineClassType = IrUtilsKt.getDefaultType(klass);
                IrSimpleFunction irSimpleFunction = InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, irConstructor2);
                boolean bl = false;
                boolean bl2 = false;
                IrSimpleFunction it = irSimpleFunction;
                boolean bl3 = false;
                it.setReturnType(inlineClassType);
                IrSimpleFunction initFunction = irSimpleFunction;
                Ref.ObjectRef<IrDelegatingConstructorCall> delegatingCtorCall = new Ref.ObjectRef<IrDelegatingConstructorCall>();
                Ref.ObjectRef<IrSetField> setMemberField = new Ref.ObjectRef<IrSetField>();
                initFunction.setBody(this.this$0.getContext().getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)new Function1<IrBlockBody, Unit>(irConstructor2, this.this$0, initFunction, delegatingCtorCall, klass, setMemberField){
                    final /* synthetic */ IrConstructor $irConstructor;
                    final /* synthetic */ InlineClassLowering this$0;
                    final /* synthetic */ IrSimpleFunction $initFunction;
                    final /* synthetic */ Ref.ObjectRef<IrDelegatingConstructorCall> $delegatingCtorCall;
                    final /* synthetic */ IrClass $klass;
                    final /* synthetic */ Ref.ObjectRef<IrSetField> $setMemberField;
                    {
                        this.$irConstructor = $irConstructor;
                        this.this$0 = $receiver;
                        this.$initFunction = $initFunction;
                        this.$delegatingCtorCall = $delegatingCtorCall;
                        this.$klass = $klass;
                        this.$setMemberField = $setMemberField;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                        void p1;
                        void p0;
                        void this_$iv$iv$iv;
                        void startOffset$iv$iv;
                        void $this$irBlockBody$iv$iv;
                        void irElement$iv;
                        void $this$irBlockBody$iv;
                        Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
                        IrValueParameterSymbol origParameterSymbol = CollectionsKt.single(this.$irConstructor.getValueParameters()).getSymbol();
                        IrBlockBody irBlockBody = $this$createBlockBody;
                        Collection collection = irBlockBody.getStatements();
                        Object object = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), this.$initFunction.getSymbol(), 0, 0, 6, null);
                        IrElement irElement = this.$initFunction;
                        IrConstructor irConstructor2 = this.$irConstructor;
                        IrSimpleFunction irSimpleFunction = this.$initFunction;
                        Ref.ObjectRef<IrDelegatingConstructorCall> objectRef = this.$delegatingCtorCall;
                        IrClass irClass2 = this.$klass;
                        Ref.ObjectRef<IrSetField> objectRef2 = this.$setMemberField;
                        boolean $i$f$irBlockBody = false;
                        void var13_14 = $this$irBlockBody$iv;
                        int n = irElement$iv.getStartOffset();
                        int endOffset$iv$iv = irElement$iv.getEndOffset();
                        boolean $i$f$irBlockBody2 = false;
                        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
                        boolean $i$f$blockBody = false;
                        void $this$invoke_u24lambda_u2d1 = this_$iv$iv$iv;
                        boolean bl = false;
                        void builder2 = $this$invoke_u24lambda_u2d1;
                        IrBody irBody = irConstructor2.getBody();
                        if (irBody == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                        }
                        IrElement $this$deepCopyWithSymbols_u24default$iv = (IrBlockBody)irBody;
                        boolean $i$f$deepCopyWithSymbols = false;
                        DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
                        IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols_u24default$iv, symbolRemapper$iv);
                        DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
                        TypeRemapper typeRemapper = typeRemapper$iv;
                        SymbolRemapper symbolRemapper = symbolRemapper$iv;
                        IrElement irElement2 = $this$deepCopyWithSymbols_u24default$iv;
                        DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p0, (TypeRemapper)p1);
                        IrElement irElement3 = PatchDeclarationParentsKt.patchDeclarationParents(irElement2.transform(deepCopyIrTreeWithSymbols, null), irSimpleFunction);
                        if (irElement3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                        }
                        Iterable $this$forEach$iv = ((IrBlockBody)((IrElement)((IrBlockBody)irElement3))).getStatements();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            IrStatement statement2 = (IrStatement)element$iv;
                            boolean bl2 = false;
                            $this$invoke_u24lambda_u2d1.unaryPlus(IrElementKt.transformStatement(statement2, new IrElementTransformerVoid(objectRef, irConstructor2, (IrBlockBodyBuilder)builder2, irClass2, objectRef2, irSimpleFunction, origParameterSymbol){
                                final /* synthetic */ Ref.ObjectRef<IrDelegatingConstructorCall> $delegatingCtorCall;
                                final /* synthetic */ IrConstructor $irConstructor;
                                final /* synthetic */ IrBlockBodyBuilder $builder;
                                final /* synthetic */ IrClass $klass;
                                final /* synthetic */ Ref.ObjectRef<IrSetField> $setMemberField;
                                final /* synthetic */ IrSimpleFunction $initFunction;
                                final /* synthetic */ IrValueParameterSymbol $origParameterSymbol;
                                {
                                    this.$delegatingCtorCall = $delegatingCtorCall;
                                    this.$irConstructor = $irConstructor;
                                    this.$builder = $builder;
                                    this.$klass = $klass;
                                    this.$setMemberField = $setMemberField;
                                    this.$initFunction = $initFunction;
                                    this.$origParameterSymbol = $origParameterSymbol;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                                    void this_$iv$iv;
                                    IrBlockBuilder p1;
                                    void p0;
                                    void $this$deepCopyWithSymbols_u24default$iv;
                                    Intrinsics.checkNotNullParameter(expression2, "expression");
                                    IrElement irElement = expression2;
                                    IrDeclarationParent initialParent$iv = this.$irConstructor;
                                    boolean $i$f$deepCopyWithSymbols = false;
                                    DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
                                    IrElementVisitorVoidKt.acceptVoid((IrElement)$this$deepCopyWithSymbols_u24default$iv, symbolRemapper$iv);
                                    DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
                                    TypeRemapper typeRemapper = typeRemapper$iv;
                                    SymbolRemapper symbolRemapper = symbolRemapper$iv;
                                    void var13_13 = $this$deepCopyWithSymbols_u24default$iv;
                                    Ref.ObjectRef<IrDelegatingConstructorCall> objectRef = this.$delegatingCtorCall;
                                    DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p0, (TypeRemapper)((Object)p1));
                                    IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var13_13.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
                                    if (irElement2 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall");
                                    }
                                    objectRef.element = (IrDelegatingConstructorCall)irElement2;
                                    IrBuilderWithScope $this$irBlock_u24default$iv = this.$builder;
                                    int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                                    int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                                    IrStatementOrigin origin$iv = null;
                                    IrType resultType$iv = null;
                                    boolean $i$f$irBlock = false;
                                    p1 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                                    boolean $i$f$block = false;
                                    void $this$visitDelegatingConstructorCall_u24lambda_u2d0 = this_$iv$iv;
                                    boolean bl = false;
                                    return this_$iv$iv.doBuild();
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public IrExpression visitSetField(@NotNull IrSetField expression2) {
                                    Intrinsics.checkNotNullParameter(expression2, "expression");
                                    boolean isMemberFieldSet = Intrinsics.areEqual(((IrField)expression2.getSymbol().getOwner()).getParent(), this.$klass);
                                    if (isMemberFieldSet) {
                                        void p1;
                                        void p0;
                                        void $this$deepCopyWithSymbols_u24default$iv;
                                        IrElement irElement = expression2;
                                        IrDeclarationParent initialParent$iv = this.$irConstructor;
                                        boolean $i$f$deepCopyWithSymbols = false;
                                        DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
                                        IrElementVisitorVoidKt.acceptVoid((IrElement)$this$deepCopyWithSymbols_u24default$iv, symbolRemapper$iv);
                                        DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
                                        TypeRemapper typeRemapper = typeRemapper$iv;
                                        SymbolRemapper symbolRemapper = symbolRemapper$iv;
                                        void var12_10 = $this$deepCopyWithSymbols_u24default$iv;
                                        Ref.ObjectRef<IrSetField> objectRef = this.$setMemberField;
                                        DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p0, (TypeRemapper)p1);
                                        IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var12_10.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
                                        if (irElement2 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrSetField");
                                        }
                                        objectRef.element = (IrSetField)irElement2;
                                    }
                                    this.transformChildrenVoid(expression2);
                                    if (isMemberFieldSet) {
                                        return expression2.getValue();
                                    }
                                    return expression2;
                                }

                                @NotNull
                                public IrExpression visitGetField(@NotNull IrGetField expression2) {
                                    Intrinsics.checkNotNullParameter(expression2, "expression");
                                    this.transformChildrenVoid(expression2);
                                    if (Intrinsics.areEqual(((IrField)expression2.getSymbol().getOwner()).getParent(), this.$klass)) {
                                        return ExpressionHelpersKt.irGet(this.$builder, CollectionsKt.single(this.$initFunction.getValueParameters()));
                                    }
                                    return expression2;
                                }

                                @NotNull
                                public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                                    Intrinsics.checkNotNullParameter(expression2, "expression");
                                    this.transformChildrenVoid(expression2);
                                    if (Intrinsics.areEqual(expression2.getSymbol().getOwner().getParent(), this.$klass)) {
                                        return inlineClassDeclarationLowering.transformPrimaryConstructor.1.access$invoke$lambda-1$unboxedInlineClassValue(this.$builder, this.$initFunction, this.$klass);
                                    }
                                    if (Intrinsics.areEqual(expression2.getSymbol(), this.$origParameterSymbol)) {
                                        return ExpressionHelpersKt.irGet(this.$builder, CollectionsKt.single(this.$initFunction.getValueParameters()));
                                    }
                                    return expression2;
                                }
                            }));
                        }
                        $this$invoke_u24lambda_u2d1.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$invoke_u24lambda_u2d1, inlineClassDeclarationLowering.transformPrimaryConstructor.1.invoke$lambda-1$unboxedInlineClassValue((IrBlockBodyBuilder)builder2, irSimpleFunction, irClass2)));
                        object = this_$iv$iv$iv.doBuild().getStatements();
                        boolean bl3 = false;
                        CollectionsKt.addAll(collection, object);
                    }

                    private static final IrTypeOperatorCallImpl invoke$lambda-1$unboxedInlineClassValue(IrBlockBodyBuilder builder2, IrSimpleFunction initFunction, IrClass klass) {
                        return ExpressionHelpersKt.irReinterpretCast(builder2, ExpressionHelpersKt.irGet(builder2, CollectionsKt.single(initFunction.getValueParameters())), IrUtilsKt.getDefaultType(klass));
                    }

                    public static final /* synthetic */ IrTypeOperatorCallImpl access$invoke$lambda-1$unboxedInlineClassValue(IrBlockBodyBuilder builder2, IrSimpleFunction initFunction, IrClass klass) {
                        return inlineClassDeclarationLowering.transformPrimaryConstructor.1.invoke$lambda-1$unboxedInlineClassValue(builder2, initFunction, klass);
                    }
                }));
                irConstructor2.setBody(this.this$0.getContext().getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)new Function1<IrBlockBody, Unit>(delegatingCtorCall, setMemberField){
                    final /* synthetic */ Ref.ObjectRef<IrDelegatingConstructorCall> $delegatingCtorCall;
                    final /* synthetic */ Ref.ObjectRef<IrSetField> $setMemberField;
                    {
                        this.$delegatingCtorCall = $delegatingCtorCall;
                        this.$setMemberField = $setMemberField;
                        super(1);
                    }

                    public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                        Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
                        IrBlockBody irBlockBody = $this$createBlockBody;
                        Collection collection = irBlockBody.getStatements();
                        Intrinsics.checkNotNull(this.$delegatingCtorCall.element);
                        T t = this.$delegatingCtorCall.element;
                        boolean bl = false;
                        collection.add(t);
                        irBlockBody = $this$createBlockBody;
                        collection = irBlockBody.getStatements();
                        Intrinsics.checkNotNull(this.$setMemberField.element);
                        t = this.$setMemberField.element;
                        bl = false;
                        collection.add(t);
                    }
                }));
                IrFunction[] irFunctionArray = new IrFunction[]{irConstructor2, initFunction};
                return CollectionsKt.listOf(irFunctionArray);
            }

            private final void transformConstructorBody(IrConstructor irConstructor2, IrSimpleFunction staticMethod) {
                if (irConstructor2.isPrimary()) {
                    return;
                }
                IrClass irClass2 = IrUtilsKt.getParentAsClass(irConstructor2);
                staticMethod.setBody(this.this$0.getContext().getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)new Function1<IrBlockBody, Unit>(this.this$0, staticMethod, irConstructor2, irClass2){
                    final /* synthetic */ InlineClassLowering this$0;
                    final /* synthetic */ IrSimpleFunction $staticMethod;
                    final /* synthetic */ IrConstructor $irConstructor;
                    final /* synthetic */ IrClass $irClass;
                    {
                        this.this$0 = $receiver;
                        this.$staticMethod = $staticMethod;
                        this.$irConstructor = $irConstructor;
                        this.$irClass = $irClass;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                        void $this$associateByTo$iv$iv;
                        void this_$iv$iv$iv;
                        void startOffset$iv$iv;
                        void $this$irBlockBody$iv$iv;
                        void irElement$iv;
                        void $this$irBlockBody$iv;
                        Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
                        IrBlockBody irBlockBody = $this$createBlockBody;
                        Collection collection = irBlockBody.getStatements();
                        Object object = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), this.$staticMethod.getSymbol(), 0, 0, 6, null);
                        IrElement irElement = this.$staticMethod;
                        IrSimpleFunction irSimpleFunction = this.$staticMethod;
                        IrConstructor irConstructor2 = this.$irConstructor;
                        IrClass irClass2 = this.$irClass;
                        boolean $i$f$irBlockBody = false;
                        void var10_11 = $this$irBlockBody$iv;
                        int n = irElement$iv.getStartOffset();
                        int endOffset$iv$iv = irElement$iv.getEndOffset();
                        boolean $i$f$irBlockBody2 = false;
                        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
                        boolean $i$f$blockBody = false;
                        void $this$invoke_u24lambda_u2d2 = this_$iv$iv$iv;
                        boolean bl = false;
                        Ref.ObjectRef<IrVariable> thisVar = new Ref.ObjectRef<IrVariable>();
                        Object $this$associateBy$iv = irSimpleFunction.getValueParameters();
                        boolean $i$f$associateBy = false;
                        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                        Iterable iterable = $this$associateBy$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv : $this$associateByTo$iv$iv) {
                            void it;
                            IrValueParameter irValueParameter = (IrValueParameter)element$iv$iv;
                            Map map = destination$iv$iv;
                            boolean bl2 = false;
                            IrValueParameterSymbol irValueParameterSymbol = irConstructor2.getValueParameters().get(it.getIndex()).getSymbol();
                            map.put(irValueParameterSymbol, element$iv$iv);
                        }
                        Map parameterMapping = destination$iv$iv;
                        $this$associateBy$iv = irConstructor2.getBody();
                        if ($this$associateBy$iv == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                        }
                        Iterable $this$forEach$iv = ((IrBlockBody)$this$associateBy$iv).getStatements();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            IrStatement statement2 = (IrStatement)element$iv;
                            boolean bl3 = false;
                            $this$invoke_u24lambda_u2d2.unaryPlus(IrElementKt.transformStatement(statement2, new IrElementTransformerVoid((IrBlockBodyBuilder)$this$invoke_u24lambda_u2d2, thisVar, irClass2, irSimpleFunction, parameterMapping, irConstructor2){
                                final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody;
                                final /* synthetic */ Ref.ObjectRef<IrVariable> $thisVar;
                                final /* synthetic */ IrClass $irClass;
                                final /* synthetic */ IrSimpleFunction $staticMethod;
                                final /* synthetic */ Map<IrValueParameterSymbol, IrValueParameter> $parameterMapping;
                                final /* synthetic */ IrConstructor $irConstructor;
                                {
                                    this.$this_irBlockBody = $receiver;
                                    this.$thisVar = $thisVar;
                                    this.$irClass = $irClass;
                                    this.$staticMethod = $staticMethod;
                                    this.$parameterMapping = $parameterMapping;
                                    this.$irConstructor = $irConstructor;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                                    void this_$iv$iv$iv;
                                    void startOffset$iv$iv;
                                    void $this$irBlock$iv$iv;
                                    void $this$irBlock_u24default$iv;
                                    Intrinsics.checkNotNullParameter(expression2, "expression");
                                    this.transformChildrenVoid(expression2);
                                    IrGeneratorWithScope irGeneratorWithScope = this.$this_irBlockBody;
                                    Ref.ObjectRef<IrVariable> objectRef = this.$thisVar;
                                    IrClass irClass2 = this.$irClass;
                                    IrSimpleFunction irSimpleFunction = this.$staticMethod;
                                    IrStatementOrigin origin$iv = null;
                                    IrType resultType$iv = ((IrExpression)expression2).getType();
                                    boolean $i$f$irBlock = false;
                                    void var9_9 = $this$irBlock_u24default$iv;
                                    int n = ((IrExpression)expression2).getStartOffset();
                                    int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
                                    boolean $i$f$irBlock2 = false;
                                    IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
                                    boolean $i$f$block = false;
                                    void $this$visitDelegatingConstructorCall_u24lambda_u2d0 = this_$iv$iv$iv;
                                    boolean bl = false;
                                    objectRef.element = IrBuildersKt.createTmpVariable$default((IrStatementsBuilder)$this$visitDelegatingConstructorCall_u24lambda_u2d0, (IrExpression)expression2, null, false, null, (IrType)IrUtilsKt.getDefaultType(irClass2), 14, null);
                                    if (objectRef.element == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException("thisVar");
                                        throw null;
                                    }
                                    ((IrVariable)objectRef.element).setParent(irSimpleFunction);
                                    return this_$iv$iv$iv.doBuild();
                                }

                                @NotNull
                                public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                                    Intrinsics.checkNotNullParameter(expression2, "expression");
                                    this.transformChildrenVoid(expression2);
                                    IrValueParameter irValueParameter = this.$irClass.getThisReceiver();
                                    if (Intrinsics.areEqual(expression2.getSymbol(), irValueParameter == null ? null : irValueParameter.getSymbol())) {
                                        if (this.$thisVar.element == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("thisVar");
                                            throw null;
                                        }
                                        return ExpressionHelpersKt.irGet(this.$this_irBlockBody, (IrVariable)this.$thisVar.element);
                                    }
                                    Object object = this.$parameterMapping;
                                    Object object2 = expression2.getSymbol();
                                    boolean bl = false;
                                    irValueParameter = object.get(object2);
                                    if (irValueParameter != null) {
                                        object = irValueParameter;
                                        object2 = this.$this_irBlockBody;
                                        bl = false;
                                        boolean bl2 = false;
                                        Object it = object;
                                        boolean bl3 = false;
                                        return ExpressionHelpersKt.irGet((IrBuilderWithScope)object2, (IrValueDeclaration)it);
                                    }
                                    return expression2;
                                }

                                @NotNull
                                public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                                    Intrinsics.checkNotNullParameter(expression2, "expression");
                                    this.transformChildrenVoid(expression2);
                                    Object object = this.$parameterMapping;
                                    Object object2 = expression2.getSymbol();
                                    boolean bl = false;
                                    IrValueParameter irValueParameter = object.get(object2);
                                    if (irValueParameter != null) {
                                        object = irValueParameter;
                                        object2 = this.$this_irBlockBody;
                                        bl = false;
                                        boolean bl2 = false;
                                        Object it = object;
                                        boolean bl3 = false;
                                        return ExpressionHelpersKt.irSet$default((IrBuilderWithScope)object2, ((IrValueParameter)it).getSymbol(), expression2.getValue(), null, 4, null);
                                    }
                                    return expression2;
                                }

                                @NotNull
                                public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                                    IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
                                    if (Intrinsics.areEqual(declaration2.getParent(), this.$irConstructor)) {
                                        declaration2.setParent(this.$staticMethod);
                                    }
                                    return declaration2;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                @NotNull
                                public IrExpression visitReturn(@NotNull IrReturn expression2) {
                                    Intrinsics.checkNotNullParameter(expression2, "expression");
                                    this.transformChildrenVoid(expression2);
                                    if (Intrinsics.areEqual(expression2.getReturnTargetSymbol(), this.$irConstructor.getSymbol())) {
                                        void $this$visitReturn_u24lambda_u2d3;
                                        void this_$iv$iv;
                                        void endOffset$iv;
                                        void startOffset$iv;
                                        void $this$irBlock_u24default$iv;
                                        IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody;
                                        int n = expression2.getStartOffset();
                                        int n2 = expression2.getEndOffset();
                                        Ref.ObjectRef<IrVariable> objectRef = this.$thisVar;
                                        IrStatementOrigin origin$iv = null;
                                        IrType resultType$iv = null;
                                        boolean $i$f$irBlock = false;
                                        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                                        boolean $i$f$block = false;
                                        void var11_11 = this_$iv$iv;
                                        IrBuilderWithScope irBuilderWithScope2 = this.$this_irBlockBody;
                                        boolean bl = false;
                                        $this$visitReturn_u24lambda_u2d3.unaryPlus(expression2.getValue());
                                        if (objectRef.element == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("thisVar");
                                            throw null;
                                        }
                                        $this$visitReturn_u24lambda_u2d3.unaryPlus(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitReturn_u24lambda_u2d3, (IrVariable)objectRef.element));
                                        Unit unit = Unit.INSTANCE;
                                        return ExpressionHelpersKt.irReturn(irBuilderWithScope2, this_$iv$iv.doBuild());
                                    }
                                    return expression2;
                                }
                            }));
                        }
                        if (thisVar.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("thisVar");
                            throw null;
                        }
                        $this$invoke_u24lambda_u2d2.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$invoke_u24lambda_u2d2, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$invoke_u24lambda_u2d2, (IrVariable)thisVar.element)));
                        object = this_$iv$iv$iv.doBuild().getStatements();
                        boolean bl4 = false;
                        CollectionsKt.addAll(collection, object);
                    }
                }));
            }

            private final void transformMethodBodyFlat(IrSimpleFunction function2, IrSimpleFunction staticMethod) {
                if (IrFunctionKt.isStaticMethodOfClass(function2) || !AdditionalIrUtilsKt.isReal(function2)) {
                    return;
                }
                IrBody functionBody = function2.getBody();
                staticMethod.setBody(this.this$0.getContext().getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)new Function1<IrBlockBody, Unit>(functionBody, function2, staticMethod, this.this$0){
                    final /* synthetic */ IrBody $functionBody;
                    final /* synthetic */ IrSimpleFunction $function;
                    final /* synthetic */ IrSimpleFunction $staticMethod;
                    final /* synthetic */ InlineClassLowering this$0;
                    {
                        this.$functionBody = $functionBody;
                        this.$function = $function;
                        this.$staticMethod = $staticMethod;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                        Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
                        IrBody irBody = this.$functionBody;
                        if (irBody == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                        }
                        $this$createBlockBody.getStatements().addAll((Collection<IrStatement>)((IrBlockBody)irBody).getStatements());
                        IrElementTransformerVoidKt.transformChildrenVoid($this$createBlockBody, new IrElementTransformerVoid(this.$function, this.$staticMethod, this.this$0){
                            final /* synthetic */ IrSimpleFunction $function;
                            final /* synthetic */ IrSimpleFunction $staticMethod;
                            final /* synthetic */ InlineClassLowering this$0;
                            {
                                this.$function = $function;
                                this.$staticMethod = $staticMethod;
                                this.this$0 = $receiver;
                            }

                            @NotNull
                            public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                                IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
                                if (Intrinsics.areEqual(declaration2.getParent(), this.$function)) {
                                    declaration2.setParent(this.$staticMethod);
                                }
                                return declaration2;
                            }

                            @NotNull
                            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                                IrValueParameter irValueParameter;
                                IrValueParameter irValueParameter2;
                                Intrinsics.checkNotNullParameter(expression2, "expression");
                                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                                IrValueParameter irValueParameter3 = irValueParameter2 = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                                if (irValueParameter2 == null) {
                                    return super.visitGetValue(expression2);
                                }
                                IrValueParameter valueDeclaration = irValueParameter2;
                                IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), this.$staticMethod.getSymbol(), 0, 0, 6, null);
                                irValueParameter2 = valueDeclaration;
                                if (Intrinsics.areEqual(irValueParameter2, this.$function.getDispatchReceiverParameter()) ? true : Intrinsics.areEqual(irValueParameter2, IrUtilsKt.getParentAsClass(this.$function).getThisReceiver())) {
                                    irValueParameter = this.$staticMethod.getValueParameters().get(0);
                                } else if (Intrinsics.areEqual(irValueParameter2, this.$function.getExtensionReceiverParameter())) {
                                    irValueParameter = this.$staticMethod.getValueParameters().get(1);
                                } else if (this.$function.getValueParameters().contains(irValueParameter2)) {
                                    int offset2 = this.$function.getExtensionReceiverParameter() != null ? 2 : 1;
                                    irValueParameter = this.$staticMethod.getValueParameters().get(valueDeclaration.getIndex() + offset2);
                                } else {
                                    return expression2;
                                }
                                return ExpressionHelpersKt.irGet(irBuilderWithScope, irValueParameter);
                            }

                            @NotNull
                            public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
                                IrValueParameter irValueParameter;
                                Intrinsics.checkNotNullParameter(expression2, "expression");
                                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                                IrValueParameter irValueParameter2 = irValueParameter = irValueDeclaration instanceof IrValueParameter ? (IrValueParameter)irValueDeclaration : null;
                                if (irValueParameter == null) {
                                    return super.visitSetValue(expression2);
                                }
                                IrValueParameter valueDeclaration = irValueParameter;
                                this.transformChildrenVoid(expression2);
                                irValueParameter = valueDeclaration;
                                if (!this.$function.getValueParameters().contains(irValueParameter)) {
                                    return expression2;
                                }
                                int offset2 = this.$function.getExtensionReceiverParameter() != null ? 2 : 1;
                                return ExpressionHelpersKt.irSet$default(LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), this.$staticMethod.getSymbol(), 0, 0, 6, null), this.$staticMethod.getValueParameters().get(valueDeclaration.getIndex() + offset2).getSymbol(), expression2.getValue(), null, 4, null);
                            }
                        });
                    }
                }));
            }

            private final IrBlockBody delegateToStaticMethod(IrSimpleFunction function2, IrSimpleFunction staticMethod) {
                return this.this$0.getContext().getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)new Function1<IrBlockBody, Unit>(this.this$0, function2, staticMethod){
                    final /* synthetic */ InlineClassLowering this$0;
                    final /* synthetic */ IrSimpleFunction $function;
                    final /* synthetic */ IrSimpleFunction $staticMethod;
                    {
                        this.this$0 = $receiver;
                        this.$function = $function;
                        this.$staticMethod = $staticMethod;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                        void this_$iv$iv;
                        void $this$irBlockBody_u24default$iv;
                        Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
                        IrBlockBody irBlockBody = $this$createBlockBody;
                        Collection collection = irBlockBody.getStatements();
                        Object object = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), this.$function.getSymbol(), 0, 0, 6, null);
                        IrSimpleFunction irSimpleFunction = this.$staticMethod;
                        IrSimpleFunction irSimpleFunction2 = this.$function;
                        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                        boolean $i$f$irBlockBody = false;
                        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                        boolean $i$f$blockBody = false;
                        void $this$invoke_u24lambda_u2d1 = this_$iv$iv;
                        boolean bl = false;
                        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$invoke_u24lambda_u2d1, irSimpleFunction);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression;
                        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$invoke_u24lambda_u2d1;
                        void var19_19 = $this$invoke_u24lambda_u2d1;
                        boolean bl4 = false;
                        Object object2 = new IrValueParameter[2];
                        IrValueParameter irValueParameter = irSimpleFunction2.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull(irValueParameter);
                        object2[0] = irValueParameter;
                        object2[1] = irSimpleFunction2.getExtensionReceiverParameter();
                        List<T> parameters2 = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(object2), (Iterable)irSimpleFunction2.getValueParameters());
                        object2 = parameters2.iterator();
                        int n = 0;
                        while (object2.hasNext()) {
                            void $this$invoke_u24lambda_u2d1_u24lambda_u2d0;
                            int index2 = n++;
                            IrValueParameter valueParameter2 = (IrValueParameter)object2.next();
                            $this$invoke_u24lambda_u2d1_u24lambda_u2d0.putValueArgument(index2, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$invoke_u24lambda_u2d1, valueParameter2));
                        }
                        Unit unit = Unit.INSTANCE;
                        var19_19.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irFunctionAccessExpression));
                        object = this_$iv$iv.doBuild().getStatements();
                        boolean bl5 = false;
                        CollectionsKt.addAll(collection, object);
                    }
                });
            }

            public void lower(@NotNull IrFile irFile) {
                DeclarationTransformer.DefaultImpls.lower(this, irFile);
            }

            public boolean getWithLocalDeclarations() {
                return DeclarationTransformer.DefaultImpls.getWithLocalDeclarations(this);
            }
        };
        this.inlineClassUsageLowering = new BodyLoweringPass(this){
            final /* synthetic */ InlineClassLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container2) {
                Intrinsics.checkNotNullParameter(irBody, "irBody");
                Intrinsics.checkNotNullParameter(container2, "container");
                IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this.this$0){
                    final /* synthetic */ InlineClassLowering this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    @NotNull
                    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                        IrConstructor function2 = (IrConstructor)expression2.getSymbol().getOwner();
                        if (!IrUtilsKt.getParentAsClass(function2).isInline()) {
                            return expression2;
                        }
                        return IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2), false, false, null, null, 60, null);
                    }

                    @NotNull
                    public IrExpression visitCall(@NotNull IrCall expression2) {
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                        IrSimpleFunction function2 = (IrSimpleFunction)expression2.getSymbol().getOwner();
                        if (!(function2.getParent() instanceof IrClass) || IrFunctionKt.isStaticMethodOfClass(function2) || !IrUtilsKt.getParentAsClass(function2).isInline() || !AdditionalIrUtilsKt.isReal(function2)) {
                            return expression2;
                        }
                        return IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2), true, false, null, null, 56, null);
                    }

                    @NotNull
                    public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                        IrConstructor function2 = (IrConstructor)expression2.getSymbol().getOwner();
                        IrClass klass = IrUtilsKt.getParentAsClass(function2);
                        return !klass.isInline() ? (IrExpression)expression2 : (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, InlineClassLowering.access$getOrCreateStaticMethod(this.this$0, function2), false, false, null, null, 60, null);
                    }
                });
            }

            public void lower(@NotNull IrFile irFile) {
                BodyLoweringPass.DefaultImpls.lower(this, irFile);
            }
        };
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final DeclarationTransformer getInlineClassDeclarationLowering() {
        return this.inlineClassDeclarationLowering;
    }

    private final IrSimpleFunction getOrCreateStaticMethod(IrFunction function2) {
        return MappingsKt.getOrPut(this.transformedFunction, (IrDeclaration)function2, (Function0)new Function0<IrSimpleFunction>(this, function2){
            final /* synthetic */ InlineClassLowering this$0;
            final /* synthetic */ IrFunction $function;
            {
                this.this$0 = $receiver;
                this.$function = $function;
                super(0);
            }

            @NotNull
            public final IrSimpleFunction invoke() {
                return InlineClassLowering.access$createStaticBodilessMethod(this.this$0, this.$function);
            }
        });
    }

    @NotNull
    public final BodyLoweringPass getInlineClassUsageLowering() {
        return this.inlineClassUsageLowering;
    }

    private final Name toInlineClassImplementationName(IrFunction $this$toInlineClassImplementationName) {
        Name name;
        String newName2 = IrUtilsKt.getParentAsClass($this$toInlineClassImplementationName).getName().asString() + "__" + $this$toInlineClassImplementationName.getName().asString() + "-impl";
        if ($this$toInlineClassImplementationName.getName().isSpecial()) {
            Name name2 = Name.special('<' + newName2 + '>');
            Intrinsics.checkNotNullExpressionValue(name2, "special(\"<$newName>\")");
            name = name2;
        } else {
            Name name3 = Name.identifier(newName2);
            Intrinsics.checkNotNullExpressionValue(name3, "identifier(newName)");
            name = name3;
        }
        return name;
    }

    private final List<IrTypeParameter> collectTypeParameters(IrTypeParametersContainer declaration2) {
        boolean bl = false;
        List result2 = new ArrayList();
        InlineClassLowering.collectTypeParameters$collectImpl(result2, declaration2);
        return result2;
    }

    private final IrSimpleFunction createStaticBodilessMethod(IrFunction function2) {
        return org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createStaticFunctionWithReceivers$default(this.context.getIrFactory(), function2.getParent(), this.toInlineClassImplementationName(function2), function2, null, null, null, null, false, false, this.collectTypeParameters(IrUtilsKt.getParentAsClass(function2)), 504, null);
    }

    private static final void collectTypeParameters$collectImpl(List<IrTypeParameter> result2, IrDeclaration declaration2) {
        if (declaration2 instanceof IrTypeParametersContainer) {
            result2.addAll((Collection<IrTypeParameter>)((IrTypeParametersContainer)declaration2).getTypeParameters());
        }
        if (declaration2 instanceof IrClass && ((IrClass)declaration2).isInner()) {
            InlineClassLowering.collectTypeParameters$collectImpl(result2, (IrDeclaration)((Object)declaration2.getParent()));
        }
    }

    public static final /* synthetic */ IrSimpleFunction access$createStaticBodilessMethod(InlineClassLowering $this, IrFunction function2) {
        return $this.createStaticBodilessMethod(function2);
    }

    public static final /* synthetic */ IrSimpleFunction access$getOrCreateStaticMethod(InlineClassLowering $this, IrFunction function2) {
        return $this.getOrCreateStaticMethod(function2);
    }
}

