/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import com.intellij.rt.coverage.util.classFinder.ClassPathEntry;
import com.intellij.util.lang.UrlClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

final class IdeaClassFinder
extends ClassFinder {
    private final Project myProject;
    private final CoverageSuitesBundle myCurrentSuite;

    IdeaClassFinder(Project project, CoverageSuitesBundle currentSuite) {
        super(IdeaClassFinder.obtainPatternsFromSuite(currentSuite), new ArrayList());
        this.myProject = project;
        this.myCurrentSuite = currentSuite;
    }

    private static List<Pattern> obtainPatternsFromSuite(CoverageSuitesBundle currentSuiteBundle) {
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>();
        for (CoverageSuite currentSuite : currentSuiteBundle.getSuites()) {
            for (String pattern : ((JavaCoverageSuite)currentSuite).getFilteredPackageNames()) {
                includePatterns.add(Pattern.compile(pattern + ".*"));
            }
            for (String pattern : ((JavaCoverageSuite)currentSuite).getFilteredClassNames()) {
                includePatterns.add(Pattern.compile(pattern));
            }
        }
        return includePatterns;
    }

    protected Collection getClassPathEntries() {
        Module[] modules;
        Collection entries = super.getClassPathEntries();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            VirtualFile testOutput;
            CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
            if (extension == null) continue;
            VirtualFile outputFile = extension.getCompilerOutputPath();
            if (outputFile != null) {
                entries.add(new ClassPathEntry(outputFile.getPath(), (ClassLoader)UrlClassLoader.build().files(Collections.singletonList(outputFile.toNioPath())).get()));
            }
            if (!this.myCurrentSuite.isTrackTestFolders() || (testOutput = extension.getCompilerOutputPathForTests()) == null) continue;
            entries.add(new ClassPathEntry(testOutput.getPath(), (ClassLoader)UrlClassLoader.build().files(Collections.singletonList(testOutput.toNioPath())).get()));
        }
        return entries;
    }
}

