/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.util.GradleNameElementUtil;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.SharedParserUtilsKt;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslWriter;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class GroovyDslUtil {
    @NotNull
    private static final Set<String> GROOVY_KEYWORDS = new HashSet<String>(Arrays.asList("as", "assert", "break", "case", "catch", "class", "const", "continue", "def", "default", "do", "else", "enum", "extends", "false", "finally", "for", "goto", "if", "implements", "import", "in", "instanceof", "interface", "new", "null", "package", "return", "super", "switch", "this", "throw", "throws", "trait", "true", "try", "while"));
    @NotNull
    private static final Pattern GROOVY_NORMAL_IDENTIFIER = Pattern.compile("(\\p{L}|[_$])(\\p{L}|[0-9]|[_$])*");

    @Nullable
    static GroovyPsiElement ensureGroovyPsi(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof GroovyPsiElement) {
            return (GroovyPsiElement)element;
        }
        throw new IllegalArgumentException("Wrong PsiElement type for writer! Must be of type GroovyPsiElement");
    }

    static void addConfigBlock(@NotNull GradleDslSettableExpression expression) {
        PsiElement unsavedConfigBlock;
        if (expression == null) {
            GroovyDslUtil.$$$reportNull$$$0(0);
        }
        if ((unsavedConfigBlock = expression.getUnsavedConfigBlock()) == null) {
            return;
        }
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(expression.getPsiElement());
        if (psiElement == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyDslUtil.getPsiElementFactory(expression);
        if (factory == null) {
            return;
        }
        GrApplicationStatement methodCallStatement = (GrApplicationStatement)factory.createStatementFromText((CharSequence)"foo 1, 2");
        PsiElement comma = methodCallStatement.getArgumentList().getFirstChild().getNextSibling();
        psiElement.addAfter(comma, psiElement.getLastChild());
        psiElement.addAfter(factory.createWhiteSpace(), psiElement.getLastChild());
        psiElement.addAfter(unsavedConfigBlock, psiElement.getLastChild());
        expression.setUnsavedConfigBlock(null);
    }

    @Nullable
    static GrClosableBlock getClosableBlock(@NotNull PsiElement element) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(1);
        }
        if (!(element instanceof GrMethodCallExpression)) {
            return null;
        }
        GrClosableBlock[] closureArguments = ((GrMethodCallExpression)element).getClosureArguments();
        if (closureArguments.length > 0) {
            return closureArguments[0];
        }
        return null;
    }

    static GroovyPsiElementFactory getPsiElementFactory(@NotNull GradleDslElement element) {
        GroovyPsiElement psiElement;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(2);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement())) == null) {
            return null;
        }
        Project project = psiElement.getProject();
        return GroovyPsiElementFactory.getInstance((Project)project);
    }

    static String getGradleNameForPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(3);
        }
        final StringBuilder gradleName = new StringBuilder();
        GroovyPsiElementVisitor visitor = new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            public void visitMethodCallExpression(@NotNull GrMethodCallExpression e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getText().startsWith("project") && e.getArgumentList().getAllArguments().length == 1 && e.getArgumentList().getAllArguments()[0] instanceof GrLiteral) {
                    gradleName.append(e.getText().replaceAll("\\s", "").replace("\"", "'"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil$1", "visitMethodCallExpression"));
            }
        });
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof GrMethodCallExpression) {
                child.accept((PsiElementVisitor)visitor);
                continue;
            }
            gradleName.append(child.getText());
        }
        return gradleName.length() == 0 ? element.getText() : gradleName.toString();
    }

    static void maybeDeleteIfEmpty(@Nullable PsiElement element, @NotNull GradleDslElement dslElement) {
        GradleDslElement parentDslElement;
        if (dslElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(4);
        }
        if (((parentDslElement = dslElement.getParent()) instanceof GradleDslExpressionList && !((GradleDslExpressionList)parentDslElement).shouldBeDeleted() || parentDslElement instanceof GradleDslExpressionMap && !((GradleDslExpressionMap)parentDslElement).shouldBeDeleted()) && parentDslElement.getPsiElement() == element) {
            return;
        }
        GroovyDslUtil.deleteIfEmpty(element, dslElement);
    }

    private static void deleteIfEmpty(@Nullable PsiElement element, @NotNull GradleDslElement containingDslElement) {
        if (containingDslElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        GradleDslElement dslParent = SharedParserUtilsKt.getNextValidParent(containingDslElement);
        if (element.isValid()) {
            if (element instanceof GrAssignmentExpression) {
                if (((GrAssignmentExpression)element).getRValue() == null) {
                    element.delete();
                }
            } else if (element instanceof GrApplicationStatement) {
                if (((GrApplicationStatement)element).getArgumentList() == null) {
                    element.delete();
                }
            } else if (element instanceof GrClosableBlock) {
                if (dslParent == null || dslParent.isInsignificantIfEmpty()) {
                    final Boolean[] isEmpty = new Boolean[]{true};
                    ((GrClosableBlock)element).acceptChildren(new GroovyElementVisitor(){

                        public void visitElement(@NotNull GroovyPsiElement child) {
                            if (child == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (child instanceof GrParameterList && ((GrParameterList)child).getParameters().length == 0) {
                                return;
                            }
                            isEmpty[0] = false;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil$2", "visitElement"));
                        }
                    });
                    if (isEmpty[0].booleanValue()) {
                        element.delete();
                    }
                }
            } else if (element instanceof GrMethodCallExpression) {
                GrMethodCallExpression call = (GrMethodCallExpression)element;
                GrArgumentList argumentList = null;
                try {
                    for (PsiElement curr = call.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
                        if (!(curr instanceof GrArgumentList)) continue;
                        argumentList = (GrArgumentList)curr;
                        break;
                    }
                }
                catch (AssertionError e) {
                    argumentList = null;
                }
                GrClosableBlock[] closureArguments = call.getClosureArguments();
                if ((argumentList == null || argumentList.getAllArguments().length == 0) && closureArguments.length == 0) {
                    element.delete();
                }
            } else if (element instanceof GrCommandArgumentList) {
                GrCommandArgumentList commandArgumentList = (GrCommandArgumentList)element;
                if (commandArgumentList.getAllArguments().length == 0) {
                    commandArgumentList.delete();
                }
            } else if (element instanceof GrNamedArgument) {
                GrNamedArgument namedArgument = (GrNamedArgument)element;
                if (namedArgument.getExpression() == null) {
                    namedArgument.delete();
                }
            } else if (element instanceof GrVariableDeclaration) {
                GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)element;
                for (GrVariable grVariable : variableDeclaration.getVariables()) {
                    if (grVariable.getInitializerGroovy() != null) continue;
                    grVariable.delete();
                }
                if (variableDeclaration.getVariables().length == 0) {
                    variableDeclaration.delete();
                }
            } else if (element instanceof GrVariable) {
                GrVariable variable = (GrVariable)element;
                if (variable.getInitializerGroovy() == null) {
                    variable.delete();
                }
            } else if (element instanceof GrListOrMap) {
                GrListOrMap listOrMap = (GrListOrMap)element;
                if (listOrMap.isMap() && listOrMap.getNamedArguments().length == 0) {
                    listOrMap.delete();
                } else if (!listOrMap.isMap() && listOrMap.getInitializers().length == 0) {
                    listOrMap.delete();
                }
            }
        }
        if (!element.isValid()) {
            GroovyDslUtil.handleElementRemoved(parent, element);
            if (dslParent != null) {
                if (element == dslParent.getPsiElement() && dslParent.isInsignificantIfEmpty()) {
                    GroovyDslUtil.maybeDeleteIfEmpty(parent, dslParent);
                } else {
                    GroovyDslUtil.maybeDeleteIfEmpty(parent, containingDslElement);
                }
            }
        }
    }

    static void handleElementRemoved(@Nullable PsiElement psiElement, @Nullable PsiElement removed) {
        if (psiElement == null) {
            return;
        }
        if (psiElement instanceof GrListOrMap) {
            GrListOrMap listOrMap = (GrListOrMap)psiElement;
            if (removed instanceof GrNamedArgument && listOrMap.isEmpty()) {
                ASTNode node = listOrMap.getNode();
                node.addLeaf(GroovyTokenTypes.mCOLON, (CharSequence)":", listOrMap.getRBrack().getNode());
            }
        }
    }

    @Nullable
    static GrExpression extractUnsavedExpression(@NotNull GradleDslSettableExpression literal) {
        GroovyPsiElement newElement;
        if (literal == null) {
            GroovyDslUtil.$$$reportNull$$$0(6);
        }
        if (!((newElement = GroovyDslUtil.ensureGroovyPsi(literal.getUnsavedValue())) instanceof GrExpression)) {
            return null;
        }
        return (GrExpression)newElement;
    }

    private static String escapeString(@NotNull String str, boolean forGString) {
        if (str == null) {
            GroovyDslUtil.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder();
        GrStringUtil.escapeStringCharacters((int)str.length(), (CharSequence)str, (String)(forGString ? "\"" : "'"), (boolean)true, (boolean)true, (StringBuilder)sb);
        return sb.toString();
    }

    @Nullable
    static PsiElement createLiteral(@NotNull GradleDslSimpleExpression context, @NotNull GradleDslFile applyContext, @NotNull Object unsavedValue) throws IncorrectOperationException {
        if (context == null) {
            GroovyDslUtil.$$$reportNull$$$0(8);
        }
        if (applyContext == null) {
            GroovyDslUtil.$$$reportNull$$$0(9);
        }
        if (unsavedValue == null) {
            GroovyDslUtil.$$$reportNull$$$0(10);
        }
        String unsavedValueText = null;
        if (unsavedValue instanceof String) {
            String stringValue = (String)unsavedValue;
            if (StringUtil.isQuotedString((String)stringValue)) {
                String unquotedString = GrStringUtil.removeQuotes((String)stringValue);
                unsavedValueText = GrStringUtil.addQuotes((String)GroovyDslUtil.escapeString(unquotedString, true), (boolean)true);
            } else {
                unsavedValueText = GrStringUtil.addQuotes((String)GroovyDslUtil.escapeString((String)unsavedValue, false), (boolean)false);
            }
        } else if (unsavedValue instanceof Integer || unsavedValue instanceof Boolean || unsavedValue instanceof BigDecimal) {
            unsavedValueText = unsavedValue.toString();
        } else if (unsavedValue instanceof ReferenceTo) {
            if (((ReferenceTo)unsavedValue).getReferredElement() != null) {
                unsavedValueText = GroovyDslUtil.convertToExternalTextValue(((ReferenceTo)unsavedValue).getReferredElement(), context, applyContext, false);
                if (unsavedValueText == null) {
                    unsavedValueText = ((ReferenceTo)unsavedValue).getReferredElement().getFullName();
                }
            } else {
                unsavedValueText = GroovyDslUtil.convertToExternalTextValue(context, applyContext, ((ReferenceTo)unsavedValue).getText(), false);
            }
        } else if (unsavedValue instanceof RawText) {
            unsavedValueText = ((RawText)unsavedValue).getGroovyText();
        }
        if (unsavedValueText == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyDslUtil.getPsiElementFactory(applyContext);
        if (factory == null) {
            return null;
        }
        return factory.createExpressionFromText((CharSequence)unsavedValueText);
    }

    public static String convertToExternalTextValue(GradleDslSimpleExpression context, GradleDslFile applyContext, String referenceText, boolean forInjection) {
        GradleDslElement referenceElement = context.resolveInternalSyntaxReference(referenceText, false);
        if (referenceElement == null) {
            return referenceText;
        }
        String externalReference = GroovyDslUtil.convertToExternalTextValue(referenceElement, context, applyContext, forInjection);
        return externalReference != null ? externalReference : referenceText;
    }

    public static String convertToExternalTextValue(GradleDslElement referenceElement, GradleDslSimpleExpression context, GradleDslFile applyContext, boolean forInjection) {
        StringBuilder externalName = new StringBuilder();
        GradleDslElement currentParent = referenceElement.getParent();
        HashSet<GradleDslElement> contextParents = new HashSet<GradleDslElement>(10);
        for (GradleDslElement contextParent = context.getParent(); contextParent != null && !(contextParent instanceof GradleDslFile); contextParent = contextParent.getParent()) {
            contextParents.add(contextParent);
        }
        ArrayList<GradleDslElement> resolutionElements = new ArrayList<GradleDslElement>();
        resolutionElements.add(referenceElement);
        while (currentParent != null && currentParent.getParent() != null && !contextParents.contains(currentParent)) {
            resolutionElements.add(0, currentParent);
            currentParent = currentParent.getParent();
        }
        for (GradleDslElement currentElement : resolutionElements) {
            List<String> elementExternalNameParts = applyContext.getParser().externalNameForParent((String)currentElement.getName(), (GradleDslElement)currentElement.getParent()).externalNameParts;
            if (currentElement.getParent() instanceof GradleDslExpressionList && currentElement instanceof GradleDslSimpleExpression) {
                GradleDslExpressionList parent = (GradleDslExpressionList)currentElement.getParent();
                int i = parent.getSimpleExpressions().indexOf(currentElement);
                externalName.append(i + "]");
            } else if (!(currentElement instanceof ExtDslElement) && !(currentElement instanceof BuildScriptDslElement)) {
                externalName.append(GroovyDslUtil.quotePartIfNecessary(elementExternalNameParts.get(0)));
            }
            if (currentElement == referenceElement) continue;
            if (currentElement instanceof GradleDslExpressionList) {
                externalName.append("[");
                continue;
            }
            if (currentElement instanceof ExtDslElement || currentElement instanceof BuildScriptDslElement) continue;
            externalName.append(".");
        }
        if (externalName.length() == 0) {
            return null;
        }
        return externalName.toString();
    }

    public static boolean isStringLiteral(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(11);
        }
        if ((node = GroovyDslUtil.getFirstASTNode(element)) == null) {
            return false;
        }
        return TokenSets.STRING_LITERAL_SET.contains(node.getElementType());
    }

    public static boolean decodeStringLiteral(@NotNull PsiElement element, @NotNull StringBuilder sb) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(12);
        }
        if (sb == null) {
            GroovyDslUtil.$$$reportNull$$$0(13);
        }
        String contents = GrStringUtil.removeQuotes((String)element.getText());
        IElementType elementType = element.getFirstChild().getNode().getElementType();
        if (GroovyTokenSets.STRING_LITERALS.contains(elementType) || elementType == GroovyTokenTypes.mGSTRING_CONTENT) {
            return GrStringUtil.parseStringCharacters((String)contents, (StringBuilder)sb, null);
        }
        if (elementType == GroovyTokenTypes.mREGEX_LITERAL || elementType == GroovyTokenTypes.mREGEX_CONTENT) {
            return GrStringUtil.parseRegexCharacters((String)contents, (StringBuilder)sb, null, (boolean)true);
        }
        if (elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_CONTENT) {
            return GrStringUtil.parseRegexCharacters((String)contents, (StringBuilder)sb, null, (boolean)false);
        }
        return false;
    }

    public static String gradleNameFor(GrExpression expression) {
        final boolean[] allValid = new boolean[]{true};
        final StringBuilder result = new StringBuilder();
        expression.accept((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                String name;
                GrExpression qualifierExpression;
                if (referenceExpression == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((qualifierExpression = referenceExpression.getQualifierExpression()) != null) {
                    qualifierExpression.accept((GroovyElementVisitor)this);
                    result.append(".");
                }
                if ((name = referenceExpression.getReferenceName()) != null) {
                    result.append(GradleNameElementUtil.escape(name));
                } else {
                    allValid[0] = false;
                }
            }

            public void visitIndexProperty(@NotNull GrIndexProperty indexPropertyExpression) {
                if (indexPropertyExpression == null) {
                    3.$$$reportNull$$$0(1);
                }
                GrExpression invokedExpression = indexPropertyExpression.getInvokedExpression();
                invokedExpression.accept((GroovyElementVisitor)this);
                result.append("[");
                GrArgumentList argumentList = indexPropertyExpression.getArgumentList();
                GroovyPsiElement[] arguments = argumentList.getAllArguments();
                if (arguments.length != 1) {
                    allValid[0] = false;
                    return;
                }
                result.append(arguments[0].getText());
                result.append("]");
            }

            public void visitElement(@NotNull GroovyPsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(2);
                }
                allValid[0] = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indexPropertyExpression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIndexProperty";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
        return allValid[0] ? result.toString() : null;
    }

    static PsiElement createDerivedMap(@NotNull GradleDslExpressionMap expressionMap) {
        PsiElement parentPsiElement;
        if (expressionMap == null) {
            GroovyDslUtil.$$$reportNull$$$0(14);
        }
        if ((parentPsiElement = GroovyDslUtil.getParentPsi(expressionMap)) == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrExpression emptyMap = factory.createExpressionFromText((CharSequence)"[:]");
        GrNamedArgument namedArgument = factory.createNamedArgument(expressionMap.getName(), emptyMap);
        PsiElement addedElement = GroovyDslUtil.addToMap((GrListOrMap)parentPsiElement, namedArgument);
        assert (addedElement instanceof GrNamedArgument);
        GrExpression added = ((GrNamedArgument)addedElement).getExpression();
        expressionMap.setPsiElement((PsiElement)added);
        return added;
    }

    private static PsiElement realAddBefore(@NotNull GrListOrMap element, @NotNull PsiElement newElement, @NotNull PsiElement anchor) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(15);
        }
        if (newElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(16);
        }
        if (anchor == null) {
            GroovyDslUtil.$$$reportNull$$$0(17);
        }
        CheckUtil.checkWritable((PsiElement)element);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)newElement);
        ASTNode anchorNode = GroovyDslUtil.getAnchorNode((PsiElement)element, anchor.getNode(), true);
        ASTNode newNode = CodeEditUtil.addChildren((ASTNode)element.getNode(), (ASTNode)elementCopy, (ASTNode)elementCopy, (ASTNode)anchorNode);
        if (newNode == null) {
            throw new IncorrectOperationException("Element cannot be added");
        }
        if (newNode instanceof TreeElement) {
            return ChangeUtil.decodeInformation((TreeElement)((TreeElement)newNode)).getPsi();
        }
        return newNode.getPsi();
    }

    private static ASTNode getAnchorNode(@NotNull PsiElement element, ASTNode anchor, Boolean before) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(18);
        }
        ASTNode anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before != null && before == false ? element.getNode().getFirstChildNode() : null);
        return anchorBefore;
    }

    static PsiElement addToMap(@NotNull GrListOrMap map, @NotNull GrNamedArgument newValue) {
        if (map == null) {
            GroovyDslUtil.$$$reportNull$$$0(19);
        }
        if (newValue == null) {
            GroovyDslUtil.$$$reportNull$$$0(20);
        }
        ASTNode astNode = map.getNode();
        if (map.getNamedArguments().length != 0) {
            astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", map.getRBrack().getNode());
        } else {
            while (map.getLBrack().getNextSibling() != map.getRBrack()) {
                map.getLBrack().getNextSibling().delete();
            }
        }
        return GroovyDslUtil.realAddBefore(map, (PsiElement)newValue, map.getRBrack());
    }

    @Nullable
    static PsiElement processListElement(@NotNull GradleDslSettableExpression expression) {
        GradleDslElement parent;
        if (expression == null) {
            GroovyDslUtil.$$$reportNull$$$0(21);
        }
        if ((parent = expression.getParent()) == null) {
            return null;
        }
        PsiElement parentPsi = parent.create();
        if (parentPsi == null) {
            return null;
        }
        PsiElement newExpressionPsi = expression.getUnsavedValue();
        if (newExpressionPsi == null) {
            return null;
        }
        PsiElement added = GroovyDslUtil.createPsiElementInsideList(parent, expression, parentPsi, newExpressionPsi);
        expression.setPsiElement(added);
        expression.commit();
        return expression.getPsiElement();
    }

    @Nullable
    static PsiElement processMapElement(@NotNull GradleDslSettableExpression expression) {
        PsiElement added;
        if (expression == null) {
            GroovyDslUtil.$$$reportNull$$$0(22);
        }
        GradleDslElement parent = expression.getParent();
        assert (parent != null);
        GroovyPsiElement parentPsiElement = GroovyDslUtil.ensureGroovyPsi(parent.create());
        if (parentPsiElement == null) {
            return null;
        }
        expression.setPsiElement((PsiElement)parentPsiElement);
        GrExpression newLiteral = GroovyDslUtil.extractUnsavedExpression(expression);
        if (newLiteral == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)newLiteral.getProject());
        GrNamedArgument namedArgument = factory.createNamedArgument(expression.getName(), newLiteral);
        if (parentPsiElement instanceof GrCommandArgumentList) {
            added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        } else if (parentPsiElement instanceof GrArgumentList) {
            added = ((GrArgumentList)parentPsiElement).addNamedArgument(namedArgument);
        } else if (parentPsiElement instanceof GrListOrMap) {
            GrListOrMap grListOrMap = (GrListOrMap)parentPsiElement;
            added = GroovyDslUtil.addToMap(grListOrMap, namedArgument);
        } else {
            added = parentPsiElement.addBefore((PsiElement)namedArgument, parentPsiElement.getLastChild());
        }
        if (added instanceof GrNamedArgument) {
            GrNamedArgument addedNameArgument = (GrNamedArgument)added;
            GrExpression grExpression = (GrExpression)PsiTreeUtil.getChildOfType((PsiElement)addedNameArgument, GrExpression.class);
            if (grExpression != null) {
                expression.setExpression((PsiElement)grExpression);
                expression.commit();
                expression.reset();
                return expression.getPsiElement();
            }
            return null;
        }
        throw new IllegalStateException("Unexpected element type added to Mpa: " + added);
    }

    static void applyDslLiteralOrReference(@NotNull GradleDslSettableExpression expression, GroovyDslWriter writer) {
        GroovyPsiElement psiElement;
        if (expression == null) {
            GroovyDslUtil.$$$reportNull$$$0(23);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(expression.getPsiElement())) == null) {
            return;
        }
        GroovyDslUtil.maybeUpdateName(expression, writer);
        GrExpression newLiteral = GroovyDslUtil.extractUnsavedExpression(expression);
        if (newLiteral == null) {
            return;
        }
        GroovyPsiElement psiExpression = GroovyDslUtil.ensureGroovyPsi(expression.getExpression());
        if (psiExpression != null) {
            PsiElement replace = psiExpression.replace((PsiElement)newLiteral);
            if (replace instanceof GrLiteral || replace instanceof GrReferenceExpression || replace instanceof GrIndexProperty) {
                expression.setExpression(replace);
            }
        } else {
            PsiElement added;
            if (psiElement instanceof GrApplicationStatement) {
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
                GrApplicationStatement fakeStatement = (GrApplicationStatement)factory.createStatementFromText((CharSequence)"a 'a'");
                GrCommandArgumentList arguments = fakeStatement.getArgumentList();
                arguments.getFirstChild().delete();
                psiElement.addAfter((PsiElement)arguments, psiElement.getLastChild());
                added = ((GrApplicationStatement)psiElement).getArgumentList().add((PsiElement)newLiteral);
            } else {
                added = psiElement.addAfter((PsiElement)newLiteral, psiElement.getLastChild());
            }
            expression.setExpression(added);
            if (expression.getUnsavedConfigBlock() != null) {
                GroovyDslUtil.addConfigBlock(expression);
            }
        }
        expression.reset();
        expression.commit();
    }

    @Nullable
    static PsiElement createNamedArgumentList(@NotNull GradleDslExpressionList expressionList) {
        PsiElement added;
        if (expressionList == null) {
            GroovyDslUtil.$$$reportNull$$$0(24);
        }
        GradleDslElement parent = expressionList.getParent();
        assert (parent instanceof GradleDslExpressionMap);
        PsiElement parentPsiElement = parent.create();
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrExpression expressionFromText = factory.createExpressionFromText((CharSequence)"[]");
        GrNamedArgument namedArgument = factory.createNamedArgument(expressionList.getName(), expressionFromText);
        if (parentPsiElement instanceof GrArgumentList) {
            GrArgumentList argList = (GrArgumentList)parentPsiElement;
            argList.addNamedArgument(namedArgument);
            GrNamedArgument[] args = argList.getNamedArguments();
            added = args[args.length - 1];
        } else if (parentPsiElement instanceof GrListOrMap) {
            GrListOrMap listOrMap = (GrListOrMap)parentPsiElement;
            if (!listOrMap.isEmpty()) {
                ASTNode node = listOrMap.getNode();
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", listOrMap.getLBrack().getNextSibling().getNode());
            }
            added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        } else {
            added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        }
        if (added instanceof GrNamedArgument) {
            GrNamedArgument addedNameArgument = (GrNamedArgument)added;
            expressionList.setPsiElement((PsiElement)addedNameArgument.getExpression());
            return expressionList.getPsiElement();
        }
        return null;
    }

    @Nullable
    static String getInjectionName(@NotNull GrStringInjection injection) {
        if (injection == null) {
            GroovyDslUtil.$$$reportNull$$$0(25);
        }
        String variableName = null;
        GrClosableBlock closableBlock = injection.getClosableBlock();
        if (closableBlock != null) {
            String blockText = closableBlock.getText();
            variableName = blockText.substring(1, blockText.length() - 1);
        } else {
            GrExpression expression = injection.getExpression();
            if (expression != null) {
                variableName = expression.getText();
            }
        }
        return variableName;
    }

    @NotNull
    static String ensureUnquotedText(@NotNull String str) {
        if (str == null) {
            GroovyDslUtil.$$$reportNull$$$0(26);
        }
        if (StringUtil.isQuotedString((String)str)) {
            str = StringUtil.unquoteString((String)str);
        }
        String string = str;
        if (string == null) {
            GroovyDslUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Nullable
    static PsiElement getParentPsi(@NotNull GradleDslElement element) {
        GradleDslElement parent;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(28);
        }
        if ((parent = element.getParent()) == null) {
            return null;
        }
        GroovyPsiElement parentPsiElement = GroovyDslUtil.ensureGroovyPsi(parent.create());
        if (parentPsiElement == null) {
            return null;
        }
        return parentPsiElement;
    }

    static boolean shouldAddToListInternal(@NotNull GradleDslElement element) {
        GradleDslElement parent;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(29);
        }
        if (!((parent = element.getParent()) instanceof GradleDslExpressionList)) {
            return false;
        }
        PsiElement parentPsi = parent.getPsiElement();
        return parentPsi instanceof GrListOrMap && ((GrListOrMap)parentPsi).getInitializers().length > 0 || parentPsi instanceof GrArgumentList && ((GrArgumentList)parentPsi).getAllArguments().length > 0;
    }

    static void emplaceElementIntoList(@NotNull PsiElement anchorBefore, @NotNull PsiElement list, @NotNull PsiElement newElement) {
        if (anchorBefore == null) {
            GroovyDslUtil.$$$reportNull$$$0(30);
        }
        if (list == null) {
            GroovyDslUtil.$$$reportNull$$$0(31);
        }
        if (newElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(32);
        }
        ASTNode node = list.getNode();
        ASTNode anchor = anchorBefore.getNode().getTreeNext();
        node.addChild(newElement.getNode(), anchor);
        node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", newElement.getNode());
    }

    static PsiElement emplaceElementToFrontOfList(@NotNull PsiElement listElement, @NotNull PsiElement newElement) {
        if (listElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(33);
        }
        if (newElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(34);
        }
        assert (listElement instanceof GrListOrMap || listElement instanceof GrArgumentList);
        ASTNode node = listElement.getNode();
        if (listElement instanceof GrListOrMap) {
            GrListOrMap list = (GrListOrMap)listElement;
            ASTNode anchor = list.getLBrack().getNode().getTreeNext();
            if (!list.isEmpty()) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), list.getLBrack().getNode().getTreeNext());
        } else if (((GrArgumentList)listElement).getLeftParen() != null) {
            GrArgumentList list = (GrArgumentList)listElement;
            PsiElement leftParen = list.getLeftParen();
            assert (leftParen != null);
            ASTNode anchor = list.getLeftParen().getNode().getTreeNext();
            if (list.getAllArguments().length != 0) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), list.getLeftParen().getNode().getTreeNext());
        } else {
            ASTNode anchor = GroovyDslUtil.getFirstASTNode(listElement);
            if (anchor != null) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), GroovyDslUtil.getFirstASTNode(listElement));
        }
        return newElement;
    }

    @Nullable
    static ASTNode getFirstASTNode(@NotNull PsiElement parent) {
        PsiElement firstChild;
        if (parent == null) {
            GroovyDslUtil.$$$reportNull$$$0(35);
        }
        if ((firstChild = parent.getFirstChild()) == null) {
            return null;
        }
        return firstChild.getNode();
    }

    @NotNull
    static PsiElement createPsiElementInsideList(@NotNull GradleDslElement parentDslElement, @NotNull GradleDslElement dslElement, @NotNull PsiElement parentPsiElement, @NotNull PsiElement newElement) {
        PsiElement added;
        if (parentDslElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(36);
        }
        if (dslElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(37);
        }
        if (parentPsiElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(38);
        }
        if (newElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(39);
        }
        GradleDslElement anchor = parentDslElement.requestAnchor(dslElement);
        if (GroovyDslUtil.shouldAddToListInternal(dslElement) && anchor != null) {
            PsiElement anchorPsi = anchor.getPsiElement();
            assert (anchorPsi != null);
            GroovyDslUtil.emplaceElementIntoList(anchorPsi, parentPsiElement, newElement);
            added = newElement;
        } else {
            added = GroovyDslUtil.emplaceElementToFrontOfList(parentPsiElement, newElement);
        }
        PsiElement psiElement = added;
        if (psiElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(40);
        }
        return psiElement;
    }

    @NotNull
    static String quotePartIfNecessary(String part) {
        if (!GROOVY_NORMAL_IDENTIFIER.matcher(part).matches()) {
            String string = "'" + part + "'";
            if (string == null) {
                GroovyDslUtil.$$$reportNull$$$0(41);
            }
            return string;
        }
        if (GROOVY_KEYWORDS.contains(part)) {
            String string = "'" + part + "'";
            if (string == null) {
                GroovyDslUtil.$$$reportNull$$$0(42);
            }
            return string;
        }
        String string = part;
        if (string == null) {
            GroovyDslUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    public static String quotePartsIfNecessary(@NotNull List<String> parts) {
        if (parts == null) {
            GroovyDslUtil.$$$reportNull$$$0(44);
        }
        StringBuilder sb = new StringBuilder();
        boolean firstPart = true;
        for (String part : parts) {
            if (!firstPart) {
                sb.append('.');
            } else {
                firstPart = false;
            }
            sb.append(GroovyDslUtil.quotePartIfNecessary(part));
        }
        String string = sb.toString();
        if (string == null) {
            GroovyDslUtil.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    static String quotePartsIfNecessary(@NotNull ExternalNameInfo info) {
        if (info == null) {
            GroovyDslUtil.$$$reportNull$$$0(46);
        }
        List<String> parts = info.externalNameParts;
        if (info.verbatim) {
            String string = String.join((CharSequence)".", parts);
            if (string == null) {
                GroovyDslUtil.$$$reportNull$$$0(47);
            }
            return string;
        }
        return GroovyDslUtil.quotePartsIfNecessary(parts);
    }

    @Nullable
    static PsiElement createNameElement(@NotNull GradleDslElement context, @NotNull String name) {
        GroovyPsiElementFactory factory;
        if (context == null) {
            GroovyDslUtil.$$$reportNull$$$0(48);
        }
        if (name == null) {
            GroovyDslUtil.$$$reportNull$$$0(49);
        }
        if ((factory = GroovyDslUtil.getPsiElementFactory(context)) == null) {
            return null;
        }
        String str = name + " 1";
        GrExpression expression = factory.createExpressionFromText((CharSequence)str);
        if (expression instanceof GrApplicationStatement) {
            return ((GrApplicationStatement)expression).getInvokedExpression();
        }
        return null;
    }

    static void maybeUpdateName(@NotNull GradleDslElement element, GroovyDslWriter writer) {
        PsiNamedElement newElement;
        GradleNameElement nameElement;
        String localName;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(50);
        }
        if ((localName = (nameElement = element.getNameElement()).getLocalName()) == null || localName.isEmpty()) {
            return;
        }
        if (localName.equals(nameElement.getOriginalName())) {
            return;
        }
        PsiElement oldName = element.getNameElement().getNamedPsiElement();
        if (oldName == null) {
            return;
        }
        GradleDslElement parent = element.getParent();
        if (parent != null) {
            ImmutableCollection modelProperties = parent.getExternalToModelMap(writer).values();
            for (ModelEffectDescription value : modelProperties) {
                if (!value.property.name.equals(nameElement.getOriginalName())) continue;
                Logger.getInstance(GroovyDslWriter.class).warn((Throwable)new UnsupportedOperationException("trying to update a property: " + nameElement.getOriginalName()));
                return;
            }
        }
        String newName = GradleNameElementUtil.unescape(localName);
        if (oldName instanceof PsiNamedElement) {
            PsiNamedElement namedElement = (PsiNamedElement)oldName;
            namedElement.setName(newName);
            newElement = namedElement;
        } else {
            PsiElement psiElement = GroovyDslUtil.createNameElement(element, GroovyDslUtil.quotePartIfNecessary(newName));
            if (psiElement == null) {
                return;
            }
            newElement = oldName.replace(psiElement);
        }
        element.getNameElement().commitNameChange((PsiElement)newElement, writer, element.getParent());
    }

    @Nullable
    static PsiElement getPsiElementForAnchor(@NotNull PsiElement parent, @Nullable GradleDslElement dslAnchor) {
        PsiElement anchorAfter;
        if (parent == null) {
            GroovyDslUtil.$$$reportNull$$$0(51);
        }
        PsiElement psiElement = anchorAfter = dslAnchor == null ? null : SharedParserUtilsKt.findLastPsiElementIn(dslAnchor);
        if (anchorAfter == null && parent instanceof GrClosableBlock) {
            return GroovyDslUtil.adjustForCloseableBlock((GrClosableBlock)parent);
        }
        while (anchorAfter != null && !(anchorAfter instanceof PsiFile) && anchorAfter.getParent() != parent) {
            anchorAfter = anchorAfter.getParent();
        }
        return anchorAfter instanceof PsiFile ? (parent instanceof GrClosableBlock ? GroovyDslUtil.adjustForCloseableBlock((GrClosableBlock)parent) : null) : anchorAfter;
    }

    private static PsiElement adjustForCloseableBlock(@NotNull GrClosableBlock block) {
        PsiElement element;
        if (block == null) {
            GroovyDslUtil.$$$reportNull$$$0(52);
        }
        if ((element = block.getFirstChild()) != null) {
            element = element.getNextSibling();
        }
        while (element != null && (element = element.getNextSibling()) != null && (Strings.isNullOrEmpty((String)element.getText()) || element.getText().matches("[\\t ]+"))) {
        }
        return element == null ? null : element.getPrevSibling();
    }

    static boolean needToCreateParent(@NotNull GradleDslElement element) {
        GradleDslElement parent;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(53);
        }
        return (parent = element.getParent()) != null && parent.getPsiElement() == null;
    }

    static boolean hasNewLineBetween(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            GroovyDslUtil.$$$reportNull$$$0(54);
        }
        if (end == null) {
            GroovyDslUtil.$$$reportNull$$$0(55);
        }
        assert (start.getParent() == end.getParent() && start.getStartOffsetInParent() <= end.getStartOffsetInParent());
        for (PsiElement element = start; element != end; element = element.getNextSibling()) {
            if (!element.getNode().getElementType().equals(GroovyTokenTypes.mNLS)) continue;
            return true;
        }
        return false;
    }

    static List<GradleReferenceInjection> findInjections(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement psiElement, boolean includeUnresolved) {
        GrStringInjection[] grStringInjections;
        if (context == null) {
            GroovyDslUtil.$$$reportNull$$$0(56);
        }
        if (psiElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(57);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (psiElement instanceof GrReferenceExpression || psiElement instanceof GrIndexProperty) {
            String text = psiElement.getText();
            GradleDslElement element = context.resolveExternalSyntaxReference(text, true);
            return ImmutableList.of((Object)new GradleReferenceInjection(context, element, psiElement, text));
        }
        if (!(psiElement instanceof GrString)) {
            return Collections.emptyList();
        }
        ArrayList<GradleReferenceInjection> injections = new ArrayList<GradleReferenceInjection>();
        for (GrStringInjection injection : grStringInjections = ((GrString)psiElement).getInjections()) {
            String name;
            if (injection == null || (name = GroovyDslUtil.getInjectionName(injection)) == null) continue;
            GradleDslElement referenceElement = context.resolveExternalSyntaxReference(name, true);
            if (!includeUnresolved && referenceElement == null) continue;
            injections.add(new GradleReferenceInjection(context, referenceElement, (PsiElement)injection, name));
        }
        return injections;
    }

    static void createAndAddClosure(@NotNull GradleDslClosure closure, @NotNull GradleDslElement element) {
        GroovyPsiElement psiElement;
        if (closure == null) {
            GroovyDslUtil.$$$reportNull$$$0(58);
        }
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(59);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement())) == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
        GrClosableBlock block = factory.createClosureFromText("{ }");
        psiElement.addAfter(factory.createWhiteSpace(), psiElement.getLastChild());
        PsiElement newElement = psiElement.addAfter((PsiElement)block, psiElement.getLastChild());
        closure.setPsiElement(newElement);
        closure.applyChanges();
        element.setParsedClosureElement(closure);
        element.setNewClosureElement(null);
    }

    static void deletePsiElement(@NotNull GradleDslElement context, @Nullable PsiElement psiElement) {
        if (context == null) {
            GroovyDslUtil.$$$reportNull$$$0(60);
        }
        if (psiElement == null || !psiElement.isValid()) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        psiElement.delete();
        GroovyDslUtil.maybeDeleteIfEmpty(parent, context);
        SharedParserUtilsKt.removePsiIfInvalid(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 28: 
            case 29: 
            case 50: 
            case 53: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDslElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 7: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 8: 
            case 48: 
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsavedValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionMap";
                break;
            }
            case 16: 
            case 32: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionList";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 27: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorBefore";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listElement";
                break;
            }
            case 35: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDslElement";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPsiElement";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureUnquotedText";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiElementInsideList";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "quotePartIfNecessary";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "quotePartsIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addConfigBlock";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClosableBlock";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementFactory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGradleNameForPsiElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "maybeDeleteIfEmpty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteIfEmpty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractUnsavedExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "escapeString";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "decodeStringLiteral";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDerivedMap";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "realAddBefore";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorNode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addToMap";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processListElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processMapElement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyDslLiteralOrReference";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createNamedArgumentList";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "ensureUnquotedText";
                break;
            }
            case 27: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParentPsi";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddToListInternal";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "emplaceElementIntoList";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "emplaceElementToFrontOfList";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFirstASTNode";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createPsiElementInsideList";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "quotePartsIfNecessary";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createNameElement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "maybeUpdateName";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementForAnchor";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "adjustForCloseableBlock";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "needToCreateParent";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "hasNewLineBetween";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "findInjections";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddClosure";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "deletePsiElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 27: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

