/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.api.util.GradleNameElementUtil;
import com.android.tools.idea.gradle.dsl.parser.GradleDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleNameElement {
    @NotNull
    public static final Pattern INDEX_PATTERN = Pattern.compile("\\[(.+?)\\]|(.+?)(?=\\[)");
    @Nullable
    private PsiElement myNameElement;
    @Nullable
    private String myLocalName;
    @Nullable
    private String myFakeName;
    @Nullable
    private String myName;
    @Nullable
    private String myOriginalName;

    @NotNull
    public static GradleNameElement from(@NotNull PsiElement element, GradleDslNameConverter converter) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(0);
        }
        return new GradleNameElement(element, converter);
    }

    @NotNull
    public static GradleNameElement empty() {
        return new GradleNameElement(null, null);
    }

    @NotNull
    public static GradleNameElement create(@NotNull String name) {
        if (name == null) {
            GradleNameElement.$$$reportNull$$$0(1);
        }
        return new GradleNameElement(GradleNameElementUtil.escape(name), false);
    }

    @NotNull
    public static GradleNameElement fake(@NotNull String name) {
        if (name == null) {
            GradleNameElement.$$$reportNull$$$0(2);
        }
        return new GradleNameElement(name, true);
    }

    @NotNull
    public static GradleNameElement copy(@NotNull GradleNameElement element) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(3);
        }
        return new GradleNameElement(element);
    }

    private GradleNameElement(@Nullable PsiElement element, GradleDslNameConverter converter) {
        this.myName = null;
        this.setUpFrom(element, converter);
    }

    private GradleNameElement(@NotNull String name, boolean isFake) {
        if (name == null) {
            GradleNameElement.$$$reportNull$$$0(4);
        }
        this.myName = null;
        if (isFake) {
            this.myFakeName = name;
        } else {
            this.myLocalName = name;
        }
        this.myOriginalName = name;
    }

    private GradleNameElement(@NotNull GradleNameElement element) {
        if (element == null) {
            GradleNameElement.$$$reportNull$$$0(5);
        }
        this.myName = null;
        this.myLocalName = element.myLocalName;
        this.myFakeName = element.myFakeName;
        this.myOriginalName = element.myOriginalName;
    }

    public void commitNameChange(@Nullable PsiElement nameElement, GradleDslNameConverter converter, GradleDslElement context) {
        this.setUpFrom(nameElement, converter);
        ModelPropertyDescription property = converter.modelDescriptionForParent(this.fullName(), context);
        String newName = property == null ? this.fullName() : property.name;
        this.rename(newName);
        this.myOriginalName = newName;
    }

    @NotNull
    public String fullName() {
        List<String> parts = this.fullNameParts();
        String string = GradleNameElement.createNameFromParts(parts);
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public List<String> fullNameParts() {
        String name = this.findName();
        if (name == null) {
            ArrayList arrayList = Lists.newArrayList();
            if (arrayList == null) {
                GradleNameElement.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        List<String> nameSegments = GradleNameElementUtil.split(name);
        List list = ContainerUtil.map(nameSegments, GradleNameElement::convertNameToKey);
        if (list == null) {
            GradleNameElement.$$$reportNull$$$0(8);
        }
        return list;
    }

    public static String createNameFromParts(@NotNull List<String> parts) {
        if (parts == null) {
            GradleNameElement.$$$reportNull$$$0(9);
        }
        return GradleNameElementUtil.join(parts);
    }

    @NotNull
    public List<String> qualifyingParts() {
        List<String> parts = this.fullNameParts();
        if (parts.isEmpty()) {
            List<String> list = parts;
            if (list == null) {
                GradleNameElement.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<String> list = parts.subList(0, parts.size() - 1);
        if (list == null) {
            GradleNameElement.$$$reportNull$$$0(11);
        }
        return list;
    }

    public boolean isQualified() {
        List<String> parts = this.fullNameParts();
        return parts.size() > 1;
    }

    @NotNull
    public String name() {
        List<String> parts = this.fullNameParts();
        if (parts.isEmpty()) {
            return "";
        }
        String string = parts.get(parts.size() - 1);
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public PsiElement getNamedPsiElement() {
        return this.myNameElement;
    }

    @Nullable
    public String getLocalName() {
        return this.myLocalName;
    }

    @Nullable
    public String getOriginalName() {
        return this.myOriginalName;
    }

    private void internalRename(@NotNull String newName) {
        if (newName == null) {
            GradleNameElement.$$$reportNull$$$0(13);
        }
        if (!this.isFake()) {
            this.myLocalName = newName;
        } else {
            this.myFakeName = newName;
        }
        this.myName = null;
    }

    public void rename(@NotNull String newName) {
        if (newName == null) {
            GradleNameElement.$$$reportNull$$$0(14);
        }
        this.internalRename(GradleNameElementUtil.escape(newName));
    }

    public void rename(@NotNull List<String> hierarchicalName) {
        if (hierarchicalName == null) {
            GradleNameElement.$$$reportNull$$$0(15);
        }
        this.internalRename(GradleNameElementUtil.join(hierarchicalName));
    }

    public boolean isEmpty() {
        String name = this.findName();
        return name == null || name.isEmpty();
    }

    public boolean isFake() {
        return this.myNameElement == null && this.myFakeName != null;
    }

    @NotNull
    public String toString() {
        String string = this.fullName();
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean isReferencedIn(@NotNull String propertyReference) {
        String indexName;
        String name;
        if (propertyReference == null) {
            GradleNameElement.$$$reportNull$$$0(17);
        }
        if (propertyReference.equals(name = this.name())) {
            return true;
        }
        Matcher matcher = INDEX_PATTERN.matcher(propertyReference);
        if (matcher.find() && matcher.groupCount() > 0 && (indexName = matcher.group(0)).equals(name)) {
            return true;
        }
        List<String> parts = GradleNameElementUtil.split(propertyReference);
        if (!parts.isEmpty() && parts.get(0).equals(name)) {
            return true;
        }
        return parts.size() > 1 && parts.get(0).equals(ExtDslElement.EXT.name) && parts.get(1).equals(name);
    }

    @Nullable
    private String findName() {
        if (this.myName != null) {
            return this.myName;
        }
        String name = null;
        if (this.myLocalName != null) {
            name = this.myLocalName;
        }
        if (name == null && this.myFakeName != null) {
            name = this.myFakeName;
        }
        this.myName = name;
        return name;
    }

    @NotNull
    public static String convertNameToKey(@NotNull String str) {
        if (str == null) {
            GradleNameElement.$$$reportNull$$$0(18);
        }
        String string = StringUtil.unquoteString((String)str);
        if (string == null) {
            GradleNameElement.$$$reportNull$$$0(19);
        }
        return string;
    }

    private void setUpFrom(@Nullable PsiElement element, GradleDslNameConverter converter) {
        this.myNameElement = element;
        this.myFakeName = null;
        if (this.myNameElement instanceof PsiNamedElement) {
            this.myLocalName = GradleNameElementUtil.escape(((PsiNamedElement)this.myNameElement).getName());
        } else if (this.myNameElement != null) {
            this.myLocalName = converter.psiToName(this.myNameElement);
        }
        this.myOriginalName = this.myLocalName;
        this.myName = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleNameElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchicalName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyReference";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/elements/GradleNameElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fullName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fullNameParts";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifyingParts";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNameToKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fake";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNameFromParts";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "internalRename";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedIn";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "convertNameToKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

