/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.util.GradleNameElementUtil;
import com.android.tools.idea.gradle.dsl.api.util.TypeReference;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.FakeElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslUnknownElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradlePropertyModelImpl
implements GradlePropertyModel {
    @Nullable
    protected GradleDslElement myElement;
    @Nullable
    protected GradleDslElement myDefaultElement;
    @NotNull
    protected GradleDslElement myPropertyHolder;
    @NotNull
    private List<PropertyTransform> myTransforms;
    @NotNull
    private final PropertyType myPropertyType;
    @NotNull
    protected String myName;
    @Nullable
    protected ModelPropertyDescription myPropertyDescription;

    public GradlePropertyModelImpl(@NotNull GradleDslElement element) {
        if (element == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(0);
        }
        this.myTransforms = new ArrayList<PropertyTransform>();
        this.myElement = element;
        this.myTransforms.add(PropertyUtil.DEFAULT_TRANSFORM);
        GradleDslElement parent = element.getParent();
        if (parent == null) {
            assert (element instanceof GradleDslFile);
            parent = element;
        }
        assert (parent instanceof GradlePropertiesDslElement || parent instanceof GradleDslMethodCall) : "Property found to be invalid, this should never happen!";
        this.myPropertyHolder = parent;
        this.myPropertyType = this.myElement.getElementType();
        this.myName = this.myElement.getName();
        this.myPropertyDescription = this.myElement.getModelProperty();
    }

    public GradlePropertyModelImpl(@NotNull GradleDslElement holder, @NotNull PropertyType type, @NotNull String name) {
        if (holder == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(2);
        }
        if (name == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(3);
        }
        this.myTransforms = new ArrayList<PropertyTransform>();
        this.myPropertyHolder = holder;
        this.myPropertyType = type;
        this.myName = name;
        this.myTransforms.add(PropertyUtil.DEFAULT_TRANSFORM);
        this.myPropertyDescription = null;
    }

    public GradlePropertyModelImpl(@NotNull GradleDslElement holder, @NotNull PropertyType type, @NotNull ModelPropertyDescription description) {
        if (holder == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(4);
        }
        if (type == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(5);
        }
        if (description == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(6);
        }
        this(holder, type, description.name);
        this.myPropertyDescription = description;
    }

    public void addTransform(@NotNull PropertyTransform transform) {
        if (transform == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(7);
        }
        this.myTransforms.add(0, transform);
    }

    @Nullable
    public GradleDslElement getDefaultElement() {
        return this.myDefaultElement;
    }

    public void setDefaultElement(@NotNull GradleDslElement defaultElement) {
        if (defaultElement == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(8);
        }
        this.myDefaultElement = defaultElement;
    }

    @Override
    @NotNull
    public GradlePropertyModel.ValueType getValueType() {
        GradlePropertyModel.ValueType valueType = GradlePropertyModelImpl.extractAndGetValueType(this.getElement());
        if (valueType == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(9);
        }
        return valueType;
    }

    @Override
    @NotNull
    public PropertyType getPropertyType() {
        GradleDslElement element = this.getElement();
        PropertyType propertyType = element == null ? this.myPropertyType : element.getElementType();
        if (propertyType == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(10);
        }
        return propertyType;
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull TypeReference<T> typeReference) {
        if (typeReference == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(11);
        }
        return this.extractValue(typeReference, true);
    }

    @Override
    public <T> T getRawValue(@NotNull TypeReference<T> typeReference) {
        if (typeReference == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(12);
        }
        return this.extractValue(typeReference, false);
    }

    @Nullable
    private static GradleDslElement maybeGetInnerReferenceModel(@NotNull GradleDslElement element) {
        GradleDslLiteral reference;
        GradleReferenceInjection injection;
        GradleDslExpression expression;
        GradleDslExpressionList list;
        if (element == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(13);
        }
        if (GradlePropertyModelImpl.extractAndGetValueType(element) == GradlePropertyModel.ValueType.LIST && element instanceof GradleDslExpressionList && (list = (GradleDslExpressionList)element).getExpressions().size() == 1 && (expression = list.getElementAt(0)) instanceof GradleDslLiteral && ((GradleDslLiteral)expression).isReference() && (injection = (reference = (GradleDslLiteral)expression).getReferenceInjection()) != null) {
            return injection.getToBeInjected();
        }
        return null;
    }

    @NotNull
    private Map<String, GradlePropertyModel> getMap(boolean resolved) {
        GradleDslExpressionMap map;
        GradleDslElement element = this.getElement();
        if (element == null) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                GradlePropertyModelImpl.$$$reportNull$$$0(14);
            }
            return immutableMap;
        }
        GradleDslElement innerElement = GradlePropertyModelImpl.maybeGetInnerReferenceModel(element);
        if (resolved && innerElement instanceof GradleDslExpressionMap) {
            map = (GradleDslExpressionMap)innerElement;
        } else {
            assert (element instanceof GradleDslExpressionMap);
            map = (GradleDslExpressionMap)element;
        }
        Map map2 = map.getPropertyElements(GradleDslExpression.class).stream().collect(Collectors.toMap(e -> e.getName(), e -> new GradlePropertyModelImpl((GradleDslElement)e), (u, v) -> v, LinkedHashMap::new));
        if (map2 == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(15);
        }
        return map2;
    }

    @NotNull
    private List<GradlePropertyModel> getList(boolean resolved) {
        GradleDslElement innerElement;
        GradleDslElement element = this.getElement();
        if (element == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GradlePropertyModelImpl.$$$reportNull$$$0(16);
            }
            return immutableList;
        }
        assert (element instanceof GradleDslExpressionList);
        GradleDslExpressionList list = (GradleDslExpressionList)element;
        if (resolved && (innerElement = GradlePropertyModelImpl.maybeGetInnerReferenceModel(element)) instanceof GradleDslExpressionList) {
            list = (GradleDslExpressionList)innerElement;
        }
        List list2 = ContainerUtil.map(list.getExpressions(), e -> new GradlePropertyModelImpl((GradleDslElement)e));
        if (list2 == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getName() {
        GradleDslExpressionList list;
        int index;
        GradleDslElement element = this.getElement();
        if (element != null && element.getParent() instanceof GradleDslExpressionList && (index = (list = (GradleDslExpressionList)element.getParent()).findIndexOf(element)) != -1) {
            String string = String.valueOf(index);
            if (string == null) {
                GradlePropertyModelImpl.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = element == null ? this.myName : element.getName();
        if (string == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    @NotNull
    public List<GradlePropertyModel> getDependencies() {
        return new ArrayList<GradlePropertyModel>(this.dependencies());
    }

    @Override
    @NotNull
    public String getFullyQualifiedName() {
        GradleDslElement element = this.getRawElement();
        if (element != null && element.getParent() instanceof GradleDslExpressionList) {
            GradleDslExpressionList list = (GradleDslExpressionList)element.getParent();
            String string = element.getParent().getQualifiedName() + "[" + String.valueOf(list.findIndexOf(element)) + "]";
            if (string == null) {
                GradlePropertyModelImpl.$$$reportNull$$$0(20);
            }
            return string;
        }
        Object object = element == null ? this.myPropertyHolder.getQualifiedName() + "." + this.getName() : element.getQualifiedName();
        if (object == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(21);
        }
        return object;
    }

    @Override
    @NotNull
    public VirtualFile getGradleFile() {
        VirtualFile virtualFile = this.myPropertyHolder.getDslFile().getFile();
        if (virtualFile == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(22);
        }
        return virtualFile;
    }

    @Override
    public void setValue(@NotNull Object value) {
        if (value == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(23);
        }
        GradleDslExpression newElement = this.myPropertyDescription == null ? this.getTransform().bind(this.myPropertyHolder, this.myElement, value, this.getName()) : this.getTransform().bind(this.myPropertyHolder, this.myElement, value, this.myPropertyDescription);
        this.bindToNewElement(newElement);
    }

    @Override
    @NotNull
    public GradlePropertyModel convertToEmptyMap() {
        this.makeEmptyMap();
        GradlePropertyModelImpl gradlePropertyModelImpl = this;
        if (gradlePropertyModelImpl == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(24);
        }
        return gradlePropertyModelImpl;
    }

    @Override
    @NotNull
    public GradlePropertyModel getMapValue(@NotNull String key) {
        GradlePropertyModel.ValueType valueType;
        if (key == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(25);
        }
        if ((valueType = this.getValueType()) != GradlePropertyModel.ValueType.MAP && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't add map value to type: " + valueType + ". Please call GradlePropertyModel#convertToMap before trying to add values");
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyMap();
        }
        GradleDslElement element = this.getTransform().transform(this.myElement);
        assert (element instanceof GradleDslExpressionMap);
        GradleDslExpressionMap map = (GradleDslExpressionMap)element;
        GradleDslElement arg = map.getPropertyElement(key);
        return arg == null ? new GradlePropertyModelImpl(element, PropertyType.DERIVED, key) : new GradlePropertyModelImpl(arg);
    }

    @Override
    @NotNull
    public GradlePropertyModel convertToEmptyList() {
        this.makeEmptyList();
        GradlePropertyModelImpl gradlePropertyModelImpl = this;
        if (gradlePropertyModelImpl == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(26);
        }
        return gradlePropertyModelImpl;
    }

    @Override
    @NotNull
    public GradlePropertyModel addListValue() {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't add list value to type: " + valueType + ". Please call GradlePropertyModel#convertToList before trying to add values");
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyList();
        }
        GradleDslElement element = this.getTransform().transform(this.myElement);
        assert (element instanceof GradleDslExpressionList);
        GradlePropertyModel gradlePropertyModel = this.addListValueAt(((GradleDslExpressionList)element).getExpressions().size());
        if (gradlePropertyModel == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(27);
        }
        return gradlePropertyModel;
    }

    @Override
    @NotNull
    public GradlePropertyModel addListValueAt(int index) {
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't add list value to type: " + valueType + ". Please call GradlePropertyModel#convertToList before trying to add values");
        }
        if (valueType == GradlePropertyModel.ValueType.NONE || this.myElement == null) {
            this.makeEmptyList();
        }
        GradleDslElement element = this.getTransform().transform(this.myElement);
        assert (element instanceof GradleDslExpressionList);
        GradleDslLiteral literal = new GradleDslLiteral(element, GradleNameElement.empty());
        literal.setValue("");
        GradleDslExpressionList list = (GradleDslExpressionList)element;
        list.addNewExpression(literal, index);
        return new GradlePropertyModelImpl(literal);
    }

    @Override
    @Nullable
    public GradlePropertyModel getListValue(@NotNull Object value) {
        GradlePropertyModel.ValueType valueType;
        if (value == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(28);
        }
        if ((valueType = this.getValueType()) != GradlePropertyModel.ValueType.LIST && valueType != GradlePropertyModel.ValueType.NONE) {
            throw new IllegalStateException("Can't get list value on type: " + valueType + ". Please call GradlePropertyModel#convertToList before trying to get values");
        }
        List list = (List)this.getValue(LIST_TYPE);
        if (list == null) {
            return null;
        }
        return list.stream().filter(e -> {
            Object v = e.getValue(OBJECT_TYPE);
            return v != null && v.equals(value);
        }).findFirst().orElse(null);
    }

    @Override
    public void delete() {
        GradleDslElement element = this.getElement();
        if (element == null || this.myElement == null) {
            return;
        }
        this.myElement = this.getTransform().delete(this.myPropertyHolder, this.myElement, element);
    }

    @Override
    @NotNull
    public ResolvedPropertyModelImpl resolve() {
        return new ResolvedPropertyModelImpl(this);
    }

    @Override
    @NotNull
    public GradlePropertyModel getUnresolvedModel() {
        GradlePropertyModelImpl gradlePropertyModelImpl = this;
        if (gradlePropertyModelImpl == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(29);
        }
        return gradlePropertyModelImpl;
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        GradleDslElement element = this.getElement();
        if (element == null) {
            return null;
        }
        return element.getPsiElement();
    }

    @Override
    @Nullable
    public PsiElement getExpressionPsiElement() {
        return this.getExpressionPsiElement(false);
    }

    @Override
    @Nullable
    public PsiElement getFullExpressionPsiElement() {
        return this.getExpressionPsiElement(true);
    }

    @Nullable
    private PsiElement getExpressionPsiElement(boolean fullExpression) {
        GradleDslElement element;
        GradleDslElement gradleDslElement = element = fullExpression ? this.myElement : this.getElement();
        if (element instanceof GradleDslExpression) {
            return ((GradleDslExpression)element).getExpression();
        }
        return element == null ? null : element.getPsiElement();
    }

    @Override
    public void rename(@NotNull String name) {
        if (name == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(30);
        }
        this.rename(Arrays.asList(name));
    }

    @Override
    public void rename(@NotNull List<String> name) {
        if (name == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(31);
        }
        if (this.myElement == null) {
            this.myName = GradleNameElementUtil.join(name);
            return;
        }
        GradleDslElement element = this.getElement();
        if (element == null) {
            return;
        }
        GradleDslElement parent = element.getParent();
        if (parent instanceof GradleDslExpressionList || parent instanceof GradleDslMethodCall) {
            throw new UnsupportedOperationException("Can't rename list values!");
        }
        element.rename(name);
        this.myName = this.myElement.getName();
    }

    @Override
    public boolean isModified() {
        GradleDslElement element = this.myElement;
        if (element != null) {
            if (element instanceof FakeElement) {
                return PropertyUtil.isFakeElementModified((FakeElement)element);
            }
            GradleDslElement originalElement = PropertyUtil.findOriginalElement(this.myPropertyHolder, element);
            return originalElement == null || PropertyUtil.isElementModified(originalElement, element);
        }
        GradlePropertiesDslElement holder = this.myPropertyHolder instanceof GradleDslMethodCall ? ((GradleDslMethodCall)this.myPropertyHolder).getArgumentsElement() : (GradlePropertiesDslElement)this.myPropertyHolder;
        GradleDslElement originalElement = holder.getOriginalElementForNameAndType(this.getName(), this.myPropertyType);
        GradleDslElement holderOriginalElement = PropertyUtil.findOriginalElement(holder.getParent(), holder);
        return originalElement != null && (originalElement.isModified() || PropertyUtil.isElementModified(holderOriginalElement, holder));
    }

    @Override
    public String toString() {
        return (String)this.getValue(STRING_TYPE);
    }

    @Override
    @Nullable
    public String valueAsString() {
        return (String)this.getValue(STRING_TYPE);
    }

    @Override
    @NotNull
    public String forceString() {
        String s = this.toString();
        assert (s != null);
        String string = s;
        if (string == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    @Nullable
    public Integer toInt() {
        return (Integer)this.getValue(INTEGER_TYPE);
    }

    @Override
    @Nullable
    public BigDecimal toBigDecimal() {
        return (BigDecimal)this.getValue(BIG_DECIMAL_TYPE);
    }

    @Override
    @Nullable
    public Boolean toBoolean() {
        return (Boolean)this.getValue(BOOLEAN_TYPE);
    }

    @Override
    @Nullable
    public List<GradlePropertyModel> toList() {
        return (List)this.getValue(LIST_TYPE);
    }

    @Override
    @Nullable
    public Map<String, GradlePropertyModel> toMap() {
        return (Map)this.getValue(MAP_TYPE);
    }

    private static GradlePropertyModel.ValueType extractAndGetValueType(@Nullable GradleDslElement element) {
        if (element == null) {
            return GradlePropertyModel.ValueType.NONE;
        }
        if (element instanceof GradleDslExpressionMap) {
            return GradlePropertyModel.ValueType.MAP;
        }
        if (element instanceof GradleDslExpressionList) {
            return GradlePropertyModel.ValueType.LIST;
        }
        if (element instanceof GradleDslSimpleExpression && ((GradleDslSimpleExpression)element).isReference()) {
            return GradlePropertyModel.ValueType.REFERENCE;
        }
        if (element instanceof GradleDslMethodCall && (element.shouldUseAssignment() || element.getElementType() == PropertyType.DERIVED) || element instanceof GradleDslUnknownElement) {
            return GradlePropertyModel.ValueType.UNKNOWN;
        }
        if (element instanceof GradleDslSimpleExpression) {
            GradleDslSimpleExpression expression = (GradleDslSimpleExpression)element;
            Object value = expression.getValue();
            if (value instanceof Boolean) {
                return GradlePropertyModel.ValueType.BOOLEAN;
            }
            if (value instanceof Integer) {
                return GradlePropertyModel.ValueType.INTEGER;
            }
            if (value instanceof String) {
                return GradlePropertyModel.ValueType.STRING;
            }
            if (value instanceof BigDecimal) {
                return GradlePropertyModel.ValueType.BIG_DECIMAL;
            }
            if (value == null) {
                return GradlePropertyModel.ValueType.NONE;
            }
            return GradlePropertyModel.ValueType.UNKNOWN;
        }
        return GradlePropertyModel.ValueType.UNKNOWN;
    }

    @Nullable
    private <T> T extractValue(@NotNull TypeReference<T> typeReference, boolean resolved) {
        Object value;
        GradleDslElement element;
        if (typeReference == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(33);
        }
        if ((element = this.getElement()) == null) {
            element = this.getDefaultElement();
        }
        if (element == null) {
            return null;
        }
        GradlePropertyModel.ValueType valueType = this.getValueType();
        if (valueType == GradlePropertyModel.ValueType.MAP) {
            value = this.getMap(resolved);
        } else if (valueType == GradlePropertyModel.ValueType.LIST) {
            value = this.getList(resolved);
        } else if (valueType == GradlePropertyModel.ValueType.REFERENCE) {
            ReferenceTo referenceVal;
            GradleDslSimpleExpression ref = (GradleDslSimpleExpression)element;
            String refText = ref.getReferenceText();
            value = typeReference.getType() == Object.class || typeReference.getType() == ReferenceTo.class ? (refText != null ? ((referenceVal = ReferenceTo.createReferenceFromText(refText, this)) != null ? typeReference.castTo(referenceVal) : typeReference.castTo(new RawText(refText, refText))) : null) : (refText == null ? null : typeReference.castTo(refText));
        } else if (valueType == GradlePropertyModel.ValueType.UNKNOWN) {
            if (!(element instanceof GradleDslBlockElement)) {
                PsiElement psiElement;
                PsiElement psiElement2 = psiElement = element instanceof GradleDslSettableExpression ? ((GradleDslSettableExpression)element).getCurrentElement() : element.getPsiElement();
                if (psiElement == null) {
                    return null;
                }
                value = GradleDslElementImpl.getPsiText(psiElement);
            } else {
                value = element.getFullName();
            }
        } else {
            GradleDslSimpleExpression expression = (GradleDslSimpleExpression)element;
            Object object = value = resolved ? expression.getValue() : expression.getUnresolvedValue();
        }
        if (value == null) {
            return null;
        }
        T result = typeReference.castTo(value);
        if (result == null && typeReference.getType().equals(String.class)) {
            result = typeReference.castTo(value.toString());
        }
        return result;
    }

    private void makeEmptyMap() {
        if (this.myPropertyDescription == null) {
            this.bindToNewElement(this.getTransform().bindMap(this.myPropertyHolder, this.myElement, this.getName(), false));
        } else {
            this.bindToNewElement(this.getTransform().bindMap(this.myPropertyHolder, this.myElement, this.myPropertyDescription, false));
        }
    }

    private void makeEmptyList() {
        if (this.myPropertyDescription == null) {
            this.bindToNewElement(this.getTransform().bindList(this.myPropertyHolder, this.myElement, this.getName(), false));
        } else {
            this.bindToNewElement(this.getTransform().bindList(this.myPropertyHolder, this.myElement, this.myPropertyDescription, false));
        }
    }

    private void bindToNewElement(@NotNull GradleDslExpression newElement) {
        if (newElement == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(34);
        }
        if (newElement == this.myElement) {
            return;
        }
        if (this.myElement != null && this.myElement.getElementType() == PropertyType.FAKE) {
            throw new UnsupportedOperationException("Can't bind from a fake element!");
        }
        GradleDslElement element = this.getTransform().replace(this.myPropertyHolder, this.myElement, newElement, this.getName());
        element.setElementType(this.myPropertyType);
        if (this.myElement != null) {
            element.setUseAssignment(this.myElement.shouldUseAssignment());
        }
        if (this.myElement != null) {
            element.setModelEffect(this.myElement.getModelEffect());
        }
        element.setModified();
        this.myElement = element;
    }

    @Nullable
    public GradleDslElement getElement() {
        return this.getTransform().transform(this.myElement);
    }

    @Override
    @Nullable
    public GradleDslElement getRawElement() {
        return this.myElement;
    }

    @Override
    @NotNull
    public GradleDslElement getRawPropertyHolder() {
        GradleDslElement gradleDslElement = this.myPropertyHolder;
        if (gradleDslElement == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(35);
        }
        return gradleDslElement;
    }

    @NotNull
    protected PropertyTransform getTransform() {
        for (PropertyTransform transform : this.myTransforms) {
            if (!transform.test(this.myElement, this.myPropertyHolder)) continue;
            PropertyTransform propertyTransform = transform;
            if (propertyTransform == null) {
                GradlePropertyModelImpl.$$$reportNull$$$0(36);
            }
            return propertyTransform;
        }
        throw new IllegalStateException("No transforms found for this property model!");
    }

    @NotNull
    List<GradlePropertyModelImpl> dependencies() {
        GradleDslElement element = this.getElement();
        if (element == null) {
            List<GradlePropertyModelImpl> list = Collections.emptyList();
            if (list == null) {
                GradlePropertyModelImpl.$$$reportNull$$$0(37);
            }
            return list;
        }
        List<GradlePropertyModelImpl> list = element.getResolvedVariables().stream().map(injection -> {
            GradleDslElement injected = injection.getToBeInjected();
            return injected != null ? new GradlePropertyModelImpl(injected) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            GradlePropertyModelImpl.$$$reportNull$$$0(38);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultElement";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/ext/GradlePropertyModelImpl";
                break;
            }
            case 11: 
            case 12: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeReference";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/ext/GradlePropertyModelImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullyQualifiedName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToEmptyMap";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToEmptyList";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "addListValue";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedModel";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "forceString";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawPropertyHolder";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransform";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTransform";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultElement";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRawValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "maybeGetInnerReferenceModel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMapValue";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getListValue";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "extractValue";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "bindToNewElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

