/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyConfigurationModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyConfigurationModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.FakeElementTransform;
import com.android.tools.idea.gradle.dsl.parser.dependencies.FakeArtifactElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactDependencyModelImpl
extends DependencyModelImpl
implements ArtifactDependencyModel {
    @Nullable
    private GradleDslClosure myConfigurationElement;
    protected boolean mySetThrough;
    @NotNull
    private static final Pattern WRAPPED_VARIABLE_FORM = Pattern.compile("\\$\\{(.*)}");
    @NotNull
    private static final Pattern UNWRAPPED_VARIABLE_FORM = Pattern.compile("\\$(([a-zA-Z0-9_]\\w*)(\\.([a-zA-Z0-9_]\\w+))*)");

    public ArtifactDependencyModelImpl(@Nullable GradleDslClosure configurationElement, @NotNull String configurationName, @NotNull DependencyModelImpl.Maintainer maintainer) {
        if (configurationName == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(0);
        }
        if (maintainer == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(1);
        }
        super(configurationName, maintainer);
        this.mySetThrough = false;
        this.myConfigurationElement = configurationElement;
    }

    @Override
    @NotNull
    public ArtifactDependencySpec getSpec() {
        String name = this.name().toString();
        assert (name != null);
        return new ArtifactDependencySpecImpl(name, this.group().toString(), this.version().toString(), this.classifier().toString(), this.extension().toString());
    }

    @Override
    @NotNull
    public String compactNotation() {
        String string = this.getSpec().compactNotation();
        if (string == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public abstract ResolvedPropertyModel name();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel group();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel version();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel classifier();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel extension();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel completeModel();

    @Override
    @Nullable
    public DependencyConfigurationModel configuration() {
        if (this.myConfigurationElement == null) {
            return null;
        }
        return new DependencyConfigurationModelImpl(this.myConfigurationElement);
    }

    @Override
    public void enableSetThrough() {
        this.mySetThrough = true;
    }

    @Override
    public void disableSetThrough() {
        this.mySetThrough = false;
    }

    static void createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        if (parent == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(3);
        }
        if (configurationName == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(4);
        }
        if (dependency == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(5);
        }
        if (excludes == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(6);
        }
        GradleNameElement name = GradleNameElement.create(configurationName);
        GradleDslLiteral literal = new GradleDslLiteral(parent, name);
        literal.setElementType(PropertyType.REGULAR);
        literal.setValue(ArtifactDependencyModelImpl.createCompactNotationForLiterals(literal, dependency));
        if (!excludes.isEmpty()) {
            PsiElement configBlock = parent.getDslFile().getParser().convertToExcludesBlock(excludes);
            assert (configBlock != null);
            literal.setConfigBlock(configBlock);
        }
        parent.setNewElement(literal);
    }

    @NotNull
    private static String createCompactNotationForLiterals(@NotNull GradleDslElement dslElement, @NotNull ArtifactDependencySpec spec) {
        if (dslElement == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(7);
        }
        if (spec == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(8);
        }
        ArrayList segments = Lists.newArrayList((Object[])new String[]{spec.getGroup(), spec.getName(), spec.getVersion(), spec.getClassifier(), spec.getExtension()});
        boolean shouldInterpolate = false;
        StringBuilder compactNotation = new StringBuilder();
        for (int currentElementIdx = 0; currentElementIdx < segments.size(); ++currentElementIdx) {
            String segment = (String)segments.get(currentElementIdx);
            if (segment == null) continue;
            if (currentElementIdx == 4) {
                compactNotation.append("@");
            } else if (currentElementIdx > 0) {
                compactNotation.append(":");
            }
            if (FakeArtifactElement.shouldInterpolate(segment)) {
                String value;
                shouldInterpolate = true;
                Matcher wrappedValueMatcher = WRAPPED_VARIABLE_FORM.matcher(segment);
                Matcher unwrappedValueMatcher = UNWRAPPED_VARIABLE_FORM.matcher(segment);
                String interpolatedVariable = null;
                if (wrappedValueMatcher.find()) {
                    interpolatedVariable = wrappedValueMatcher.group(1);
                } else if (unwrappedValueMatcher.find()) {
                    interpolatedVariable = unwrappedValueMatcher.group(1);
                }
                String string = value = interpolatedVariable != null ? dslElement.getDslFile().getParser().convertReferenceToExternalText(dslElement, interpolatedVariable, true) : segment;
                if (Pattern.compile("([a-zA-Z0-9_]\\w*)").matcher(value).matches()) {
                    compactNotation.append("$" + value);
                    continue;
                }
                compactNotation.append("${" + value + "}");
                continue;
            }
            compactNotation.append(segment);
        }
        ArtifactDependencySpecImpl dependencySpec = ArtifactDependencySpecImpl.create(compactNotation.toString());
        String string = shouldInterpolate ? GradlePropertyModel.iStr(dependencySpec.compactNotation()) : dependencySpec.compactNotation();
        if (string == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maintainer";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "compactNotation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompactNotationForLiterals";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNew";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCompactNotationForLiterals";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class CompactNotation
    extends ArtifactDependencyModelImpl {
        @NotNull
        private GradleDslSimpleExpression myDslExpression;

        @Nullable
        static CompactNotation create(@NotNull String configurationName, @NotNull GradleDslSimpleExpression dslExpression, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
            String value;
            if (configurationName == null) {
                CompactNotation.$$$reportNull$$$0(0);
            }
            if (dslExpression == null) {
                CompactNotation.$$$reportNull$$$0(1);
            }
            if (maintainer == null) {
                CompactNotation.$$$reportNull$$$0(2);
            }
            if ((value = dslExpression.getValue(String.class)) == null || value.trim().isEmpty()) {
                return null;
            }
            CompactNotation notation = new CompactNotation(configurationName, dslExpression, configurationElement, maintainer);
            return notation.name().getValueType() != GradlePropertyModel.ValueType.NONE ? notation : null;
        }

        private CompactNotation(@NotNull String configurationName, @NotNull GradleDslSimpleExpression dslExpression, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
            if (configurationName == null) {
                CompactNotation.$$$reportNull$$$0(3);
            }
            if (dslExpression == null) {
                CompactNotation.$$$reportNull$$$0(4);
            }
            if (maintainer == null) {
                CompactNotation.$$$reportNull$$$0(5);
            }
            super(configurationElement, configurationName, maintainer);
            this.myDslExpression = dslExpression;
        }

        @NotNull
        public ResolvedPropertyModel createModelFor(@NotNull String name, @NotNull Function<ArtifactDependencySpec, String> getFunc, @NotNull BiConsumer<ArtifactDependencySpecImpl, String> setFunc, boolean canDelete) {
            if (name == null) {
                CompactNotation.$$$reportNull$$$0(6);
            }
            if (getFunc == null) {
                CompactNotation.$$$reportNull$$$0(7);
            }
            if (setFunc == null) {
                CompactNotation.$$$reportNull$$$0(8);
            }
            GradleDslSimpleExpression element = this.mySetThrough ? PropertyUtil.resolveElement(this.myDslExpression) : this.myDslExpression;
            FakeArtifactElement fakeElement = new FakeArtifactElement(element.getParent(), GradleNameElement.fake(name), element, getFunc, setFunc, canDelete);
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create(fakeElement).addTransform(new FakeElementTransform()).buildResolved();
            if (resolvedPropertyModelImpl == null) {
                CompactNotation.$$$reportNull$$$0(9);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel name() {
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor("name", ArtifactDependencySpec::getName, ArtifactDependencySpecImpl::setName, false);
            if (resolvedPropertyModel == null) {
                CompactNotation.$$$reportNull$$$0(10);
            }
            return resolvedPropertyModel;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel group() {
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor("group", ArtifactDependencySpec::getGroup, ArtifactDependencySpecImpl::setGroup, true);
            if (resolvedPropertyModel == null) {
                CompactNotation.$$$reportNull$$$0(11);
            }
            return resolvedPropertyModel;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel version() {
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor("version", ArtifactDependencySpec::getVersion, ArtifactDependencySpecImpl::setVersion, true);
            if (resolvedPropertyModel == null) {
                CompactNotation.$$$reportNull$$$0(12);
            }
            return resolvedPropertyModel;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel classifier() {
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor("classifier", ArtifactDependencySpec::getClassifier, ArtifactDependencySpecImpl::setClassifier, true);
            if (resolvedPropertyModel == null) {
                CompactNotation.$$$reportNull$$$0(13);
            }
            return resolvedPropertyModel;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel extension() {
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor("extension", ArtifactDependencySpec::getExtension, ArtifactDependencySpecImpl::setExtension, true);
            if (resolvedPropertyModel == null) {
                CompactNotation.$$$reportNull$$$0(14);
            }
            return resolvedPropertyModel;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel completeModel() {
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create(this.myDslExpression).buildResolved();
            if (resolvedPropertyModelImpl == null) {
                CompactNotation.$$$reportNull$$$0(15);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        protected GradleDslElement getDslElement() {
            GradleDslSimpleExpression gradleDslSimpleExpression = this.myDslExpression;
            if (gradleDslSimpleExpression == null) {
                CompactNotation.$$$reportNull$$$0(16);
            }
            return gradleDslSimpleExpression;
        }

        @Override
        void setDslElement(@NotNull GradleDslElement dslElement) {
            if (dslElement == null) {
                CompactNotation.$$$reportNull$$$0(17);
            }
            assert (!this.mySetThrough);
            this.myDslExpression = (GradleDslSimpleExpression)dslElement;
        }

        @Override
        @Nullable
        public PsiElement getPsiElement() {
            return this.myDslExpression.getExpression();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationName";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dslExpression";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maintainer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getFunc";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setFunc";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl$CompactNotation";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dslElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl$CompactNotation";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createModelFor";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "group";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "version";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classifier";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extension";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "completeModel";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDslElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createModelFor";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "setDslElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class MapNotation
    extends ArtifactDependencyModelImpl {
        @NotNull
        private GradleDslExpressionMap myDslElement;

        @Nullable
        static MapNotation create(@NotNull String configurationName, @NotNull GradleDslExpressionMap dslElement, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
            if (configurationName == null) {
                MapNotation.$$$reportNull$$$0(0);
            }
            if (dslElement == null) {
                MapNotation.$$$reportNull$$$0(1);
            }
            if (maintainer == null) {
                MapNotation.$$$reportNull$$$0(2);
            }
            if (dslElement.getLiteral("name", String.class) == null) {
                return null;
            }
            return new MapNotation(configurationName, dslElement, configurationElement, maintainer);
        }

        private MapNotation(@NotNull String configurationName, @NotNull GradleDslExpressionMap dslElement, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
            if (configurationName == null) {
                MapNotation.$$$reportNull$$$0(3);
            }
            if (dslElement == null) {
                MapNotation.$$$reportNull$$$0(4);
            }
            if (maintainer == null) {
                MapNotation.$$$reportNull$$$0(5);
            }
            super(configurationElement, configurationName, maintainer);
            this.myDslElement = dslElement;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel name() {
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myDslElement, "name").buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotation.$$$reportNull$$$0(6);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel group() {
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myDslElement, "group").buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotation.$$$reportNull$$$0(7);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel version() {
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myDslElement, "version").buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotation.$$$reportNull$$$0(8);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel classifier() {
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myDslElement, "classifier").buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotation.$$$reportNull$$$0(9);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel extension() {
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myDslElement, "ext").buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotation.$$$reportNull$$$0(10);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel completeModel() {
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create(this.myDslElement).buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotation.$$$reportNull$$$0(11);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        protected GradleDslElement getDslElement() {
            GradleDslExpressionMap gradleDslExpressionMap = this.myDslElement;
            if (gradleDslExpressionMap == null) {
                MapNotation.$$$reportNull$$$0(12);
            }
            return gradleDslExpressionMap;
        }

        @Override
        void setDslElement(@NotNull GradleDslElement dslElement) {
            if (dslElement == null) {
                MapNotation.$$$reportNull$$$0(13);
            }
            this.myDslElement = (GradleDslExpressionMap)dslElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationName";
                    break;
                }
                case 1: 
                case 4: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dslElement";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maintainer";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl$MapNotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl$MapNotation";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "group";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "version";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classifier";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extension";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "completeModel";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDslElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setDslElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

