/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectBuildModelImpl
implements ProjectBuildModel {
    @NotNull
    private final BuildModelContext myBuildModelContext;
    @Nullable
    private final GradleBuildFile myProjectBuildFile;

    public ProjectBuildModelImpl(@NotNull Project project, @Nullable VirtualFile file, @NotNull BuildModelContext buildModelContext) {
        if (project == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(0);
        }
        if (buildModelContext == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(1);
        }
        this.myBuildModelContext = buildModelContext;
        this.myProjectBuildFile = this.myBuildModelContext.parseProjectBuildFile(project, file);
    }

    @Override
    @Nullable
    public GradleBuildModel getProjectBuildModel() {
        return this.myProjectBuildFile == null ? null : new GradleBuildModelImpl(this.myProjectBuildFile);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull Module module) {
        VirtualFile file;
        if (module == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(2);
        }
        return (file = this.myBuildModelContext.getGradleBuildFile(module)) == null ? null : this.getModuleBuildModel(file);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull File modulePath) {
        VirtualFile file;
        if (modulePath == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(3);
        }
        return (file = this.myBuildModelContext.getGradleBuildFile(modulePath)) == null ? null : this.getModuleBuildModel(file);
    }

    @Override
    @NotNull
    public GradleBuildModel getModuleBuildModel(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(4);
        }
        GradleBuildFile dslFile = this.myBuildModelContext.getOrCreateBuildFile(file, false);
        return new GradleBuildModelImpl(dslFile);
    }

    @Override
    @Nullable
    public GradleSettingsModel getProjectSettingsModel() {
        VirtualFile virtualFile = this.getProjectSettingsFile();
        if (virtualFile == null) {
            return null;
        }
        GradleSettingsFile settingsFile = this.myBuildModelContext.getOrCreateSettingsFile(virtualFile);
        return new GradleSettingsModelImpl(settingsFile);
    }

    @Nullable
    private VirtualFile getProjectSettingsFile() {
        VirtualFile virtualFile = this.myProjectBuildFile == null ? this.myBuildModelContext.getProjectSettingsFile() : this.myProjectBuildFile.tryToFindSettingsFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile;
    }

    @Override
    public void applyChanges() {
        this.runOverProjectTree(file -> {
            file.applyChanges();
            file.saveAllChanges();
        });
    }

    @Override
    public void resetState() {
        this.runOverProjectTree(GradleDslElementImpl::resetState);
    }

    @Override
    public void reparse() {
        List<GradleDslFile> files = this.myBuildModelContext.getAllRequestedFiles();
        files.forEach(GradleDslFile::reparse);
    }

    @Override
    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels() {
        List<GradleBuildModel> list = this.getAllIncludedBuildModels((i, j) -> {});
        if (list == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels(@NotNull BiConsumer<Integer, Integer> func) {
        GradleSettingsModel settingsModel;
        File buildSrc;
        VirtualFile buildSrcVirtualFile;
        if (func == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(6);
        }
        Integer[] nModelsSeen = new Integer[]{0};
        ArrayList<GradleBuildModel> allModels = new ArrayList<GradleBuildModel>();
        if (this.myProjectBuildFile != null) {
            allModels.add(new GradleBuildModelImpl(this.myProjectBuildFile));
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], null);
        }
        if ((buildSrcVirtualFile = this.myBuildModelContext.getGradleBuildFile(buildSrc = new File(FileUtil.toCanonicalPath((String)this.myBuildModelContext.getProject().getBasePath()), "buildSrc"))) != null) {
            allModels.add(this.getModuleBuildModel(buildSrcVirtualFile));
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], null);
        }
        if ((settingsModel = this.getProjectSettingsModel()) == null) {
            ArrayList<GradleBuildModel> arrayList = allModels;
            if (arrayList == null) {
                ProjectBuildModelImpl.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        Set<String> modulePaths = settingsModel.modulePaths();
        Integer nModelsToConsider = nModelsSeen[0] + modulePaths.size();
        allModels.addAll(modulePaths.stream().map(modulePath -> {
            VirtualFile file;
            File moduleDir;
            GradleBuildModel model = null;
            if (!modulePath.equals(":") && (moduleDir = settingsModel.moduleDirectory((String)modulePath)) != null && (file = this.myBuildModelContext.getGradleBuildFile(moduleDir)) != null) {
                model = this.getModuleBuildModel(file);
            }
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], nModelsToConsider);
            return model;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        ArrayList<GradleBuildModel> arrayList = allModels;
        if (arrayList == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private void runOverProjectTree(@NotNull Consumer<GradleDslFile> func) {
        if (func == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(9);
        }
        this.myBuildModelContext.getAllRequestedFiles().forEach(func);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModelContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/ProjectBuildModelImpl";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/ProjectBuildModelImpl";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIncludedBuildModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleBuildModel";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllIncludedBuildModels";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runOverProjectTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

