/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleFileModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.configurations.ConfigurationsModel;
import com.android.tools.idea.gradle.dsl.api.crashlytics.CrashlyticsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.PluginModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModelImpl;
import com.android.tools.idea.gradle.dsl.model.build.BuildScriptModelImpl;
import com.android.tools.idea.gradle.dsl.model.configurations.ConfigurationsModelImpl;
import com.android.tools.idea.gradle.dsl.model.crashlytics.CrashlyticsModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModelImpl;
import com.android.tools.idea.gradle.dsl.model.java.JavaModelImpl;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModelImpl;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationsDslElement;
import com.android.tools.idea.gradle.dsl.parser.crashlytics.CrashlyticsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleBuildModelImpl
extends GradleFileModelImpl
implements GradleBuildModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NonNls
    private static final String ID = "id";

    public GradleBuildModelImpl(@NotNull GradleBuildFile buildDslFile) {
        if (buildDslFile == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(0);
        }
        super(buildDslFile);
    }

    @Override
    @NotNull
    public List<PluginModel> plugins() {
        ApplyDslElement applyDslElement;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        ArrayList<PluginModelImpl> plugins = new ArrayList<PluginModelImpl>();
        if (pluginsDslElement != null) {
            plugins.addAll(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(pluginsDslElement)).values());
        }
        if ((applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class)) != null) {
            plugins.addAll(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement)).values());
        }
        return new ArrayList<PluginModel>(PluginModelImpl.deduplicatePlugins(plugins).values());
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull String plugin) {
        Map<String, PluginModelImpl> applyPluginsModels;
        if (plugin == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(1);
        }
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (pluginsDslElement == null && applyDslElement == null) {
            pluginsDslElement = new PluginsDslElement(this.myGradleDslFile, GradleNameElement.fake(PluginsDslElement.PLUGINS.name));
            this.myGradleDslFile.addNewElementAt(0, pluginsDslElement);
        } else if (pluginsDslElement == null) {
            Map<String, PluginModelImpl> models = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement));
            if (models.containsKey(plugin)) {
                PluginModel pluginModel = models.get(plugin);
                if (pluginModel == null) {
                    GradleBuildModelImpl.$$$reportNull$$$0(2);
                }
                return pluginModel;
            }
            GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, GradleNameElement.create("apply"));
            applyMap.setAsNamedArgs(true);
            GradleDslLiteral literal = new GradleDslLiteral(applyMap, GradleNameElement.create(PLUGIN));
            literal.setValue(plugin.trim());
            applyMap.setNewElement(literal);
            applyDslElement.setNewElement(applyMap);
            return new PluginModelImpl(applyMap, literal);
        }
        Map<String, PluginModelImpl> models = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(pluginsDslElement));
        if (models.containsKey(plugin)) {
            PluginModel pluginModel = models.get(plugin);
            if (pluginModel == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(3);
            }
            return pluginModel;
        }
        if (applyDslElement != null && (applyPluginsModels = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement))).containsKey(plugin)) {
            PluginModel pluginModel = applyPluginsModels.get(plugin);
            if (pluginModel == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(4);
            }
            return pluginModel;
        }
        GradleDslLiteral literal = new GradleDslLiteral(pluginsDslElement, GradleNameElement.create(ID));
        literal.setElementType(PropertyType.REGULAR);
        literal.setValue(plugin.trim());
        pluginsDslElement.setNewElement(literal);
        return new PluginModelImpl(literal, literal);
    }

    @Override
    public void removePlugin(@NotNull String plugin) {
        ApplyDslElement applyDslElement;
        PluginsDslElement pluginsDslElement;
        if (plugin == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(5);
        }
        if ((pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS)) != null) {
            PluginModelImpl.removePlugins(PluginModelImpl.create(pluginsDslElement), plugin);
        }
        if ((applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class)) != null) {
            PluginModelImpl.removePlugins(PluginModelImpl.create(applyDslElement), plugin);
        }
    }

    @Override
    @Nullable
    public PsiElement getPluginsPsiElement() {
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        if (pluginsDslElement != null) {
            return pluginsDslElement.getPsiElement();
        }
        return null;
    }

    @Override
    @NotNull
    public AndroidModel android() {
        AndroidDslElement androidDslElement = this.myGradleDslFile.ensurePropertyElement(AndroidDslElement.ANDROID);
        return new AndroidModelImpl(androidDslElement);
    }

    @Override
    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptDslElement buildScriptDslElement = this.myGradleDslFile.ensurePropertyElement(BuildScriptDslElement.BUILDSCRIPT);
        return new BuildScriptModelImpl(buildScriptDslElement);
    }

    @Override
    @NotNull
    public ConfigurationsModel configurations() {
        ConfigurationsDslElement configurationsDslElement = this.myGradleDslFile.ensurePropertyElementBefore(ConfigurationsDslElement.CONFIGURATIONS, DependenciesDslElement.class);
        return new ConfigurationsModelImpl(configurationsDslElement);
    }

    @Override
    @NotNull
    public CrashlyticsModel crashlytics() {
        CrashlyticsDslElement crashlyticsDslElement = this.myGradleDslFile.ensurePropertyElement(CrashlyticsDslElement.CRASHLYTICS);
        return new CrashlyticsModelImpl(crashlyticsDslElement);
    }

    @Override
    @NotNull
    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesDslElement = this.myGradleDslFile.ensurePropertyElement(DependenciesDslElement.DEPENDENCIES);
        return new DependenciesModelImpl(dependenciesDslElement);
    }

    @Override
    @NotNull
    public ExtModel ext() {
        int at = 0;
        List<GradleDslElement> elements = this.myGradleDslFile.getAllElements();
        if (!elements.isEmpty() && elements.get(0) instanceof ApplyDslElement) {
            ++at;
        }
        ExtDslElement extDslElement = this.myGradleDslFile.ensurePropertyElementAt(ExtDslElement.EXT, at);
        return new ExtModelImpl(extDslElement);
    }

    @Override
    @NotNull
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.ensurePropertyElement(JavaDslElement.JAVA);
        return new JavaModelImpl(javaDslElement);
    }

    @Override
    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesDslElement repositoriesDslElement = this.myGradleDslFile.ensurePropertyElement(RepositoriesDslElement.REPOSITORIES);
        return new RepositoriesModelImpl(repositoriesDslElement);
    }

    @Override
    @NotNull
    public Set<GradleFileModel> getInvolvedFiles() {
        Set<GradleFileModel> set = this.getAllInvolvedFiles().stream().distinct().map(e -> GradleBuildModelImpl.getFileModel(e)).collect(Collectors.toSet());
        if (set == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    private static GradleFileModel getFileModel(@NotNull GradleDslFile file) {
        if (file == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(7);
        }
        if (file instanceof GradleBuildFile) {
            return new GradleBuildModelImpl((GradleBuildFile)file);
        }
        if (file instanceof GradleSettingsFile) {
            return new GradleSettingsModelImpl((GradleSettingsFile)file);
        }
        if (file instanceof GradlePropertiesFile) {
            return new GradlePropertiesModel(file);
        }
        throw new IllegalStateException("Unknown GradleDslFile type found!");
    }

    @Override
    @NotNull
    public File getModuleRootDirectory() {
        BuildModelContext context = this.myGradleDslFile.getContext();
        VirtualFile projectSettingsFile = context.getProjectSettingsFile();
        if (projectSettingsFile == null) {
            File file = this.myGradleDslFile.getDirectoryPath();
            if (file == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(8);
            }
            return file;
        }
        GradleSettingsFile settingsFile = context.getOrCreateSettingsFile(projectSettingsFile);
        GradleSettingsModelImpl settingsModel = new GradleSettingsModelImpl(settingsFile);
        File directory = settingsModel.moduleDirectory(this.myGradleDslFile.getName());
        if (directory == null) {
            File file = this.myGradleDslFile.getDirectoryPath();
            if (file == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(9);
            }
            return file;
        }
        File file = directory;
        if (file == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(10);
        }
        return file;
    }

    @Override
    @TestOnly
    public void removeRepositoriesBlocks() {
        this.myGradleDslFile.removeProperty(RepositoriesDslElement.REPOSITORIES.name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = PLUGIN;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModelImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModelImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPlugin";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvolvedFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRootDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyPlugin";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePlugin";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

