/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.renderers;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.jetbrains.packagesearch.PackageSearchIcons;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.TableColors;
import java.awt.Component;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001eB-\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J4\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PopupMenuListItemCellRenderer;", "T", "Ljavax/swing/DefaultListCellRenderer;", "selectedValue", "colors", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/TableColors;", "itemLabelRenderer", "Lkotlin/Function1;", "", "(Ljava/lang/Object;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/TableColors;Lkotlin/jvm/functions/Function1;)V", "currentItemIsSelected", "", "emptyIcon", "Lcom/intellij/util/ui/EmptyIcon;", "Lorg/jetbrains/annotations/NotNull;", "selectedIcon", "Ljavax/swing/Icon;", "Ljava/lang/Object;", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "", "index", "", "isSelected", "cellHasFocus", "AccessibleRenderer", "intellij.packageSearch"})
public final class PopupMenuListItemCellRenderer<T>
extends DefaultListCellRenderer {
    @Nullable
    private final T selectedValue;
    @NotNull
    private final TableColors colors;
    @NotNull
    private final Function1<T, String> itemLabelRenderer;
    @NotNull
    private final Icon selectedIcon;
    @NotNull
    private final EmptyIcon emptyIcon;
    private boolean currentItemIsSelected;

    public PopupMenuListItemCellRenderer(@Nullable T selectedValue, @NotNull TableColors colors, @NotNull Function1<? super T, String> itemLabelRenderer) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter(itemLabelRenderer, (String)"itemLabelRenderer");
        this.selectedValue = selectedValue;
        this.colors = colors;
        this.itemLabelRenderer = itemLabelRenderer;
        Icon icon = PackageSearchIcons.Checkmark;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Checkmark");
        this.selectedIcon = icon;
        icon = EmptyIcon.create((int)this.selectedIcon.getIconWidth());
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"create(selectedIcon.iconWidth)");
        this.emptyIcon = icon;
    }

    public /* synthetic */ PopupMenuListItemCellRenderer(Object object, TableColors tableColors, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(object, tableColors, function1);
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<?> list, @NotNull Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object item = value;
        String itemLabel = Intrinsics.stringPlus((String)((String)this.itemLabelRenderer.invoke(item)), (Object)" ");
        Component component = super.getListCellRendererComponent(list, itemLabel, index, isSelected, cellHasFocus);
        if (component == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JLabel");
        }
        JLabel label = (JLabel)component;
        label.setFont(list.getFont());
        this.colors.applyTo(label, isSelected);
        this.currentItemIsSelected = item == this.selectedValue;
        label.setIcon(this.currentItemIsSelected ? this.selectedIcon : (Icon)this.emptyIcon);
        GraphicsUtil.setAntialiasingType((JComponent)label, (Object)AntialiasingType.getAAHintForSwingComponent());
        return label;
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleRenderer(this.currentItemIsSelected);
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PopupMenuListItemCellRenderer$AccessibleRenderer;", "Ljavax/swing/JLabel$AccessibleJLabel;", "Ljavax/swing/JLabel;", "isSelected", "", "(Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PopupMenuListItemCellRenderer;Z)V", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleStateSet", "Ljavax/accessibility/AccessibleStateSet;", "intellij.packageSearch"})
    private final class AccessibleRenderer
    extends JLabel.AccessibleJLabel {
        private final boolean isSelected;

        public AccessibleRenderer(boolean isSelected) {
            Intrinsics.checkNotNullParameter((Object)PopupMenuListItemCellRenderer.this, (String)"this$0");
            super(PopupMenuListItemCellRenderer.this);
            this.isSelected = isSelected;
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.CHECK_BOX;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"CHECK_BOX");
            return accessibleRole;
        }

        @Override
        @NotNull
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet set = super.getAccessibleStateSet();
            if (this.isSelected) {
                set.add(AccessibleState.CHECKED);
            }
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"set");
            return set;
        }
    }
}

