/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.renderers;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBComboBoxLabel;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUI;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageScope;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.UiPackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.TableColorsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.renderers.PackageScopeTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0013H\u0003\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageScopeTableCellRenderer;", "Ljavax/swing/table/TableCellRenderer;", "()V", "getTableCellRendererComponent", "Ljavax/swing/JPanel;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "scopesMessage", "", "installedScopes", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageScope;", "defaultScope", "intellij.packageSearch"})
public final class PackageScopeTableCellRenderer
implements TableCellRenderer {
    @NotNull
    public static final PackageScopeTableCellRenderer INSTANCE = new PackageScopeTableCellRenderer();

    private PackageScopeTableCellRenderer() {
    }

    @Override
    @NotNull
    public JPanel getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String string;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("al left center, insets 0 8 0 0"));
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$getTableCellRendererComponent_u24lambda_u2d1 = jPanel;
        boolean bl3 = false;
        TableColorsKt.getColors(table).applyTo($this$getTableCellRendererComponent_u24lambda_u2d1, isSelected);
        Color bgColor = !isSelected && value instanceof UiPackageModel.SearchResult ? (Color)PackageSearchUI.INSTANCE.getListRowHighlightBackground$intellij_packageSearch() : $this$getTableCellRendererComponent_u24lambda_u2d1.getBackground();
        $this$getTableCellRendererComponent_u24lambda_u2d1.setBackground(bgColor);
        JBComboBoxLabel jBComboBoxLabel = new JBComboBoxLabel();
        boolean bl4 = false;
        boolean bl5 = false;
        JBComboBoxLabel $this$getTableCellRendererComponent_u24lambda_u2d1_u24lambda_u2d0 = jBComboBoxLabel;
        boolean bl6 = false;
        TableColorsKt.getColors(table).applyTo((JComponent)$this$getTableCellRendererComponent_u24lambda_u2d1_u24lambda_u2d0, isSelected);
        $this$getTableCellRendererComponent_u24lambda_u2d1_u24lambda_u2d0.setBackground(bgColor);
        $this$getTableCellRendererComponent_u24lambda_u2d1_u24lambda_u2d0.setIcon(AllIcons.General.LinkDropTriangle);
        Object object = value;
        if (object instanceof UiPackageModel.Installed) {
            string = INSTANCE.scopesMessage(((UiPackageModel.Installed)value).getDeclaredScopes(), ((UiPackageModel.Installed)value).getDefaultScope());
        } else if (object instanceof UiPackageModel.SearchResult) {
            string = ((UiPackageModel.SearchResult)value).getSelectedScope().getDisplayName();
        } else {
            throw new IllegalArgumentException("The value is expected to be a ScopeViewModel, but wasn't.");
        }
        $this$getTableCellRendererComponent_u24lambda_u2d1_u24lambda_u2d0.setText(string);
        JBComboBoxLabel jbComboBoxLabel = jBComboBoxLabel;
        $this$getTableCellRendererComponent_u24lambda_u2d1.add((Component)jbComboBoxLabel);
        return jPanel;
    }

    @NlsSafe
    private final String scopesMessage(List<? extends PackageScope> installedScopes, PackageScope defaultScope) {
        if (installedScopes.isEmpty()) {
            return defaultScope.getDisplayName();
        }
        return CollectionsKt.joinToString$default((Iterable)installedScopes, null, null, null, (int)0, null, (Function1)scopesMessage.1.INSTANCE, (int)31, null);
    }
}

