/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.renderers;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import com.jetbrains.packagesearch.api.v2.ApiStandardPackage;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUI;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.PackagesTableItem;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.TagComponent;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.TableColorsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.IntScalingExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.MigLayoutExtensionsKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.UnitValue;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u00062\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0014J6\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J8\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageNameCellRenderer;", "Ljavax/swing/table/TableCellRenderer;", "()V", "columnConstraints", "Lnet/miginfocom/layout/AC;", "componentGapX", "", "layoutConstraints", "Lnet/miginfocom/layout/LC;", "kotlin.jvm.PlatformType", "tagBackground", "Lcom/intellij/ui/JBColor;", "tagBackgroundSelected", "tagForeground", "tagForegroundSelected", "componentConstraint", "Lnet/miginfocom/layout/CC;", "x", "y", "gapAfter", "(IILjava/lang/Integer;)Lnet/miginfocom/layout/CC;", "createNamePanel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageNameCellRenderer$TagPaintingJPanel;", "columnWidth", "name", "", "identifier", "isKotlinMultiplatform", "", "isSelected", "getTableCellRendererComponent", "Ljavax/swing/JPanel;", "table", "Ljavax/swing/JTable;", "value", "", "hasFocus", "row", "column", "TagPaintingJPanel", "intellij.packageSearch"})
public final class PackageNameCellRenderer
implements TableCellRenderer {
    @NotNull
    public static final PackageNameCellRenderer INSTANCE;
    private static final LC layoutConstraints;
    private static final int componentGapX;
    @NotNull
    private static final AC columnConstraints;
    @NotNull
    private static final JBColor tagForeground;
    @NotNull
    private static final JBColor tagBackground;
    @NotNull
    private static final JBColor tagForegroundSelected;
    @NotNull
    private static final JBColor tagBackgroundSelected;

    private PackageNameCellRenderer() {
    }

    private final CC componentConstraint(int x, int y, Integer gapAfter) {
        CC cC = new CC();
        boolean bl = false;
        boolean bl2 = false;
        CC $this$componentConstraint_u24lambda_u2d3 = cC;
        boolean bl3 = false;
        $this$componentConstraint_u24lambda_u2d3.setCellX(x);
        $this$componentConstraint_u24lambda_u2d3.setCellY(y);
        if (gapAfter != null) {
            $this$componentConstraint_u24lambda_u2d3.gapAfter(gapAfter.toString());
        }
        return cC;
    }

    static /* synthetic */ CC componentConstraint$default(PackageNameCellRenderer packageNameCellRenderer, int n, int n2, Integer n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = null;
        }
        return packageNameCellRenderer.componentConstraint(n, n2, n3);
    }

    @Override
    @NotNull
    public JPanel getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int columnWidth = table.getTableHeader().getColumnModel().getColumn(0).getWidth();
        PackagesTableItem packagesTableItem = (PackagesTableItem)value;
        if (packagesTableItem instanceof PackagesTableItem.InstalledPackage) {
            Object packageModel = ((PackagesTableItem)value).getPackageModel();
            ApiStandardPackage apiStandardPackage = ((PackageModel)packageModel).getRemoteInfo();
            String name = StringUtils.normalizeSpace((String)(apiStandardPackage == null ? null : apiStandardPackage.getName()));
            String rawIdentifier = ((PackageModel)packageModel).getIdentifier-f1q_7Ec();
            TagPaintingJPanel tagPaintingJPanel = this.createNamePanel(columnWidth, name, rawIdentifier, ((PackageModel)packageModel).isKotlinMultiplatform(), isSelected);
            boolean bl = false;
            boolean bl2 = false;
            TagPaintingJPanel $this$getTableCellRendererComponent_u24lambda_u2d4 = tagPaintingJPanel;
            boolean bl3 = false;
            TableColorsKt.getColors(table).applyTo($this$getTableCellRendererComponent_u24lambda_u2d4, isSelected);
            jPanel = tagPaintingJPanel;
        } else if (packagesTableItem instanceof PackagesTableItem.InstallablePackage) {
            Object packageModel = ((PackagesTableItem)value).getPackageModel();
            Object rawIdentifier = ((PackageModel)packageModel).getRemoteInfo();
            String name = StringUtils.normalizeSpace((String)(rawIdentifier == null ? null : rawIdentifier.getName()));
            rawIdentifier = ((PackageModel)packageModel).getIdentifier-f1q_7Ec();
            TagPaintingJPanel tagPaintingJPanel = this.createNamePanel(columnWidth, name, (String)rawIdentifier, ((PackageModel)packageModel).isKotlinMultiplatform(), isSelected);
            boolean bl = false;
            boolean bl4 = false;
            TagPaintingJPanel $this$getTableCellRendererComponent_u24lambda_u2d5 = tagPaintingJPanel;
            boolean bl5 = false;
            TableColorsKt.getColors(table).applyTo($this$getTableCellRendererComponent_u24lambda_u2d5, isSelected);
            if (!isSelected) {
                $this$getTableCellRendererComponent_u24lambda_u2d5.setBackground((Color)PackageSearchUI.INSTANCE.getListRowHighlightBackground$intellij_packageSearch());
            }
            jPanel = tagPaintingJPanel;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final TagPaintingJPanel createNamePanel(int columnWidth, @NlsSafe String name, @NlsSafe String identifier, boolean isKotlinMultiplatform, boolean isSelected) {
        Object $this$createNamePanel_u24lambda_u2d10_u24lambda_u2d8;
        Object $this$createNamePanel_u24lambda_u2d10_u24lambda_u2d7;
        Unit unit;
        TagPaintingJPanel tagPaintingJPanel;
        TagPaintingJPanel tagPaintingJPanel2 = new TagPaintingJPanel(columnWidth, isSelected);
        boolean bl = false;
        boolean bl2 = false;
        TagPaintingJPanel $this$createNamePanel_u24lambda_u2d10 = tagPaintingJPanel2;
        boolean bl3 = false;
        Object object = name;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!(object == null || StringsKt.isBlank((CharSequence)object)) && !Intrinsics.areEqual((Object)name, (Object)identifier)) {
            Object $this$createNamePanel_u24lambda_u2d10_u24lambda_u2d6;
            object = new JLabel(name);
            bl4 = false;
            bl5 = false;
            Object object2 = object;
            tagPaintingJPanel = $this$createNamePanel_u24lambda_u2d10;
            boolean bl6 = false;
            ((JComponent)$this$createNamePanel_u24lambda_u2d10_u24lambda_u2d6).setForeground(PackageSearchUI.INSTANCE.getTextColorPrimary$intellij_packageSearch(isSelected));
            unit = Unit.INSTANCE;
            tagPaintingJPanel.add((Component)object, PackageNameCellRenderer.componentConstraint$default(INSTANCE, 0, 0, componentGapX, 3, null));
            object = new JLabel(identifier);
            bl4 = false;
            bl5 = false;
            $this$createNamePanel_u24lambda_u2d10_u24lambda_u2d6 = object;
            tagPaintingJPanel = $this$createNamePanel_u24lambda_u2d10;
            boolean bl7 = false;
            ((JComponent)$this$createNamePanel_u24lambda_u2d10_u24lambda_u2d7).setForeground(PackageSearchUI.INSTANCE.getTextColorSecondary$intellij_packageSearch(isSelected));
            unit = Unit.INSTANCE;
            tagPaintingJPanel.add((Component)object, PackageNameCellRenderer.componentConstraint$default(INSTANCE, 0, 0, null, 7, null).gapAfter("0:push"));
        } else {
            object = new JLabel(identifier);
            bl4 = false;
            bl5 = false;
            $this$createNamePanel_u24lambda_u2d10_u24lambda_u2d7 = object;
            tagPaintingJPanel = $this$createNamePanel_u24lambda_u2d10;
            boolean bl8 = false;
            ((JComponent)$this$createNamePanel_u24lambda_u2d10_u24lambda_u2d8).setForeground(PackageSearchUI.INSTANCE.getTextColorPrimary$intellij_packageSearch(isSelected));
            unit = Unit.INSTANCE;
            tagPaintingJPanel.add((Component)object, PackageNameCellRenderer.componentConstraint$default(INSTANCE, 0, 0, null, 7, null));
        }
        if (isKotlinMultiplatform) {
            void $this$createNamePanel_u24lambda_u2d10_u24lambda_u2d9;
            object = new TagComponent(PackageSearchBundle.INSTANCE.message("packagesearch.terminology.kotlinMultiplatform", new Object[0]));
            bl4 = false;
            bl5 = false;
            $this$createNamePanel_u24lambda_u2d10_u24lambda_u2d8 = object;
            tagPaintingJPanel = $this$createNamePanel_u24lambda_u2d10;
            boolean bl9 = false;
            $this$createNamePanel_u24lambda_u2d10_u24lambda_u2d9.setVisible(false);
            unit = Unit.INSTANCE;
            tagPaintingJPanel.add((Component)object, PackageNameCellRenderer.componentConstraint$default(INSTANCE, 1, 0, null, 4, null));
        }
        return tagPaintingJPanel2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$columnConstraints_u24lambda_u2d2_u24lambda_u2d1;
        DimConstraint $this$columnConstraints_u24lambda_u2d2_u24lambda_u2d0;
        INSTANCE = new PackageNameCellRenderer();
        LC lC = new LC().align("left", "center");
        Intrinsics.checkNotNullExpressionValue((Object)lC, (String)"LC().align(\"left\", \"center\")");
        layoutConstraints = MigLayoutExtensionsKt.scaledInsets$default(lC, 0, 8, 0, 0, 5, null);
        componentGapX = IntScalingExtensionsKt.scaled(4);
        lC = new AC();
        boolean bl = false;
        boolean bl2 = false;
        LC $this$columnConstraints_u24lambda_u2d2 = lC;
        boolean bl3 = false;
        $this$columnConstraints_u24lambda_u2d2.gap(String.valueOf(componentGapX));
        DimConstraint[] dimConstraintArray = new DimConstraint[2];
        DimConstraint dimConstraint = new DimConstraint();
        boolean bl4 = false;
        boolean bl5 = false;
        DimConstraint dimConstraint2 = dimConstraint;
        int n = 0;
        DimConstraint[] dimConstraintArray2 = dimConstraintArray;
        LC lC2 = $this$columnConstraints_u24lambda_u2d2;
        boolean bl6 = false;
        $this$columnConstraints_u24lambda_u2d2.gap(String.valueOf(componentGapX));
        $this$columnConstraints_u24lambda_u2d2_u24lambda_u2d0.setSize(new BoundSize(new UnitValue(150.0f, 0, ""), ""));
        Unit unit = Unit.INSTANCE;
        dimConstraintArray2[n] = dimConstraint;
        dimConstraint = new DimConstraint();
        bl4 = false;
        bl5 = false;
        $this$columnConstraints_u24lambda_u2d2_u24lambda_u2d0 = dimConstraint;
        n = 1;
        dimConstraintArray2 = dimConstraintArray;
        boolean bl7 = false;
        $this$columnConstraints_u24lambda_u2d2_u24lambda_u2d1.setGapBefore(new BoundSize(new UnitValue((float)componentGapX / 2.0f), ""));
        unit = Unit.INSTANCE;
        dimConstraintArray2[n] = dimConstraint;
        lC2.setConstaints(dimConstraintArray);
        columnConstraints = lC;
        tagForeground = new JBColor(0x808080, 0x9C9C9C);
        tagBackground = new JBColor(0xE5E5E5, 0x666B6E);
        tagForegroundSelected = new JBColor(0xFFFFFF, 0xFFFFFF);
        tagBackgroundSelected = new JBColor(4429282, 7908834);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageNameCellRenderer$TagPaintingJPanel;", "Ljavax/swing/JPanel;", "columnWidth", "", "isSelected", "", "(IZ)V", "paintChildren", "", "g", "Ljava/awt/Graphics;", "intellij.packageSearch"})
    private static final class TagPaintingJPanel
    extends JPanel {
        private final int columnWidth;
        private final boolean isSelected;

        public TagPaintingJPanel(int columnWidth, boolean isSelected) {
            super((LayoutManager)new MigLayout(layoutConstraints.width(columnWidth + "px!"), columnConstraints));
            this.columnWidth = columnWidth;
            this.isSelected = isSelected;
            this.setSize(new Dimension(this.columnWidth, this.getHeight()));
            this.setMaximumSize(new Dimension(this.columnWidth, Integer.MAX_VALUE));
        }

        @Override
        protected void paintChildren(@NotNull Graphics g) {
            TagComponent tagComponent;
            Object object;
            boolean bl;
            Object object2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintChildren(g);
                object2 = this.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"components");
                object2 = (Object[])object2;
                bl = false;
                Object[] objectArray = object2;
                boolean bl2 = false;
                for (Object object3 : objectArray) {
                    Component it = (Component)object3;
                    boolean bl3 = false;
                    if (!(it instanceof TagComponent)) continue;
                    object = object3;
                    break block2;
                }
                object = null;
            }
            Object object4 = object;
            TagComponent tagComponent2 = tagComponent = object4 instanceof TagComponent ? (TagComponent)object4 : null;
            if (tagComponent == null) {
                return;
            }
            TagComponent tagComponent3 = tagComponent;
            int tagX = this.columnWidth - tagComponent3.getWidth();
            int tagY = this.getHeight() / 2 - tagComponent3.getHeight() / 2;
            object2 = g;
            bl = false;
            boolean bl4 = false;
            Object $this$paintChildren_u24lambda_u2d2 = object2;
            boolean bl5 = false;
            ((Graphics)$this$paintChildren_u24lambda_u2d2).setColor(this.getBackground());
            ((Graphics)$this$paintChildren_u24lambda_u2d2).fillRect(tagX - componentGapX, 0, this.columnWidth - tagX, this.getHeight());
            ((Graphics)$this$paintChildren_u24lambda_u2d2).translate(tagX, tagY);
            TagComponent tagComponent4 = tagComponent3;
            int n = 0;
            boolean bl6 = false;
            TagComponent $this$paintChildren_u24lambda_u2d2_u24lambda_u2d1 = tagComponent4;
            boolean bl7 = false;
            $this$paintChildren_u24lambda_u2d2_u24lambda_u2d1.setVisible(true);
            $this$paintChildren_u24lambda_u2d2_u24lambda_u2d1.setForeground((Color)JBColor.namedColor((String)"Plugins.tagForeground", (Color)((Color)(this.isSelected ? tagForegroundSelected : tagForeground))));
            $this$paintChildren_u24lambda_u2d2_u24lambda_u2d1.setBackground((Color)JBColor.namedColor((String)"Plugins.tagBackground", (Color)((Color)(this.isSelected ? tagBackgroundSelected : tagBackground))));
            $this$paintChildren_u24lambda_u2d2_u24lambda_u2d1.paint(g);
        }
    }
}

