/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns;

import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.KnownRepositories;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RepositoryModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.TargetModules;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageOperationType;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperation;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperationFactory;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.PackagesTableItem;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.renderers.PackageActionsTableCellRendererAndEditor;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001*B+\u0012\u001c\u0010\u0004\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0016\u0010\u001f\u001a\u0004\u0018\u00010 2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0003J\u0014\u0010!\u001a\u00020\"2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0016\u0010#\u001a\u0004\u0018\u00010\u001e2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\u0014\u0010$\u001a\u00020%2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0014\u0010&\u001a\u00020\u00182\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J&\u0010'\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010(\u001a\u00020)2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/ActionsColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTableItem;", "", "operationExecutor", "Lkotlin/Function1;", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation;", "", "operationFactory", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperationFactory;", "(Lkotlin/jvm/functions/Function1;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperationFactory;)V", "allKnownRepositories", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$All;", "cellRendererAndEditor", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageActionsTableCellRendererAndEditor;", "hoverItem", "getHoverItem", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTableItem;", "setHoverItem", "(Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTableItem;)V", "knownRepositoriesInTargetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$InTargetModules;", "onlyStable", "", "targetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/TargetModules;", "createOperationsFor", "item", "operationType", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageOperationType;", "generateMessageFor", "", "getEditor", "Ljavax/swing/table/TableCellEditor;", "getOperationTypeFor", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "isCellEditable", "updateData", "valueOf", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/ActionsColumn$ActionsViewModel;", "ActionsViewModel", "intellij.packageSearch"})
public final class ActionsColumn
extends ColumnInfo<PackagesTableItem<?>, Object> {
    @NotNull
    private final Function1<List<? extends PackageSearchOperation<?>>, Unit> operationExecutor;
    @NotNull
    private final PackageSearchOperationFactory operationFactory;
    @Nullable
    private PackagesTableItem<?> hoverItem;
    @NotNull
    private TargetModules targetModules;
    @NotNull
    private KnownRepositories.InTargetModules knownRepositoriesInTargetModules;
    @NotNull
    private KnownRepositories.All allKnownRepositories;
    private boolean onlyStable;
    @NotNull
    private final PackageActionsTableCellRendererAndEditor cellRendererAndEditor;

    public ActionsColumn(@NotNull Function1<? super List<? extends PackageSearchOperation<?>>, Unit> operationExecutor, @NotNull PackageSearchOperationFactory operationFactory) {
        Intrinsics.checkNotNullParameter(operationExecutor, (String)"operationExecutor");
        Intrinsics.checkNotNullParameter((Object)operationFactory, (String)"operationFactory");
        super(PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.packages.columns.actions", new Object[0]));
        this.operationExecutor = operationExecutor;
        this.operationFactory = operationFactory;
        this.targetModules = TargetModules.None.INSTANCE;
        this.knownRepositoriesInTargetModules = KnownRepositories.InTargetModules.Companion.getEMPTY();
        this.allKnownRepositories = KnownRepositories.All.Companion.getEMPTY();
        this.cellRendererAndEditor = new PackageActionsTableCellRendererAndEditor((Function1<? super ActionsViewModel, Unit>)((Function1)new Function1<ActionsViewModel, Unit>(this){
            final /* synthetic */ ActionsColumn this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ActionsViewModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionsColumn.access$getOperationExecutor$p(this.this$0).invoke(it.getOperations());
            }
        }));
    }

    @Nullable
    public final PackagesTableItem<?> getHoverItem() {
        return this.hoverItem;
    }

    public final void setHoverItem(@Nullable PackagesTableItem<?> packagesTableItem) {
        this.hoverItem = packagesTableItem;
    }

    @NotNull
    public TableCellRenderer getRenderer(@NotNull PackagesTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return this.cellRendererAndEditor;
    }

    @NotNull
    public TableCellEditor getEditor(@NotNull PackagesTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return (TableCellEditor)((Object)this.cellRendererAndEditor);
    }

    public boolean isCellEditable(@NotNull PackagesTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return this.getOperationTypeFor(item) != null;
    }

    public final void updateData(boolean onlyStable, @NotNull TargetModules targetModules, @NotNull KnownRepositories.InTargetModules knownRepositoriesInTargetModules, @NotNull KnownRepositories.All allKnownRepositories) {
        Intrinsics.checkNotNullParameter((Object)targetModules, (String)"targetModules");
        Intrinsics.checkNotNullParameter((Object)knownRepositoriesInTargetModules, (String)"knownRepositoriesInTargetModules");
        Intrinsics.checkNotNullParameter((Object)allKnownRepositories, (String)"allKnownRepositories");
        this.onlyStable = onlyStable;
        this.targetModules = targetModules;
        this.knownRepositoriesInTargetModules = knownRepositoriesInTargetModules;
        this.allKnownRepositories = allKnownRepositories;
    }

    @NotNull
    public ActionsViewModel valueOf(@NotNull PackagesTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        PackageOperationType operationType = this.getOperationTypeFor(item);
        return new ActionsViewModel((PackageModel)item.getPackageModel(), (List<? extends PackageSearchOperation<?>>)this.createOperationsFor(item, operationType), operationType, this.generateMessageFor(item), item instanceof PackagesTableItem.InstallablePackage, Intrinsics.areEqual(item, this.hoverItem));
    }

    private final PackageOperationType getOperationTypeFor(PackagesTableItem<?> item) {
        PackageOperationType packageOperationType;
        PackagesTableItem<?> packagesTableItem = item;
        if (packagesTableItem instanceof PackagesTableItem.InstalledPackage) {
            PackageModel.Installed packageModel = (PackageModel.Installed)((PackagesTableItem.InstalledPackage)item).getPackageModel();
            PackageVersion currentVersion = ((PackagesTableItem.InstalledPackage)item).getUiPackageModel().getSelectedVersion();
            packageOperationType = currentVersion instanceof PackageVersion.Missing ? PackageOperationType.SET : (packageModel.canBeUpgraded(currentVersion, this.onlyStable) ? PackageOperationType.UPGRADE : null);
        } else if (packagesTableItem instanceof PackagesTableItem.InstallablePackage) {
            packageOperationType = PackageOperationType.INSTALL;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return packageOperationType;
    }

    private final List<PackageSearchOperation<?>> createOperationsFor(PackagesTableItem<?> item, PackageOperationType operationType) {
        List<PackageSearchOperation<?>> list;
        if (operationType == null) {
            return CollectionsKt.emptyList();
        }
        Object packageModel = item.getPackageModel();
        RepositoryModel repoToInstall = this.knownRepositoriesInTargetModules.repositoryToAddWhenInstallingOrUpgrading((PackageModel)packageModel, item.getUiPackageModel().getSelectedVersion(), this.allKnownRepositories);
        PackageOperationType packageOperationType = operationType;
        int n = WhenMappings.$EnumSwitchMapping$0[packageOperationType.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                list = this.operationFactory.createChangePackageVersionOperations((PackageModel.Installed)packageModel, item.getUiPackageModel().getSelectedVersion(), this.targetModules, repoToInstall);
                break;
            }
            case 3: {
                list = this.operationFactory.createAddPackageOperations((PackageModel.SearchResult)packageModel, item.getUiPackageModel().getSelectedVersion(), item.getUiPackageModel().getSelectedScope(), this.targetModules, repoToInstall);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    @Nls
    private final String generateMessageFor(PackagesTableItem<?> item) {
        PackageVersion selectedVersion;
        Object packageModel = item.getPackageModel();
        Object[] objectArray = this.knownRepositoriesInTargetModules.repositoryToAddWhenInstallingOrUpgrading((PackageModel)packageModel, selectedVersion = item.getUiPackageModel().getSelectedVersion(), this.allKnownRepositories);
        if (objectArray == null) {
            return null;
        }
        Object[] repoToInstall = objectArray;
        objectArray = new Object[]{repoToInstall.getDisplayName()};
        return PackageSearchBundle.INSTANCE.message("packagesearch.repository.willBeAddedOnInstall", objectArray);
    }

    public static final /* synthetic */ Function1 access$getOperationExecutor$p(ActionsColumn $this) {
        return $this.operationExecutor;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\fH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\fH\u00c6\u0003JS\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0012\b\u0002\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0003\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\nH\u00d6\u0001R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/ActionsColumn$ActionsViewModel;", "", "packageModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel;", "operations", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation;", "operationType", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageOperationType;", "infoMessage", "", "isSearchResult", "", "isHover", "(Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel;Ljava/util/List;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageOperationType;Ljava/lang/String;ZZ)V", "getInfoMessage", "()Ljava/lang/String;", "()Z", "getOperationType", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageOperationType;", "getOperations", "()Ljava/util/List;", "getPackageModel", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "intellij.packageSearch"})
    public static final class ActionsViewModel {
        @NotNull
        private final PackageModel packageModel;
        @NotNull
        private final List<PackageSearchOperation<?>> operations;
        @Nullable
        private final PackageOperationType operationType;
        @Nullable
        private final String infoMessage;
        private final boolean isSearchResult;
        private final boolean isHover;

        public ActionsViewModel(@NotNull PackageModel packageModel, @NotNull List<? extends PackageSearchOperation<?>> operations, @Nullable PackageOperationType operationType, @Nls @Nullable String infoMessage, boolean isSearchResult, boolean isHover) {
            Intrinsics.checkNotNullParameter((Object)packageModel, (String)"packageModel");
            Intrinsics.checkNotNullParameter(operations, (String)"operations");
            this.packageModel = packageModel;
            this.operations = operations;
            this.operationType = operationType;
            this.infoMessage = infoMessage;
            this.isSearchResult = isSearchResult;
            this.isHover = isHover;
        }

        @NotNull
        public final PackageModel getPackageModel() {
            return this.packageModel;
        }

        @NotNull
        public final List<PackageSearchOperation<?>> getOperations() {
            return this.operations;
        }

        @Nullable
        public final PackageOperationType getOperationType() {
            return this.operationType;
        }

        @Nullable
        public final String getInfoMessage() {
            return this.infoMessage;
        }

        public final boolean isSearchResult() {
            return this.isSearchResult;
        }

        public final boolean isHover() {
            return this.isHover;
        }

        @NotNull
        public final PackageModel component1() {
            return this.packageModel;
        }

        @NotNull
        public final List<PackageSearchOperation<?>> component2() {
            return this.operations;
        }

        @Nullable
        public final PackageOperationType component3() {
            return this.operationType;
        }

        @Nullable
        public final String component4() {
            return this.infoMessage;
        }

        public final boolean component5() {
            return this.isSearchResult;
        }

        public final boolean component6() {
            return this.isHover;
        }

        @NotNull
        public final ActionsViewModel copy(@NotNull PackageModel packageModel, @NotNull List<? extends PackageSearchOperation<?>> operations, @Nullable PackageOperationType operationType, @Nls @Nullable String infoMessage, boolean isSearchResult, boolean isHover) {
            Intrinsics.checkNotNullParameter((Object)packageModel, (String)"packageModel");
            Intrinsics.checkNotNullParameter(operations, (String)"operations");
            return new ActionsViewModel(packageModel, operations, operationType, infoMessage, isSearchResult, isHover);
        }

        public static /* synthetic */ ActionsViewModel copy$default(ActionsViewModel actionsViewModel, PackageModel packageModel, List list, PackageOperationType packageOperationType, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                packageModel = actionsViewModel.packageModel;
            }
            if ((n & 2) != 0) {
                list = actionsViewModel.operations;
            }
            if ((n & 4) != 0) {
                packageOperationType = actionsViewModel.operationType;
            }
            if ((n & 8) != 0) {
                string = actionsViewModel.infoMessage;
            }
            if ((n & 0x10) != 0) {
                bl = actionsViewModel.isSearchResult;
            }
            if ((n & 0x20) != 0) {
                bl2 = actionsViewModel.isHover;
            }
            return actionsViewModel.copy(packageModel, list, packageOperationType, string, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ActionsViewModel(packageModel=" + this.packageModel + ", operations=" + this.operations + ", operationType=" + (Object)((Object)this.operationType) + ", infoMessage=" + this.infoMessage + ", isSearchResult=" + this.isSearchResult + ", isHover=" + this.isHover + ')';
        }

        public int hashCode() {
            int result = this.packageModel.hashCode();
            result = result * 31 + ((Object)this.operations).hashCode();
            result = result * 31 + (this.operationType == null ? 0 : this.operationType.hashCode());
            result = result * 31 + (this.infoMessage == null ? 0 : this.infoMessage.hashCode());
            int n = this.isSearchResult ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.isHover ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActionsViewModel)) {
                return false;
            }
            ActionsViewModel actionsViewModel = (ActionsViewModel)other;
            if (!Intrinsics.areEqual((Object)this.packageModel, (Object)actionsViewModel.packageModel)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.operations, actionsViewModel.operations)) {
                return false;
            }
            if (this.operationType != actionsViewModel.operationType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.infoMessage, (Object)actionsViewModel.infoMessage)) {
                return false;
            }
            if (this.isSearchResult != actionsViewModel.isSearchResult) {
                return false;
            }
            return this.isHover == actionsViewModel.isHover;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PackageOperationType.values().length];
            nArray[PackageOperationType.UPGRADE.ordinal()] = 1;
            nArray[PackageOperationType.SET.ordinal()] = 2;
            nArray[PackageOperationType.INSTALL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

