/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.OperationException;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperation;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperationFailure;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0007J\u0014\u0010\n\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0003J\u0014\u0010\r\u001a\u00020\u00042\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0003\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/OperationFailureRenderer;", "", "()V", "renderFailure", "", "failure", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperationFailure;", "renderFailuresAsHtmlBulletList", "failures", "", "renderObjectNameFor", "operation", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation;", "renderVerbFor", "intellij.packageSearch"})
public final class OperationFailureRenderer {
    @NlsSafe
    @NotNull
    public final String renderFailuresAsHtmlBulletList(@NotNull List<PackageSearchOperationFailure> failures2) {
        Intrinsics.checkNotNullParameter(failures2, (String)"failures");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$renderFailuresAsHtmlBulletList_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        $this$renderFailuresAsHtmlBulletList_u24lambda_u2d0.append("<html><head></head><body><ul>");
        for (PackageSearchOperationFailure failure : failures2) {
            $this$renderFailuresAsHtmlBulletList_u24lambda_u2d0.append("<li>");
            $this$renderFailuresAsHtmlBulletList_u24lambda_u2d0.append(this.renderFailure(failure));
            $this$renderFailuresAsHtmlBulletList_u24lambda_u2d0.append("</li>");
        }
        $this$renderFailuresAsHtmlBulletList_u24lambda_u2d0.append("</ul></body></html>");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Nls
    @NotNull
    public final String renderFailure(@NotNull PackageSearchOperationFailure failure) {
        String string;
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        OperationException operationException = failure.getException();
        if (operationException instanceof OperationException.UnsupportedBuildSystem) {
            Object[] objectArray = new Object[]{failure.getOperation().getProjectModule().getName(), this.renderVerbFor(failure.getOperation()), this.renderObjectNameFor(failure.getOperation()), failure.getOperation().getProjectModule().getBuildSystemType().getName()};
            string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.error.message.unsupportedBuildSystem", objectArray);
        } else if (operationException instanceof OperationException.InvalidPackage) {
            Object[] objectArray = new Object[]{failure.getOperation().getProjectModule().getName(), this.renderVerbFor(failure.getOperation()), ((OperationException.InvalidPackage)failure.getException()).getDependency().getDisplayName()};
            string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.error.message.invalidPackage", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nls
    private final String renderVerbFor(PackageSearchOperation<?> operation) {
        String string;
        PackageSearchOperation<?> packageSearchOperation = operation;
        if (packageSearchOperation instanceof PackageSearchOperation.Package.Install) {
            string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.verb.install", new Object[0]);
        } else if (packageSearchOperation instanceof PackageSearchOperation.Package.Remove) {
            string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.verb.remove", new Object[0]);
        } else if (packageSearchOperation instanceof PackageSearchOperation.Package.ChangeInstalled) {
            string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.verb.change", new Object[0]);
        } else if (packageSearchOperation instanceof PackageSearchOperation.Repository.Install) {
            string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.verb.install", new Object[0]);
        } else if (packageSearchOperation instanceof PackageSearchOperation.Repository.Remove) {
            string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.verb.remove", new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nls
    private final String renderObjectNameFor(PackageSearchOperation<?> operation) {
        String string;
        PackageSearchOperation<?> packageSearchOperation = operation;
        if (packageSearchOperation instanceof PackageSearchOperation.Package) {
            string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.objectName.dependency", new Object[0]);
        } else if (packageSearchOperation instanceof PackageSearchOperation.Repository) {
            string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.objectName.repository", new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

