/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations;

import com.intellij.buildsystem.model.OperationFailure;
import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.DependencyOperationMetadata;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ProjectModule;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ProjectModuleOperationProvider;
import com.jetbrains.packagesearch.intellij.plugin.fus.PackageSearchEventsLogger;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageIdentifier;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageScope;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.OperationException;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperation;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperationFailure;
import com.jetbrains.packagesearch.intellij.plugin.util.LogExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.util.StringExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u0004*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001dH\u0002J\u001c\u0010\u001f\u001a\u00020 *\u00020!H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\"\u0010#\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006$"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/ModuleOperationExecutor;", "", "()V", "changePackage", "", "operation", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation$Package$ChangeInstalled;", "dependencyOperationMetadataFrom", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/DependencyOperationMetadata;", "projectModule", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/ProjectModule;", "dependency", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "newVersion", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageVersion;", "newScope", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageScope;", "doOperation", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperationFailure;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation;", "installPackage", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation$Package$Install;", "installRepository", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation$Repository$Install;", "removePackage", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation$Package$Remove;", "removeRepository", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation$Repository$Remove;", "throwIfAnyFailures", "", "Lcom/intellij/buildsystem/model/OperationFailure;", "toIdentifier", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageIdentifier;", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "toIdentifier-raxUTLs", "(Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;)Ljava/lang/String;", "intellij.packageSearch"})
public final class ModuleOperationExecutor {
    @Nullable
    public final PackageSearchOperationFailure doOperation(@NotNull PackageSearchOperation<?> operation) {
        Object object;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        try {
            object = operation;
            if (object instanceof PackageSearchOperation.Package.Install) {
                this.installPackage((PackageSearchOperation.Package.Install)operation);
            } else if (object instanceof PackageSearchOperation.Package.Remove) {
                this.removePackage((PackageSearchOperation.Package.Remove)operation);
            } else if (object instanceof PackageSearchOperation.Package.ChangeInstalled) {
                this.changePackage((PackageSearchOperation.Package.ChangeInstalled)operation);
            } else if (object instanceof PackageSearchOperation.Repository.Install) {
                this.installRepository((PackageSearchOperation.Repository.Install)operation);
            } else if (object instanceof PackageSearchOperation.Repository.Remove) {
                this.removeRepository((PackageSearchOperation.Repository.Remove)operation);
            }
            object = null;
        }
        catch (OperationException e) {
            LogExtensionsKt.logWarn("ModuleOperationExecutor#doOperation()", e, (Function0<String>)((Function0)new Function0<String>(operation){
                final /* synthetic */ PackageSearchOperation<?> $operation;
                {
                    this.$operation = $operation;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus((String)"Failure while performing operation ", this.$operation);
                }
            }));
            object = new PackageSearchOperationFailure(operation, e);
        }
        return object;
    }

    private final void installPackage(PackageSearchOperation.Package.Install operation) {
        ProjectModule projectModule = operation.getProjectModule();
        ProjectModuleOperationProvider projectModuleOperationProvider = ProjectModuleOperationProvider.Companion.forProjectModuleType(projectModule.getModuleType());
        if (projectModuleOperationProvider == null) {
            throw OperationException.Companion.unsupportedBuildSystem(projectModule);
        }
        ProjectModuleOperationProvider operationProvider = projectModuleOperationProvider;
        LogExtensionsKt.logDebug("ModuleOperationExecutor#installPackage()", (Function0<String>)((Function0)new Function0<String>(operation, projectModule){
            final /* synthetic */ PackageSearchOperation.Package.Install $operation;
            final /* synthetic */ ProjectModule $projectModule;
            {
                this.$operation = $operation;
                this.$projectModule = $projectModule;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Installing package " + this.$operation.getModel().getDisplayName() + " in " + this.$projectModule.getName();
            }
        }));
        this.throwIfAnyFailures(operationProvider.addDependencyToModule(this.dependencyOperationMetadataFrom(projectModule, operation.getModel(), operation.getNewVersion(), operation.getNewScope()), projectModule));
        PackageSearchEventsLogger.Companion.logPackageInstalled-CpnKe8A(this.toIdentifier-raxUTLs(operation.getModel().getCoordinates()), operation.getNewVersion(), operation.getProjectModule());
        LogExtensionsKt.logTrace("ModuleOperationExecutor#installPackage()", (Function0<String>)((Function0)new Function0<String>(operation, projectModule){
            final /* synthetic */ PackageSearchOperation.Package.Install $operation;
            final /* synthetic */ ProjectModule $projectModule;
            {
                this.$operation = $operation;
                this.$projectModule = $projectModule;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Package " + this.$operation.getModel().getDisplayName() + " installed in " + this.$projectModule.getName();
            }
        }));
    }

    private final String toIdentifier-raxUTLs(UnifiedCoordinates $this$toIdentifier_u2draxUTLs) {
        return PackageIdentifier.constructor-impl($this$toIdentifier_u2draxUTLs.getGroupId() + ':' + $this$toIdentifier_u2draxUTLs.getArtifactId());
    }

    private final void removePackage(PackageSearchOperation.Package.Remove operation) {
        ProjectModule projectModule = operation.getProjectModule();
        ProjectModuleOperationProvider projectModuleOperationProvider = ProjectModuleOperationProvider.Companion.forProjectModuleType(projectModule.getModuleType());
        if (projectModuleOperationProvider == null) {
            throw OperationException.Companion.unsupportedBuildSystem(projectModule);
        }
        ProjectModuleOperationProvider operationProvider = projectModuleOperationProvider;
        LogExtensionsKt.logDebug("ModuleOperationExecutor#removePackage()", (Function0<String>)((Function0)new Function0<String>(operation, projectModule){
            final /* synthetic */ PackageSearchOperation.Package.Remove $operation;
            final /* synthetic */ ProjectModule $projectModule;
            {
                this.$operation = $operation;
                this.$projectModule = $projectModule;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Removing package " + this.$operation.getModel().getDisplayName() + " from " + this.$projectModule.getName();
            }
        }));
        this.throwIfAnyFailures(operationProvider.removeDependencyFromModule(ModuleOperationExecutor.dependencyOperationMetadataFrom$default(this, projectModule, operation.getModel(), null, null, 12, null), projectModule));
        PackageSearchEventsLogger.Companion.logPackageRemoved-CpnKe8A(this.toIdentifier-raxUTLs(operation.getModel().getCoordinates()), operation.getCurrentVersion(), operation.getProjectModule());
        LogExtensionsKt.logTrace("ModuleOperationExecutor#removePackage()", (Function0<String>)((Function0)new Function0<String>(operation, projectModule){
            final /* synthetic */ PackageSearchOperation.Package.Remove $operation;
            final /* synthetic */ ProjectModule $projectModule;
            {
                this.$operation = $operation;
                this.$projectModule = $projectModule;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Package " + this.$operation.getModel().getDisplayName() + " removed from " + this.$projectModule.getName();
            }
        }));
    }

    private final void changePackage(PackageSearchOperation.Package.ChangeInstalled operation) {
        ProjectModule projectModule = operation.getProjectModule();
        ProjectModuleOperationProvider projectModuleOperationProvider = ProjectModuleOperationProvider.Companion.forProjectModuleType(projectModule.getModuleType());
        if (projectModuleOperationProvider == null) {
            throw OperationException.Companion.unsupportedBuildSystem(projectModule);
        }
        ProjectModuleOperationProvider operationProvider = projectModuleOperationProvider;
        LogExtensionsKt.logDebug("ModuleOperationExecutor#changePackage()", (Function0<String>)((Function0)new Function0<String>(operation, projectModule){
            final /* synthetic */ PackageSearchOperation.Package.ChangeInstalled $operation;
            final /* synthetic */ ProjectModule $projectModule;
            {
                this.$operation = $operation;
                this.$projectModule = $projectModule;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Changing package " + this.$operation.getModel().getDisplayName() + " in " + this.$projectModule.getName();
            }
        }));
        this.throwIfAnyFailures(operationProvider.updateDependencyInModule(this.dependencyOperationMetadataFrom(projectModule, operation.getModel(), operation.getNewVersion(), operation.getNewScope()), projectModule));
        PackageSearchEventsLogger.Companion.logPackageUpdated-rU7RFWs(this.toIdentifier-raxUTLs(operation.getModel().getCoordinates()), operation.getCurrentVersion(), operation.getNewVersion(), operation.getProjectModule());
        LogExtensionsKt.logTrace("ModuleOperationExecutor#changePackage()", (Function0<String>)((Function0)new Function0<String>(operation, projectModule){
            final /* synthetic */ PackageSearchOperation.Package.ChangeInstalled $operation;
            final /* synthetic */ ProjectModule $projectModule;
            {
                this.$operation = $operation;
                this.$projectModule = $projectModule;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Package " + this.$operation.getModel().getDisplayName() + " changed in " + this.$projectModule.getName();
            }
        }));
    }

    private final DependencyOperationMetadata dependencyOperationMetadataFrom(ProjectModule projectModule, UnifiedDependency dependency, PackageVersion newVersion, PackageScope newScope) {
        String string = StringExtensionsKt.nullIfBlank(dependency.getCoordinates().getGroupId());
        if (string == null) {
            throw new OperationException.InvalidPackage(dependency);
        }
        String string2 = string;
        string = StringExtensionsKt.nullIfBlank(dependency.getCoordinates().getArtifactId());
        if (string == null) {
            throw new OperationException.InvalidPackage(dependency);
        }
        String string3 = string;
        Comparable<PackageVersion> comparable = newVersion;
        string = StringExtensionsKt.nullIfBlank(comparable == null ? null : ((PackageVersion)comparable).getVersionName());
        String string4 = string == null ? StringExtensionsKt.nullIfBlank(dependency.getCoordinates().getVersion()) : string;
        comparable = newScope;
        string = StringExtensionsKt.nullIfBlank(comparable == null ? null : ((PackageScope)comparable).getScopeName());
        return new DependencyOperationMetadata(projectModule, string2, string3, StringExtensionsKt.nullIfBlank(dependency.getCoordinates().getVersion()), StringExtensionsKt.nullIfBlank(dependency.getScope()), string4, string == null ? StringExtensionsKt.nullIfBlank(dependency.getScope()) : string);
    }

    static /* synthetic */ DependencyOperationMetadata dependencyOperationMetadataFrom$default(ModuleOperationExecutor moduleOperationExecutor, ProjectModule projectModule, UnifiedDependency unifiedDependency, PackageVersion packageVersion, PackageScope packageScope, int n, Object object) {
        if ((n & 4) != 0) {
            packageVersion = null;
        }
        if ((n & 8) != 0) {
            packageScope = null;
        }
        return moduleOperationExecutor.dependencyOperationMetadataFrom(projectModule, unifiedDependency, packageVersion, packageScope);
    }

    private final void installRepository(PackageSearchOperation.Repository.Install operation) {
        ProjectModule projectModule = operation.getProjectModule();
        ProjectModuleOperationProvider projectModuleOperationProvider = ProjectModuleOperationProvider.Companion.forProjectModuleType(projectModule.getModuleType());
        if (projectModuleOperationProvider == null) {
            throw OperationException.Companion.unsupportedBuildSystem(projectModule);
        }
        ProjectModuleOperationProvider operationProvider = projectModuleOperationProvider;
        LogExtensionsKt.logDebug("ModuleOperationExecutor#installRepository()", (Function0<String>)((Function0)new Function0<String>(operation, projectModule){
            final /* synthetic */ PackageSearchOperation.Repository.Install $operation;
            final /* synthetic */ ProjectModule $projectModule;
            {
                this.$operation = $operation;
                this.$projectModule = $projectModule;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Installing repository " + this.$operation.getModel().getDisplayName() + " in " + this.$projectModule.getName();
            }
        }));
        this.throwIfAnyFailures(operationProvider.addRepositoryToModule(operation.getModel(), projectModule));
        PackageSearchEventsLogger.Companion.logRepositoryAdded(operation.getModel());
        LogExtensionsKt.logTrace("ModuleOperationExecutor#installRepository()", (Function0<String>)((Function0)new Function0<String>(operation, projectModule){
            final /* synthetic */ PackageSearchOperation.Repository.Install $operation;
            final /* synthetic */ ProjectModule $projectModule;
            {
                this.$operation = $operation;
                this.$projectModule = $projectModule;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Repository " + this.$operation.getModel().getDisplayName() + " installed in " + this.$projectModule.getName();
            }
        }));
    }

    private final void removeRepository(PackageSearchOperation.Repository.Remove operation) {
        ProjectModule projectModule = operation.getProjectModule();
        ProjectModuleOperationProvider projectModuleOperationProvider = ProjectModuleOperationProvider.Companion.forProjectModuleType(projectModule.getModuleType());
        if (projectModuleOperationProvider == null) {
            throw OperationException.Companion.unsupportedBuildSystem(projectModule);
        }
        ProjectModuleOperationProvider operationProvider = projectModuleOperationProvider;
        LogExtensionsKt.logDebug("ModuleOperationExecutor#removeRepository()", (Function0<String>)((Function0)new Function0<String>(operation, projectModule){
            final /* synthetic */ PackageSearchOperation.Repository.Remove $operation;
            final /* synthetic */ ProjectModule $projectModule;
            {
                this.$operation = $operation;
                this.$projectModule = $projectModule;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Removing repository " + this.$operation.getModel().getDisplayName() + " from " + this.$projectModule.getName();
            }
        }));
        this.throwIfAnyFailures(operationProvider.removeRepositoryFromModule(operation.getModel(), projectModule));
        PackageSearchEventsLogger.Companion.logRepositoryRemoved(operation.getModel());
        LogExtensionsKt.logTrace("ModuleOperationExecutor#removeRepository()", (Function0<String>)((Function0)new Function0<String>(operation, projectModule){
            final /* synthetic */ PackageSearchOperation.Repository.Remove $operation;
            final /* synthetic */ ProjectModule $projectModule;
            {
                this.$operation = $operation;
                this.$projectModule = $projectModule;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Repository " + this.$operation.getModel().getDisplayName() + " removed from " + this.$projectModule.getName();
            }
        }));
    }

    private final void throwIfAnyFailures(List<? extends OperationFailure<?>> $this$throwIfAnyFailures) {
        if ($this$throwIfAnyFailures.isEmpty()) {
            return;
        }
        if ($this$throwIfAnyFailures.size() > 1) {
            throw new IllegalStateException("A single operation resulted in multiple failures");
        }
    }
}

