/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.jetbrains.packagesearch.api.v2.ApiStandardPackage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/InstalledDependency;", "", "groupId", "", "artifactId", "(Ljava/lang/String;Ljava/lang/String;)V", "getArtifactId", "()Ljava/lang/String;", "coordinatesString", "getCoordinatesString", "getGroupId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.packageSearch"})
public final class InstalledDependency {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @NotNull
    private final String coordinatesString;

    public InstalledDependency(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.coordinatesString = this.groupId + ':' + this.artifactId;
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final String getArtifactId() {
        return this.artifactId;
    }

    @NotNull
    public final String getCoordinatesString() {
        return this.coordinatesString;
    }

    @NotNull
    public final String component1() {
        return this.groupId;
    }

    @NotNull
    public final String component2() {
        return this.artifactId;
    }

    @NotNull
    public final InstalledDependency copy(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        return new InstalledDependency(groupId, artifactId);
    }

    public static /* synthetic */ InstalledDependency copy$default(InstalledDependency installedDependency, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = installedDependency.groupId;
        }
        if ((n & 2) != 0) {
            string2 = installedDependency.artifactId;
        }
        return installedDependency.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "InstalledDependency(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ')';
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = result * 31 + this.artifactId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InstalledDependency)) {
            return false;
        }
        InstalledDependency installedDependency = (InstalledDependency)other;
        if (!Intrinsics.areEqual((Object)this.groupId, (Object)installedDependency.groupId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.artifactId, (Object)installedDependency.artifactId);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/InstalledDependency$Companion;", "", "()V", "from", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/InstalledDependency;", "dependency", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "standardV2Package", "Lcom/jetbrains/packagesearch/api/v2/ApiStandardPackage;", "intellij.packageSearch"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final InstalledDependency from(@NotNull UnifiedDependency dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            String groupId = dependency.getCoordinates().getGroupId();
            String artifactId = dependency.getCoordinates().getArtifactId();
            if (groupId == null || artifactId == null) {
                return null;
            }
            return new InstalledDependency(groupId, artifactId);
        }

        @NotNull
        public final InstalledDependency from(@NotNull ApiStandardPackage standardV2Package) {
            Intrinsics.checkNotNullParameter((Object)standardV2Package, (String)"standardV2Package");
            return new InstalledDependency(standardV2Package.getGroupId(), standardV2Package.getArtifactId());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

