/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.components;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.TableColorsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.GeometryExtensionsKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0014J\b\u0010(\u001a\u00020&H\u0016J\b\u0010)\u001a\u00020&H\u0002J#\u0010*\u001a\u00020&2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010+R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR:\u0010\u0012\u001a.\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014 \u0015*\u0015\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0017\u00a2\u0006\u0002\b\u00160\u0013\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006,"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/components/ComboBoxTableCellEditorComponent;", "T", "", "Lcom/intellij/ui/components/JBLabel;", "table", "Lcom/intellij/ui/table/JBTable;", "cellRenderer", "Ljavax/swing/ListCellRenderer;", "(Lcom/intellij/ui/table/JBTable;Ljavax/swing/ListCellRenderer;)V", "column", "", "isForcePopupMatchCellWidth", "", "()Z", "setForcePopupMatchCellWidth", "(Z)V", "isShowBelowCell", "setShowBelowCell", "listeners", "", "Ljava/awt/event/ActionListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "options", "", "getOptions", "()Ljava/lang/Iterable;", "setOptions", "(Ljava/lang/Iterable;)V", "row", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "addActionListener", "", "listener", "addNotify", "initAndShowPopup", "setCell", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "intellij.packageSearch"})
public final class ComboBoxTableCellEditorComponent<T>
extends JBLabel {
    @NotNull
    private final JBTable table;
    @NotNull
    private ListCellRenderer<T> cellRenderer;
    @NotNull
    private Iterable<? extends T> options;
    private boolean isForcePopupMatchCellWidth;
    private boolean isShowBelowCell;
    @Nullable
    private T value;
    private int row;
    private int column;
    @NotNull
    private final List<ActionListener> listeners;

    public ComboBoxTableCellEditorComponent(@NotNull JBTable table, @NotNull ListCellRenderer<T> cellRenderer2) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(cellRenderer2, (String)"cellRenderer");
        this.table = table;
        this.cellRenderer = cellRenderer2;
        this.options = CollectionsKt.emptyList();
        this.isForcePopupMatchCellWidth = true;
        this.isShowBelowCell = true;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList<ActionListener>()");
        this.listeners = list;
        this.setOpaque(true);
        this.setBackground(TableColorsKt.getColors((JTable)this.table).getSelectionBackground());
    }

    @NotNull
    public final Iterable<T> getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Iterable<? extends T> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"<set-?>");
        this.options = iterable;
    }

    public final boolean isForcePopupMatchCellWidth() {
        return this.isForcePopupMatchCellWidth;
    }

    public final void setForcePopupMatchCellWidth(boolean bl) {
        this.isForcePopupMatchCellWidth = bl;
    }

    public final boolean isShowBelowCell() {
        return this.isShowBelowCell;
    }

    public final void setShowBelowCell(boolean bl) {
        this.isShowBelowCell = bl;
    }

    @Nullable
    public final T getValue() {
        return this.value;
    }

    public final void setValue(@Nullable T t) {
        this.value = t;
    }

    public final void setCell(@Nullable Integer row, @Nullable Integer column) {
        if (row != null) {
            this.row = row;
        }
        if (column != null) {
            this.column = column;
        }
    }

    public static /* synthetic */ void setCell$default(ComboBoxTableCellEditorComponent comboBoxTableCellEditorComponent, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        comboBoxTableCellEditorComponent.setCell(n, n2);
    }

    public void addNotify() {
        super.addNotify();
        this.initAndShowPopup();
    }

    private final void initAndShowPopup() {
        Rectangle cellRect = this.table.getCellRect(this.row, this.column, true);
        boolean surrendersFocusOnKeystrokeOldValue = this.table.surrendersFocusOnKeyStroke();
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.toList(this.options)).setRenderer(this.cellRenderer).setItemChosenCallback(arg_0 -> ComboBoxTableCellEditorComponent.initAndShowPopup$lambda-0(this, arg_0)).setCancelCallback(() -> ComboBoxTableCellEditorComponent.initAndShowPopup$lambda-1(this)).addListener(new JBPopupListener(this, surrendersFocusOnKeystrokeOldValue){
            final /* synthetic */ ComboBoxTableCellEditorComponent<T> this$0;
            final /* synthetic */ boolean $surrendersFocusOnKeystrokeOldValue;
            {
                this.this$0 = $receiver;
                this.$surrendersFocusOnKeystrokeOldValue = $surrendersFocusOnKeystrokeOldValue;
            }

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComboBoxTableCellEditorComponent.access$getTable$p(this.this$0).setSurrendersFocusOnKeystroke(false);
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ComboBoxTableCellEditorComponent.access$getTable$p(this.this$0).setSurrendersFocusOnKeystroke(this.$surrendersFocusOnKeystrokeOldValue);
            }
        }).setMinSize(this.isForcePopupMatchCellWidth ? new Dimension((int)cellRect.getSize().getWidth(), -1) : null).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"private fun initAndShowPopup() {\n        val cellRect = table.getCellRect(row, column, true)\n        val surrendersFocusOnKeystrokeOldValue = table.surrendersFocusOnKeyStroke()\n\n        val popup = JBPopupFactory.getInstance()\n            .createPopupChooserBuilder(options.toList())\n            .setRenderer(cellRenderer)\n            .setItemChosenCallback { selectedItem ->\n                value = selectedItem\n                val event = ActionEvent(this, ActionEvent.ACTION_PERFORMED, \"elementChosen\")\n                for (listener in listeners) {\n                    listener.actionPerformed(event)\n                }\n                TableUtil.stopEditing(table)\n                table.setValueAt(value, row, column) // on Mac getCellEditorValue() is called before myValue is set.\n                table.tableChanged(TableModelEvent(table.model, row)) // force repaint\n            }\n            .setCancelCallback {\n                TableUtil.stopEditing(table)\n                true\n            }\n            .addListener(object : JBPopupListener {\n                override fun beforeShown(event: LightweightWindowEvent) {\n                    table.surrendersFocusOnKeystroke = false\n                }\n\n                override fun onClosed(event: LightweightWindowEvent) {\n                    table.surrendersFocusOnKeystroke = surrendersFocusOnKeystrokeOldValue\n                }\n            })\n            .setMinSize(if (isForcePopupMatchCellWidth) Dimension(cellRect.size.getWidth().toInt(), -1) else null)\n            .createPopup()\n\n        val popupLocation = Point(cellRect.left, if (isShowBelowCell) cellRect.bottom else cellRect.top)\n        popup.show(RelativePoint(table, popupLocation))\n    }");
        JBPopup popup2 = jBPopup;
        Intrinsics.checkNotNullExpressionValue((Object)cellRect, (String)"cellRect");
        Point popupLocation = new Point(GeometryExtensionsKt.getLeft(cellRect), this.isShowBelowCell ? GeometryExtensionsKt.getBottom(cellRect) : GeometryExtensionsKt.getTop(cellRect));
        popup2.show(new RelativePoint((Component)this.table, popupLocation));
    }

    public final void addActionListener(@NotNull ActionListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    private static final void initAndShowPopup$lambda-0(ComboBoxTableCellEditorComponent this$0, Object selectedItem) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setValue(selectedItem);
        ActionEvent event = new ActionEvent((Object)this$0, 1001, "elementChosen");
        for (ActionListener listener2 : this$0.listeners) {
            listener2.actionPerformed(event);
        }
        TableUtil.stopEditing((JTable)((JTable)this$0.table));
        this$0.table.setValueAt(this$0.getValue(), this$0.row, this$0.column);
        this$0.table.tableChanged(new TableModelEvent(this$0.table.getModel(), this$0.row));
    }

    private static final Boolean initAndShowPopup$lambda-1(ComboBoxTableCellEditorComponent this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        TableUtil.stopEditing((JTable)((JTable)this$0.table));
        return true;
    }

    public static final /* synthetic */ JBTable access$getTable$p(ComboBoxTableCellEditorComponent $this) {
        return $this.table;
    }
}

