/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationGroupManagerImpl;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.StringKt;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.rest.InstallPackageRequest;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.PackageSearchToolWindowFactory;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageSearchDataService;
import com.jetbrains.packagesearch.intellij.plugin.util.ProjectExtensionsKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u0004H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/rest/PackageSearchRestService;", "Lorg/jetbrains/ide/RestService;", "()V", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "installPackage", "", "isAccessible", "", "Lio/netty/handler/codec/http/HttpRequest;", "isHostTrusted", "isMethodSupported", "method", "Lio/netty/handler/codec/http/HttpMethod;", "listProjects", "notify", "project", "Lcom/intellij/openapi/project/Project;", "pkg", "intellij.packageSearch"})
public final class PackageSearchRestService
extends RestService {
    @NotNull
    protected String getServiceName() {
        return "packageSearch";
    }

    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return method == HttpMethod.GET || method == HttpMethod.POST;
    }

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = RestService.Companion.getStringParameter("action", urlDecoder);
        if (Intrinsics.areEqual((Object)string, (Object)"projects")) {
            this.listProjects(request, context);
        } else if (Intrinsics.areEqual((Object)string, (Object)"install")) {
            this.installPackage(request, context);
        } else {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            HttpResponseStatus httpResponseStatus2 = httpResponseStatus;
            boolean bl = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request));
            httpResponseStatus = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"context.channel()");
            RestService.Companion.sendStatus(httpResponseStatus2, bl, (Channel)httpResponseStatus);
        }
        return null;
    }

    private final void listProjects(FullHttpRequest request, ChannelHandlerContext context) {
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        String name = ApplicationNamesInfo.getInstance().getProductName();
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getInstance().build");
        BuildNumber build2 = buildNumber;
        buildNumber = RestService.Companion.createJsonWriter((OutputStream)out);
        boolean bl = false;
        boolean bl2 = false;
        BuildNumber $this$listProjects_u24lambda_u2d1 = buildNumber;
        boolean bl3 = false;
        $this$listProjects_u24lambda_u2d1.beginObject();
        $this$listProjects_u24lambda_u2d1.name("name").value(name);
        $this$listProjects_u24lambda_u2d1.name("buildNumber").value(build2.asString());
        $this$listProjects_u24lambda_u2d1.name("projects");
        $this$listProjects_u24lambda_u2d1.beginArray();
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getInstance().openProjects");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl4 = false;
            $this$listProjects_u24lambda_u2d1.value(it.getName());
        }
        $this$listProjects_u24lambda_u2d1.endArray();
        $this$listProjects_u24lambda_u2d1.endObject();
        $this$listProjects_u24lambda_u2d1.close();
        RestService.Companion.send(out, (HttpRequest)request, context);
    }

    private final void installPackage(FullHttpRequest request, ChannelHandlerContext context) {
        Project project;
        HttpResponseStatus httpResponseStatus;
        InstallPackageRequest data;
        block2: {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            data = (InstallPackageRequest)gson.fromJson(RestService.Companion.createJsonReader(request), (Type)((Object)InstallPackageRequest.class));
            Object[] objectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getInstance().openProjects");
            objectArray = objectArray;
            boolean bl = false;
            httpResponseStatus = objectArray;
            boolean bl2 = false;
            Object[] objectArray2 = httpResponseStatus;
            int n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Project project2;
                Project it = project2 = objectArray2[i];
                boolean bl3 = false;
                if (!StringsKt.equals((String)it.getName(), (String)data.getProject(), (boolean)true)) continue;
                project = project2;
                break block2;
            }
            project = null;
        }
        Project project3 = project;
        String pkg = data.getPackage();
        String query = StringKt.nullize((String)data.getQuery(), (boolean)true);
        if (project3 == null || pkg == null) {
            httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"BAD_REQUEST");
            HttpResponseStatus httpResponseStatus2 = httpResponseStatus;
            boolean bl = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request));
            httpResponseStatus = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"context.channel()");
            RestService.Companion.sendStatus(httpResponseStatus2, bl, (Channel)httpResponseStatus);
            return;
        }
        AppUIExecutor.onUiThread().execute(() -> PackageSearchRestService.installPackage$lambda-3(project3, query, pkg, this));
        RestService.Companion.sendOk(request, context);
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return true;
    }

    protected boolean isHostTrusted(@NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) {
        boolean bl;
        String originHost;
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        String origin = NettyKt.getOrigin((HttpRequest)((HttpRequest)request));
        try {
            string = origin == null ? null : StringKt.nullize$default((String)new URI(origin).getHost(), (boolean)false, (int)1, null);
        }
        catch (URISyntaxException ignored) {
            return false;
        }
        String string2 = originHost = string;
        if (string2 == null) {
            bl = false;
        } else {
            boolean bl2;
            String string3 = string2;
            boolean bl3 = false;
            boolean bl4 = false;
            String it = string3;
            boolean bl5 = false;
            bl = bl2 = Intrinsics.areEqual((Object)it, (Object)"package-search.jetbrains.com") || StringsKt.endsWith$default((String)it, (String)"package-search.services.jetbrains.com", (boolean)false, (int)2, null) || NetUtils.isLocalhost((String)it);
        }
        boolean isTrusted = bl;
        return isTrusted || super.isHostTrusted(request, urlDecoder);
    }

    private final void notify(Project project, @Nls String pkg) {
        new NotificationGroupManagerImpl().getNotificationGroup("packagesearch.notification").createNotification(PackageSearchBundle.INSTANCE.message("packagesearch.title", new Object[0]), PackageSearchBundle.INSTANCE.message("packagesearch.restService.readyForInstallation", new Object[0]), NotificationType.INFORMATION).setSubtitle(pkg).notify(project);
    }

    private static final void installPackage$lambda-3(Project $project, String $query, String $pkg, PackageSearchRestService this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ProjectUtil.focusProjectWindow((Project)$project, (boolean)true);
        PackageSearchToolWindowFactory.Companion.activateToolWindow($project, (Function0<Unit>)((Function0)new Function0<Unit>($project, $query, $pkg, this$0){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $query;
            final /* synthetic */ String $pkg;
            final /* synthetic */ PackageSearchRestService this$0;
            {
                this.$project = $project;
                this.$query = $query;
                this.$pkg = $pkg;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                PackageSearchDataService rootModel = ProjectExtensionsKt.getPackageSearchDataService(this.$project);
                String string = this.$query;
                rootModel.setSearchQuery(string == null ? StringsKt.replace$default((String)this.$pkg, (char)':', (char)' ', (boolean)false, (int)4, null) : string);
                PackageSearchRestService.access$notify(this.this$0, this.$project, this.$pkg);
            }
        }));
    }

    public static final /* synthetic */ void access$notify(PackageSearchRestService $this, Project project, String pkg) {
        $this.notify(project, pkg);
    }
}

