/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.jetbrains.packagesearch.PackageSearchIcons;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.PackageSearchToolWindowFactory;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageSearchDataService;
import com.jetbrains.packagesearch.intellij.plugin.util.ProjectExtensionsKt;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0015\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016J%\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/intentions/PackageSearchUnresolvedReferenceQuickFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "Lcom/intellij/openapi/util/Iconable;", "ref", "Lcom/intellij/psi/PsiReference;", "(Lcom/intellij/psi/PsiReference;)V", "classnamePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getFamilyName", "", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "flags", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.packageSearch"})
public final class PackageSearchUnresolvedReferenceQuickFix
implements IntentionAction,
LowPriorityAction,
Iconable {
    @NotNull
    private final PsiReference ref;
    private final Pattern classnamePattern;

    public PackageSearchUnresolvedReferenceQuickFix(@NotNull PsiReference ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.ref = ref;
        this.classnamePattern = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{Lu}\\p{javaJavaIdentifierPart}+");
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PackageSearchToolWindowFactory.Companion.activateToolWindow(project, (Function0<Unit>)((Function0)new Function0<Unit>(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ PackageSearchUnresolvedReferenceQuickFix this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                PackageSearchDataService packageSearchDataService = ProjectExtensionsKt.getPackageSearchDataService(this.$project);
                String string = PackageSearchUnresolvedReferenceQuickFix.access$getRef$p(this.this$0).getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ref.canonicalText");
                packageSearchDataService.setSearchQuery(string);
            }
        }));
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement psiElement = this.ref.getElement();
        boolean bl = false;
        boolean bl2 = false;
        PsiElement $this$isAvailable_u24lambda_u2d0 = psiElement;
        boolean bl3 = false;
        return $this$isAvailable_u24lambda_u2d0.isValid() && this.classnamePattern.matcher($this$isAvailable_u24lambda_u2d0.getText()).matches();
    }

    @NotNull
    public String getText() {
        return PackageSearchBundle.INSTANCE.message("packagesearch.quickfix.packagesearch.action", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return PackageSearchBundle.INSTANCE.message("packagesearch.quickfix.packagesearch.family", new Object[0]);
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = PackageSearchIcons.Package;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Package");
        return icon;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static final /* synthetic */ PsiReference access$getRef$p(PackageSearchUnresolvedReferenceQuickFix $this) {
        return $this.ref;
    }
}

