/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.intentions;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ProjectModule;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RepositoryModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RootDataModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperation;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperationFactory;
import com.jetbrains.packagesearch.intellij.plugin.util.ProjectExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J3\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0096\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/intentions/PackageSearchDependencyUpdateQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "packageModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel$Installed;", "unifiedDependency", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "projectModule", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/ProjectModule;", "targetVersion", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageVersion;", "(Lcom/intellij/psi/PsiElement;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel$Installed;Lcom/intellij/buildsystem/model/unified/UnifiedDependency;Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/ProjectModule;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageVersion;)V", "operationFactory", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperationFactory;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "intellij.packageSearch"})
public final class PackageSearchDependencyUpdateQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final PackageModel.Installed packageModel;
    @NotNull
    private final UnifiedDependency unifiedDependency;
    @NotNull
    private final ProjectModule projectModule;
    @NotNull
    private final PackageVersion targetVersion;
    @NotNull
    private final PackageSearchOperationFactory operationFactory;

    public PackageSearchDependencyUpdateQuickFix(@NotNull PsiElement element, @NotNull PackageModel.Installed packageModel, @NotNull UnifiedDependency unifiedDependency, @NotNull ProjectModule projectModule, @NotNull PackageVersion targetVersion) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)packageModel, (String)"packageModel");
        Intrinsics.checkNotNullParameter((Object)unifiedDependency, (String)"unifiedDependency");
        Intrinsics.checkNotNullParameter((Object)projectModule, (String)"projectModule");
        Intrinsics.checkNotNullParameter((Object)targetVersion, (String)"targetVersion");
        super(element);
        this.packageModel = packageModel;
        this.unifiedDependency = unifiedDependency;
        this.projectModule = projectModule;
        this.targetVersion = targetVersion;
        this.operationFactory = new PackageSearchOperationFactory();
    }

    @NotNull
    public String getFamilyName() {
        return PackageSearchBundle.INSTANCE.message("packagesearch.quickfix.upgrade.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{UnifiedCoordinates.copy$default((UnifiedCoordinates)this.unifiedDependency.getCoordinates(), null, null, null, (int)3, null).getDisplayName(), this.targetVersion};
        return PackageSearchBundle.INSTANCE.message("packagesearch.quickfix.upgrade.action", objectArray);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        String string = this.unifiedDependency.getCoordinates().getVersion();
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "The dependency " + this.unifiedDependency.getCoordinates().getDisplayName() + " has no set version";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        RootDataModel dataModel = (RootDataModel)ProjectExtensionsKt.getPackageSearchDataService(project).getDataModelFlow().getValue();
        PackageVersion selectedVersion = PackageVersion.Companion.from(this.unifiedDependency.getCoordinates().getVersion());
        RepositoryModel repoToInstall = dataModel.getKnownRepositoriesInTargetModules().repositoryToAddWhenInstallingOrUpgrading(this.packageModel, selectedVersion, dataModel.getAllKnownRepositories());
        List<PackageSearchOperation<?>> operations = this.operationFactory.createChangePackageVersionOperations(this.projectModule, this.unifiedDependency, this.targetVersion, repoToInstall);
        ProjectExtensionsKt.getPackageSearchDataService(project).executeOperations(operations);
    }
}

