/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.gradle;

import com.intellij.buildsystem.model.OperationFailure;
import com.intellij.buildsystem.model.OperationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.AbstractProjectModuleOperationProvider;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.DependencyOperationMetadata;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ProjectModule;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ProjectModuleType;
import com.jetbrains.packagesearch.intellij.plugin.gradle.GradleProjectModuleType;
import com.jetbrains.packagesearch.intellij.plugin.gradle.configuration.PackageSearchGradleConfiguration;
import com.jetbrains.packagesearch.intellij.plugin.gradle.configuration.PackageSearchGradleConfigurationKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/gradle/GradleProjectModuleOperationProvider;", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/AbstractProjectModuleOperationProvider;", "()V", "addDependencyToModule", "", "Lcom/intellij/buildsystem/model/OperationFailure;", "Lcom/intellij/buildsystem/model/OperationItem;", "operationMetadata", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/DependencyOperationMetadata;", "module", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/ProjectModule;", "hasSupportFor", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "projectModuleType", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/ProjectModuleType;", "removeDependencyFromModule", "saveAdditionalScopeToConfigurationIfNeeded", "", "scopeName", "", "intellij.packageSearch"})
public class GradleProjectModuleOperationProvider
extends AbstractProjectModuleOperationProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSupportFor(@NotNull Project project, @Nullable PsiFile psiFile) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        boolean isGroovyFile = StringsKt.equals((String)"groovy", (String)psiFile.getFileType().getName(), (boolean)true);
        boolean isKotlinFile = StringsKt.equals((String)"kotlin", (String)psiFile.getFileType().getName(), (boolean)true);
        if (!isGroovyFile && !isKotlinFile) {
            return false;
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        if (StringsKt.endsWith((String)string, (String)"gradle", (boolean)true)) return true;
        string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        if (!StringsKt.endsWith((String)string, (String)"gradle.kts", (boolean)true)) return false;
        return true;
    }

    @Override
    public boolean hasSupportFor(@NotNull ProjectModuleType projectModuleType) {
        Intrinsics.checkNotNullParameter((Object)projectModuleType, (String)"projectModuleType");
        return projectModuleType instanceof GradleProjectModuleType;
    }

    @Override
    @NotNull
    public List<OperationFailure<? extends OperationItem>> addDependencyToModule(@NotNull DependencyOperationMetadata operationMetadata, @NotNull ProjectModule module) {
        Intrinsics.checkNotNullParameter((Object)operationMetadata, (String)"operationMetadata");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = operationMetadata.getNewScope();
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = PackageSearchBundle.INSTANCE.getMessage("packagesearch.operation.error.gradle.missing.configuration", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PackageSearchBundle.getMessage(\"packagesearch.operation.error.gradle.missing.configuration\")");
            String string3 = string2;
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        string = module.getNativeModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.nativeModule.project");
        this.saveAdditionalScopeToConfigurationIfNeeded((Project)string, operationMetadata.getNewScope());
        return super.addDependencyToModule(operationMetadata, module);
    }

    @Override
    @NotNull
    public List<OperationFailure<? extends OperationItem>> removeDependencyFromModule(@NotNull DependencyOperationMetadata operationMetadata, @NotNull ProjectModule module) {
        Intrinsics.checkNotNullParameter((Object)operationMetadata, (String)"operationMetadata");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = operationMetadata.getCurrentScope();
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = PackageSearchBundle.INSTANCE.getMessage("packagesearch.operation.error.gradle.missing.configuration", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PackageSearchBundle.getMessage(\"packagesearch.operation.error.gradle.missing.configuration\")");
            String string3 = string2;
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        return super.removeDependencyFromModule(operationMetadata, module);
    }

    private final void saveAdditionalScopeToConfigurationIfNeeded(Project project, String scopeName) {
        PackageSearchGradleConfiguration configuration = PackageSearchGradleConfigurationKt.packageSearchGradleConfigurationForProject(project);
        if (!configuration.getUpdateScopesOnUsage()) {
            return;
        }
        configuration.addGradleScope(scopeName);
    }
}

