/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.gradle;

import com.intellij.lang.Language;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.BuildSystemType;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ModuleTransformer;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ProjectModule;
import com.jetbrains.packagesearch.intellij.plugin.gradle.GradleModuleTransformerKt;
import com.jetbrains.packagesearch.intellij.plugin.gradle.GradleProjectModuleType;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.util.LogExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J*\u0010\u001a\u001a\u00020\u001b*\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u001f\u001a\u0004\u0018\u00010\r*\u00020\r2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010!\u001a\u00020\u0011*\u00020\u000fH\u0002\u00a8\u0006#"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/gradle/GradleModuleTransformer;", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/ModuleTransformer;", "()V", "createNavigatableDependencyCallback", "Lkotlin/Function3;", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageVersion;", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findExternalProjectOrNull", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "module", "Lcom/intellij/openapi/module/Module;", "recursiveSearch", "", "getAllSubmodules", "", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/ProjectModule;", "rootModule", "isKotlinDsl", "buildVirtualFile", "transformModules", "nativeModules", "addChildrenToListRecursive", "", "modules", "", "currentModule", "findProjectWithId", "externalProjectId", "isNotGradleSourceSetModule", "Companion", "intellij.packageSearch"})
public final class GradleModuleTransformer
implements ModuleTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ProjectModule> transformModules(@NotNull Project project, @NotNull List<? extends Module> nativeModules) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(nativeModules, (String)"nativeModules");
        Iterable $this$filter$iv = nativeModules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Module)element$iv$iv;
            boolean bl = false;
            if (!this.isNotGradleSourceSetModule((Module)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            ProjectModule projectModule;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            Module nativeModule = (Module)element$iv$iv;
            boolean bl2 = false;
            ExternalProject externalProject = this.findExternalProjectOrNull(project, nativeModule, false);
            if (externalProject == null) {
                projectModule = null;
            } else {
                ExternalProject externalProject2 = externalProject;
                File file = externalProject2.getBuildFile();
                if (file == null) {
                    projectModule = null;
                } else {
                    File file2;
                    File buildFile = file2 = file;
                    Object object = LocalFileSystem.getInstance().findFileByPath(buildFile.getAbsolutePath());
                    if (object == null) {
                        projectModule = null;
                    } else {
                        file = object;
                        File buildVirtualFile = file;
                        BuildSystemType buildSystemType = this.isKotlinDsl(project, (VirtualFile)buildVirtualFile) ? BuildSystemType.Companion.getGRADLE_KOTLIN() : BuildSystemType.Companion.getGRADLE_GROOVY();
                        object = externalProject2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"externalProject.name");
                        ProjectModule projectModule2 = projectModule = new ProjectModule((String)object, nativeModule, null, (VirtualFile)buildVirtualFile, buildSystemType, GradleProjectModuleType.INSTANCE, this.createNavigatableDependencyCallback(project, (VirtualFile)buildVirtualFile));
                    }
                }
            }
            if (projectModule == null) continue;
            ProjectModule projectModule3 = projectModule;
            boolean bl3 = false;
            boolean bl4 = false;
            ProjectModule it$iv$iv = projectModule3;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ProjectModule)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getAllSubmodules(project, (ProjectModule)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<VirtualFile> set$iv = new HashSet<VirtualFile>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ProjectModule it2 = (ProjectModule)e$iv;
            boolean bl = false;
            VirtualFile key$iv = it2.getBuildFile();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private final boolean isKotlinDsl(Project project, VirtualFile buildVirtualFile) {
        Language language;
        Object object = PsiManager.getInstance((Project)project).findFile(buildVirtualFile);
        Language language2 = language = object == null ? null : object.getLanguage();
        return Intrinsics.areEqual(language == null ? null : ((object = language.getDisplayName()) == null ? null : Boolean.valueOf(StringsKt.contains((CharSequence)((CharSequence)object), (CharSequence)"kotlin", (boolean)true))), (Object)true);
    }

    private final boolean isNotGradleSourceSetModule(Module $this$isNotGradleSourceSetModule) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)$this$isNotGradleSourceSetModule)) {
            return false;
        }
        return !Intrinsics.areEqual((Object)ExternalSystemApiUtil.getExternalModuleType((Module)$this$isNotGradleSourceSetModule), (Object)"sourceSet");
    }

    private final List<ProjectModule> getAllSubmodules(Project project, ProjectModule rootModule) {
        ExternalProject externalProject = GradleModuleTransformer.findExternalProjectOrNull$default(this, project, rootModule.getNativeModule(), false, 4, null);
        if (externalProject == null) {
            return CollectionsKt.emptyList();
        }
        ExternalProject externalRootProject = externalProject;
        Object[] objectArray = new ProjectModule[]{rootModule};
        List modules = CollectionsKt.mutableListOf((Object[])objectArray);
        this.addChildrenToListRecursive(externalRootProject, modules, rootModule, project);
        return modules;
    }

    private final ExternalProject findExternalProjectOrNull(Project project, Module module, boolean recursiveSearch) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            LogExtensionsKt.logDebug(Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName(), (Function0<String>)((Function0)new Function0<String>(project, module){
                final /* synthetic */ Project $project;
                final /* synthetic */ Module $module;
                {
                    this.$project = $project;
                    this.$module = $module;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Module has no external project ID, project=" + this.$project.getProjectFilePath() + ", module=" + this.$module.getModuleFilePath();
                }
            }));
            return null;
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (rootProjectPath == null) {
            LogExtensionsKt.logDebug(Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName(), (Function0<String>)((Function0)new Function0<String>(project, module){
                final /* synthetic */ Project $project;
                final /* synthetic */ Module $module;
                {
                    this.$project = $project;
                    this.$module = $module;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Root external project was not yet imported, project=" + this.$project.getProjectFilePath() + ", module=" + this.$module.getModuleFilePath();
                }
            }));
            return null;
        }
        ExternalProjectDataCache externalProjectDataCache = ExternalProjectDataCache.getInstance((Project)project);
        ExternalProject externalProject = externalProjectDataCache.getRootExternalProject(rootProjectPath);
        if (externalProject == null) {
            LogExtensionsKt.logDebug(Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName(), (Function0<String>)((Function0)new Function0<String>(project, module){
                final /* synthetic */ Project $project;
                final /* synthetic */ Module $module;
                {
                    this.$project = $project;
                    this.$module = $module;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "External project is not yet cached, project=" + this.$project.getProjectFilePath() + ", module=" + this.$module.getModuleFilePath();
                }
            }));
            return null;
        }
        return this.findProjectWithId(externalProject, externalProjectId, recursiveSearch);
    }

    static /* synthetic */ ExternalProject findExternalProjectOrNull$default(GradleModuleTransformer gradleModuleTransformer, Project project, Module module, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return gradleModuleTransformer.findExternalProjectOrNull(project, module, bl);
    }

    private final ExternalProject findProjectWithId(ExternalProject $this$findProjectWithId, String externalProjectId, boolean recursiveSearch) {
        if (Intrinsics.areEqual((Object)externalProjectId, (Object)$this$findProjectWithId.getId())) {
            return $this$findProjectWithId;
        }
        if (!recursiveSearch) {
            return null;
        }
        Collection childExternalProjects = $this$findProjectWithId.getChildProjects().values();
        if (childExternalProjects.isEmpty()) {
            return null;
        }
        for (ExternalProject childExternalProject : childExternalProjects) {
            if (Intrinsics.areEqual((Object)childExternalProject.getId(), (Object)externalProjectId)) {
                return childExternalProject;
            }
            Intrinsics.checkNotNullExpressionValue((Object)childExternalProject, (String)"childExternalProject");
            ExternalProject recursiveExternalProject = this.findProjectWithId(childExternalProject, externalProjectId, recursiveSearch);
            if (recursiveExternalProject == null) continue;
            return recursiveExternalProject;
        }
        return null;
    }

    private final void addChildrenToListRecursive(ExternalProject $this$addChildrenToListRecursive, List<ProjectModule> modules, ProjectModule currentModule, Project project) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        for (ExternalProject externalProject : $this$addChildrenToListRecursive.getChildProjects().values()) {
            File file;
            File projectBuildFile;
            File file2;
            File file3;
            Object object = externalProject.getBuildFile();
            if (object == null) {
                file3 = null;
            } else {
                String string = ((File)object).getAbsolutePath();
                if (string == null) {
                    file3 = null;
                } else {
                    String string2 = string;
                    Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"localFileSystem");
                    VirtualFileSystem virtualFileSystem = (VirtualFileSystem)localFileSystem;
                    boolean bl = false;
                    boolean bl2 = false;
                    String p0 = string2;
                    boolean bl3 = false;
                    file3 = virtualFileSystem.findFileByPath(p0);
                }
            }
            if ((file2 = file3) == null || (object = ModuleUtilCore.findModuleForFile(projectBuildFile = (file = file2), (Project)project)) == null) continue;
            File nativeModule = file2 = object;
            object = externalProject.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"externalProject.name");
            ProjectModule projectModule = new ProjectModule((String)object, (Module)nativeModule, currentModule, (VirtualFile)projectBuildFile, BuildSystemType.Companion.getGRADLE_GROOVY(), GradleProjectModuleType.INSTANCE, this.createNavigatableDependencyCallback(project, (VirtualFile)projectBuildFile));
            object = modules;
            boolean bl = false;
            object.add(projectModule);
            Intrinsics.checkNotNullExpressionValue((Object)externalProject, (String)"externalProject");
            this.addChildrenToListRecursive(externalProject, modules, projectModule, project);
        }
    }

    private final Function3<String, String, PackageVersion, Navigatable> createNavigatableDependencyCallback(Project project, VirtualFile file) {
        return (Function3)new Function3<String, String, PackageVersion, Navigatable>(project, file){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            {
                this.$project = $project;
                this.$file = $file;
                super(3);
            }

            @Nullable
            public final Navigatable invoke(@NotNull String groupId, @NotNull String artifactId, @NotNull PackageVersion $noName_2) {
                Navigatable navigatable;
                Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
                Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
                Intrinsics.checkNotNullParameter((Object)$noName_2, (String)"$noName_2");
                PsiFile psiFile = PsiManager.getInstance((Project)this.$project).findFile(this.$file);
                if (psiFile == null) {
                    navigatable = null;
                } else {
                    PsiFile psiFile2 = psiFile;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiFile psiFile3 = psiFile2;
                    boolean bl3 = false;
                    PsiElement psiElement = GradleModuleTransformer.Companion.findDependencyElement(psiFile3, groupId, artifactId);
                    if (psiElement == null) {
                        navigatable = null;
                    } else {
                        PsiElement dependencyElement = psiElement;
                        navigatable = (Navigatable)dependencyElement;
                    }
                }
                return navigatable;
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/gradle/GradleModuleTransformer$Companion;", "", "()V", "findDependencyElement", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "groupId", "", "artifactId", "intellij.packageSearch"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiElement findDependencyElement(@NotNull PsiFile file, @NotNull String groupId, @NotNull String artifactId) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
            boolean isKotlinDependency = Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(file.getLanguage().getClass()).getQualifiedName(), (Object)"org.jetbrains.kotlin.idea.KotlinLanguage") && Intrinsics.areEqual((Object)groupId, (Object)"org.jetbrains.kotlin") && StringsKt.startsWith$default((String)artifactId, (String)"kotlin-", (boolean)false, (int)2, null);
            String kotlinDependencyImport = "kotlin(\"" + StringsKt.removePrefix((String)artifactId, (CharSequence)"kotlin-") + "\")";
            String searchableText = isKotlinDependency ? kotlinDependencyImport : groupId + ':' + artifactId;
            return GradleModuleTransformerKt.access$firstElementContaining(file, searchableText);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

