/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.extensibility;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ProjectModuleOperationProvider;
import com.jetbrains.packagesearch.intellij.plugin.intentions.PackageSearchDependencyUpdateQuickFix;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageScope;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackagesToUpdate;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RootDataModel;
import com.jetbrains.packagesearch.intellij.plugin.util.ModelConversionExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.util.ProjectExtensionsKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H$J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/PackageUpdateInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "getVersionPsiElement", "Lcom/intellij/psi/PsiElement;", "dependency", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "shouldCheckFile", "intellij.packageSearch"})
public abstract class PackageUpdateInspection
extends LocalInspectionTool {
    @Nullable
    protected abstract PsiElement getVersionPsiElement(@NotNull PsiFile var1, @NotNull UnifiedDependency var2);

    @Nullable
    public final ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!this.shouldCheckFile(file)) {
            return null;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        Project project2 = project;
        RootDataModel dataModel = (RootDataModel)ProjectExtensionsKt.getPackageSearchDataService(project2).getDataModelFlow().getValue();
        if (dataModel.getPackageModels().isEmpty()) {
            return null;
        }
        Module module = ModuleUtil.findModuleForFile((PsiFile)file);
        Map<Module, Set<PackagesToUpdate.PackageUpdateInfo>> map2 = dataModel.getPackagesToUpdate().getUpdatesByModule();
        boolean bl = false;
        Set<PackagesToUpdate.PackageUpdateInfo> set = map2.get(module);
        if (set == null) {
            return null;
        }
        Set<PackagesToUpdate.PackageUpdateInfo> availableUpdates = set;
        ProblemsHolder problemsHolder = new ProblemsHolder(manager, file, isOnTheFly);
        for (PackagesToUpdate.PackageUpdateInfo packageUpdateInfo : availableUpdates) {
            Object[] versionElement;
            Object[] objectArray;
            Object[] objectArray2;
            PackageVersion currentVersion = packageUpdateInfo.getUsageInfo().getVersion();
            PackageScope scope = packageUpdateInfo.getUsageInfo().getScope();
            UnifiedDependency unifiedDependency = ModelConversionExtensionsKt.toUnifiedDependency(packageUpdateInfo.getPackageModel(), currentVersion, scope);
            PackageUpdateInspection $this$tryDoing$iv = this;
            boolean $i$f$tryDoing = false;
            try {
                boolean bl2 = false;
                objectArray2 = this.getVersionPsiElement(file, unifiedDependency);
            }
            catch (Throwable t$iv) {
                try {
                    Logger.getInstance(PackageUpdateInspection.class).error(Intrinsics.stringPlus((String)"Failed to execute safe operation: ", (Object)t$iv.getMessage()), t$iv);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                objectArray2 = null;
            }
            if ((objectArray = objectArray2) == null || !Intrinsics.areEqual((Object)(versionElement = objectArray).getContainingFile(), (Object)file)) continue;
            objectArray = new Object[]{packageUpdateInfo.getTargetVersion()};
            String string = PackageSearchBundle.INSTANCE.message("packagesearch.inspection.upgrade.description", objectArray);
            objectArray = new LocalQuickFix[]{(LocalQuickFix)new PackageSearchDependencyUpdateQuickFix((PsiElement)versionElement, packageUpdateInfo.getPackageModel(), unifiedDependency, packageUpdateInfo.getUsageInfo().getProjectModule(), packageUpdateInfo.getTargetVersion())};
            problemsHolder.registerProblem((PsiElement)versionElement, string, (LocalQuickFix[])objectArray);
        }
        return problemsHolder.getResultsArray();
    }

    private final boolean shouldCheckFile(PsiFile file) {
        String string = file.getLanguage().getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.language.displayName");
        boolean isScala = StringsKt.contains((CharSequence)string, (CharSequence)"scala", (boolean)true);
        if (isScala) {
            return false;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        ProjectModuleOperationProvider projectModuleOperationProvider = ProjectModuleOperationProvider.Companion.forProjectPsiFileOrNull(project, file);
        if (projectModuleOperationProvider == null) {
            return false;
        }
        ProjectModuleOperationProvider operationProvider = projectModuleOperationProvider;
        projectModuleOperationProvider = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)projectModuleOperationProvider, (String)"file.project");
        return operationProvider.hasSupportFor((Project)projectModuleOperationProvider, file);
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"WARNING");
        return highlightDisplayLevel;
    }
}

