/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.api.query.language;

import com.intellij.util.io.URLUtil;
import com.jetbrains.packagesearch.intellij.plugin.api.query.SearchQueryParser;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0006H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/api/query/language/SampleQuery;", "Lcom/jetbrains/packagesearch/intellij/plugin/api/query/SearchQueryParser;", "query", "", "(Ljava/lang/String;)V", "onlyMpp", "", "onlyStable", "tags", "", "buildQueryString", "handleAttribute", "", "name", "value", "invert", "intellij.packageSearch"})
public final class SampleQuery
extends SearchQueryParser {
    @NotNull
    private final Set<String> tags;
    private boolean onlyStable;
    private boolean onlyMpp;

    public SampleQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        boolean bl = false;
        this.tags = new LinkedHashSet();
        this.onlyStable = true;
        this.parse(query);
    }

    @Override
    protected void handleAttribute(@NotNull String name, @NotNull String value, boolean invert) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.equals((String)name, (String)"/tag", (boolean)true)) {
            this.tags.add(value);
        } else if (StringsKt.equals((String)name, (String)"/onlyStable", (boolean)true)) {
            String string = value;
            boolean bl = false;
            this.onlyStable = Boolean.parseBoolean(string);
        } else if (StringsKt.equals((String)name, (String)"/onlyMpp", (boolean)true)) {
            String string = value;
            boolean bl = false;
            this.onlyMpp = Boolean.parseBoolean(string);
        }
    }

    @NotNull
    public final String buildQueryString() {
        StringBuilder url = new StringBuilder();
        url.append("q=");
        Object object = this.getSearchQuery();
        boolean bl = false;
        boolean bl2 = false;
        if (!(object == null || object.length() == 0)) {
            object = this.getSearchQuery();
            Intrinsics.checkNotNull((Object)object);
            url.append(URLUtil.encodeURIComponent((String)object));
        }
        url.append(Intrinsics.stringPlus((String)"&onlyStable=", (Object)this.onlyStable));
        url.append(Intrinsics.stringPlus((String)"&onlyMpp=", (Object)this.onlyMpp));
        for (String tag : this.tags) {
            url.append("&tags=").append(URLUtil.encodeURIComponent((String)tag));
        }
        object = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"url.toString()");
        return object;
    }
}

