/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.api.http;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.jetbrains.packagesearch.intellij.plugin.api.http.ApiResult;
import com.jetbrains.packagesearch.intellij.plugin.api.http.EmptyBodyException;
import com.jetbrains.packagesearch.intellij.plugin.api.http.HttpWrapperKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0012\n\u0000\u001aK\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\t0\bH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0002H\u0002\u001a,\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0017H\u0002\u001a\u001a\u0010\u0018\u001a\u00020\u0019*\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"requestString", "Lcom/jetbrains/packagesearch/intellij/plugin/api/http/ApiResult;", "", "url", "acceptContentType", "timeoutInSeconds", "", "headers", "", "Lkotlin/Pair;", "(Ljava/lang/String;Ljava/lang/String;ILjava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "asJSONObject", "Lcom/google/gson/JsonObject;", "copyTo", "", "Ljava/io/InputStream;", "out", "Ljava/io/OutputStream;", "bufferSize", "cancellationRequested", "Lkotlin/Function0;", "", "log", "", "readBytes", "", "intellij.packageSearch"})
public final class HttpWrapperKt {
    @Nullable
    public static final Object requestString(@NotNull String url, @NotNull String acceptContentType, int timeoutInSeconds, @NotNull List<Pair<String, String>> headers, @NotNull Continuation<? super ApiResult<String>> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super ApiResult<String>> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        try {
            RequestBuilder builder2 = HttpRequests.request((String)url).productNameAsUserAgent().accept(acceptContentType).connectTimeout(timeoutInSeconds * 1000).readTimeout(timeoutInSeconds * 1000).tuner(new HttpRequests.ConnectionTuner(headers){
                final /* synthetic */ List<Pair<String, String>> $headers;
                {
                    this.$headers = $headers;
                }

                public final void tune(@NotNull URLConnection connection) {
                    Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                    Iterable $this$forEach$iv = this.$headers;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl = false;
                        connection.setRequestProperty((String)it.getFirst(), (String)it.getSecond());
                    }
                }
            });
            builder2.connect(new HttpRequests.RequestProcessor((CancellableContinuation<? super ApiResult<String>>)cont, url, acceptContentType, headers){
                final /* synthetic */ CancellableContinuation<ApiResult<String>> $cont;
                final /* synthetic */ String $url;
                final /* synthetic */ String $acceptContentType;
                final /* synthetic */ List<Pair<String, String>> $headers;
                {
                    this.$cont = $cont;
                    this.$url = $url;
                    this.$acceptContentType = $acceptContentType;
                    this.$headers = $headers;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void process(@NotNull HttpRequests.Request request) {
                    String string;
                    HttpURLConnection httpURLConnection;
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Object $this$castSafelyTo$iv = request.getConnection();
                    boolean $i$f$castSafelyTo = false;
                    Object object = $this$castSafelyTo$iv;
                    if (!(object instanceof HttpURLConnection)) {
                        object = null;
                    }
                    int statusCode = (httpURLConnection = (HttpURLConnection)object) == null ? -1 : ($this$castSafelyTo$iv = httpURLConnection.getResponseCode());
                    $this$castSafelyTo$iv = request.getConnection().getInputStream();
                    Object object2 = this.$cont;
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)$this$castSafelyTo$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        byte[] byArray = HttpWrapperKt.access$readBytes(it, (Function0)new Function0<Boolean>(object2){
                            final /* synthetic */ CancellableContinuation<ApiResult<String>> $cont;
                            {
                                this.$cont = $cont;
                                super(0);
                            }

                            public final boolean invoke() {
                                return this.$cont.isCancelled();
                            }
                        });
                        Charset charset = Charsets.UTF_8;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        string = new String(byArray, charset);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)$this$castSafelyTo$iv, (Throwable)throwable);
                    }
                    String responseText2 = string;
                    if (this.$cont.isCancelled()) {
                        return;
                    }
                    if (statusCode != 200) {
                        Logger.getInstance((String)"HttpWrapper").debug(StringsKt.trimMargin$default((String)("\n                    |\n                    |<-- HTTP GET " + this.$url + "\n                    |    Accept: " + this.$acceptContentType + "\n                    |" + CollectionsKt.joinToString$default((Iterable)this.$headers, (CharSequence)"\n", null, null, (int)0, null, (Function1)requestString.2.1.INSTANCE, (int)30, null) + "\n                    |\n                    |--> RESPONSE HTTP " + statusCode + "\n                    |" + responseText2 + "\n                    |\n                "), null, (int)1, null));
                    }
                    object2 = responseText2;
                    bl = false;
                    ApiResult r = object2.length() == 0 ? (ApiResult)new ApiResult.Failure<T>(new EmptyBodyException()) : (ApiResult)new ApiResult.Success<String>(responseText2);
                    object2 = (Continuation)this.$cont;
                    bl = false;
                    throwable = Result.Companion;
                    boolean bl6 = false;
                    object2.resumeWith(Result.constructor-impl((Object)r));
                }
            });
        }
        catch (Throwable t) {
            HttpWrapperKt.log(t);
            Continuation continuation = (Continuation)cont;
            ApiResult.Failure failure = new ApiResult.Failure(HttpWrapperKt.log(t));
            boolean bl3 = false;
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            continuation.resumeWith(Result.constructor-impl(failure));
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public static /* synthetic */ Object requestString$default(String string, String string2, int n, List list, Continuation continuation, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 10;
        }
        return HttpWrapperKt.requestString(string, string2, n, list, (Continuation<? super ApiResult<String>>)continuation);
    }

    private static final JsonObject asJSONObject(String $this$asJSONObject) {
        JsonObject jsonObject = JsonParser.parseString((String)$this$asJSONObject).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"parseString(this).asJsonObject");
        return jsonObject;
    }

    private static final Throwable log(Throwable $this$log) {
        Throwable throwable = $this$log;
        boolean bl = false;
        boolean bl2 = false;
        Throwable $this$log_u24lambda_u2d1 = throwable;
        boolean bl3 = false;
        try {
            Logger.getInstance($this$log_u24lambda_u2d1.getClass()).warn("Error occurred while performing a request", $this$log_u24lambda_u2d1);
        }
        catch (Throwable throwable2) {
        }
        return throwable;
    }

    private static final long copyTo(InputStream $this$copyTo, OutputStream out, int bufferSize, Function0<Boolean> cancellationRequested) {
        long bytesCopied = 0L;
        byte[] buffer = new byte[bufferSize];
        int bytes = $this$copyTo.read(buffer);
        while (bytes >= 0 && !((Boolean)cancellationRequested.invoke()).booleanValue()) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = $this$copyTo.read(buffer);
        }
        return bytesCopied;
    }

    static /* synthetic */ long copyTo$default(InputStream inputStream, OutputStream outputStream, int n, Function0 function0, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return HttpWrapperKt.copyTo(inputStream, outputStream, n, (Function0<Boolean>)function0);
    }

    private static final byte[] readBytes(InputStream $this$readBytes, Function0<Boolean> cancellationRequested) {
        int n = 8192;
        int n2 = $this$readBytes.available();
        boolean bl = false;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(Math.max(n, n2));
        HttpWrapperKt.copyTo$default($this$readBytes, buffer, 0, cancellationRequested, 2, null);
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.toByteArray()");
        return byArray;
    }

    public static final /* synthetic */ byte[] access$readBytes(InputStream $receiver, Function0 cancellationRequested) {
        return HttpWrapperKt.readBytes($receiver, (Function0<Boolean>)cancellationRequested);
    }
}

