/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter.lineIndent;

import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinIndentationAdjuster;
import org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinLangLineIndentProvider;
import org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinLangLineIndentProviderKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J,\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinLangLineIndentProvider;", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider;", "()V", "getIndent", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "getLineIndent", "", "indentionSettings", "Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinIndentationAdjuster;", "isSuitableForLanguage", "", "mapType", "Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition$SyntaxElement;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "Companion", "KotlinElement", "kotlin.line-indent-provider"})
public abstract class KotlinLangLineIndentProvider
extends JavaLikeLangLineIndentProvider {
    private static final Map<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP;
    private static final HashSet<SemanticEditorPosition.SyntaxElement> CONTROL_FLOW_KEYWORDS;
    private static final SemanticEditorPosition.SyntaxElement[] WHITE_SPACE_OR_COMMENT_BIT_SET;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public abstract KotlinIndentationAdjuster indentionSettings(@NotNull Editor var1);

    @Nullable
    protected SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return SYNTAX_MAP.get(tokenType);
    }

    public boolean isSuitableForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language.isKindOf((Language)KotlinLanguage.INSTANCE);
    }

    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return offset > 0 && this.getPosition(editor, offset - 1).isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.RegularStringPart) ? LineIndentProvider.DO_NOT_ADJUST : super.getLineIndent(project, editor, language, offset);
    }

    @Nullable
    protected IndentCalculator getIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        IndentCalculator indentCalculator;
        SemanticEditorPosition semanticEditorPosition;
        SemanticEditorPosition after;
        SemanticEditorPosition before;
        SemanticEditorPosition currentPosition;
        KotlinIndentationAdjuster settings;
        JavaLikeLangLineIndentProvider.IndentCalculatorFactory factory;
        block21: {
            block20: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                factory = new JavaLikeLangLineIndentProvider.IndentCalculatorFactory(project, editor);
                settings = this.indentionSettings(editor);
                currentPosition = this.getPosition(editor, offset);
                if (!currentPosition.matchesRule((SemanticEditorPosition.Rule)getIndent.1.INSTANCE)) {
                    return null;
                }
                before = currentPosition.beforeOptionalMix(Arrays.copyOf(WHITE_SPACE_OR_COMMENT_BIT_SET, WHITE_SPACE_OR_COMMENT_BIT_SET.length));
                after = currentPosition.afterOptionalMix(Arrays.copyOf(WHITE_SPACE_OR_COMMENT_BIT_SET, WHITE_SPACE_OR_COMMENT_BIT_SET.length));
                if (after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace) && !currentPosition.hasLineBreaksAfter(offset)) {
                    SemanticEditorPosition semanticEditorPosition2 = before;
                    Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition2, (String)"before");
                    SemanticEditorPosition semanticEditorPosition3 = after;
                    Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition3, (String)"after");
                    SemanticEditorPosition.SyntaxElement syntaxElement = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace;
                    SemanticEditorPosition.SyntaxElement syntaxElement2 = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace;
                    Indent indent = Indent.getNoneIndent();
                    Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"Indent.getNoneIndent()");
                    return KotlinLangLineIndentProvider.Companion.createIndentCalculatorForBrace(factory, semanticEditorPosition2, semanticEditorPosition3, syntaxElement, syntaxElement2, indent);
                }
                if (before.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) && after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace)) {
                    SemanticEditorPosition semanticEditorPosition4 = before;
                    Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition4, (String)"before");
                    SemanticEditorPosition semanticEditorPosition5 = after;
                    Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition5, (String)"after");
                    SemanticEditorPosition.SyntaxElement syntaxElement = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace;
                    SemanticEditorPosition.SyntaxElement syntaxElement3 = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace;
                    Indent indent = Indent.getNormalIndent();
                    Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"Indent.getNormalIndent()");
                    return KotlinLangLineIndentProvider.Companion.createIndentCalculatorForBrace(factory, semanticEditorPosition4, semanticEditorPosition5, syntaxElement, syntaxElement3, indent);
                }
                if (after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket) && !currentPosition.hasLineBreaksAfter(offset)) {
                    SemanticEditorPosition semanticEditorPosition6 = before;
                    Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition6, (String)"before");
                    SemanticEditorPosition semanticEditorPosition7 = after;
                    Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition7, (String)"after");
                    SemanticEditorPosition.SyntaxElement syntaxElement = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket;
                    SemanticEditorPosition.SyntaxElement syntaxElement4 = (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket;
                    Indent indent = Indent.getNoneIndent();
                    Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"Indent.getNoneIndent()");
                    return KotlinLangLineIndentProvider.Companion.createIndentCalculatorForBrace(factory, semanticEditorPosition6, semanticEditorPosition7, syntaxElement, syntaxElement4, indent);
                }
                if (before.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket) && after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket)) {
                    Indent indent;
                    SemanticEditorPosition semanticEditorPosition8 = before;
                    Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition8, (String)"before");
                    Indent indent2 = indent = KotlinLangLineIndentProvider.Companion.isSimilarToFunctionInvocation(semanticEditorPosition8) ? Indent.getContinuationIndent() : Indent.getNormalIndent();
                    Intrinsics.checkNotNullExpressionValue((Object)indent2, (String)"indent");
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent2, before.getStartOffset());
                }
                if (before.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon) && before.before().isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Quest)) {
                    Indent indent = Indent.getNoneIndent();
                    Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"Indent.getNoneIndent()");
                    SemanticEditorPosition semanticEditorPosition9 = before;
                    Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition9, (String)"before");
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent, semanticEditorPosition9.getStartOffset());
                }
                if (before.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.TemplateEntryOpen)) {
                    Indent indent;
                    Indent indent3 = indent = !currentPosition.hasLineBreaksAfter(offset) && after.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.TemplateEntryClose) ? Indent.getNoneIndent() : Indent.getNormalIndent();
                    Intrinsics.checkNotNullExpressionValue((Object)indent3, (String)"indent");
                    SemanticEditorPosition semanticEditorPosition10 = before;
                    Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition10, (String)"before");
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent3, semanticEditorPosition10.getStartOffset());
                }
                if (before.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{(SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword})) break block20;
                SemanticEditorPosition semanticEditorPosition11 = before;
                Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition11, (String)"before");
                if (!KotlinLangLineIndentProvider.Companion.isFinallyKeyword(semanticEditorPosition11)) break block21;
            }
            return factory.createIndentCalculator(Indent.getNoneIndent(), IndentCalculator.LINE_BEFORE);
        }
        if (after.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.TemplateEntryClose)) {
            Indent indent = currentPosition.hasEmptyLineAfter(offset) ? Indent.getNormalIndent() : Indent.getNoneIndent();
            after.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)KotlinElement.TemplateEntryOpen, (SemanticEditorPosition.SyntaxElement)KotlinElement.TemplateEntryClose);
            Indent indent4 = indent;
            Intrinsics.checkNotNullExpressionValue((Object)indent4, (String)"indent");
            SemanticEditorPosition semanticEditorPosition12 = after;
            Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition12, (String)"after");
            return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent4, semanticEditorPosition12.getStartOffset());
        }
        if (before.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Eq)) {
            SemanticEditorPosition semanticEditorPosition13 = KotlinLangLineIndentProvider.Companion.beforeIgnoringWhiteSpaceOrComment(before);
            Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition13, (String)"before.beforeIgnoringWhiteSpaceOrComment()");
            SemanticEditorPosition declaration = KotlinLangLineIndentProvider.Companion.findFunctionOrPropertyOrMultiDeclarationBefore(semanticEditorPosition13);
            if (declaration != null) {
                Indent indent;
                Indent indent5 = indent = settings.getContinuationIndentForExpressionBodies() ? Indent.getContinuationIndent() : Indent.getNormalIndent();
                Intrinsics.checkNotNullExpressionValue((Object)indent5, (String)"indent");
                return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent5, declaration.getStartOffset());
            }
        } else if (before.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis) && after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
            SemanticEditorPosition semanticEditorPosition14 = currentPosition;
            Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition14, (String)"currentPosition");
            SemanticEditorPosition semanticEditorPosition15 = after;
            Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition15, (String)"after");
            IndentCalculator indentCalculator2 = KotlinLangLineIndentProvider.Companion.createIndentCalculatorForParenthesis(factory, before, semanticEditorPosition14, semanticEditorPosition15, offset, settings);
            if (indentCalculator2 != null) {
                IndentCalculator indentCalculator3 = indentCalculator2;
                boolean bl = false;
                boolean bl2 = false;
                IndentCalculator it = indentCalculator3;
                boolean bl3 = false;
                return it;
            }
        }
        SemanticEditorPosition semanticEditorPosition16 = KotlinLangLineIndentProvider.Companion.findFunctionOrPropertyOrMultiDeclarationBefore(before);
        if (semanticEditorPosition16 != null) {
            semanticEditorPosition = semanticEditorPosition16;
            boolean bl = false;
            boolean bl4 = false;
            SemanticEditorPosition it = semanticEditorPosition;
            boolean bl5 = false;
            Indent indent = Indent.getNoneIndent();
            Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"Indent.getNoneIndent()");
            return KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent, it.getStartOffset());
        }
        SemanticEditorPosition semanticEditorPosition17 = KotlinLangLineIndentProvider.Companion.controlFlowStatementBefore(before);
        if (semanticEditorPosition17 != null) {
            Indent indent;
            semanticEditorPosition = semanticEditorPosition17;
            boolean bl = false;
            boolean bl6 = false;
            SemanticEditorPosition controlFlowKeywordPosition = semanticEditorPosition;
            boolean bl7 = false;
            Indent indent6 = indent = KotlinLangLineIndentProvider.Companion.similarToCatchKeyword(controlFlowKeywordPosition) ? (before.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis) ? Indent.getNoneIndent() : Indent.getNormalIndent()) : (after.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis) ? (before.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace) ? Indent.getNormalIndent() : Indent.getContinuationIndent()) : (after.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{(SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, KotlinElement.Arrow}) || KotlinLangLineIndentProvider.Companion.isWhileInsideDoWhile(controlFlowKeywordPosition) ? Indent.getNoneIndent() : Indent.getNormalIndent()));
            Intrinsics.checkNotNullExpressionValue((Object)indent6, (String)"indent");
            indentCalculator = KotlinLangLineIndentProviderKt.access$createIndentCalculator(factory, indent6, controlFlowKeywordPosition.getStartOffset());
        } else {
            indentCalculator = null;
        }
        return indentCalculator;
    }

    static {
        Companion = new Companion(null);
        SYNTAX_MAP = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)KtTokens.WHITE_SPACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace), TuplesKt.to((Object)KtTokens.EOL_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment), TuplesKt.to((Object)KtTokens.BLOCK_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment), TuplesKt.to((Object)KtTokens.DOC_COMMENT, (Object)((Object)KotlinElement.KDoc)), TuplesKt.to((Object)KtTokens.ARROW, (Object)((Object)KotlinElement.Arrow)), TuplesKt.to((Object)KtTokens.LONG_TEMPLATE_ENTRY_START, (Object)((Object)KotlinElement.TemplateEntryOpen)), TuplesKt.to((Object)KtTokens.LONG_TEMPLATE_ENTRY_END, (Object)((Object)KotlinElement.TemplateEntryClose)), TuplesKt.to((Object)KtTokens.LBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace), TuplesKt.to((Object)KtTokens.RBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace), TuplesKt.to((Object)KtTokens.LPAR, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis), TuplesKt.to((Object)KtTokens.RPAR, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis), TuplesKt.to((Object)KtTokens.LBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket), TuplesKt.to((Object)KtTokens.RBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket), TuplesKt.to((Object)KtTokens.LT, (Object)((Object)KotlinElement.OpenTypeBrace)), TuplesKt.to((Object)KtTokens.GT, (Object)((Object)KotlinElement.CloseTypeBrace)), TuplesKt.to((Object)KtTokens.IF_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword), TuplesKt.to((Object)KtTokens.ELSE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword), TuplesKt.to((Object)KtTokens.WHEN_KEYWORD, (Object)((Object)KotlinElement.WhenKeyword)), TuplesKt.to((Object)KtTokens.TRY_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword), TuplesKt.to((Object)KtTokens.WHILE_KEYWORD, (Object)((Object)KotlinElement.WhileKeyword)), TuplesKt.to((Object)KtTokens.DO_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword), TuplesKt.to((Object)KtTokens.FOR_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword), TuplesKt.to((Object)KtTokens.REGULAR_STRING_PART, (Object)((Object)KotlinElement.RegularStringPart)), TuplesKt.to((Object)KtTokens.IDENTIFIER, (Object)((Object)KotlinElement.Identifier)), TuplesKt.to((Object)KtTokens.FUN_KEYWORD, (Object)((Object)KotlinElement.FunctionKeyword)), TuplesKt.to((Object)KtTokens.DOT, (Object)((Object)KotlinElement.Dot)), TuplesKt.to((Object)KtTokens.QUEST, (Object)((Object)KotlinElement.Quest)), TuplesKt.to((Object)KtTokens.COMMA, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma), TuplesKt.to((Object)KtTokens.COLON, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon), TuplesKt.to((Object)KtTokens.EQ, (Object)((Object)KotlinElement.Eq)), TuplesKt.to((Object)KtTokens.VAL_KEYWORD, (Object)((Object)KotlinElement.Val)), TuplesKt.to((Object)KtTokens.VAR_KEYWORD, (Object)((Object)KotlinElement.Var))});
        CONTROL_FLOW_KEYWORDS = SetsKt.hashSetOf((Object[])new SemanticEditorPosition.SyntaxElement[]{KotlinElement.WhenKeyword, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword, KotlinElement.WhileKeyword, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword});
        WHITE_SPACE_OR_COMMENT_BIT_SET = new SemanticEditorPosition.SyntaxElement[]{(SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment};
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinLangLineIndentProvider$KotlinElement;", "", "Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition$SyntaxElement;", "(Ljava/lang/String;I)V", "TemplateEntryOpen", "TemplateEntryClose", "Arrow", "WhenKeyword", "WhileKeyword", "RegularStringPart", "KDoc", "Identifier", "OpenTypeBrace", "CloseTypeBrace", "FunctionKeyword", "Dot", "Quest", "Eq", "Val", "Var", "kotlin.line-indent-provider"})
    private static final class KotlinElement
    extends Enum<KotlinElement>
    implements SemanticEditorPosition.SyntaxElement {
        public static final /* enum */ KotlinElement TemplateEntryOpen;
        public static final /* enum */ KotlinElement TemplateEntryClose;
        public static final /* enum */ KotlinElement Arrow;
        public static final /* enum */ KotlinElement WhenKeyword;
        public static final /* enum */ KotlinElement WhileKeyword;
        public static final /* enum */ KotlinElement RegularStringPart;
        public static final /* enum */ KotlinElement KDoc;
        public static final /* enum */ KotlinElement Identifier;
        public static final /* enum */ KotlinElement OpenTypeBrace;
        public static final /* enum */ KotlinElement CloseTypeBrace;
        public static final /* enum */ KotlinElement FunctionKeyword;
        public static final /* enum */ KotlinElement Dot;
        public static final /* enum */ KotlinElement Quest;
        public static final /* enum */ KotlinElement Eq;
        public static final /* enum */ KotlinElement Val;
        public static final /* enum */ KotlinElement Var;
        private static final /* synthetic */ KotlinElement[] $VALUES;

        static {
            KotlinElement[] kotlinElementArray = new KotlinElement[16];
            KotlinElement[] kotlinElementArray2 = kotlinElementArray;
            kotlinElementArray[0] = TemplateEntryOpen = new KotlinElement();
            kotlinElementArray[1] = TemplateEntryClose = new KotlinElement();
            kotlinElementArray[2] = Arrow = new KotlinElement();
            kotlinElementArray[3] = WhenKeyword = new KotlinElement();
            kotlinElementArray[4] = WhileKeyword = new KotlinElement();
            kotlinElementArray[5] = RegularStringPart = new KotlinElement();
            kotlinElementArray[6] = KDoc = new KotlinElement();
            kotlinElementArray[7] = Identifier = new KotlinElement();
            kotlinElementArray[8] = OpenTypeBrace = new KotlinElement();
            kotlinElementArray[9] = CloseTypeBrace = new KotlinElement();
            kotlinElementArray[10] = FunctionKeyword = new KotlinElement();
            kotlinElementArray[11] = Dot = new KotlinElement();
            kotlinElementArray[12] = Quest = new KotlinElement();
            kotlinElementArray[13] = Eq = new KotlinElement();
            kotlinElementArray[14] = Val = new KotlinElement();
            kotlinElementArray[15] = Var = new KotlinElement();
            $VALUES = kotlinElementArray;
        }

        public static KotlinElement[] values() {
            return (KotlinElement[])$VALUES.clone();
        }

        public static KotlinElement valueOf(String string) {
            return Enum.valueOf(KotlinElement.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0014\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\u00100\u0010*\u00020\u0010H\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002J4\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u000eH\u0002J6\u0010)\u001a\u0004\u0018\u00010\"*\u00020#2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\f\u0010/\u001a\u00020\u001b*\u00020\u0010H\u0002J\f\u00100\u001a\u00020\u001b*\u00020\u0010H\u0002J\f\u00101\u001a\u00020\u001b*\u00020\u0010H\u0002J\f\u00102\u001a\u00020\u001b*\u00020\u0010H\u0002J\f\u00103\u001a\u00020\u001b*\u00020\u0010H\u0002J\f\u00104\u001a\u00020\u001b*\u00020\u0010H\u0002J\f\u00105\u001a\u00020\u001b*\u00020\u0010H\u0002J\f\u00106\u001a\u000207*\u00020\u0010H\u0002J\f\u00108\u001a\u00020\u001b*\u00020\u0010H\u0002J\f\u00109\u001a\u00020\u001b*\u00020\u0010H\u0002J\f\u0010:\u001a\u00020\u001b*\u00020\u0010H\u0002J\u001c\u0010:\u001a\u00020\u001b*\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\f\u0010;\u001a\u00020\u001b*\u00020\u0010H\u0002J\u0014\u0010<\u001a\u00020\u001b*\u00020\u00102\u0006\u0010=\u001a\u00020\u001bH\u0002J\f\u0010>\u001a\u00020\u001b*\u00020\u0010H\u0002J\f\u0010?\u001a\u000207*\u00020\u0010H\u0002J\f\u0010@\u001a\u00020\u001b*\u00020\u0010H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinLangLineIndentProvider$Companion;", "", "()V", "CONTROL_FLOW_KEYWORDS", "Ljava/util/HashSet;", "Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition$SyntaxElement;", "Lkotlin/collections/HashSet;", "SYNTAX_MAP", "", "Lcom/intellij/psi/tree/IElementType;", "WHITE_SPACE_OR_COMMENT_BIT_SET", "", "[Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition$SyntaxElement;", "createAlignMultilineIndent", "Lcom/intellij/formatting/Indent;", "position", "Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition;", "findFunctionDeclarationBeforeBody", "endOfDeclaration", "findFunctionKeywordBeforeIdentifier", "identifierPosition", "findFunctionOrPropertyOrMultiDeclarationBefore", "findMultiDeclarationBeforeAssignment", "rightParenthesis", "findPropertyDeclarationBeforeAssignment", "findPropertyKeywordBeforeIdentifier", "isDestructuringDeclaration", "", "leftParenthesis", "isSimilarToFunctionInvocation", "beforeIgnoringWhiteSpaceOrComment", "kotlin.jvm.PlatformType", "controlFlowStatementBefore", "createIndentCalculatorForBrace", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/IndentCalculator;", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider$IndentCalculatorFactory;", "before", "after", "leftBraceType", "rightBraceType", "defaultIndent", "createIndentCalculatorForParenthesis", "currentPosition", "offset", "", "settings", "Lorg/jetbrains/kotlin/idea/formatter/lineIndent/KotlinIndentationAdjuster;", "isCatchKeyword", "isControlFlowKeyword", "isFinallyKeyword", "isIdentifier", "isVarOrVal", "isWhileInsideDoWhile", "moveBeforeBlockIfPossible", "moveBeforeIgnoringWhiteSpaceOrComment", "", "moveBeforeParameterIfPossible", "moveBeforeParametersIfPossible", "moveBeforeParenthesesIfPossible", "moveBeforeTypeParametersIfPossible", "moveBeforeTypeQualifierIfPossible", "canStartWithTypeParameter", "moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment", "moveBeforeWhileThisIsWhiteSpaceOrComment", "similarToCatchKeyword", "kotlin.line-indent-provider"})
    public static final class Companion {
        private final IndentCalculator createIndentCalculatorForBrace(JavaLikeLangLineIndentProvider.IndentCalculatorFactory $this$createIndentCalculatorForBrace, SemanticEditorPosition before, SemanticEditorPosition after, SemanticEditorPosition.SyntaxElement leftBraceType, SemanticEditorPosition.SyntaxElement rightBraceType, Indent defaultIndent) {
            SemanticEditorPosition resultPosition;
            Object object;
            block8: {
                SemanticEditorPosition leftBrace2;
                block7: {
                    SemanticEditorPosition leftAnchor;
                    SemanticEditorPosition semanticEditorPosition;
                    SemanticEditorPosition semanticEditorPosition2 = leftBrace2 = before.copyAnd(new Consumer(leftBraceType, rightBraceType){
                        final /* synthetic */ SemanticEditorPosition.SyntaxElement $leftBraceType;
                        final /* synthetic */ SemanticEditorPosition.SyntaxElement $rightBraceType;

                        public final void accept(SemanticEditorPosition it) {
                            it.moveToLeftParenthesisBackwardsSkippingNested(this.$leftBraceType, this.$rightBraceType);
                        }
                        {
                            this.$leftBraceType = syntaxElement;
                            this.$rightBraceType = syntaxElement2;
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition2, (String)"leftBrace");
                    if (semanticEditorPosition2.isAtEnd()) {
                        return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForBrace, defaultIndent, 0);
                    }
                    SemanticEditorPosition.SyntaxElement[] syntaxElementArray = WHITE_SPACE_OR_COMMENT_BIT_SET;
                    if (after.after().afterOptionalMix(Arrays.copyOf(syntaxElementArray, syntaxElementArray.length)).isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma)) {
                        return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForBrace, this.createAlignMultilineIndent(leftBrace2), leftBrace2.getStartOffset());
                    }
                    SemanticEditorPosition beforeLeftBrace2 = leftBrace2.copyAnd((Consumer)createIndentCalculatorForBrace.beforeLeftBrace.1.INSTANCE);
                    if (beforeLeftBrace2.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                        beforeLeftBrace2.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
                        semanticEditorPosition = beforeLeftBrace2;
                    } else {
                        SemanticEditorPosition semanticEditorPosition3 = beforeLeftBrace2;
                        Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition3, (String)"beforeLeftBrace");
                        semanticEditorPosition = this.findFunctionDeclarationBeforeBody(semanticEditorPosition3);
                    }
                    if ((object = (leftAnchor = semanticEditorPosition)) == null) break block7;
                    SemanticEditorPosition semanticEditorPosition4 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    SemanticEditorPosition it = semanticEditorPosition4;
                    boolean bl3 = false;
                    object = !it.isAtEnd() ? semanticEditorPosition4 : null;
                    if (object != null) break block8;
                }
                object = leftBrace2;
            }
            SemanticEditorPosition semanticEditorPosition = resultPosition = object;
            Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition, (String)"resultPosition");
            return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForBrace, defaultIndent, semanticEditorPosition.getStartOffset());
        }

        private final IndentCalculator createIndentCalculatorForParenthesis(JavaLikeLangLineIndentProvider.IndentCalculatorFactory $this$createIndentCalculatorForParenthesis, SemanticEditorPosition leftParenthesis, SemanticEditorPosition currentPosition, SemanticEditorPosition rightParenthesis, int offset, KotlinIndentationAdjuster settings) {
            boolean bl = leftParenthesis.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl = rightParenthesis.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
            bl2 = false;
            bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (!currentPosition.hasLineBreaksAfter(offset)) {
                Indent indentForBinaryExpression;
                Object var8_10 = null;
                Lazy indentForParentheses2 = LazyKt.lazy((Function0)((Function0)new Function0<Indent>(settings, leftParenthesis){
                    final /* synthetic */ KotlinIndentationAdjuster $settings;
                    final /* synthetic */ SemanticEditorPosition $leftParenthesis;

                    public final Indent invoke() {
                        return this.$settings.getAlignWhenMultilineFunctionParentheses() ? org.jetbrains.kotlin.idea.formatter.lineIndent.KotlinLangLineIndentProvider$Companion.access$createAlignMultilineIndent(KotlinLangLineIndentProvider.Companion, this.$leftParenthesis) : Indent.getNoneIndent();
                    }
                    {
                        this.$settings = kotlinIndentationAdjuster;
                        this.$leftParenthesis = semanticEditorPosition;
                        super(0);
                    }
                }));
                SemanticEditorPosition semanticEditorPosition = this.beforeIgnoringWhiteSpaceOrComment(leftParenthesis);
                Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition, (String)"leftParenthesis.beforeIg\u2026ringWhiteSpaceOrComment()");
                SemanticEditorPosition semanticEditorPosition2 = this.findFunctionKeywordBeforeIdentifier(semanticEditorPosition);
                if (semanticEditorPosition2 != null) {
                    SemanticEditorPosition semanticEditorPosition3 = semanticEditorPosition2;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    SemanticEditorPosition it = semanticEditorPosition3;
                    boolean bl8 = false;
                    Lazy lazy = indentForParentheses2;
                    Object var15_30 = null;
                    Object var16_31 = var8_10;
                    boolean bl9 = false;
                    Indent indent = (Indent)lazy.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"indentForParentheses");
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForParenthesis, indent, it.getStartOffset());
                }
                if (this.isSimilarToFunctionInvocation(leftParenthesis)) {
                    Lazy lazy = indentForParentheses2;
                    Object var10_20 = null;
                    boolean bl10 = false;
                    Indent indent = (Indent)lazy.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"indentForParentheses");
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForParenthesis, indent, leftParenthesis.getStartOffset());
                }
                if (this.isDestructuringDeclaration(leftParenthesis, rightParenthesis)) {
                    Indent indent = Indent.getNoneIndent();
                    Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"Indent.getNoneIndent()");
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForParenthesis, indent, leftParenthesis.getStartOffset());
                }
                SemanticEditorPosition semanticEditorPosition4 = this.beforeIgnoringWhiteSpaceOrComment(leftParenthesis);
                boolean bl11 = false;
                boolean bl12 = false;
                SemanticEditorPosition keyword = semanticEditorPosition4;
                boolean bl13 = false;
                SemanticEditorPosition semanticEditorPosition5 = keyword;
                Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition5, (String)"keyword");
                if (Companion.isControlFlowKeyword(semanticEditorPosition5)) {
                    Indent indent = Indent.getNoneIndent();
                    Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"Indent.getNoneIndent()");
                    return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForParenthesis, indent, keyword.getStartOffset());
                }
                Indent indent = indentForBinaryExpression = settings.getAlignWhenMultilineBinaryExpression() ? this.createAlignMultilineIndent(leftParenthesis) : Indent.getContinuationIndent();
                Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"indentForBinaryExpression");
                return KotlinLangLineIndentProviderKt.access$createIndentCalculator($this$createIndentCalculatorForParenthesis, indent, leftParenthesis.getStartOffset());
            }
            return null;
        }

        private final SemanticEditorPosition findFunctionOrPropertyOrMultiDeclarationBefore(SemanticEditorPosition endOfDeclaration) {
            SemanticEditorPosition semanticEditorPosition;
            SemanticEditorPosition semanticEditorPosition2 = this.findFunctionDeclarationBeforeBody(endOfDeclaration);
            if (semanticEditorPosition2 == null) {
                semanticEditorPosition2 = semanticEditorPosition = this.findPropertyDeclarationBeforeAssignment(endOfDeclaration);
            }
            if (semanticEditorPosition2 == null) {
                semanticEditorPosition = this.findMultiDeclarationBeforeAssignment(endOfDeclaration);
            }
            return semanticEditorPosition;
        }

        private final SemanticEditorPosition findMultiDeclarationBeforeAssignment(SemanticEditorPosition rightParenthesis) {
            if (!rightParenthesis.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                return null;
            }
            SemanticEditorPosition semanticEditorPosition = rightParenthesis.copy();
            boolean bl = false;
            boolean bl2 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl3 = false;
            if (!Companion.moveBeforeParenthesesIfPossible($this$with)) {
                return null;
            }
            SemanticEditorPosition semanticEditorPosition2 = $this$with;
            boolean bl4 = false;
            boolean bl5 = false;
            SemanticEditorPosition it = semanticEditorPosition2;
            boolean bl6 = false;
            return Companion.isVarOrVal($this$with) ? semanticEditorPosition2 : null;
        }

        private final SemanticEditorPosition findPropertyDeclarationBeforeAssignment(SemanticEditorPosition endOfDeclaration) {
            if (endOfDeclaration.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                SemanticEditorPosition semanticEditorPosition = this.findPropertyKeywordBeforeIdentifier(endOfDeclaration);
                if (semanticEditorPosition != null) {
                    SemanticEditorPosition semanticEditorPosition2 = semanticEditorPosition;
                    boolean bl = false;
                    boolean bl2 = false;
                    SemanticEditorPosition it = semanticEditorPosition2;
                    boolean bl3 = false;
                    return it;
                }
            }
            SemanticEditorPosition semanticEditorPosition = endOfDeclaration.copy();
            boolean bl = false;
            boolean bl4 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl5 = false;
            if (Companion.moveBeforeTypeQualifierIfPossible($this$with, true)) {
                if (!$this$with.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
                    return null;
                }
                Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$with);
            }
            SemanticEditorPosition semanticEditorPosition3 = $this$with;
            Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition3, (String)"this");
            return Companion.findPropertyKeywordBeforeIdentifier(semanticEditorPosition3);
        }

        private final SemanticEditorPosition findFunctionDeclarationBeforeBody(SemanticEditorPosition endOfDeclaration) {
            SemanticEditorPosition semanticEditorPosition = endOfDeclaration.copy();
            boolean bl = false;
            boolean bl2 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl3 = false;
            if (Companion.moveBeforeTypeQualifierIfPossible($this$with, true)) {
                if (!$this$with.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
                    return null;
                }
                Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$with);
            }
            if (!Companion.moveBeforeParenthesesIfPossible($this$with)) {
                return null;
            }
            SemanticEditorPosition semanticEditorPosition2 = $this$with;
            Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition2, (String)"this");
            return Companion.findFunctionKeywordBeforeIdentifier(semanticEditorPosition2);
        }

        private final SemanticEditorPosition findPropertyKeywordBeforeIdentifier(SemanticEditorPosition identifierPosition) {
            if (!identifierPosition.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                return null;
            }
            SemanticEditorPosition semanticEditorPosition = identifierPosition.copy();
            boolean bl = false;
            boolean bl2 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl3 = false;
            if (!Companion.moveBeforeTypeQualifierIfPossible($this$with, false)) {
                return null;
            }
            Companion.moveBeforeTypeParametersIfPossible($this$with);
            SemanticEditorPosition semanticEditorPosition2 = $this$with;
            boolean bl4 = false;
            boolean bl5 = false;
            SemanticEditorPosition it = semanticEditorPosition2;
            boolean bl6 = false;
            SemanticEditorPosition semanticEditorPosition3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)semanticEditorPosition3, (String)"it");
            return Companion.isVarOrVal(semanticEditorPosition3) ? semanticEditorPosition2 : null;
        }

        private final SemanticEditorPosition findFunctionKeywordBeforeIdentifier(SemanticEditorPosition identifierPosition) {
            if (identifierPosition.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.FunctionKeyword)) {
                return identifierPosition;
            }
            SemanticEditorPosition semanticEditorPosition = identifierPosition.copy();
            boolean bl = false;
            boolean bl2 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl3 = false;
            Companion.moveBeforeWhileThisIsWhiteSpaceOrComment($this$with);
            if ($this$with.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Dot)) {
                Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$with);
                if (!Companion.moveBeforeTypeQualifierIfPossible($this$with, true)) {
                    return null;
                }
                return $this$with.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.FunctionKeyword) ? $this$with : null;
            }
            if (!$this$with.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                return null;
            }
            if (!Companion.moveBeforeTypeQualifierIfPossible($this$with, false)) {
                return null;
            }
            Companion.moveBeforeTypeParametersIfPossible($this$with);
            SemanticEditorPosition semanticEditorPosition2 = $this$with;
            boolean bl4 = false;
            boolean bl5 = false;
            SemanticEditorPosition it = semanticEditorPosition2;
            boolean bl6 = false;
            return it.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.FunctionKeyword) ? semanticEditorPosition2 : null;
        }

        private final boolean isSimilarToFunctionInvocation(SemanticEditorPosition leftParenthesis) {
            SemanticEditorPosition semanticEditorPosition = leftParenthesis.copy();
            boolean bl = false;
            boolean bl2 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl3 = false;
            $this$with.moveBefore();
            if (!Companion.moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment($this$with) || $this$with.isAtEnd()) {
                return false;
            }
            if ($this$with.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.CloseTypeBrace)) {
                $this$with.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)KotlinElement.OpenTypeBrace, (SemanticEditorPosition.SyntaxElement)KotlinElement.CloseTypeBrace);
                return Companion.moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment($this$with) && Companion.isIdentifier($this$with);
            }
            return Companion.isIdentifier($this$with) || $this$with.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{(SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket});
        }

        private final boolean isDestructuringDeclaration(SemanticEditorPosition leftParenthesis, SemanticEditorPosition rightParenthesis) {
            SemanticEditorPosition semanticEditorPosition = leftParenthesis.copy();
            boolean bl = false;
            boolean bl2 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl3 = false;
            Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$with);
            if (Companion.isVarOrVal($this$with)) {
                return true;
            }
            if (!Companion.moveBeforeParametersIfPossible(rightParenthesis)) {
                return false;
            }
            return $this$with.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace);
        }

        private final boolean moveBeforeParametersIfPossible(SemanticEditorPosition $this$moveBeforeParametersIfPossible) {
            while (!$this$moveBeforeParametersIfPossible.isAtEnd()) {
                if (!this.moveBeforeParameterIfPossible($this$moveBeforeParametersIfPossible)) {
                    return false;
                }
                if (!$this$moveBeforeParametersIfPossible.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma)) {
                    return true;
                }
                this.moveBeforeIgnoringWhiteSpaceOrComment($this$moveBeforeParametersIfPossible);
            }
            return false;
        }

        private final boolean moveBeforeParameterIfPossible(SemanticEditorPosition $this$moveBeforeParameterIfPossible) {
            if ($this$moveBeforeParameterIfPossible.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                return this.moveBeforeParenthesesIfPossible($this$moveBeforeParameterIfPossible);
            }
            if (!this.moveBeforeTypeQualifierIfPossible($this$moveBeforeParameterIfPossible, true)) {
                return false;
            }
            if ($this$moveBeforeParameterIfPossible.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
                this.moveBeforeIgnoringWhiteSpaceOrComment($this$moveBeforeParameterIfPossible);
                if ($this$moveBeforeParameterIfPossible.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis)) {
                    return this.moveBeforeParenthesesIfPossible($this$moveBeforeParameterIfPossible);
                }
                if (!$this$moveBeforeParameterIfPossible.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                    return false;
                }
                this.moveBeforeIgnoringWhiteSpaceOrComment($this$moveBeforeParameterIfPossible);
            }
            return true;
        }

        private final boolean moveBeforeTypeQualifierIfPossible(SemanticEditorPosition $this$moveBeforeTypeQualifierIfPossible, boolean canStartWithTypeParameter) {
            if (!canStartWithTypeParameter && !$this$moveBeforeTypeQualifierIfPossible.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                return false;
            }
            while (!$this$moveBeforeTypeQualifierIfPossible.isAtEnd()) {
                SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                spreadBuilder.add((Object)KotlinElement.Quest);
                spreadBuilder.addSpread((Object)WHITE_SPACE_OR_COMMENT_BIT_SET);
                $this$moveBeforeTypeQualifierIfPossible.moveBeforeOptionalMix((SemanticEditorPosition.SyntaxElement[])spreadBuilder.toArray((Object[])new SemanticEditorPosition.SyntaxElement[spreadBuilder.size()]));
                this.moveBeforeTypeParametersIfPossible($this$moveBeforeTypeQualifierIfPossible);
                if (!$this$moveBeforeTypeQualifierIfPossible.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                    return false;
                }
                this.moveBeforeIgnoringWhiteSpaceOrComment($this$moveBeforeTypeQualifierIfPossible);
                if (!$this$moveBeforeTypeQualifierIfPossible.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Dot)) {
                    return true;
                }
                this.moveBeforeIgnoringWhiteSpaceOrComment($this$moveBeforeTypeQualifierIfPossible);
            }
            return false;
        }

        private final Indent createAlignMultilineIndent(SemanticEditorPosition position) {
            int beforeLineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)position.getChars(), (int)position.getStartOffset(), (String)"\n") + 1;
            int beforeLineWithoutIndentStart = CharArrayUtil.shiftForward((CharSequence)position.getChars(), (int)beforeLineStart, (String)" \t");
            Indent indent = Indent.getSpaceIndent((int)(position.getStartOffset() - beforeLineWithoutIndentStart));
            Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"Indent.getSpaceIndent(po\u2026reLineWithoutIndentStart)");
            return indent;
        }

        private final boolean isWhileInsideDoWhile(SemanticEditorPosition $this$isWhileInsideDoWhile) {
            if (!$this$isWhileInsideDoWhile.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.WhileKeyword)) {
                return false;
            }
            SemanticEditorPosition semanticEditorPosition = $this$isWhileInsideDoWhile.copy();
            boolean bl = false;
            boolean bl2 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl3 = false;
            $this$with.moveBefore();
            int whileKeywordLevel = 1;
            while (!$this$with.isAtEnd()) {
                if ($this$with.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                    return false;
                }
                if ($this$with.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword)) {
                    if (--whileKeywordLevel == 0) {
                        return true;
                    }
                    $this$with.moveBefore();
                    continue;
                }
                if ($this$with.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.WhileKeyword)) {
                    ++whileKeywordLevel;
                    $this$with.moveBefore();
                    continue;
                }
                if ($this$with.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace)) {
                    $this$with.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
                    continue;
                }
                $this$with.moveBefore();
            }
            return false;
        }

        private final SemanticEditorPosition controlFlowStatementBefore(SemanticEditorPosition $this$controlFlowStatementBefore) {
            SemanticEditorPosition semanticEditorPosition = $this$controlFlowStatementBefore.copy();
            boolean bl = false;
            boolean bl2 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl3 = false;
            if ($this$with.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$with);
            }
            if (Companion.isControlFlowKeyword($this$with)) {
                return $this$with;
            }
            if (!Companion.moveBeforeParenthesesIfPossible($this$with)) {
                return null;
            }
            SemanticEditorPosition semanticEditorPosition2 = $this$with;
            boolean bl4 = false;
            boolean bl5 = false;
            SemanticEditorPosition it = semanticEditorPosition2;
            boolean bl6 = false;
            return Companion.isControlFlowKeyword($this$with) ? semanticEditorPosition2 : null;
        }

        private final boolean isControlFlowKeyword(SemanticEditorPosition $this$isControlFlowKeyword) {
            return CollectionsKt.contains((Iterable)CONTROL_FLOW_KEYWORDS, (Object)$this$isControlFlowKeyword.getCurrElement()) || this.isCatchKeyword($this$isControlFlowKeyword) || this.isFinallyKeyword($this$isControlFlowKeyword);
        }

        private final boolean similarToCatchKeyword(SemanticEditorPosition $this$similarToCatchKeyword) {
            String string = KotlinLangLineIndentProviderKt.access$textOfCurrentPosition($this$similarToCatchKeyword);
            KtKeywordToken ktKeywordToken = KtTokens.CATCH_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.CATCH_KEYWORD");
            return Intrinsics.areEqual((Object)string, (Object)ktKeywordToken.getValue());
        }

        private final boolean isCatchKeyword(SemanticEditorPosition $this$isCatchKeyword) {
            SemanticEditorPosition semanticEditorPosition = $this$isCatchKeyword.copy();
            boolean bl = false;
            boolean bl2 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl3 = false;
            do {
                if (!$this$with.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                    return false;
                }
                if (!Companion.similarToCatchKeyword($this$with)) {
                    return false;
                }
                Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$with);
                if (!Companion.moveBeforeBlockIfPossible($this$with)) {
                    return false;
                }
                if ($this$with.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword)) {
                    return true;
                }
                if (Companion.moveBeforeParenthesesIfPossible($this$with)) continue;
                return false;
            } while (!$this$with.isAtEnd());
            return false;
        }

        private final boolean isFinallyKeyword(SemanticEditorPosition $this$isFinallyKeyword) {
            if (!$this$isFinallyKeyword.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier)) {
                return false;
            }
            String string = KotlinLangLineIndentProviderKt.access$textOfCurrentPosition($this$isFinallyKeyword);
            KtKeywordToken ktKeywordToken = KtTokens.FINALLY_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.FINALLY_KEYWORD");
            if (Intrinsics.areEqual((Object)string, (Object)ktKeywordToken.getValue()) ^ true) {
                return false;
            }
            SemanticEditorPosition semanticEditorPosition = $this$isFinallyKeyword.copy();
            boolean bl = false;
            boolean bl2 = false;
            SemanticEditorPosition $this$with = semanticEditorPosition;
            boolean bl3 = false;
            Companion.moveBeforeIgnoringWhiteSpaceOrComment($this$with);
            if (!Companion.moveBeforeBlockIfPossible($this$with)) {
                return false;
            }
            if ($this$with.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword)) {
                return true;
            }
            if (!Companion.moveBeforeParenthesesIfPossible($this$with)) {
                return false;
            }
            return Companion.isCatchKeyword($this$with);
        }

        private final void moveBeforeWhileThisIsWhiteSpaceOrComment(SemanticEditorPosition $this$moveBeforeWhileThisIsWhiteSpaceOrComment) {
            SemanticEditorPosition.SyntaxElement[] syntaxElementArray = WHITE_SPACE_OR_COMMENT_BIT_SET;
            $this$moveBeforeWhileThisIsWhiteSpaceOrComment.moveBeforeOptionalMix(Arrays.copyOf(syntaxElementArray, syntaxElementArray.length));
        }

        private final void moveBeforeIgnoringWhiteSpaceOrComment(SemanticEditorPosition $this$moveBeforeIgnoringWhiteSpaceOrComment) {
            $this$moveBeforeIgnoringWhiteSpaceOrComment.moveBefore();
            this.moveBeforeWhileThisIsWhiteSpaceOrComment($this$moveBeforeIgnoringWhiteSpaceOrComment);
        }

        private final SemanticEditorPosition beforeIgnoringWhiteSpaceOrComment(SemanticEditorPosition $this$beforeIgnoringWhiteSpaceOrComment) {
            return $this$beforeIgnoringWhiteSpaceOrComment.copyAnd((Consumer)beforeIgnoringWhiteSpaceOrComment.1.INSTANCE);
        }

        private final boolean moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment(SemanticEditorPosition $this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment) {
            while (!$this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment.isAtEnd()) {
                if ($this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) && $this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment.isAtMultiline()) {
                    return false;
                }
                if (!$this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment)) break;
                $this$moveBeforeWhileThisIsWhiteSpaceOnSameLineOrBlockComment.moveBefore();
            }
            return true;
        }

        private final boolean isIdentifier(SemanticEditorPosition $this$isIdentifier) {
            return $this$isIdentifier.isAt((SemanticEditorPosition.SyntaxElement)KotlinElement.Identifier) || $this$isIdentifier.isAt((IElementType)KtTokens.THIS_KEYWORD);
        }

        private final boolean isVarOrVal(SemanticEditorPosition $this$isVarOrVal) {
            return $this$isVarOrVal.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{KotlinElement.Var, KotlinElement.Val});
        }

        private final boolean moveBeforeBlockIfPossible(SemanticEditorPosition $this$moveBeforeBlockIfPossible) {
            return this.moveBeforeParenthesesIfPossible($this$moveBeforeBlockIfPossible, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
        }

        private final boolean moveBeforeTypeParametersIfPossible(SemanticEditorPosition $this$moveBeforeTypeParametersIfPossible) {
            return this.moveBeforeParenthesesIfPossible($this$moveBeforeTypeParametersIfPossible, KotlinElement.OpenTypeBrace, KotlinElement.CloseTypeBrace);
        }

        private final boolean moveBeforeParenthesesIfPossible(SemanticEditorPosition $this$moveBeforeParenthesesIfPossible) {
            return this.moveBeforeParenthesesIfPossible($this$moveBeforeParenthesesIfPossible, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
        }

        private final boolean moveBeforeParenthesesIfPossible(SemanticEditorPosition $this$moveBeforeParenthesesIfPossible, SemanticEditorPosition.SyntaxElement leftParenthesis, SemanticEditorPosition.SyntaxElement rightParenthesis) {
            if (!$this$moveBeforeParenthesesIfPossible.isAt(rightParenthesis)) {
                return false;
            }
            $this$moveBeforeParenthesesIfPossible.moveBeforeParentheses(leftParenthesis, rightParenthesis);
            this.moveBeforeWhileThisIsWhiteSpaceOrComment($this$moveBeforeParenthesesIfPossible);
            return true;
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$moveBeforeIgnoringWhiteSpaceOrComment(Companion $this, SemanticEditorPosition $this$access_u24moveBeforeIgnoringWhiteSpaceOrComment) {
            $this.moveBeforeIgnoringWhiteSpaceOrComment($this$access_u24moveBeforeIgnoringWhiteSpaceOrComment);
        }

        public static final /* synthetic */ Indent access$createAlignMultilineIndent(Companion $this, SemanticEditorPosition position) {
            return $this.createAlignMultilineIndent(position);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

