/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.impl.jps.serialization.CustomModuleRootsSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ErrorReporter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentReader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentWriter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsModuleListSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ModuleImlFileEntitiesSerializerKt;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageDiffBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.BridgeModelModifiableEntitiesKt;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaModuleSettingsEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRoot;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRootTypeId;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModifiableJavaModuleSettingsEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModifiableModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.bridgeEntities.SourceRootEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.output.EclipseJDOMUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.AbstractEclipseClasspathReader;
import org.jetbrains.idea.eclipse.config.EclipseEntitiesKt;
import org.jetbrains.idea.eclipse.config.EclipseModuleRootsSerializer;
import org.jetbrains.idea.eclipse.config.EclipseModuleRootsSerializer$saveRoots$;
import org.jetbrains.idea.eclipse.config.EclipseProjectFile;
import org.jetbrains.idea.eclipse.config.EclipseProjectPropertiesEntity;
import org.jetbrains.idea.eclipse.config.EmlFileLoader;
import org.jetbrains.idea.eclipse.config.EmlFileSaver;
import org.jetbrains.idea.eclipse.config.ModifiableEclipseProjectPropertiesEntity;
import org.jetbrains.idea.eclipse.config.ModulePathShortener;
import org.jetbrains.idea.eclipse.config.ModuleRelativePathResolver;
import org.jetbrains.idea.eclipse.config.PathConversionKt;
import org.jetbrains.idea.eclipse.conversion.EJavadocUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathWriter;
import org.jetbrains.idea.eclipse.importWizard.EclipseNatureImporter;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0001GB\u0005\u00a2\u0006\u0002\u0010\u0003J,\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JT\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002JP\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010/\u001a\u0002002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002JL\u00101\u001a\u0002022\u0006\u0010(\u001a\u00020)2\u0006\u00103\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010/\u001a\u0002002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JL\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u001b2 \u00108\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020;0:\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0<092\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010\u00192\u0006\u0010@\u001a\u00020AH\u0002J\\\u0010B\u001a\u0002022\u0006\u00107\u001a\u00020\u001b2 \u00108\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020;0:\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0<092\u0006\u0010C\u001a\u00020D2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010E\u001a\u00020F2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006H"}, d2={"Lorg/jetbrains/idea/eclipse/config/EclipseModuleRootsSerializer;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/CustomModuleRootsSerializer;", "Lcom/intellij/configurationStore/StorageManagerFileWriteRequestor;", "()V", "id", "", "getId", "()Ljava/lang/String;", "createEntitySource", "Lcom/intellij/workspaceModel/storage/EntitySource;", "imlFileUrl", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "internalEntitySource", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource;", "customDir", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "createLibraryRoots", "Ljava/util/ArrayList;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryRoot;", "Lkotlin/collections/ArrayList;", "url", "srcUrl", "nativeRoot", "entryTag", "Lorg/jdom/Element;", "moduleEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "relativePathResolver", "Lorg/jetbrains/idea/eclipse/config/ModuleRelativePathResolver;", "virtualUrlManager", "findGlobalLibraryLevel", "libraryName", "generateUniqueLibraryName", "path", "libraryNames", "", "getEmlFileUrl", "loadClasspathTags", "classpathTag", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "contentRootEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ContentRootEntity;", "storageRootUrl", "reader", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentReader;", "errorReporter", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/ErrorReporter;", "loadRoots", "", "originalModuleEntity", "internalModuleListSerializer", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsModuleListSerializer;", "saveClasspathTags", "module", "entities", "", "Ljava/lang/Class;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "", "entitySource", "Lorg/jetbrains/idea/eclipse/config/EclipseProjectFile;", "oldClasspath", "pathShortener", "Lorg/jetbrains/idea/eclipse/config/ModulePathShortener;", "saveRoots", "writer", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentWriter;", "storage", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "Companion", "intellij.eclipse"})
public final class EclipseModuleRootsSerializer
implements CustomModuleRootsSerializer,
StorageManagerFileWriteRequestor {
    private static final Logger LOG;
    @NotNull
    private static final LibraryRootTypeId JAVADOC_TYPE;
    @NotNull
    private static final LibraryRootTypeId NATIVE_TYPE;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return "eclipse";
    }

    @Nullable
    public EntitySource createEntitySource(@NotNull VirtualFileUrl imlFileUrl, @NotNull JpsFileEntitySource internalEntitySource, @Nullable String customDir, @NotNull VirtualFileUrlManager virtualFileManager) {
        VirtualFileUrl classpathUrl;
        Intrinsics.checkNotNullParameter((Object)imlFileUrl, (String)"imlFileUrl");
        Intrinsics.checkNotNullParameter((Object)internalEntitySource, (String)"internalEntitySource");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        VirtualFileUrl storageRootUrl = PathConversionKt.getStorageRoot(imlFileUrl, customDir, virtualFileManager);
        VirtualFileUrl virtualFileUrl = classpathUrl = storageRootUrl.append(".classpath");
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"classpathUrl");
        return new EclipseProjectFile(virtualFileUrl, internalEntitySource);
    }

    public void loadRoots(@NotNull WorkspaceEntityStorageBuilder builder, @NotNull ModuleEntity originalModuleEntity, @NotNull JpsFileContentReader reader, @Nullable String customDir, @NotNull VirtualFileUrl imlFileUrl, @Nullable JpsModuleListSerializer internalModuleListSerializer, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)originalModuleEntity, (String)"originalModuleEntity");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)imlFileUrl, (String)"imlFileUrl");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        ModuleEntity moduleEntity = originalModuleEntity;
        VirtualFileUrl storageRootUrl = PathConversionKt.getStorageRoot(imlFileUrl, customDir, virtualFileManager);
        EntitySource entitySource2 = moduleEntity.getEntitySource();
        if (entitySource2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.idea.eclipse.config.EclipseProjectFile");
        }
        EclipseProjectFile entitySource3 = (EclipseProjectFile)entitySource2;
        ContentRootEntity contentRootEntity = BridgeModelModifiableEntitiesKt.addContentRootEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (VirtualFileUrl)storageRootUrl, (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList(), (ModuleEntity)moduleEntity);
        String string = entitySource3.getClasspathFile().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entitySource.classpathFile.url");
        Element classpathTag = reader.loadComponent(string, "", null);
        if (classpathTag != null) {
            ModuleRelativePathResolver relativePathResolver = new ModuleRelativePathResolver(internalModuleListSerializer, reader, virtualFileManager);
            moduleEntity = this.loadClasspathTags(classpathTag, builder, contentRootEntity, storageRootUrl, reader, relativePathResolver, errorReporter, imlFileUrl, virtualFileManager);
        } else {
            BridgeModelModifiableEntitiesKt.addJavaModuleSettingsEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (boolean)false, (boolean)true, (VirtualFileUrl)storageRootUrl.append("bin"), null, null, (ModuleEntity)moduleEntity, (EntitySource)entitySource3);
        }
        String emlUrl = this.getEmlFileUrl(imlFileUrl);
        Element emlTag = reader.loadComponent(emlUrl, "", null);
        if (emlTag != null) {
            String string2 = imlFileUrl.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"imlFileUrl.url");
            reader.getExpandMacroMap(string2).substitute(emlTag, SystemInfo.isFileSystemCaseSensitive);
            new EmlFileLoader(moduleEntity, builder, reader.getExpandMacroMap(emlUrl), virtualFileManager).loadEml(emlTag, contentRootEntity);
        } else {
            JavaModuleSettingsEntity javaSettings = moduleEntity.getJavaSettings();
            if (javaSettings != null) {
                builder.modifyEntity(ModifiableJavaModuleSettingsEntity.class, (WorkspaceEntity)javaSettings, (Function1)loadRoots.1.INSTANCE);
            } else {
                BridgeModelModifiableEntitiesKt.addJavaModuleSettingsEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (boolean)true, (boolean)false, null, null, null, (ModuleEntity)moduleEntity, (EntitySource)entitySource3);
            }
        }
    }

    private final String getEmlFileUrl(VirtualFileUrl imlFileUrl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = imlFileUrl.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imlFileUrl.url");
        return stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)".iml")).append(".eml").toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ModuleEntity loadClasspathTags(Element classpathTag, WorkspaceEntityStorageBuilder builder, ContentRootEntity contentRootEntity, VirtualFileUrl storageRootUrl, JpsFileContentReader reader, ModuleRelativePathResolver relativePathResolver, ErrorReporter errorReporter, VirtualFileUrl imlFileUrl, VirtualFileUrlManager virtualUrlManager) {
        block45: {
            $fun$reportError$1 = new Function1<String, Unit>(errorReporter, storageRootUrl){
                final /* synthetic */ ErrorReporter $errorReporter;
                final /* synthetic */ VirtualFileUrl $storageRootUrl;

                public final void invoke(@NotNull String message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    VirtualFileUrl virtualFileUrl = this.$storageRootUrl.append(".classpath");
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"storageRootUrl.append(EclipseXml.CLASSPATH_FILE)");
                    this.$errorReporter.reportError(message, virtualFileUrl);
                }
                {
                    this.$errorReporter = errorReporter;
                    this.$storageRootUrl = virtualFileUrl;
                    super(1);
                }
            };
            $fun$getUrlByRelativePath$2 = new Function1<String, VirtualFileUrl>(storageRootUrl){
                final /* synthetic */ VirtualFileUrl $storageRootUrl;

                @NotNull
                public final VirtualFileUrl invoke(@NotNull String path) {
                    VirtualFileUrl virtualFileUrl;
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    CharSequence charSequence = path;
                    boolean bl = false;
                    if (charSequence.length() == 0) {
                        virtualFileUrl = this.$storageRootUrl;
                    } else {
                        VirtualFileUrl virtualFileUrl2 = this.$storageRootUrl.append(FileUtil.toSystemIndependentName((String)path));
                        virtualFileUrl = virtualFileUrl2;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl2, (String)"storageRootUrl.append(Fi\u2026temIndependentName(path))");
                    }
                    return virtualFileUrl;
                }
                {
                    this.$storageRootUrl = virtualFileUrl;
                    super(1);
                }
            };
            moduleEntity = contentRootEntity.getModule();
            $fun$editEclipseProperties$3 = new Function1<Function1<? super ModifiableEclipseProjectPropertiesEntity, ? extends Unit>, Unit>(moduleEntity, builder){
                final /* synthetic */ ModuleEntity $moduleEntity;
                final /* synthetic */ WorkspaceEntityStorageBuilder $builder;

                public final void invoke(@NotNull Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit> action) {
                    Intrinsics.checkNotNullParameter(action, (String)"action");
                    EclipseProjectPropertiesEntity eclipseProjectPropertiesEntity = EclipseEntitiesKt.getEclipseProperties(this.$moduleEntity);
                    if (eclipseProjectPropertiesEntity == null) {
                        eclipseProjectPropertiesEntity = EclipseEntitiesKt.addEclipseProjectPropertiesEntity((WorkspaceEntityStorageDiffBuilder)this.$builder, this.$moduleEntity, this.$moduleEntity.getEntitySource());
                    }
                    EclipseProjectPropertiesEntity eclipseProperties = eclipseProjectPropertiesEntity;
                    this.$builder.modifyEntity(ModifiableEclipseProjectPropertiesEntity.class, (WorkspaceEntity)eclipseProperties, (Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(action){
                        final /* synthetic */ Function1 $action;

                        public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity $this$modifyEntity) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$this$modifyEntity), (String)"$receiver");
                            this.$action.invoke((Object)((Object)$this$modifyEntity));
                        }
                        {
                            this.$action = function1;
                            super(1);
                        }
                    });
                }
                {
                    this.$moduleEntity = moduleEntity;
                    this.$builder = workspaceEntityStorageBuilder;
                    super(1);
                }
            };
            storageRootPath = JpsPathUtil.urlToPath((String)storageRootUrl.getUrl());
            libraryNames = new HashSet<E>();
            v0 = imlFileUrl.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"imlFileUrl.url");
            expandMacroMap = reader.getExpandMacroMap(v0);
            var18_17 = false;
            sourceRoots = new ArrayList<E>();
            dependencies = new ArrayList<Object>();
            dependencies.add(ModuleDependencyItem.ModuleSourceDependency.INSTANCE);
            v1 = classpathTag.getChildren("classpathentry");
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"classpathTag.getChildren\u2026seXml.CLASSPATHENTRY_TAG)");
            $this$forEachIndexed$iv = v1;
            $i$f$forEachIndexed = false;
            index$iv = 0;
            block14: for (T item$iv : $this$forEachIndexed$iv) {
                var24_26 = index$iv++;
                var25_27 = false;
                if (var24_26 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                var26_28 = (Element)item$iv;
                index = var24_26;
                $i$a$-forEachIndexed-EclipseModuleRootsSerializer$loadClasspathTags$4 = false;
                kind = entryTag.getAttributeValue("kind");
                if (kind == null) {
                    $fun$reportError$1.invoke("'kind' attribute is missing in 'classpathentry' tag");
                    continue;
                }
                path = entryTag.getAttributeValue("path");
                if (path == null) {
                    $fun$reportError$1.invoke("'path' attribute is missing in 'classpathentry' tag");
                    continue;
                }
                exported = Intrinsics.areEqual((Object)"true", (Object)entryTag.getAttributeValue("exported"));
                var32_34 = kind;
                tmp = -1;
                switch (var32_34.hashCode()) {
                    case -1005512447: {
                        if (!var32_34.equals("output")) break;
                        tmp = 1;
                        break;
                    }
                    case 98690: {
                        if (!var32_34.equals("con")) break;
                        tmp = 2;
                        break;
                    }
                    case 107141: {
                        if (!var32_34.equals("lib")) break;
                        tmp = 3;
                        break;
                    }
                    case 114148: {
                        if (!var32_34.equals("src")) break;
                        tmp = 4;
                        break;
                    }
                    case 116519: {
                        if (!var32_34.equals("var")) break;
                        tmp = 5;
                        break;
                    }
                }
                switch (tmp) {
                    case 4: {
                        if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                            dependencies.add(new ModuleDependencyItem.Exportable.ModuleDependency(new ModuleId(StringsKt.removePrefix((String)path, (CharSequence)"/")), exported, ModuleDependencyItem.DependencyScope.COMPILE, false));
                            break;
                        }
                        linkedPath = AbstractEclipseClasspathReader.expandLinkedResourcesPath((String)storageRootPath, (ExpandMacroToPathMap)expandMacroMap, (String)path);
                        srcUrl = null;
                        if (linkedPath != null) ** GOTO lbl73
                        srcUrl = $fun$getUrlByRelativePath$2.invoke(path);
                        v2 = BridgeModelModifiableEntitiesKt.addSourceRootEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (ContentRootEntity)contentRootEntity, (VirtualFileUrl)srcUrl, (String)"java-source", (EntitySource)contentRootEntity.getEntitySource());
                        ** GOTO lbl88
lbl73:
                        // 1 sources

                        srcUrl = PathConversionKt.convertToRootUrl(linkedPath, virtualUrlManager);
                        $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(path, srcUrl){
                            final /* synthetic */ String $path;
                            final /* synthetic */ VirtualFileUrl $srcUrl;

                            public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity it) {
                                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                String string = this.$srcUrl.getUrl();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"srcUrl.url");
                                EclipseEntitiesKt.setVariable(it, "linksrc:", this.$path, string);
                            }
                            {
                                this.$path = string;
                                this.$srcUrl = virtualFileUrl;
                                super(1);
                            }
                        }));
                        $this$firstOrNull$iv = moduleEntity.getContentRoots();
                        $i$f$firstOrNull = false;
                        for (E element$iv : $this$firstOrNull$iv) {
                            it = (ContentRootEntity)element$iv;
                            $i$a$-firstOrNull-EclipseModuleRootsSerializer$loadClasspathTags$4$sourceRoot$newContentRoot$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)srcUrl)) continue;
                            v3 = element$iv;
                            ** GOTO lbl84
                        }
                        v3 = null;
lbl84:
                        // 2 sources

                        if ((v4 = (ContentRootEntity)v3) == null) {
                            v4 = BridgeModelModifiableEntitiesKt.addContentRootEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (VirtualFileUrl)srcUrl, (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList(), (ModuleEntity)moduleEntity);
                        }
                        newContentRoot = v4;
                        v2 = BridgeModelModifiableEntitiesKt.addSourceRootEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (ContentRootEntity)newContentRoot, (VirtualFileUrl)srcUrl, (String)"java-source", (EntitySource)newContentRoot.getEntitySource());
lbl88:
                        // 2 sources

                        sourceRoot = v2;
                        BridgeModelModifiableEntitiesKt.addJavaSourceRootEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (SourceRootEntity)sourceRoot, (boolean)false, (String)"");
                        sourceRoots.add(sourceRoot.getUrl());
                        dependencies.removeIf(loadClasspathTags.4.1.INSTANCE);
                        dependencies.add(ModuleDependencyItem.ModuleSourceDependency.INSTANCE);
                        $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(index, srcUrl, this, $fun$reportError$1, dependencies, storageRootPath, expandMacroMap, $fun$getUrlByRelativePath$2, builder, contentRootEntity, virtualUrlManager, $fun$editEclipseProperties$3, moduleEntity, sourceRoots, relativePathResolver, libraryNames){
                            final /* synthetic */ int $index;
                            final /* synthetic */ VirtualFileUrl $srcUrl;
                            final /* synthetic */ EclipseModuleRootsSerializer this$0;
                            final /* synthetic */ loadClasspathTags.1 $reportError$1$inlined;
                            final /* synthetic */ ArrayList $dependencies$inlined;
                            final /* synthetic */ String $storageRootPath$inlined;
                            final /* synthetic */ ExpandMacroToPathMap $expandMacroMap$inlined;
                            final /* synthetic */ loadClasspathTags.2 $getUrlByRelativePath$2$inlined;
                            final /* synthetic */ WorkspaceEntityStorageBuilder $builder$inlined;
                            final /* synthetic */ ContentRootEntity $contentRootEntity$inlined;
                            final /* synthetic */ VirtualFileUrlManager $virtualUrlManager$inlined;
                            final /* synthetic */ loadClasspathTags.3 $editEclipseProperties$3$inlined;
                            final /* synthetic */ ModuleEntity $moduleEntity$inlined;
                            final /* synthetic */ List $sourceRoots$inlined;
                            final /* synthetic */ ModuleRelativePathResolver $relativePathResolver$inlined;
                            final /* synthetic */ HashSet $libraryNames$inlined;
                            {
                                this.$index = n;
                                this.$srcUrl = virtualFileUrl;
                                this.this$0 = eclipseModuleRootsSerializer;
                                this.$reportError$1$inlined = var4_4;
                                this.$dependencies$inlined = arrayList;
                                this.$storageRootPath$inlined = string;
                                this.$expandMacroMap$inlined = expandMacroToPathMap;
                                this.$getUrlByRelativePath$2$inlined = var8_8;
                                this.$builder$inlined = workspaceEntityStorageBuilder;
                                this.$contentRootEntity$inlined = contentRootEntity;
                                this.$virtualUrlManager$inlined = virtualFileUrlManager;
                                this.$editEclipseProperties$3$inlined = var12_12;
                                this.$moduleEntity$inlined = moduleEntity;
                                this.$sourceRoots$inlined = list;
                                this.$relativePathResolver$inlined = moduleRelativePathResolver;
                                this.$libraryNames$inlined = hashSet;
                                super(1);
                            }

                            public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity it) {
                                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                it.setExpectedModuleSourcePlace(this.$dependencies$inlined.size() - 1);
                                Map<String, Integer> map = it.getSrcPlace();
                                String string = this.$srcUrl.getUrl();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"srcUrl.url");
                                map.put(string, this.$index);
                            }
                        }));
                        break;
                    }
                    case 1: {
                        linked = AbstractEclipseClasspathReader.expandLinkedResourcesPath((String)storageRootPath, (ExpandMacroToPathMap)expandMacroMap, (String)path);
                        outputUrl = null;
                        if (linked != null) {
                            outputUrl = virtualUrlManager.fromUrl(PathConversionKt.pathToUrl(linked));
                            $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(path, outputUrl){
                                final /* synthetic */ String $path;
                                final /* synthetic */ VirtualFileUrl $outputUrl;

                                public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity it) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                    String string = this.$outputUrl.getUrl();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"outputUrl.url");
                                    EclipseEntitiesKt.setVariable(it, "link:", this.$path, string);
                                }
                                {
                                    this.$path = string;
                                    this.$outputUrl = virtualFileUrl;
                                    super(1);
                                }
                            }));
                        } else {
                            outputUrl = $fun$getUrlByRelativePath$2.invoke(path);
                        }
                        BridgeModelModifiableEntitiesKt.addJavaModuleSettingsEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (boolean)false, (boolean)true, (VirtualFileUrl)outputUrl, null, null, (ModuleEntity)moduleEntity, (EntitySource)contentRootEntity.getEntitySource());
                        break;
                    }
                    case 3: {
                        linked = AbstractEclipseClasspathReader.expandLinkedResourcesPath((String)storageRootPath, (ExpandMacroToPathMap)expandMacroMap, (String)path);
                        url /* !! */  = null;
                        if (linked != null) {
                            url /* !! */  = PathConversionKt.convertToRootUrl(linked, virtualUrlManager);
                            $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(path, url /* !! */ ){
                                final /* synthetic */ String $path;
                                final /* synthetic */ VirtualFileUrl $url;

                                public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity it) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                    String string = this.$url.getUrl();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.url");
                                    EclipseEntitiesKt.setVariable(it, "link:", this.$path, string);
                                }
                                {
                                    this.$path = string;
                                    this.$url = virtualFileUrl;
                                    super(1);
                                }
                            }));
                        } else {
                            url /* !! */  = PathConversionKt.convertRelativePathToUrl(path, contentRootEntity, relativePathResolver, virtualUrlManager);
                        }
                        $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(url /* !! */ ){
                            final /* synthetic */ VirtualFileUrl $url;

                            public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity it) {
                                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                it.getEclipseUrls().add(this.$url);
                            }
                            {
                                this.$url = virtualFileUrl;
                                super(1);
                            }
                        }));
                        sourcePath = entryTag.getAttributeValue("sourcepath");
                        srcUrl = null;
                        if (sourcePath != null) {
                            linkedSrc = AbstractEclipseClasspathReader.expandLinkedResourcesPath((String)storageRootPath, (ExpandMacroToPathMap)expandMacroMap, (String)sourcePath);
                            if (linkedSrc != null) {
                                srcUrl = PathConversionKt.convertToRootUrl(linkedSrc, virtualUrlManager);
                                $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(path, srcUrl){
                                    final /* synthetic */ String $path;
                                    final /* synthetic */ VirtualFileUrl $srcUrl;

                                    public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity it) {
                                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                        String string = this.$srcUrl.getUrl();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"srcUrl.url");
                                        EclipseEntitiesKt.setVariable(it, "linksrc:", this.$path, string);
                                    }
                                    {
                                        this.$path = string;
                                        this.$srcUrl = virtualFileUrl;
                                        super(1);
                                    }
                                }));
                            } else {
                                srcUrl = PathConversionKt.convertRelativePathToUrl(sourcePath, contentRootEntity, relativePathResolver, virtualUrlManager);
                            }
                        } else {
                            srcUrl = null;
                        }
                        if (AbstractEclipseClasspathReader.getNativeLibraryRoot((Element)entryTag) != null) {
                            var37_51 = false;
                            element$iv = false;
                            it = $i$f$firstOrNull;
                            $i$a$-let-EclipseModuleRootsSerializer$loadClasspathTags$4$nativeRoot$1 = false;
                            v5 = PathConversionKt.convertRelativePathToUrl(it, contentRootEntity, relativePathResolver, virtualUrlManager);
                        } else {
                            v5 = null;
                        }
                        nativeRoot = v5;
                        name = this.generateUniqueLibraryName(path, (Set<String>)libraryNames);
                        v6 = entryTag;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"entryTag");
                        roots = this.createLibraryRoots(url /* !! */ , srcUrl, nativeRoot, (Element)v6, moduleEntity, relativePathResolver, virtualUrlManager);
                        libraryEntity = BridgeModelModifiableEntitiesKt.addLibraryEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (String)name, (LibraryTableId)((LibraryTableId)new LibraryTableId.ModuleLibraryTableId(moduleEntity.persistentId())), (List)roots, (List)CollectionsKt.emptyList(), (EntitySource)contentRootEntity.getEntitySource());
                        dependencies.add(new ModuleDependencyItem.Exportable.LibraryDependency(libraryEntity.persistentId(), exported, ModuleDependencyItem.DependencyScope.COMPILE));
                        break;
                    }
                    case 5: {
                        slash = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
                        if (slash == 0) {
                            $fun$reportError$1.invoke("'path' attribute format is incorrect for 'var': " + path);
                            continue block14;
                        }
                        libName = this.generateUniqueLibraryName(path, (Set<String>)libraryNames);
                        url = PathConversionKt.convertVariablePathToUrl(expandMacroMap, path, 0, virtualUrlManager);
                        $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(path, url){
                            final /* synthetic */ String $path;
                            final /* synthetic */ VirtualFileUrl $url;

                            public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity it) {
                                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                String string = this.$url.getUrl();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.url");
                                EclipseEntitiesKt.setVariable(it, "", this.$path, string);
                            }
                            {
                                this.$path = string;
                                this.$url = virtualFileUrl;
                                super(1);
                            }
                        }));
                        srcPath = entryTag.getAttributeValue("sourcepath");
                        srcUrl = null;
                        if (srcPath != null) {
                            srcUrl = PathConversionKt.convertVariablePathToUrl(expandMacroMap, srcPath, AbstractEclipseClasspathReader.srcVarStart((String)srcPath), virtualUrlManager);
                            $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(srcPath, srcUrl){
                                final /* synthetic */ String $srcPath;
                                final /* synthetic */ VirtualFileUrl $srcUrl;

                                public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity it) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                    String string = this.$srcUrl.getUrl();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"srcUrl.url");
                                    EclipseEntitiesKt.setVariable(it, "src:", this.$srcPath, string);
                                }
                                {
                                    this.$srcPath = string;
                                    this.$srcUrl = virtualFileUrl;
                                    super(1);
                                }
                            }));
                        } else {
                            srcUrl = null;
                        }
                        v7 = AbstractEclipseClasspathReader.getNativeLibraryRoot((Element)entryTag);
                        if (v7 != null) {
                            roots = v7;
                            libraryEntity = false;
                            var39_59 = false;
                            it = roots;
                            $i$a$-let-EclipseModuleRootsSerializer$loadClasspathTags$4$nativeRoot$2 = false;
                            v8 = PathConversionKt.convertRelativePathToUrl(it, contentRootEntity, relativePathResolver, virtualUrlManager);
                        } else {
                            v8 = null;
                        }
                        nativeRoot = v8;
                        v9 = entryTag;
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"entryTag");
                        roots = this.createLibraryRoots(url, srcUrl, nativeRoot, (Element)v9, moduleEntity, relativePathResolver, virtualUrlManager);
                        libraryEntity = BridgeModelModifiableEntitiesKt.addLibraryEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (String)libName, (LibraryTableId)((LibraryTableId)new LibraryTableId.ModuleLibraryTableId(moduleEntity.persistentId())), (List)roots, (List)CollectionsKt.emptyList(), (EntitySource)contentRootEntity.getEntitySource());
                        dependencies.add(new ModuleDependencyItem.Exportable.LibraryDependency(libraryEntity.persistentId(), exported, ModuleDependencyItem.DependencyScope.COMPILE));
                        break;
                    }
                    case 2: {
                        if (Intrinsics.areEqual((Object)path, (Object)"org.eclipse.pde.core.requiredPlugins")) {
                            libraryId = new LibraryId("ECLIPSE", (LibraryTableId)new LibraryTableId.GlobalLibraryTableId("application"));
                            dependencies.add(new ModuleDependencyItem.Exportable.LibraryDependency(libraryId, exported, ModuleDependencyItem.DependencyScope.COMPILE));
                            break;
                        }
                        if (StringsKt.startsWith$default((String)path, (String)"org.eclipse.jdt.launching.JRE_CONTAINER", (boolean)false, (int)2, null)) {
                            jdkName = AbstractEclipseClasspathReader.getLastPathComponent((String)path);
                            dependencies.removeIf(loadClasspathTags.4.9.INSTANCE);
                            dependencies.add(jdkName != null ? (ModuleDependencyItem)new ModuleDependencyItem.SdkDependency(jdkName, "JavaSDK") : (ModuleDependencyItem)ModuleDependencyItem.InheritedSdkDependency.INSTANCE);
                            break;
                        }
                        if (StringsKt.startsWith$default((String)path, (String)"org.eclipse.jdt.USER_LIBRARY", (boolean)false, (int)2, null)) {
                            Intrinsics.checkNotNullExpressionValue((Object)AbstractEclipseClasspathReader.getPresentableName((String)path), (String)"AbstractEclipseClasspath\u2026.getPresentableName(path)");
                            globalLevel = this.findGlobalLibraryLevel(libraryName);
                            tableId = globalLevel != null ? (LibraryTableId)new LibraryTableId.GlobalLibraryTableId(globalLevel) : (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE;
                            libraryId = new LibraryId(libraryName, tableId);
                            dependencies.add(new ModuleDependencyItem.Exportable.LibraryDependency(libraryId, exported, ModuleDependencyItem.DependencyScope.COMPILE));
                            break;
                        }
                        if (StringsKt.startsWith$default((String)path, (String)"org.eclipse.jdt.junit.JUNIT_CONTAINER", (boolean)false, (int)2, null)) {
                            junitName = "junit" + AbstractEclipseClasspathReader.getPresentableName((String)path);
                            v10 /* !! */  = url /* !! */  = EclipseClasspathReader.getJunitClsUrl(StringsKt.contains$default((CharSequence)junitName, (CharSequence)"4", (boolean)false, (int)2, null));
                            Intrinsics.checkNotNullExpressionValue((Object)v10 /* !! */ , (String)"url");
                            roots = CollectionsKt.listOf((Object)new LibraryRoot(virtualUrlManager.fromUrl((String)v10 /* !! */ ), LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
                            libraryEntity = BridgeModelModifiableEntitiesKt.addLibraryEntity((WorkspaceEntityStorageDiffBuilder)((WorkspaceEntityStorageDiffBuilder)builder), (String)junitName, (LibraryTableId)((LibraryTableId)new LibraryTableId.ModuleLibraryTableId(moduleEntity.persistentId())), (List)roots, (List)CollectionsKt.emptyList(), (EntitySource)contentRootEntity.getEntitySource());
                            dependencies.add(new ModuleDependencyItem.Exportable.LibraryDependency(libraryEntity.persistentId(), exported, ModuleDependencyItem.DependencyScope.COMPILE));
                            break;
                        }
                        definedCons = EclipseNatureImporter.getAllDefinedCons();
                        if (definedCons.contains(path)) {
                            $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(path, index){
                                final /* synthetic */ String $path;
                                final /* synthetic */ int $index;

                                public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity it) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                    it.getKnownCons().add(this.$path);
                                    it.getSrcPlace().put(this.$path, this.$index);
                                }
                                {
                                    this.$path = string;
                                    this.$index = n;
                                    super(1);
                                }
                            }));
                            break;
                        }
                        $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(path){
                            final /* synthetic */ String $path;

                            public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity it) {
                                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                                it.getUnknownCons().add(this.$path);
                            }
                            {
                                this.$path = string;
                                super(1);
                            }
                        }));
                        libraryId = new LibraryId(path, (LibraryTableId)new LibraryTableId.GlobalLibraryTableId("application"));
                        dependencies.add(new ModuleDependencyItem.Exportable.LibraryDependency(libraryId, exported, ModuleDependencyItem.DependencyScope.COMPILE));
                        break;
                    }
                    default: {
                        $fun$reportError$1.invoke("Unknown 'kind' in 'classpathentry': " + kind);
                    }
                }
            }
            $this$none$iv = dependencies;
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v11 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (ModuleDependencyItem)element$iv;
                    $i$a$-none-EclipseModuleRootsSerializer$loadClasspathTags$5 = false;
                    if (!(it instanceof ModuleDependencyItem.SdkDependency != false || Intrinsics.areEqual((Object)it, (Object)ModuleDependencyItem.InheritedSdkDependency.INSTANCE) != false)) continue;
                    v11 = false;
                    break block45;
                }
                v11 = true;
            }
        }
        if (v11) {
            $fun$editEclipseProperties$3.invoke((Function1<? super ModifiableEclipseProjectPropertiesEntity, Unit>)((Function1)loadClasspathTags.6.INSTANCE));
            dependencies.add(0, ModuleDependencyItem.InheritedSdkDependency.INSTANCE);
        }
        ModuleImlFileEntitiesSerializerKt.storeSourceRootsOrder((List)sourceRoots, (ContentRootEntity)contentRootEntity, (WorkspaceEntityStorageBuilder)builder);
        return (ModuleEntity)builder.modifyEntity(ModifiableModuleEntity.class, (WorkspaceEntity)moduleEntity, (Function1)new Function1<ModifiableModuleEntity, Unit>(dependencies){
            final /* synthetic */ ArrayList $dependencies;

            public final void invoke(@NotNull ModifiableModuleEntity $this$modifyEntity) {
                Intrinsics.checkNotNullParameter((Object)$this$modifyEntity, (String)"$receiver");
                $this$modifyEntity.setDependencies((List)this.$dependencies);
            }
            {
                this.$dependencies = arrayList;
                super(1);
            }
        });
    }

    private final String findGlobalLibraryLevel(String libraryName) {
        Object v2;
        block2: {
            LibraryTablesRegistrar registrar;
            LibraryTablesRegistrar libraryTablesRegistrar = registrar = LibraryTablesRegistrar.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)libraryTablesRegistrar, (String)"registrar");
            if (libraryTablesRegistrar.getLibraryTable().getLibraryByName(libraryName) != null) {
                return "application";
            }
            List list = registrar.getCustomLibraryTables();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"registrar.customLibraryTables");
            Iterable iterable = list;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                LibraryTable it = (LibraryTable)t;
                boolean bl3 = false;
                if (!(it.getLibraryByName(libraryName) != null)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        LibraryTable libraryTable = v2;
        return libraryTable != null ? libraryTable.getTableLevel() : null;
    }

    private final String generateUniqueLibraryName(String path, Set<String> libraryNames) {
        String pathComponent = AbstractEclipseClasspathReader.getLastPathComponent((String)path);
        if (pathComponent != null && libraryNames.add(pathComponent)) {
            return pathComponent;
        }
        String string = UniqueNameGenerator.generateUniqueName((String)path, (Collection)libraryNames);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UniqueNameGenerator.gene\u2026eName(path, libraryNames)");
        String name = string;
        libraryNames.add(name);
        return name;
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<LibraryRoot> createLibraryRoots(VirtualFileUrl url, VirtualFileUrl srcUrl, VirtualFileUrl nativeRoot, Element entryTag, ModuleEntity moduleEntity, ModuleRelativePathResolver relativePathResolver, VirtualFileUrlManager virtualUrlManager) {
        ArrayList<LibraryRoot> roots;
        block4: {
            void $this$mapTo$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object object;
            roots = new ArrayList<LibraryRoot>();
            roots.add(new LibraryRoot(url, LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
            if (srcUrl != null) {
                roots.add(new LibraryRoot(srcUrl, LibraryRootTypeId.Companion.getSOURCES(), null, 4, null));
            }
            if (nativeRoot != null) {
                roots.add(new LibraryRoot(nativeRoot, NATIVE_TYPE, null, 4, null));
            }
            if ((object = entryTag.getChild("attributes")) == null || (object = object.getChildren("attribute")) == null) break block4;
            Iterable iterable = (Iterable)object;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Element it = (Element)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAttributeValue("name"), (Object)"javadoc_location")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                Element $i$f$filterTo2 = (Element)item$iv;
                Collection collection = roots;
                boolean bl = false;
                String string = it.getAttributeValue("value");
                Intrinsics.checkNotNull((Object)string);
                LibraryRoot libraryRoot = new LibraryRoot(PathConversionKt.convertToJavadocUrl(string, moduleEntity, relativePathResolver, virtualUrlManager), JAVADOC_TYPE, null, 4, null);
                collection.add(libraryRoot);
            }
            ArrayList cfr_ignored_0 = (ArrayList)((Collection)roots);
        }
        return roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRoots(@NotNull ModuleEntity module, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities, @NotNull JpsFileContentWriter writer, @Nullable String customDir, @NotNull VirtualFileUrl imlFileUrl, @NotNull WorkspaceEntityStorage storage, @NotNull VirtualFileUrlManager virtualFileManager) {
        ModulePathShortener pathShortener;
        Function2<Path, Element, Unit> $fun$saveXmlFile$1;
        block22: {
            InputStream oldClasspath;
            EclipseProjectFile entitySource2;
            block21: {
                InputStream inputStream;
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter(entities, (String)"entities");
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)imlFileUrl, (String)"imlFileUrl");
                Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
                Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
                $fun$saveXmlFile$1 = new Function2<Path, Element, Unit>(this){
                    final /* synthetic */ EclipseModuleRootsSerializer this$0;

                    public final void invoke(@NotNull Path path, @NotNull Element root) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                        WriteAction.runAndWait((ThrowableRunnable)new ThrowableRunnable(this, path, root){
                            final /* synthetic */ saveRoots.1 this$0;
                            final /* synthetic */ Path $path;
                            final /* synthetic */ Element $root;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void run() {
                                Closeable closeable = StorageUtilKt.getOrCreateVirtualFile((Path)this.$path, (StorageManagerFileWriteRequestor)this.this$0.this$0).getOutputStream((Object)this.this$0.this$0);
                                boolean bl = false;
                                boolean bl2 = false;
                                Throwable throwable = null;
                                try {
                                    OutputStream it = (OutputStream)closeable;
                                    boolean bl3 = false;
                                    EclipseJDOMUtil.output(this.$root, (Writer)new OutputStreamWriter(it, StandardCharsets.UTF_8), System.lineSeparator());
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$path = path;
                                this.$root = element;
                            }
                        });
                    }
                    {
                        this.this$0 = eclipseModuleRootsSerializer;
                        super(2);
                    }
                };
                List list = entities.get(ContentRootEntity.class);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List contentRoots = list;
                Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)contentRoots), (Function1)saveRoots.entitySource.1.INSTANCE);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)saveRoots$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                EclipseProjectFile eclipseProjectFile = (EclipseProjectFile)SequencesKt.firstOrNull((Sequence)sequence);
                if (eclipseProjectFile == null) {
                    return;
                }
                entitySource2 = eclipseProjectFile;
                VirtualFile classpathFile = VirtualFileManager.getInstance().findFileByUrl(entitySource2.getClasspathFile().getUrl());
                Object object = classpathFile;
                if (object != null && (object = object.getInputStream()) != null) {
                    Closeable closeable = (Closeable)object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl3 = false;
                        it = JDOMUtil.load((InputStream)it);
                        inputStream = it;
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    inputStream = null;
                }
                oldClasspath = inputStream;
                pathShortener = new ModulePathShortener(storage);
                if (oldClasspath != null) break block21;
                Collection collection = entities.get(SourceRootEntity.class);
                boolean bl = false;
                boolean it = false;
                if ((collection == null || collection.isEmpty()) && module.getDependencies().size() <= 2) break block22;
            }
            Element newClasspath = this.saveClasspathTags(module, entities, entitySource2, (Element)oldClasspath, pathShortener);
            if (oldClasspath == null || !JDOMUtil.areElementsEqual((Element)newClasspath, oldClasspath)) {
                $fun$saveXmlFile$1.invoke(VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)entitySource2.getClasspathFile()), newClasspath);
            }
        }
        String emlFileUrl = this.getEmlFileUrl(imlFileUrl);
        String string = imlFileUrl.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imlFileUrl.url");
        Element emlRoot = new EmlFileSaver(module, entities, pathShortener, writer.getReplacePathMacroMap(string), writer.getReplacePathMacroMap(emlFileUrl)).saveEml();
        if (emlRoot != null) {
            Path path = Paths.get(JpsPathUtil.urlToPath((String)emlFileUrl), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(JpsPathUtil.urlToPath(emlFileUrl))");
            $fun$saveXmlFile$1.invoke(path, emlRoot);
        } else {
            VirtualFile emlFile = VirtualFileManager.getInstance().findFileByUrl(emlFileUrl);
            if (emlFile != null) {
                boolean $i$f$runAsWriteActionIfNeeded = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isWriteAccessAllowed()) {
                    boolean bl = false;
                    try {
                        emlFile.delete((Object)this);
                    }
                    catch (IOException iOException) {
                    }
                } else {
                    boolean $i$f$runWriteAction = false;
                    ApplicationManager.getApplication().runWriteAction(new Computable(this, emlFile){
                        final /* synthetic */ EclipseModuleRootsSerializer this$0;
                        final /* synthetic */ VirtualFile $emlFile$inlined;
                        {
                            this.this$0 = eclipseModuleRootsSerializer;
                            this.$emlFile$inlined = virtualFile;
                        }

                        public final T compute() {
                            boolean bl = false;
                            try {
                                this.$emlFile$inlined.delete((Object)this.this$0);
                            }
                            catch (IOException iOException) {
                            }
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Element saveClasspathTags(ModuleEntity module, Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities, EclipseProjectFile entitySource2, Element oldClasspath, ModulePathShortener pathShortener) {
        String outputPath;
        Function3<String, String, Integer, Element> $fun$addClasspathEntry$1;
        Element classpathTag;
        block58: {
            Unit unit;
            Iterator iterator;
            List list;
            List sourceRoots;
            Map map;
            String string;
            Map map2;
            classpathTag = new Element("classpath");
            Object object = oldClasspath;
            if (object != null && (object = object.getChildren("classpathentry")) != null) {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = (Iterable)object;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object t : $this$associateByTo$iv$iv) {
                    void it;
                    Element element = (Element)t;
                    map2 = destination$iv$iv;
                    boolean bl = false;
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = it.getAttributeValue("kind");
                    Intrinsics.checkNotNull((Object)string2);
                    string = stringBuilder.append(string2).append(EclipseClasspathWriter.getJREKey(it.getAttributeValue("path"))).toString();
                    map2.put(string, t);
                }
                map = destination$iv$iv;
            } else {
                map = MapsKt.emptyMap();
            }
            Map oldEntries = map;
            $fun$addClasspathEntry$1 = new Function3<String, String, Integer, Element>(classpathTag, oldEntries){
                final /* synthetic */ Element $classpathTag;
                final /* synthetic */ Map $oldEntries;

                @NotNull
                public final Element invoke(@NotNull String kind, @Nullable String path, int index) {
                    Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                    Element element = EclipseClasspathWriter.addOrderEntry(kind, path, this.$classpathTag, index, this.$oldEntries);
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addOrderEntry(kind, path\u2026thTag, index, oldEntries)");
                    return element;
                }

                public static /* synthetic */ Element invoke$default(saveClasspathTags.1 var0, String string, String string2, int n, int n2, Object object) {
                    if ((n2 & 4) != 0) {
                        n = -1;
                    }
                    return var0.invoke(string, string2, n);
                }
                {
                    this.$classpathTag = element;
                    this.$oldEntries = map;
                    super(3);
                }
            };
            EclipseProjectPropertiesEntity eclipseProperties = EclipseEntitiesKt.getEclipseProperties(module);
            List list2 = entities.get(SourceRootEntity.class);
            if (list2 == null) {
                list2 = sourceRoots = CollectionsKt.emptyList();
            }
            if ((list = entities.get(LibraryEntity.class)) == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$associateBy$iv22 = list;
            boolean $i$f$associateBy = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv22, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv22;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            boolean bl = false;
            for (Object element$iv$iv : iterable) {
                void it;
                LibraryEntity libraryEntity = (LibraryEntity)element$iv$iv;
                map2 = destination$iv$iv;
                boolean bl2 = false;
                string = it.getName();
                map2.put(string, element$iv$iv);
            }
            Map moduleLibraries2 = destination$iv$iv;
            boolean $this$associateBy$iv22 = false;
            Iterator capacity$iv22 = ((Iterable)module.getDependencies()).iterator();
            while (true) {
                void itemIndex;
                block63: {
                    boolean shouldPlaceSeparately;
                    Object element$iv$iv;
                    block61: {
                        Object object2;
                        String string3;
                        VirtualFileUrl compilerOutput;
                        block59: {
                            ModuleDependencyItem moduleDependencyItem;
                            ModuleDependencyItem item;
                            block66: {
                                block64: {
                                    String libraryName;
                                    Element classpathEntry;
                                    block65: {
                                        VirtualFileUrl firstRoot;
                                        void $this$filterTo$iv$iv;
                                        block62: {
                                            block60: {
                                                if (!capacity$iv22.hasNext()) break block59;
                                                item = (ModuleDependencyItem)capacity$iv22.next();
                                                moduleDependencyItem = item;
                                                if (!Intrinsics.areEqual((Object)moduleDependencyItem, (Object)ModuleDependencyItem.ModuleSourceDependency.INSTANCE)) break block60;
                                                EclipseProjectPropertiesEntity eclipseProjectPropertiesEntity = eclipseProperties;
                                                shouldPlaceSeparately = eclipseProjectPropertiesEntity != null && eclipseProjectPropertiesEntity.getExpectedModuleSourcePlace() == itemIndex;
                                                Object object3 = PathConversionKt.getMainContentRoot(module);
                                                if (object3 == null || (object3 = ModuleImlFileEntitiesSerializerKt.getSourceRootsComparator((ContentRootEntity)object3)) == null) {
                                                    boolean bl3 = false;
                                                    object3 = new Comparator<T>(){

                                                        public final int compare(T a, T b) {
                                                            boolean bl = false;
                                                            SourceRootEntity it = (SourceRootEntity)a;
                                                            boolean bl2 = false;
                                                            Comparable comparable = (Comparable)((Object)it.getUrl().getUrl());
                                                            it = (SourceRootEntity)b;
                                                            Comparable comparable2 = comparable;
                                                            bl2 = false;
                                                            Comparable comparable3 = (Comparable)((Object)it.getUrl().getUrl());
                                                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                                                        }
                                                    };
                                                }
                                                Object object4 = object3;
                                                element$iv$iv = CollectionsKt.sortedWith((Iterable)sourceRoots, (Comparator)object4).iterator();
                                                break block61;
                                            }
                                            if (!(moduleDependencyItem instanceof ModuleDependencyItem.Exportable.ModuleDependency)) break block62;
                                            String path = '/' + ((ModuleDependencyItem.Exportable.ModuleDependency)item).getModule().getName();
                                            Element element = EclipseClasspathWriter.getOldElement("src", path, oldEntries);
                                            classpathEntry = saveClasspathTags.1.invoke$default($fun$addClasspathEntry$1, "src", path, 0, 4, null);
                                            if (element == null) {
                                                EclipseClasspathWriter.setAttributeIfAbsent(classpathEntry, "combineaccessrules", "false");
                                            }
                                            EclipseClasspathWriter.setExported(classpathEntry, ((ModuleDependencyItem.Exportable.ModuleDependency)item).getExported());
                                            break block63;
                                        }
                                        if (!(moduleDependencyItem instanceof ModuleDependencyItem.Exportable.LibraryDependency)) break block64;
                                        libraryName = ((ModuleDependencyItem.Exportable.LibraryDependency)item).getLibrary().getName();
                                        if (!(((ModuleDependencyItem.Exportable.LibraryDependency)item).getLibrary().getTableId() instanceof LibraryTableId.ModuleLibraryTableId)) break block65;
                                        Object object5 = (LibraryEntity)moduleLibraries2.get(libraryName);
                                        if (object5 == null || (object5 = object5.getRoots()) == null) {
                                            object5 = CollectionsKt.emptyList();
                                        }
                                        Object object6 = object5;
                                        Iterable $this$filter$iv = (Iterable)object6;
                                        boolean $i$f$filter = false;
                                        Iterable index = $this$filter$iv;
                                        Object destination$iv$iv2 = new ArrayList();
                                        int $i$f$filterTo = 0;
                                        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                                            LibraryRoot it = (LibraryRoot)element$iv$iv2;
                                            boolean bl4 = false;
                                            if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)OrderRootType.CLASSES.name())) continue;
                                            destination$iv$iv2.add(element$iv$iv2);
                                        }
                                        List libraryClassesRoots = (List)destination$iv$iv2;
                                        LibraryRoot libraryRoot = (LibraryRoot)CollectionsKt.firstOrNull((List)libraryClassesRoots);
                                        Object object7 = firstRoot = libraryRoot != null ? libraryRoot.getUrl() : null;
                                        if (firstRoot != null) {
                                            String firstUrl = firstRoot.getUrl();
                                            if (StringsKt.contains$default((CharSequence)libraryName, (CharSequence)"junit", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)firstUrl, (Object)EclipseClasspathReader.getJunitClsUrl(StringsKt.contains$default((CharSequence)libraryName, (CharSequence)"4", (boolean)false, (int)2, null)))) {
                                                StringBuilder stringBuilder = new StringBuilder().append("org.eclipse.jdt.junit.JUNIT_CONTAINER/");
                                                destination$iv$iv2 = libraryName;
                                                $i$f$filterTo = "junit".length();
                                                boolean bl5 = false;
                                                Object object8 = destination$iv$iv2;
                                                if (object8 == null) {
                                                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                                }
                                                String string4 = ((String)object8).substring($i$f$filterTo);
                                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                                                Element classpathEntry2 = saveClasspathTags.1.invoke$default($fun$addClasspathEntry$1, "con", stringBuilder.append(string4).toString(), 0, 4, null);
                                                EclipseClasspathWriter.setExported(classpathEntry2, ((ModuleDependencyItem.Exportable.LibraryDependency)item).getExported());
                                                break block63;
                                            } else {
                                                VirtualFileUrl[] nativeRoots2;
                                                void $this$mapTo$iv$iv;
                                                void $this$map$iv;
                                                void $this$filterTo$iv$iv2;
                                                Iterable $this$filter$iv2;
                                                String string5;
                                                VirtualFileUrl firstSrcRoot;
                                                void $this$filterTo$iv$iv3;
                                                Element element;
                                                Object object9;
                                                String eclipseVariablePath;
                                                String string6;
                                                boolean newVarLibrary = false;
                                                boolean link = false;
                                                EclipseProjectPropertiesEntity eclipseProjectPropertiesEntity = eclipseProperties;
                                                if (eclipseProjectPropertiesEntity != null) {
                                                    String string7 = firstUrl;
                                                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"firstUrl");
                                                    string6 = EclipseEntitiesKt.getVariable(eclipseProjectPropertiesEntity, "", string7);
                                                } else {
                                                    string6 = eclipseVariablePath = null;
                                                }
                                                if (eclipseVariablePath == null) {
                                                    String string8;
                                                    EclipseProjectPropertiesEntity eclipseProjectPropertiesEntity2 = eclipseProperties;
                                                    if (eclipseProjectPropertiesEntity2 != null) {
                                                        String string9 = firstUrl;
                                                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"firstUrl");
                                                        string8 = EclipseEntitiesKt.getVariable(eclipseProjectPropertiesEntity2, "link:", string9);
                                                    } else {
                                                        string8 = null;
                                                    }
                                                    eclipseVariablePath = string8;
                                                    boolean bl6 = link = eclipseVariablePath != null;
                                                }
                                                if (!(eclipseVariablePath != null || (object9 = eclipseProperties) != null && (object9 = ((EclipseProjectPropertiesEntity)((Object)object9)).getEclipseUrls()) != null && object9.contains(firstRoot))) {
                                                    newVarLibrary = true;
                                                    eclipseVariablePath = PathConversionKt.convertToEclipsePathWithVariable(libraryClassesRoots);
                                                }
                                                if (eclipseVariablePath != null) {
                                                    element = saveClasspathTags.1.invoke$default($fun$addClasspathEntry$1, link ? "lib" : "var", eclipseVariablePath, 0, 4, null);
                                                } else {
                                                    LOG.assertTrue(!StringUtil.isEmptyOrSpaces((String)firstUrl), (Object)("Library: " + libraryName));
                                                    element = saveClasspathTags.1.invoke$default($fun$addClasspathEntry$1, "lib", PathConversionKt.convertToEclipsePath(firstRoot, module, entitySource2, pathShortener), 0, 4, null);
                                                }
                                                Element classpathEntry3 = element;
                                                String srcRelativePath = null;
                                                String eclipseSrcVariablePath = null;
                                                boolean addSrcRoots = true;
                                                VirtualFileUrl[] $this$filter$iv3 = (VirtualFileUrl[])object6;
                                                boolean $i$f$filter2 = false;
                                                VirtualFileUrl[] virtualFileUrlArray = $this$filter$iv3;
                                                Collection destination$iv$iv3 = new ArrayList();
                                                boolean $i$f$filterTo2 = false;
                                                for (Object element$iv$iv3 : $this$filterTo$iv$iv3) {
                                                    LibraryRoot it = (LibraryRoot)element$iv$iv3;
                                                    boolean bl7 = false;
                                                    if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)OrderRootType.SOURCES.name())) continue;
                                                    destination$iv$iv3.add(element$iv$iv3);
                                                }
                                                List librarySourceRoots = (List)destination$iv$iv3;
                                                LibraryRoot libraryRoot2 = (LibraryRoot)CollectionsKt.firstOrNull((List)librarySourceRoots);
                                                Object object10 = firstSrcRoot = libraryRoot2 != null ? libraryRoot2.getUrl() : null;
                                                if (firstSrcRoot == null) {
                                                    srcRelativePath = null;
                                                } else {
                                                    String firstSrcUrl = firstSrcRoot.getUrl();
                                                    srcRelativePath = PathConversionKt.convertToEclipsePath(firstSrcRoot, module, entitySource2, pathShortener);
                                                    if (eclipseVariablePath != null) {
                                                        String string10;
                                                        EclipseProjectPropertiesEntity eclipseProjectPropertiesEntity3 = eclipseProperties;
                                                        if (eclipseProjectPropertiesEntity3 != null) {
                                                            String string11 = firstSrcUrl;
                                                            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"firstSrcUrl");
                                                            string10 = EclipseEntitiesKt.getVariable(eclipseProjectPropertiesEntity3, "src:", string11);
                                                        } else {
                                                            string10 = eclipseSrcVariablePath = null;
                                                        }
                                                        if (eclipseSrcVariablePath == null) {
                                                            String string12;
                                                            EclipseProjectPropertiesEntity eclipseProjectPropertiesEntity4 = eclipseProperties;
                                                            if (eclipseProjectPropertiesEntity4 != null) {
                                                                String string13 = firstSrcUrl;
                                                                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"firstSrcUrl");
                                                                string12 = EclipseEntitiesKt.getVariable(eclipseProjectPropertiesEntity4, "linksrc:", string13);
                                                            } else {
                                                                string12 = eclipseSrcVariablePath = null;
                                                            }
                                                        }
                                                        if (eclipseSrcVariablePath == null) {
                                                            eclipseSrcVariablePath = PathConversionKt.convertToEclipsePathWithVariable(librarySourceRoots);
                                                            if (eclipseSrcVariablePath != null) {
                                                                eclipseSrcVariablePath = '/' + eclipseSrcVariablePath;
                                                            } else if (newVarLibrary) {
                                                                classpathEntry3.detach();
                                                                classpathEntry3 = saveClasspathTags.1.invoke$default($fun$addClasspathEntry$1, "lib", PathConversionKt.convertToEclipsePath(firstRoot, module, entitySource2, pathShortener), 0, 4, null);
                                                            } else {
                                                                LOG.info("Added root " + srcRelativePath + " (in existing var library) can't be replaced with any variable; src roots placed in .eml only");
                                                                addSrcRoots = false;
                                                            }
                                                        }
                                                    }
                                                }
                                                if (addSrcRoots) {
                                                    string5 = eclipseSrcVariablePath;
                                                    if (string5 == null) {
                                                        string5 = srcRelativePath;
                                                    }
                                                } else {
                                                    string5 = null;
                                                }
                                                EclipseClasspathWriter.setOrRemoveAttribute(classpathEntry3, "sourcepath", string5);
                                                Iterable firstSrcUrl = (Iterable)object6;
                                                String string14 = "javadoc_location";
                                                string = new Function(module, entitySource2, pathShortener){
                                                    final /* synthetic */ ModuleEntity $module;
                                                    final /* synthetic */ EclipseProjectFile $entitySource;
                                                    final /* synthetic */ ModulePathShortener $pathShortener;

                                                    public final String fun(VirtualFileUrl it) {
                                                        VirtualFileUrl virtualFileUrl = it;
                                                        Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"it");
                                                        return PathConversionKt.convertToEclipseJavadocPath(virtualFileUrl, this.$module, this.$entitySource.getInternalSource().getProjectLocation(), this.$pathShortener);
                                                    }
                                                    {
                                                        this.$module = moduleEntity;
                                                        this.$entitySource = eclipseProjectFile;
                                                        this.$pathShortener = modulePathShortener;
                                                    }
                                                };
                                                map2 = classpathEntry3;
                                                boolean $i$f$filter3 = false;
                                                destination$iv$iv3 = $this$filter$iv2;
                                                Collection destination$iv$iv4 = new ArrayList();
                                                boolean $i$f$filterTo3 = false;
                                                for (Object element$iv$iv4 : $this$filterTo$iv$iv2) {
                                                    LibraryRoot it = (LibraryRoot)element$iv$iv4;
                                                    boolean bl8 = false;
                                                    if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)"JAVADOC")) continue;
                                                    destination$iv$iv4.add(element$iv$iv4);
                                                }
                                                Collection<VirtualFileUrl> collection = (List)destination$iv$iv4;
                                                $this$filter$iv2 = collection;
                                                boolean $i$f$map = false;
                                                $this$filterTo$iv$iv2 = $this$map$iv;
                                                destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                boolean $i$f$mapTo = false;
                                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                                    LibraryRoot it = (LibraryRoot)item$iv$iv;
                                                    collection = destination$iv$iv4;
                                                    boolean bl9 = false;
                                                    VirtualFileUrl virtualFileUrl = it.getUrl();
                                                    collection.add(virtualFileUrl);
                                                }
                                                collection = (List)destination$iv$iv4;
                                                Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)collection);
                                                boolean $i$f$toTypedArray = false;
                                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                                VirtualFileUrl[] virtualFileUrlArray2 = thisCollection$iv.toArray(new VirtualFileUrl[0]);
                                                if (virtualFileUrlArray2 == null) {
                                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                                }
                                                EJavadocUtil.setupAttributes((Element)map2, string, string14, virtualFileUrlArray2);
                                                Collection $this$toTypedArray$iv2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object6)), (Function1)saveClasspathTags.nativeRoots.1.INSTANCE), (Function1)saveClasspathTags.nativeRoots.2.INSTANCE));
                                                boolean $i$f$toTypedArray2 = false;
                                                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                                                if (thisCollection$iv2.toArray(new VirtualFileUrl[0]) == null) {
                                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                                                }
                                                virtualFileUrlArray = nativeRoots2;
                                                boolean bl10 = false;
                                                VirtualFileUrl[] virtualFileUrlArray3 = virtualFileUrlArray;
                                                boolean bl11 = false;
                                                if (!(virtualFileUrlArray3.length == 0)) {
                                                    EJavadocUtil.setupAttributes(classpathEntry3, (Function)new Function(module, entitySource2, pathShortener){
                                                        final /* synthetic */ ModuleEntity $module;
                                                        final /* synthetic */ EclipseProjectFile $entitySource;
                                                        final /* synthetic */ ModulePathShortener $pathShortener;

                                                        public final String fun(VirtualFileUrl it) {
                                                            VirtualFileUrl virtualFileUrl = it;
                                                            Intrinsics.checkNotNullExpressionValue((Object)virtualFileUrl, (String)"it");
                                                            String string = PathConversionKt.convertToEclipsePath(virtualFileUrl, this.$module, this.$entitySource, this.$pathShortener);
                                                            Intrinsics.checkNotNull((Object)string);
                                                            return string;
                                                        }
                                                        {
                                                            this.$module = moduleEntity;
                                                            this.$entitySource = eclipseProjectFile;
                                                            this.$pathShortener = modulePathShortener;
                                                        }
                                                    }, "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY", nativeRoots2);
                                                }
                                                EclipseClasspathWriter.setExported(classpathEntry3, ((ModuleDependencyItem.Exportable.LibraryDependency)item).getExported());
                                            }
                                        }
                                        break block63;
                                    }
                                    Object object11 = eclipseProperties;
                                    String string15 = object11 != null && (object11 = object11.getUnknownCons()) != null && object11.contains(libraryName) ? libraryName : (Intrinsics.areEqual((Object)libraryName, (Object)"ECLIPSE") ? "org.eclipse.pde.core.requiredPlugins" : "org.eclipse.jdt.USER_LIBRARY/" + libraryName);
                                    classpathEntry = saveClasspathTags.1.invoke$default($fun$addClasspathEntry$1, "con", string15, 0, 4, null);
                                    EclipseClasspathWriter.setExported(classpathEntry, ((ModuleDependencyItem.Exportable.LibraryDependency)item).getExported());
                                    break block63;
                                }
                                if (!Intrinsics.areEqual((Object)moduleDependencyItem, (Object)ModuleDependencyItem.InheritedSdkDependency.INSTANCE)) break block66;
                                EclipseProjectPropertiesEntity eclipseProjectPropertiesEntity = eclipseProperties;
                                if (eclipseProjectPropertiesEntity == null || !eclipseProjectPropertiesEntity.getForceConfigureJdk()) {
                                    saveClasspathTags.1.invoke$default($fun$addClasspathEntry$1, "con", "org.eclipse.jdt.launching.JRE_CONTAINER", 0, 4, null);
                                }
                                break block63;
                            }
                            if (!(moduleDependencyItem instanceof ModuleDependencyItem.SdkDependency)) break block63;
                            String jdkLink = "org.eclipse.jdt.launching.JRE_CONTAINER" + (Intrinsics.areEqual((Object)((ModuleDependencyItem.SdkDependency)item).getSdkType(), (Object)"JavaSDK") ? "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType" : "") + '/' + ((ModuleDependencyItem.SdkDependency)item).getSdkName();
                            saveClasspathTags.1.invoke$default($fun$addClasspathEntry$1, "con", jdkLink, 0, 4, null);
                            break block63;
                        }
                        JavaModuleSettingsEntity javaModuleSettingsEntity = module.getJavaSettings();
                        Object object12 = compilerOutput = javaModuleSettingsEntity != null ? javaModuleSettingsEntity.getCompilerOutput() : null;
                        if (compilerOutput != null) {
                            String linkedPath;
                            String string16;
                            EclipseProjectPropertiesEntity eclipseProjectPropertiesEntity = eclipseProperties;
                            if (eclipseProjectPropertiesEntity != null) {
                                String string17 = compilerOutput.getUrl();
                                Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"compilerOutput.url");
                                string16 = EclipseEntitiesKt.getVariable(eclipseProjectPropertiesEntity, "link:", string17);
                            } else {
                                string16 = null;
                            }
                            if ((string3 = (linkedPath = string16)) == null) {
                                string3 = PathConversionKt.convertToEclipsePath(compilerOutput, module, entitySource2, pathShortener);
                            }
                        } else {
                            string3 = outputPath = "bin";
                        }
                        if ((object2 = eclipseProperties) != null && (object2 = object2.getKnownCons()) != null) {
                            Iterable $this$forEach$iv = (Iterable)object2;
                            boolean bl12 = false;
                            iterator = $this$forEach$iv.iterator();
                            break;
                        }
                        unit = null;
                        break block58;
                    }
                    while (element$iv$iv.hasNext()) {
                        Object object13;
                        SourceRootEntity sourceRoot2 = (SourceRootEntity)element$iv$iv.next();
                        String relativePath = PathConversionKt.convertToEclipsePath(sourceRoot2.getUrl(), module, entitySource2, pathShortener);
                        ContentRootEntity contentRootEntity = PathConversionKt.getMainContentRoot(module);
                        if (Intrinsics.areEqual((Object)sourceRoot2.getContentRoot().getUrl(), (Object)(contentRootEntity != null ? contentRootEntity.getUrl() : null)) ^ true) {
                            String linkedPath;
                            String string18;
                            EclipseProjectPropertiesEntity eclipseProjectPropertiesEntity = eclipseProperties;
                            if (eclipseProjectPropertiesEntity != null) {
                                String string19 = sourceRoot2.getUrl().getUrl();
                                Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"sourceRoot.url.url");
                                string18 = EclipseEntitiesKt.getVariable(eclipseProjectPropertiesEntity, "linksrc:", string19);
                            } else {
                                string18 = linkedPath = null;
                            }
                            if (linkedPath != null) {
                                relativePath = linkedPath;
                            }
                        }
                        int index = (object13 = eclipseProperties) != null && (object13 = ((EclipseProjectPropertiesEntity)((Object)object13)).getSrcPlace()) != null && (object13 = (Integer)object13.get(sourceRoot2.getUrl().getUrl())) != null ? (Integer)object13 : -1;
                        $fun$addClasspathEntry$1.invoke("src", relativePath, shouldPlaceSeparately ? index : -1);
                    }
                }
                ++itemIndex;
            }
            while (iterator.hasNext()) {
                Object t = iterator.next();
                String it = (String)t;
                boolean bl13 = false;
                Integer n = eclipseProperties.getSrcPlace().get(it);
                $fun$addClasspathEntry$1.invoke("con", it, n != null ? n : -1);
            }
            unit = Unit.INSTANCE;
        }
        EclipseClasspathWriter.setAttributeIfAbsent(saveClasspathTags.1.invoke$default($fun$addClasspathEntry$1, "output", outputPath, 0, 4, null), "path", "bin");
        return classpathTag;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EclipseModuleRootsSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        JAVADOC_TYPE = new LibraryRootTypeId("JAVADOC");
        NATIVE_TYPE = new LibraryRootTypeId("NATIVE");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/eclipse/config/EclipseModuleRootsSerializer$Companion;", "", "()V", "JAVADOC_TYPE", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryRootTypeId;", "getJAVADOC_TYPE$intellij_eclipse", "()Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryRootTypeId;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NATIVE_TYPE", "getNATIVE_TYPE$intellij_eclipse", "intellij.eclipse"})
    public static final class Companion {
        @NotNull
        public final LibraryRootTypeId getJAVADOC_TYPE$intellij_eclipse() {
            return JAVADOC_TYPE;
        }

        @NotNull
        public final LibraryRootTypeId getNATIVE_TYPE$intellij_eclipse() {
            return NATIVE_TYPE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

