/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.files;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.JspHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.lexer.VtlLexer;
import com.intellij.velocity.psi.VtlElementTypes;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class VtlSyntaxHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey VELOCITY_DOT = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_DOT", DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey VELOCITY_PARENTHS = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_PARENTHS", DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey VELOCITY_BRACKETS = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_BRACKETS", DefaultLanguageHighlighterColors.BRACKETS);
    public static final TextAttributesKey VELOCITY_BRACES = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_BRACES", DefaultLanguageHighlighterColors.BRACES);
    public static final TextAttributesKey VELOCITY_OPERATION_SIGN = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_OPERATION_SIGN", DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey VELOCITY_STRING = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_STRING", DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey VELOCITY_ESCAPE = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_ESCAPE", DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    public static final TextAttributesKey VELOCITY_NUMBER = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_NUMBER", DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey VELOCITY_KEYWORD = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_KEYWORD", DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey VELOCITY_COMMA = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_COMMA", DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey VELOCITY_SEMICOLON = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_SEMICOLON", DefaultLanguageHighlighterColors.SEMICOLON);
    public static final TextAttributesKey VELOCITY_DIRECTIVE = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_DIRECTIVE", JspHighlighterColors.JSP_ACTION_AND_DIRECTIVE_NAME);
    public static final TextAttributesKey VELOCITY_REFERENCE = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_REFERENCE", JspHighlighterColors.JSP_ATTRIBUTE_NAME);
    public static final TextAttributesKey VELOCITY_COMMENT = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_COMMENT", JspHighlighterColors.JSP_COMMENT);
    public static final TextAttributesKey VELOCITY_BAD_CHARACTER = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_BAD_CHARACTER", HighlighterColors.BAD_CHARACTER);
    public static final TextAttributesKey VELOCITY_SCRIPTING_BACKGROUND = VtlSyntaxHighlighter.createTextAttributesKey("VELOCITY_SCRIPTING_BACKGROUND", JspHighlighterColors.JSP_SCRIPTING_BACKGROUND);
    private static final Map<IElementType, TextAttributesKey> ourMap = new HashMap<IElementType, TextAttributesKey>();

    private static TextAttributesKey createTextAttributesKey(@NonNls String externalName, TextAttributesKey defaultTextAttr) {
        return TextAttributesKey.createTextAttributesKey((String)externalName, (TextAttributesKey)defaultTextAttr);
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new VtlLexer();
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)VELOCITY_SCRIPTING_BACKGROUND, (TextAttributesKey)ourMap.get(tokenType));
        if (textAttributesKeyArray == null) {
            VtlSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    static {
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_DOT, (IElementType[])new IElementType[]{VtlElementTypes.DOT, VtlElementTypes.JAVA_DOT});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_PARENTHS, (IElementType[])new IElementType[]{VtlElementTypes.LEFT_PAREN, VtlElementTypes.RIGHT_PAREN});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_BRACKETS, (IElementType[])new IElementType[]{VtlElementTypes.LEFT_BRACKET, VtlElementTypes.RIGHT_BRACKET});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_BRACES, (IElementType[])new IElementType[]{VtlElementTypes.LEFT_BRACE_IN_EXPR, VtlElementTypes.RIGHT_BRACE_IN_EXPR});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_OPERATION_SIGN, (IElementType[])new IElementType[]{VtlElementTypes.PLUS, VtlElementTypes.MINUS, VtlElementTypes.ASTERISK, VtlElementTypes.DIVIDE, VtlElementTypes.PERCENT, VtlElementTypes.AND, VtlElementTypes.OR, VtlElementTypes.EXCLAIM, VtlElementTypes.QUESTION, VtlElementTypes.RANGE});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_STRING, (IElementType[])new IElementType[]{VtlElementTypes.STRING_TEXT, VtlElementTypes.DOUBLE_QUOTE, VtlElementTypes.SINGLE_QUOTE});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_ESCAPE, (IElementType[])new IElementType[]{VtlElementTypes.CHAR_ESCAPE});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_NUMBER, (IElementType[])new IElementType[]{VtlElementTypes.INTEGER, VtlElementTypes.DOUBLE});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_KEYWORD, (IElementType[])new IElementType[]{VtlElementTypes.BOOLEAN, VtlElementTypes.IN});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_COMMA, (IElementType[])new IElementType[]{VtlElementTypes.COMMA});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_SEMICOLON, (IElementType[])new IElementType[]{VtlElementTypes.SEMICOLON});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_DIRECTIVE, (IElementType[])new IElementType[]{VtlElementTypes.START_REFERENCE, VtlElementTypes.START_REF_FORMAL, VtlElementTypes.LEFT_BRACE, VtlElementTypes.RIGHT_BRACE});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_DIRECTIVE, (IElementType[])VtlElementTypes.DIR_STARTERS.getTypes());
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_REFERENCE, (IElementType[])new IElementType[]{VtlElementTypes.IDENTIFIER});
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_COMMENT, (IElementType[])VtlElementTypes.COMMENTS.getTypes());
        SyntaxHighlighterBase.fillMap(ourMap, (TextAttributesKey)VELOCITY_BAD_CHARACTER, (IElementType[])new IElementType[]{TokenType.BAD_CHARACTER});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/files/VtlSyntaxHighlighter", "getTokenHighlights"));
    }
}

