/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.files;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.VtlFileIndex;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.directives.FixedNameVariable;
import com.intellij.velocity.psi.directives.VtlDirective;
import com.intellij.velocity.psi.directives.VtlDirectiveHolder;
import com.intellij.velocity.psi.files.ProviderBuilder;
import com.intellij.velocity.psi.files.VelocityPropertiesProvider;
import com.intellij.velocity.psi.files.VtlFileProxy;
import com.intellij.velocity.psi.files.VtlFileType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VtlFile
extends PsiFileBase
implements VtlDirectiveHolder {
    private static final String QUOTED_TEXT = "\"([^\"]*)\"";
    private static final String QUOTED_TEXT_NOT_EMPTY = "\"([^\"]+)\"";
    private static final String PATH_TO_FILE = "[ \t\n]*path=\"([^\"]+)\"";
    private static final String SCOPE_FILE_AND_ANY_TAIL = "([ \t\n]+file=\"([^\"]*)\")?(.*)";
    @NonNls
    public static final String VTLVARIABLE_MARKER = "@vtlvariable ";
    @NonNls
    private static final Pattern IMPLICIT_VAR_DECL_PATTERN = Pattern.compile("(.*?)@vtlvariable [ ]*name=\"([^\"]+)\"[ \t\n]+type=\"([^\"]*)\"([ \t\n]+file=\"([^\"]*)\")?(.*)");
    @NonNls
    public static final String VTLMACROLIBRARY_MARKER = "@vtlmacrolibrary ";
    @NonNls
    private static final Pattern EXTERNAL_MACRO_LIBRARY_PATTERN = Pattern.compile("(.*?)@vtlmacrolibrary [ \t\n]*path=\"([^\"]+)\"([ \t\n]+file=\"([^\"]*)\")?(.*)");
    @NonNls
    public static final String VELOCITY_PROPERTIES_MARKER = "@velocityproperties ";
    @NonNls
    private static final Pattern VELOCITY_PROPERTIES_PATTERN = Pattern.compile("(.*?)@velocityproperties [ \t\n]*path=\"([^\"]+)\"([ \t\n]+runtime_root=\"([^\"]*)\")?([ \t\n]+file=\"([^\"]*)\")?(.*)");
    private final CachedValue<Map<String, VtlImplicitVariable>> myImplicitVars;
    private final CachedValue<Collection<VtlVariable>> myGlobalVars;
    private final CachedValue<Collection<VtlMacro>> myGlobalMacros;
    private final CachedValue<Collection<VtlFileProxy>> myMacroLibraries;
    private final CachedValue<Map<String, Set<VtlMacro>>> myAllMacros;
    private final CachedValue<VelocityPropertiesProvider> myVelocityProperties;

    public VtlFile(FileViewProvider viewProvider) {
        super(viewProvider, (Language)VtlLanguage.INSTANCE);
        ProviderBuilder builder = new ProviderBuilder(this);
        this.myImplicitVars = this.createCachedValue(ProviderBuilder.createImplicitVarsProvider(this));
        this.myGlobalVars = this.createCachedValue(builder.createGlobalVarsProvider());
        this.myGlobalMacros = this.createCachedValue(builder.createGlobalMacrosProvider());
        this.myMacroLibraries = this.createCachedValue(builder.createMacroLibrariesProvider());
        this.myAllMacros = this.createCachedValue(builder.createAllMacrosProvider());
        this.myVelocityProperties = this.createCachedValue(builder.createVelocityPropertiesProvider());
    }

    private <T> CachedValue<T> createCachedValue(CachedValueProvider<T> provider) {
        return CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(provider, false);
    }

    @NotNull
    public FileType getFileType() {
        VtlFileType vtlFileType = VtlFileType.INSTANCE;
        if (vtlFileType == null) {
            VtlFile.$$$reportNull$$$0(0);
        }
        return vtlFileType;
    }

    public String toString() {
        return this.getPresentableName();
    }

    @Override
    public VtlDirective @NotNull [] getDirectiveChildren() {
        VtlDirective[] vtlDirectiveArray = (VtlDirective[])this.findChildrenByClass(VtlDirective.class);
        if (vtlDirectiveArray == null) {
            VtlFile.$$$reportNull$$$0(1);
        }
        return vtlDirectiveArray;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "VtlFile:" + this.getName();
        if (string == null) {
            VtlFile.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public VtlImplicitVariable findImplicitVariable(@NotNull String name, @Nullable String scopeFilePath) {
        if (name == null) {
            VtlFile.$$$reportNull$$$0(3);
        }
        if (scopeFilePath != null) {
            name = (String)name + scopeFilePath;
        }
        return (VtlImplicitVariable)((Map)this.myImplicitVars.getValue()).get(name);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            VtlFile.$$$reportNull$$$0(4);
        }
        if (state == null) {
            VtlFile.$$$reportNull$$$0(5);
        }
        if (place == null) {
            VtlFile.$$$reportNull$$$0(6);
        }
        if (!this.processExportableDeclarations(processor, state, null)) {
            return false;
        }
        if (!PsiUtil.processDeclarations(processor, state, lastParent, null, this)) {
            return false;
        }
        for (VtlVariable var : (Collection)this.myGlobalVars.getValue()) {
            if (processor.execute((PsiElement)var, state)) continue;
            return false;
        }
        if (!(this.getProject().isDefault() || this.processGlobalMacros(processor, state) && this.processVelocityPropertiesLibraries(processor, state) && this.processImplicitlyIncludedFiles(processor, state))) {
            return false;
        }
        return this.processScopeControlVariables(processor, state);
    }

    private boolean processScopeControlVariables(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            VtlFile.$$$reportNull$$$0(7);
        }
        if (state == null) {
            VtlFile.$$$reportNull$$$0(8);
        }
        return !PsiUtil.isAtLeast17(this) || processor.execute((PsiElement)new FixedNameVariable((PsiElement)this, "template", true), state) && processor.execute((PsiElement)new FixedNameVariable((PsiElement)this, "evaluate", true), state);
    }

    private boolean processGlobalMacros(PsiScopeProcessor processor, ResolveState state) {
        for (VtlMacro macro : (Collection)this.myGlobalMacros.getValue()) {
            if (processor.execute((PsiElement)macro, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processExportableDeclarations(PsiScopeProcessor processor, ResolveState state, @Nullable VtlFile placeFile) {
        for (VtlImplicitVariable var : ((Map)this.myImplicitVars.getValue()).values()) {
            if (!var.isVisibleIn(placeFile) || processor.execute((PsiElement)var, state)) continue;
            return false;
        }
        return this.processMacroLibraries(processor, state, placeFile);
    }

    private boolean processVelocityPropertiesLibraries(PsiScopeProcessor processor, ResolveState state) {
        VelocityPropertiesProvider velocityProperties = (VelocityPropertiesProvider)this.myVelocityProperties.getValue();
        if (velocityProperties == null) {
            return true;
        }
        VirtualFile virtual = this.getOriginalFile().getVirtualFile();
        if (virtual == null) {
            return true;
        }
        List<VtlFile> velocimacros = velocityProperties.getVelocimacroLibraryListBasedOn(virtual.getParent());
        for (VtlFile lib : velocimacros) {
            if (lib.processMacrosInFile(processor, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitlyIncludedFiles(PsiScopeProcessor processor, ResolveState state) {
        Collection<VtlFile> implicitlyIncludedFiles = VtlFileIndex.getImplicitlyIncludedFiles((PsiFile)this);
        if (implicitlyIncludedFiles.isEmpty()) {
            return true;
        }
        VtlFile placeFile = (VtlFile)this.getOriginalFile();
        for (VtlFile implicitlyIncludedFile : implicitlyIncludedFiles) {
            if (implicitlyIncludedFile.processExportableDeclarations(processor, state, placeFile)) continue;
            return false;
        }
        return true;
    }

    private boolean processMacroLibraries(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, VtlFile placeFile) {
        if (processor == null) {
            VtlFile.$$$reportNull$$$0(9);
        }
        if (state == null) {
            VtlFile.$$$reportNull$$$0(10);
        }
        for (VtlFileProxy lib : (Collection)this.myMacroLibraries.getValue()) {
            if (!lib.isVisibleIn(placeFile) || lib.getFile().processMacrosInFile(processor, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processMacrosInFile(PsiScopeProcessor processor, ResolveState state) {
        for (Set macros : ((Map)this.myAllMacros.getValue()).values()) {
            assert (macros.size() > 0);
            if (processor.execute((PsiElement)macros.iterator().next(), state)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllMacrosInScope(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            VtlFile.$$$reportNull$$$0(11);
        }
        if (state == null) {
            VtlFile.$$$reportNull$$$0(12);
        }
        return this.processGlobalMacros(processor, state) && this.processMacroLibraries(processor, state, null) && this.processVelocityPropertiesLibraries(processor, state) && this.processImplicitlyIncludedFiles(processor, state) && this.processMacrosInFile(processor, state);
    }

    public int getNumberOfMacros(@Nullable String macroName) {
        Set macroSet = (Set)((Map)this.myAllMacros.getValue()).get(macroName);
        return macroSet == null ? 0 : macroSet.size();
    }

    @NotNull
    public Set<String> getDefinedMacroNames() {
        HashSet<String> result = new HashSet<String>();
        for (VtlMacro macro : this.getDefinedMacros()) {
            ContainerUtil.addIfNotNull(result, (Object)macro.getName());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            VtlFile.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    public Set<VtlMacro> getDefinedMacros() {
        HashSet<VtlMacro> res = new HashSet<VtlMacro>();
        Map macros = (Map)this.myAllMacros.getValue();
        for (Set sameNameMacros : macros.values()) {
            for (VtlMacro macro : sameNameMacros) {
                if (macro.getContainingFile() != this) continue;
                res.add(macro);
            }
        }
        HashSet<VtlMacro> hashSet = res;
        if (hashSet == null) {
            VtlFile.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @Nullable
    public VelocityPropertiesProvider getVelocityProperties() {
        return (VelocityPropertiesProvider)this.myVelocityProperties.getValue();
    }

    public boolean isIdeTemplateFile() {
        return this.getViewProvider().getUserData(FileTemplateManager.DEFAULT_TEMPLATE_PROPERTIES) != null;
    }

    public static String @Nullable [] findVariableNameAndTypeAndScopeFilePath(@NotNull String commentText) {
        Matcher matcher;
        if (commentText == null) {
            VtlFile.$$$reportNull$$$0(15);
        }
        if (!(matcher = IMPLICIT_VAR_DECL_PATTERN.matcher(commentText)).matches()) {
            return null;
        }
        return new String[]{matcher.group(2), matcher.group(3), matcher.group(5)};
    }

    public static String @Nullable [] findMacroLibraryPathAndScopeFilePath(@NotNull String commentText) {
        Matcher matcher;
        if (commentText == null) {
            VtlFile.$$$reportNull$$$0(16);
        }
        if (!(matcher = EXTERNAL_MACRO_LIBRARY_PATTERN.matcher(commentText)).matches()) {
            return null;
        }
        return new String[]{matcher.group(2), matcher.group(4)};
    }

    public static String[] findVelocityPropertiesPathAndScopeFilePath(String commentText) {
        Matcher matcher = VELOCITY_PROPERTIES_PATTERN.matcher(commentText);
        if (!matcher.matches()) {
            return null;
        }
        return new String[]{matcher.group(2), matcher.group(4), matcher.group(6)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/psi/files/VtlFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectiveChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/psi/files/VtlFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinedMacroNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinedMacros";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findImplicitVariable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processScopeControlVariables";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processMacroLibraries";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processAllMacrosInScope";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findVariableNameAndTypeAndScopeFilePath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findMacroLibraryPathAndScopeFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

