/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.directives;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlArgumentList;
import com.intellij.velocity.psi.VtlCallExpression;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.directives.FixedNameVariable;
import com.intellij.velocity.psi.directives.VtlDirective;
import org.jetbrains.annotations.NotNull;

public class VtlMacroCall
extends VtlCallExpression
implements VtlDirective {
    public VtlMacroCall(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getMacroName();
        if (string == null) {
            VtlMacroCall.$$$reportNull$$$0(0);
        }
        return string;
    }

    private String getMacroName() {
        PsiElement child = this.findChildByType(VtlCompositeElementTypes.REFERENCE_EXPRESSION);
        return child != null ? child.getText() : "";
    }

    @Override
    public int getFoldingStartOffset() {
        return this.getNode().getTextRange().getStartOffset() + this.getPresentableName().length() + 1;
    }

    @Override
    public int getFoldingEndOffset() {
        return this.getNode().getTextRange().getEndOffset();
    }

    @Override
    public boolean needsClosing() {
        return false;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            VtlMacroCall.$$$reportNull$$$0(1);
        }
        if (state == null) {
            VtlMacroCall.$$$reportNull$$$0(2);
        }
        if (place == null) {
            VtlMacroCall.$$$reportNull$$$0(3);
        }
        String macroName = this.getMacroName();
        if (PsiUtil.isAtLeast17(this) && StringUtil.isNotEmpty((String)macroName) && !processor.execute((PsiElement)new FixedNameVariable((PsiElement)this, macroName, true), state)) {
            return false;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    public VtlExpression @NotNull [] getArguments() {
        VtlArgumentList argList = (VtlArgumentList)((Object)this.findChildByClass(VtlArgumentList.class));
        if (argList == null) {
            if (VtlExpression.EMPTY_ARRAY == null) {
                VtlMacroCall.$$$reportNull$$$0(4);
            }
            return VtlExpression.EMPTY_ARRAY;
        }
        VtlExpression[] vtlExpressionArray = argList.getArguments();
        if (vtlExpressionArray == null) {
            VtlMacroCall.$$$reportNull$$$0(5);
        }
        return vtlExpressionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/psi/directives/VtlMacroCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/psi/directives/VtlMacroCall";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

