/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.directives;

import com.intellij.psi.PsiElement;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.directives.VtlDirectiveHolder;
import com.intellij.velocity.psi.files.VtlFile;

public interface VtlDirective
extends VtlDirectiveHolder {
    public static final String[] DIRECTIVE_NAMES = new String[]{"break", "define", "else", "elseif", "end", "evaluate", "foreach", "if", "include", "literal", "macro", "parse", "set", "stop"};

    public int getFoldingStartOffset();

    public int getFoldingEndOffset();

    public boolean needsClosing();

    public static final class Validator {
        private Validator() {
        }

        public static boolean areParenthesesNeeded(String childName) {
            return !"break".equals(childName) && !"else".equals(childName) && !"end".equals(childName) && !"stop".equals(childName);
        }

        public static boolean isAllowed(PsiElement parent, String childName) {
            if ("macro".equals(childName)) {
                return parent instanceof VtlFile;
            }
            if ("end".equals(childName)) {
                return PsiUtil.isTypeOf(parent, VtlElementTypes.SHARP_FOREACH, VtlElementTypes.SHARP_IF, VtlElementTypes.SHARP_LITERAL, VtlElementTypes.SHARP_MACRODECL, VtlElementTypes.SHARP_DEFINE) || PsiUtil.isTypeOf(parent.getParent(), VtlElementTypes.SHARP_IF) && PsiUtil.isTypeOf(parent, VtlElementTypes.SHARP_ELSE, VtlElementTypes.SHARP_ELSEIF);
            }
            if ("else".equals(childName) || "elseif".equals(childName)) {
                return PsiUtil.isTypeOf(parent, VtlElementTypes.SHARP_IF) || PsiUtil.isTypeOf(parent.getParent(), VtlElementTypes.SHARP_IF) && PsiUtil.isTypeOf(parent, VtlElementTypes.SHARP_ELSEIF);
            }
            if ("break".equals(childName)) {
                return PsiUtil.isTypeOf(parent, VtlElementTypes.SHARP_FOREACH);
            }
            return true;
        }
    }
}

