/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.codeInsight.completion.util.PsiTypeCanonicalLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SoftFileReferenceSet;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.psi.VtlDirectiveHeader;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.VtlLiteralExpressionType;
import com.intellij.velocity.psi.VtlNamedElement;
import com.intellij.velocity.psi.VtlTokenType;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.directives.FixedNameVariable;
import com.intellij.velocity.psi.directives.VtlAssignment;
import com.intellij.velocity.psi.directives.VtlDirective;
import com.intellij.velocity.psi.directives.VtlParse;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.files.VtlFileType;
import com.intellij.velocity.psi.reference.VtlFileReferenceSet;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiUtil {
    @NonNls
    private static final String NULL_TYPE_NAME = "???";
    private static final Set<String> CONTROL_DIRECTIVES = ContainerUtil.newHashSet((Object[])new String[]{"if", "else", "elseif", "foreach"});

    public static boolean isAtLeast17(PsiElement element) {
        Project project = element.getProject();
        return JavaPsiFacade.getInstance((Project)project).findClass("org.apache.velocity.context.ChainedInternalContextAdapter", GlobalSearchScope.allScope((Project)project)) != null;
    }

    public static VtlReferenceExpression createVtlReferenceExpression(String text, Project project) {
        VtlFile dummyFile = PsiUtil.createDummyFile(project, "$" + text);
        PsiElement interpolation = dummyFile.getFirstChild();
        assert (interpolation != null);
        PsiElement refStart = interpolation.getFirstChild();
        assert (refStart != null);
        PsiElement ref = refStart.getNextSibling();
        assert (ref instanceof VtlReferenceExpression);
        return (VtlReferenceExpression)ref;
    }

    public static PsiElement createIdentifierElement(Project project, String name) {
        VtlFile dummyFile = PsiUtil.createDummyFile(project, "$" + name);
        PsiElement interpolation = dummyFile.getFirstChild();
        assert (interpolation != null);
        PsiElement reference = interpolation.getLastChild();
        assert (reference != null);
        return PsiUtil.assertElementType(reference.getFirstChild(), VtlElementTypes.IDENTIFIER);
    }

    private static PsiElement assertElementType(PsiElement element, VtlTokenType type) {
        assert (element != null);
        ASTNode node = element.getNode();
        assert (node != null && node.getElementType() == type);
        return element;
    }

    public static VtlLiteralExpressionType.VtlStringLiteral createStringLiteral(Project project, String text) {
        VtlFile dummyFile = PsiUtil.createDummyFile(project, "#m(" + text + ")");
        PsiElement macroCall = dummyFile.getFirstChild();
        assert (macroCall != null);
        PsiElement rightParen = macroCall.getLastChild();
        assert (rightParen != null);
        PsiElement argList = rightParen.getPrevSibling();
        assert (argList != null);
        PsiElement stringLiteral = argList.getFirstChild();
        assert (stringLiteral instanceof VtlLiteralExpressionType.VtlStringLiteral);
        return (VtlLiteralExpressionType.VtlStringLiteral)stringLiteral;
    }

    public static VtlFile createDummyFile(Project project, String text) {
        String fileName = "dummy." + VtlFileType.INSTANCE.getDefaultExtension();
        return (VtlFile)PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, (Language)VtlLanguage.INSTANCE, (CharSequence)text, false, true);
    }

    public static boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @Nullable Set<? super PsiFile> filesVisited, @NotNull PsiElement elementToProcess) {
        PsiElement child;
        if (processor == null) {
            PsiUtil.$$$reportNull$$$0(0);
        }
        if (state == null) {
            PsiUtil.$$$reportNull$$$0(1);
        }
        if (elementToProcess == null) {
            PsiUtil.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = child = lastParent == null ? elementToProcess.getLastChild() : lastParent.getPrevSibling();
        if (child == null || child.getParent() instanceof VtlDirectiveHeader) {
            return true;
        }
        do {
            VtlFile file;
            VtlVariable assignedVariable;
            if (child instanceof VtlNamedElement && !processor.execute(child, state)) {
                return false;
            }
            if (child instanceof VtlAssignment && (assignedVariable = ((VtlAssignment)child).getAssignedVariable((FixedNameVariable)state.get(FixedNameVariable.SCOPE))) != null && !processor.execute((PsiElement)assignedVariable, state)) {
                return false;
            }
            if (child instanceof VtlDirective && CONTROL_DIRECTIVES.contains(((VtlDirective)child).getPresentableName()) && !PsiUtil.processDeclarations(processor, state, null, filesVisited, child)) {
                return false;
            }
            if (!(child instanceof VtlParse)) continue;
            if (filesVisited == null) {
                filesVisited = new HashSet<PsiFile>();
            }
            if ((file = ((VtlParse)child).resolveFile()) == null || filesVisited.contains(file)) continue;
            filesVisited.add((PsiFile)file);
            if (PsiUtil.processDeclarations(processor, ResolveState.initial(), null, filesVisited, file)) continue;
            return false;
        } while ((child = child.getPrevSibling()) != null);
        return true;
    }

    public static boolean isFormalNotationStart(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        String childText = element.getText().trim();
        return "${".equals(childText) || "$!{".equals(childText);
    }

    @NotNull
    public static String getPresentableText(@Nullable PsiType psiType) {
        if (psiType instanceof PsiWildcardType) {
            psiType = ((PsiWildcardType)psiType).getExtendsBound();
        }
        String string = psiType == null ? NULL_TYPE_NAME : psiType.getPresentableText();
        if (string == null) {
            PsiUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static PsiType getBoxedType(PsiType type, @NotNull PsiElement context) {
        if (context == null) {
            PsiUtil.$$$reportNull$$$0(4);
        }
        if (!(type instanceof PsiPrimitiveType) || PsiType.VOID.equals((Object)type)) {
            return type;
        }
        PsiClassType boxedType = ((PsiPrimitiveType)type).getBoxedType(context);
        if (boxedType == null) {
            return type;
        }
        return boxedType;
    }

    @Nullable
    public static TextRange findRange(@NotNull String source, @NotNull String startMarker, @NotNull String endMarker) {
        int start;
        if (source == null) {
            PsiUtil.$$$reportNull$$$0(5);
        }
        if (startMarker == null) {
            PsiUtil.$$$reportNull$$$0(6);
        }
        if (endMarker == null) {
            PsiUtil.$$$reportNull$$$0(7);
        }
        if ((start = source.indexOf(startMarker)) < 0) {
            return null;
        }
        int end = source.indexOf(endMarker, start += startMarker.length());
        if (end < start) {
            return null;
        }
        return new TextRange(start, end);
    }

    public static boolean isTypeOf(PsiElement element, VtlTokenType ... elementTypes) {
        if (element == null) {
            return false;
        }
        PsiElement child = element.getFirstChild();
        if (child == null) {
            return false;
        }
        IElementType childType = child.getNode().getElementType();
        for (VtlTokenType elementType : elementTypes) {
            if (childType != elementType) continue;
            return true;
        }
        return false;
    }

    public static FileReference @NotNull [] getFileReferences(@NotNull String text, @NotNull PsiElement element, int startOffset, boolean considerVelocityProperties) {
        if (text == null) {
            PsiUtil.$$$reportNull$$$0(8);
        }
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(9);
        }
        VtlFileReferenceSet set = considerVelocityProperties ? new VtlFileReferenceSet(text, element, startOffset) : new SoftFileReferenceSet(text, element, startOffset, null, true);
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            PsiUtil.$$$reportNull$$$0(10);
        }
        return fileReferenceArray;
    }

    @Nullable
    public static <T extends PsiFile> T findFile(PsiReference @NotNull [] references, Class<T> fileClass) {
        if (references == null) {
            PsiUtil.$$$reportNull$$$0(11);
        }
        for (PsiReference reference : references) {
            PsiElement target = reference.resolve();
            if (!fileClass.isInstance(target)) continue;
            return (T)((PsiFile)target);
        }
        return null;
    }

    @Nullable
    public static String getRelativePath(@NotNull PsiFile base, @NotNull PsiFile target) {
        if (base == null) {
            PsiUtil.$$$reportNull$$$0(12);
        }
        if (target == null) {
            PsiUtil.$$$reportNull$$$0(13);
        }
        VirtualFile vBase = base.getVirtualFile();
        VirtualFile vTarget = target.getVirtualFile();
        return vBase != null && vTarget != null ? VfsUtilCore.findRelativePath((VirtualFile)vBase, (VirtualFile)vTarget, (char)'/') : null;
    }

    @Nullable
    public static String getRelativePath(@Nullable String basePath, @Nullable String targetPath) {
        if (basePath == null || targetPath == null) {
            return null;
        }
        String relativePath = FileUtil.getRelativePath((File)new File(basePath), (File)new File(targetPath));
        if (relativePath == null) {
            return null;
        }
        return FileUtil.toSystemIndependentName((String)relativePath);
    }

    @Nullable
    public static String getPath(@NotNull PsiFile file) {
        VirtualFile baseFile;
        if (file == null) {
            PsiUtil.$$$reportNull$$$0(14);
        }
        if ((baseFile = file.getVirtualFile()) == null) {
            return null;
        }
        return baseFile.getPath();
    }

    public static LookupElement createPsiTypeLookupElement(PsiElement element, String typeName) {
        return (LookupElement)ReadAction.compute(() -> {
            try {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory();
                return new PsiTypeCanonicalLookupElement(elementFactory.createTypeFromText(typeName, element));
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToProcess";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/psi/PsiUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startMarker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endMarker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/psi/PsiUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 3: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBoxedType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileReferences";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

