/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.VtlInspectionBase;
import com.intellij.velocity.psi.directives.VtlSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VtlDirectiveArgsInspection
extends VtlInspectionBase {
    @Override
    protected void registerProblems(PsiElement element, ProblemsHolder holder) {
        if (element instanceof VtlSet) {
            VtlSet vtlSet = (VtlSet)element;
            if (vtlSet.getAssignedMethodCallExpression() != null) {
                holder.registerProblem(vtlSet.getFirstChild(), VelocityBundle.message("assignment.to.method.call", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
            } else {
                PsiType assignedType = vtlSet.getAssignedVariableElementType(null);
                if (PsiType.VOID.equals((Object)assignedType)) {
                    holder.registerProblem(vtlSet.getFirstChild(), VelocityBundle.message("assignment.of.void", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                }
            }
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "VtlDirectiveArgsInspection";
    }
}

