/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.DefineInCommentIntention;
import com.intellij.velocity.inspections.Util;
import com.intellij.velocity.psi.files.VelocityPropertiesProvider;
import com.intellij.velocity.psi.reference.VtlFileReferenceSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefineVelocityPropertiesRefForFilesIntention
extends DefineInCommentIntention {
    public DefineVelocityPropertiesRefForFilesIntention(@NotNull @IntentionName String text) {
        if (text == null) {
            DefineVelocityPropertiesRefForFilesIntention.$$$reportNull$$$0(0);
        }
        super(text, VelocityBundle.message("add.velocity.properties.ref.fix.name", new Object[0]));
    }

    @Override
    @Nullable
    protected PsiElement getReferenceElement(@NotNull Editor editor, @NotNull PsiFile file) {
        FileReference ref;
        if (editor == null) {
            DefineVelocityPropertiesRefForFilesIntention.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DefineVelocityPropertiesRefForFilesIntention.$$$reportNull$$$0(2);
        }
        return (ref = Util.findReferenceExpression(editor, file, FileReference.class)) != null && ref.resolve() == null && Util.canSetVelocityProperties(file) ? ref.getElement() : null;
    }

    @Override
    protected void prepareTemplate(@NotNull Template template, @NotNull PsiElement element, String relativePath, @NotNull PsiFile fileToInsertComment) {
        if (template == null) {
            DefineVelocityPropertiesRefForFilesIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            DefineVelocityPropertiesRefForFilesIntention.$$$reportNull$$$0(4);
        }
        if (fileToInsertComment == null) {
            DefineVelocityPropertiesRefForFilesIntention.$$$reportNull$$$0(5);
        }
        List<String> allFiles = DefineVelocityPropertiesRefForFilesIntention.computeFilePaths(element, fileToInsertComment);
        template.addTextSegment("#* @velocityproperties path=");
        ConstantNode pathExpression = new ConstantNode((String)ContainerUtil.getOnlyItem(allFiles)).withLookupStrings(allFiles);
        template.addVariable("PATH", (Expression)pathExpression, (Expression)pathExpression, true);
        Object fileRef = relativePath != null ? " file=\"" + relativePath + "\"" : "";
        template.addTextSegment((String)fileRef + " *#\n");
        template.addEndVariable();
    }

    private static List<String> computeFilePaths(PsiElement element, PsiFile fileToInsertComment) {
        VtlFileReferenceSet refSet = Util.findVtlFileReferenceSet(element);
        if (refSet == null) {
            return Collections.emptyList();
        }
        PsiFile[] referencedFiles = Util.findReferencedFiles(ModuleUtilCore.findModuleForPsiElement((PsiElement)element), refSet.getLastReference().getCanonicalText());
        if (referencedFiles.length == 0) {
            return Collections.emptyList();
        }
        return Util.collectFilePaths(element, psiFile -> {
            PsiFile file = psiFile.getViewProvider().getPsi((Language)PropertiesLanguage.INSTANCE);
            if (file instanceof PropertiesFile) {
                PropertiesFile propFile = (PropertiesFile)file;
                VelocityPropertiesProvider velocityProperties = new VelocityPropertiesProvider(propFile);
                for (PsiFile referencedFile : referencedFiles) {
                    String referencedFilePath = referencedFile.getViewProvider().getVirtualFile().getPath();
                    String filePath = Util.computeFilePath(velocityProperties, referencedFilePath, refSet.getPathString(), fileToInsertComment);
                    if (filePath == null) continue;
                    return filePath;
                }
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToInsertComment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ModuleWide
    extends DefineVelocityPropertiesRefForFilesIntention {
        public ModuleWide() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.module.wide", new Object[0]));
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                ModuleWide.$$$reportNull$$$0(0);
            }
            this.chooseTargetFile(file, editor, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention$ModuleWide", "invoke"));
        }
    }

    public static class LocalExternal
    extends DefineVelocityPropertiesRefForFilesIntention {
        public LocalExternal() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.external", new Object[0]));
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                LocalExternal.$$$reportNull$$$0(0);
            }
            this.chooseTargetFile(file, editor, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention$LocalExternal", "invoke"));
        }
    }

    public static class Local
    extends DefineVelocityPropertiesRefForFilesIntention {
        public Local() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.local", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                Local.$$$reportNull$$$0(0);
            }
            this.defineInComment(editor, file, file, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefForFilesIntention$Local", "invoke"));
        }
    }
}

