/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.velocity.Icons;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.VtlFileIndex;
import com.intellij.velocity.inspections.Util;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlLoopVariable;
import com.intellij.velocity.psi.VtlParameterDeclaration;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.files.VtlFileViewProvider;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefineInCommentIntention
implements IntentionAction {
    @Nls
    private final String myText;
    @Nls
    private final String myFamilyName;
    public static final String VELOCITY_IMPLICIT_VM = "velocity_implicit.vm";

    public DefineInCommentIntention(@NotNull @IntentionName String text, @NotNull @IntentionFamilyName String familyName) {
        if (text == null) {
            DefineInCommentIntention.$$$reportNull$$$0(0);
        }
        if (familyName == null) {
            DefineInCommentIntention.$$$reportNull$$$0(1);
        }
        this.myText = text;
        this.myFamilyName = familyName;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            DefineInCommentIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            DefineInCommentIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            DefineInCommentIntention.$$$reportNull$$$0(4);
        }
        return file.getViewProvider() instanceof VtlFileViewProvider && this.getReferenceElement(editor, file) != null && ModuleUtilCore.findModuleForPsiElement((PsiElement)file) != null;
    }

    @Nullable
    protected PsiElement getReferenceElement(@NotNull Editor editor, @NotNull PsiFile file) {
        VtlReferenceExpression ref;
        if (editor == null) {
            DefineInCommentIntention.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DefineInCommentIntention.$$$reportNull$$$0(6);
        }
        if ((ref = Util.findReferenceExpression(editor, file)) == null) {
            return null;
        }
        PsiElement resolve = ref.resolve();
        if (resolve instanceof VtlParameterDeclaration || resolve instanceof VtlLoopVariable || ref.multiResolve(false).length == 0) {
            return this.isAvailable(ref) ? ref : null;
        }
        return null;
    }

    protected boolean isAvailable(@NotNull VtlReferenceExpression ref) {
        if (ref == null) {
            DefineInCommentIntention.$$$reportNull$$$0(7);
        }
        return true;
    }

    protected void defineInComment(Editor editor, PsiFile fileWithVarReference, PsiFile fileToInsertComment, boolean addFileReference) {
        PsiElement ref = this.getReferenceElement(editor, fileWithVarReference);
        assert (ref != null);
        Project project = fileWithVarReference.getProject();
        if (!FileModificationService.getInstance().prepareFileForWrite(fileToInsertComment)) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document documentToInsertComment = documentManager.getDocument(fileToInsertComment);
        assert (documentToInsertComment != null);
        WriteCommandAction.writeCommandAction((Project)project).run(() -> {
            Editor e = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, fileToInsertComment.getViewProvider().getVirtualFile(), 0), true);
            assert (e != null);
            assert (documentToInsertComment == e.getDocument());
            int insertionIndex = this.calcInsertionIndex(documentToInsertComment);
            e.getCaretModel().moveToOffset(insertionIndex);
            TemplateManager manager = TemplateManager.getInstance((Project)project);
            Template template = manager.createTemplate("", "");
            String relativePath = addFileReference ? PsiUtil.getRelativePath(fileToInsertComment, fileWithVarReference) : null;
            this.prepareTemplate(template, ref, relativePath, fileToInsertComment);
            manager.startTemplate(e, template);
        });
    }

    protected int calcInsertionIndex(Document documentToInsertComment) {
        return documentToInsertComment.getText().startsWith("#* @implicitly included *#\n") ? "#* @implicitly included *#\n".length() : 0;
    }

    protected abstract void prepareTemplate(@NotNull Template var1, @NotNull PsiElement var2, @Nullable String var3, @NotNull PsiFile var4);

    protected void chooseTargetFile(final PsiFile file, final Editor editor, final boolean addFileReference) {
        Collection<VtlFile> implicitlyIncludedFiles = VtlFileIndex.getImplicitlyIncludedFiles(file);
        if (implicitlyIncludedFiles.size() == 1) {
            this.defineInComment(editor, file, (PsiFile)implicitlyIncludedFiles.iterator().next(), addFileReference);
            return;
        }
        if (implicitlyIncludedFiles.size() < 1) {
            VtlFile newTargetFile;
            try {
                newTargetFile = (VtlFile)WriteCommandAction.runWriteCommandAction((Project)file.getProject(), () -> {
                    VirtualFile virtualFile = this.createVelocityImplicitVmFile(file);
                    if (virtualFile == null) {
                        return null;
                    }
                    VfsUtil.saveText((VirtualFile)virtualFile, (String)"#* @implicitly included *#\n");
                    PsiFile psiFile = file.getManager().findFile(virtualFile);
                    if (psiFile instanceof VtlFile) {
                        return (VtlFile)psiFile;
                    }
                    return null;
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (newTargetFile != null) {
                this.defineInComment(editor, file, (PsiFile)newTargetFile, addFileReference);
            }
            return;
        }
        BaseListPopupStep<VtlFile> step = new BaseListPopupStep<VtlFile>(VelocityBundle.message("choose.external.definitions.file", new Object[0]), implicitlyIncludedFiles.toArray(new VtlFile[0])){

            @NotNull
            public String getTextFor(VtlFile value) {
                String string = value.getViewProvider().getVirtualFile().getName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(VtlFile selectedValue, boolean finalChoice) {
                if (finalChoice) {
                    DefineInCommentIntention.this.defineInComment(editor, file, (PsiFile)selectedValue, addFileReference);
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public Icon getIconFor(VtlFile aValue) {
                return Icons.VTL_ICON;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/DefineInCommentIntention$1", "getTextFor"));
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).showInBestPositionFor(editor);
    }

    @Nullable
    private VirtualFile createVelocityImplicitVmFile(PsiFile file) throws IOException {
        VirtualFile dir;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        VirtualFile[] roots = module == null ? VirtualFile.EMPTY_ARRAY : ModuleRootManager.getInstance((Module)module).getSourceRoots();
        PsiDirectory psiDirectory = file.getContainingDirectory();
        Object object = roots.length > 0 ? roots[0] : (dir = psiDirectory != null ? psiDirectory.getVirtualFile() : null);
        if (dir == null) {
            return null;
        }
        List existingNames = ContainerUtil.map((Object[])dir.getChildren(), virtualFile -> virtualFile.getName());
        return dir.createChildData((Object)this, UniqueNameGenerator.generateUniqueName((String)"velocity_implicit", (String)"", (String)".vm", (Collection)existingNames));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/inspections/DefineInCommentIntention";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/inspections/DefineInCommentIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

