/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.i18n;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeAction;
import com.intellij.codeInspection.i18n.I18nizeHandlerProvider;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;

public class VtlI18nProvider
extends I18nizeHandlerProvider {
    private static final String VELOCITY_I18N_EXPRESSION = "velocity.i18n.expression";

    @Nullable
    public I18nQuickFixHandler<?> getHandler(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull TextRange range) {
        if (psiFile == null) {
            VtlI18nProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            VtlI18nProvider.$$$reportNull$$$0(1);
        }
        if (range == null) {
            VtlI18nProvider.$$$reportNull$$$0(2);
        }
        if (psiFile instanceof VtlFile && PsiUtilCore.getLanguageAtOffset((PsiFile)psiFile, (int)range.getStartOffset()) != VtlLanguage.INSTANCE) {
            return new I18nQuickFixHandler<UExpression>(){

                public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
                    this.getSelectedTemplateText(psiFile, editor);
                }

                private String getSelectedTemplateText(PsiFile psiFile, Editor editor) {
                    TextRange selectedRange = JavaI18nUtil.getSelectedRange((Editor)editor, (PsiFile)psiFile);
                    if (selectedRange == null) {
                        throw new IncorrectOperationException("Please select a text fragment");
                    }
                    PsiElement start = psiFile.getViewProvider().findElementAt(selectedRange.getStartOffset(), (Language)VtlLanguage.INSTANCE);
                    if (start == null || start.getNode().getElementType() != VtlElementTypes.TEMPLATE_TEXT || start.getTextRange().getEndOffset() < selectedRange.getEndOffset()) {
                        throw new IncorrectOperationException("Please select some template text");
                    }
                    return selectedRange.substring(psiFile.getText());
                }

                public void performI18nization(PsiFile psiFile, Editor editor, UExpression literalExpression, Collection<PropertiesFile> propertiesFiles, String key, String value, String i18nizedText, UExpression[] parameters, PropertyCreationHandler propertyCreationHandler) throws IncorrectOperationException {
                    Project project = psiFile.getProject();
                    propertyCreationHandler.createProperty(project, propertiesFiles, key, value, parameters);
                    TextRange range = JavaI18nUtil.getSelectedRange((Editor)editor, (PsiFile)psiFile);
                    assert (range != null);
                    editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)("(\"" + key + "\")"));
                    VtlI18nProvider.editI18nExpression(editor, project, range.getStartOffset());
                }

                public UExpression getEnclosingLiteral(PsiFile file, Editor editor) {
                    return I18nizeAction.getEnclosingStringLiteral((PsiFile)file, (Editor)editor);
                }

                @Nullable
                public JavaI18nizeQuickFixDialog<UExpression> createDialog(Project project, Editor editor, PsiFile psiFile) {
                    return new JavaI18nizeQuickFixDialog(project, psiFile, null, this.getSelectedTemplateText(psiFile, editor), null, false, false);
                }
            };
        }
        return null;
    }

    private static void editI18nExpression(final Editor editor, Project project, int offset) {
        editor.getSelectionModel().removeSelection();
        editor.getCaretModel().moveToOffset(offset);
        final RangeMarker marker = editor.getDocument().createRangeMarker(offset, offset);
        marker.setGreedyToLeft(true);
        marker.setGreedyToRight(true);
        final PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
        template.addVariable((Expression)new ConstantNode(propertiesComponent.getValue(VELOCITY_I18N_EXPRESSION, "#m")), true);
        TemplateManager.getInstance((Project)project).startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!brokenOff && marker.isValid()) {
                    String newExpr = editor.getDocument().getText().substring(marker.getStartOffset(), marker.getEndOffset());
                    propertiesComponent.setValue(VtlI18nProvider.VELOCITY_I18N_EXPRESSION, newExpr, "#m");
                }
                marker.dispose();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/velocity/i18n/VtlI18nProvider$2", "templateFinished"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
        }
        objectArray[1] = "com/intellij/velocity/i18n/VtlI18nProvider";
        objectArray[2] = "getHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

