/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.javadoc.JavaDocInfoGeneratorFactory;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlVariable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return QuickDocUtil.inferLinkFromFullDocumentation((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement, (String)VtlDocumentationProvider.getQuickNavigateInfoInner(element));
    }

    @NlsSafe
    private static String getQuickNavigateInfoInner(PsiElement element) {
        if (element instanceof VtlVariable) {
            VtlVariable variable = (VtlVariable)element;
            String name = variable.getName();
            PsiType type = variable.getPsiType();
            if (type != null) {
                return type.getPresentableText() + " " + name;
            }
            return name;
        }
        if (element instanceof BeanPropertyElement) {
            return JavaDocumentationProvider.generateMethodInfo((PsiMethod)((BeanPropertyElement)element).getMethod(), (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
        if (element instanceof PsiClass) {
            return JavaDocumentationProvider.generateClassInfo((PsiClass)((PsiClass)element));
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return JavaDocumentationProvider.getExternalJavaDocUrl((PsiElement)VtlDocumentationProvider.substituteElement(element));
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        if ((element = VtlDocumentationProvider.substituteElement(element)) instanceof PsiMember) {
            return JavaDocumentationProvider.generateExternalJavadoc((PsiElement)element);
        }
        if (element instanceof VtlMacro) {
            StringBuilder doc = new StringBuilder();
            doc.append("<div class='definition'><pre>");
            int headerEnd = element.getText().indexOf(41);
            if (headerEnd > 0) {
                doc.append(element.getText(), 0, headerEnd + 1);
            }
            doc.append("</pre></div>");
            VtlDocumentationProvider.appendDocComment(element, doc, ((VtlMacro)element).getDocComment());
            return doc.toString();
        }
        if (element instanceof VtlVariable) {
            StringBuilder doc = new StringBuilder();
            doc.append("<div class='definition'><pre>");
            PsiType type = ((VtlVariable)element).getPsiType();
            if (type != null) {
                JavaDocInfoGenerator.generateType((StringBuilder)doc, (PsiType)type, (PsiElement)element, (boolean)true);
                doc.append(" ");
            }
            doc.append("$");
            doc.append(((VtlVariable)element).getName());
            doc.append("</pre></div>");
            VtlDocumentationProvider.appendDocComment(element, doc, ((VtlVariable)element).getDocComment());
            return doc.toString();
        }
        return null;
    }

    private static void appendDocComment(PsiElement element, StringBuilder doc, @Nullable PsiComment comment) {
        if (comment != null) {
            Project project = comment.getProject();
            String javaText = "/" + comment.getText().substring(1, comment.getTextLength() - 1) + "/";
            PsiDocComment javaComment = JavaPsiFacade.getElementFactory((Project)project).createDocCommentFromText(javaText);
            JavaDocInfoGeneratorFactory.create((Project)project, (PsiElement)element).generateCommonSection(doc, javaComment);
            doc.append("</table>");
        }
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls, boolean onHover) {
        return JavaDocumentationProvider.fetchExternalJavadoc((PsiElement)VtlDocumentationProvider.substituteElement(element), (Project)project, docUrls);
    }

    private static PsiElement substituteElement(PsiElement element) {
        if (element instanceof BeanPropertyElement) {
            element = ((BeanPropertyElement)element).getMethod();
        }
        return element;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof VtlVariable || object instanceof BeanPropertyElement || object instanceof VtlMacro) {
            return (PsiElement)object;
        }
        if (object instanceof String && element.textContains('#')) {
            return VtlDocumentationProvider.findDirectiveClass((String)object, element);
        }
        return null;
    }

    private static PsiClass findDirectiveClass(String directive, PsiElement context) {
        String className = "org.apache.velocity.runtime.directive." + StringUtil.capitalize((String)directive);
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(className, context.getResolveScope());
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        String name;
        String text;
        if (editor == null) {
            VtlDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            VtlDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (contextElement != null && (text = contextElement.getText()).startsWith("#") && StringUtil.isJavaIdentifier((String)(name = text.substring(1)))) {
            return VtlDocumentationProvider.findDirectiveClass(name, contextElement);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/velocity/VtlDocumentationProvider";
        objectArray[2] = "getCustomDocumentationElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

