/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.view.toolwindow;

import com.intellij.analysis.pwa.analyser.PwaFileWithProblems;
import com.intellij.analysis.pwa.analyser.PwaProblem;
import com.intellij.analysis.pwa.analyser.listeners.PwaResultsListener;
import com.intellij.analysis.pwa.view.toolwindow.PwaProblemsView;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/analysis/pwa/view/toolwindow/PwaProblemsViewImpl;", "Lcom/intellij/analysis/pwa/view/toolwindow/PwaProblemsView;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "errorPanel", "Lcom/intellij/ide/errorTreeView/NewErrorTreeViewPanel;", "dispose", "", "init", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "update", "fileWithProblems", "Lcom/intellij/analysis/pwa/analyser/PwaFileWithProblems;", "intellij.pwa.core"})
final class PwaProblemsViewImpl
implements PwaProblemsView,
Disposable {
    private final NewErrorTreeViewPanel errorPanel;

    @Override
    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        Content content = contentManager2.getFactory().createContent((JComponent)this.errorPanel, "Errors", false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"contentManager.factory.c\u2026orPanel, \"Errors\", false)");
        Content errorPanelContent = content;
        errorPanelContent.setCloseable(false);
        contentManager2.addContent(errorPanelContent);
        Disposer.register((Disposable)this, (Disposable)new Disposable(contentManager2){
            final /* synthetic */ ContentManager $contentManager;

            public final void dispose() {
                this.$contentManager.removeAllContents(true);
            }
            {
                this.$contentManager = contentManager;
            }
        });
    }

    @Override
    public void update(@NotNull PwaFileWithProblems fileWithProblems) {
        Intrinsics.checkNotNullParameter((Object)fileWithProblems, (String)"fileWithProblems");
        VirtualFile path = fileWithProblems.getFile();
        this.errorPanel.removeAllInGroup(path.getPresentableUrl());
        for (PwaProblem problem : fileWithProblems.getProblems()) {
            this.errorPanel.addMessage(4, new String[]{problem.getText()}, path, problem.getLine(), problem.getColumn(), null);
        }
    }

    public void dispose() {
    }

    public PwaProblemsViewImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.errorPanel = new NewErrorTreeViewPanel(project2, null, false, true, null);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public final void dispose() {
                Disposer.dispose((Disposable)((Disposable)errorPanel));
            }
        });
        project2.getMessageBus().connect((Disposable)this).subscribe(PwaResultsListener.Companion.getTOPIC(), (Object)new PwaResultsListener(){

            @Override
            public void filesUpdated(@NotNull Project project2, @NotNull List<PwaFileWithProblems> updated) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter(updated, (String)"updated");
                for (PwaFileWithProblems problems2 : updated) {
                    this.update(problems2);
                }
            }
        });
    }
}

