/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.view;

import com.intellij.analysis.pwa.settings.PwaSettings;
import com.intellij.analysis.pwa.utils.PwaBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.GotItTooltip;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/analysis/pwa/view/PwaTooltipService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "disablePwaTooltip", "Lcom/intellij/ui/GotItTooltip;", "enablePwaTooltip", "createTooltip", "turnedOn", "", "dispose", "", "showTooltip", "component", "Ljavax/swing/JComponent;", "intellij.pwa.core"})
public final class PwaTooltipService
implements Disposable {
    private final GotItTooltip disablePwaTooltip;
    private final GotItTooltip enablePwaTooltip;
    private final Project project;

    public final void showTooltip(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.disablePwaTooltip.hidePopup();
        this.enablePwaTooltip.hidePopup();
        boolean turnedOn = PwaSettings.Companion.getInstance(this.project).isEnabled();
        GotItTooltip tooltip = turnedOn ? this.disablePwaTooltip : this.enablePwaTooltip;
        tooltip.show(component, (Function2)new Function2<Component, Balloon, Point>(component){
            final /* synthetic */ JComponent $component;

            @NotNull
            public final Point invoke(@NotNull Component $noName_0, @NotNull Balloon $noName_1) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                return new Point(this.$component.getWidth(), this.$component.getHeight());
            }
            {
                this.$component = jComponent;
                super(2);
            }
        });
    }

    public void dispose() {
    }

    private final GotItTooltip createTooltip(boolean turnedOn) {
        String headerText = PwaBundle.Companion.message(turnedOn ? "toggle.pwa.popup.turned.on.header" : "toggle.pwa.popup.turned.off.header", new Object[0]);
        String text = PwaBundle.Companion.message("toggle.pwa.popup.content", new Object[0]);
        String buttonText = PwaBundle.Companion.message(turnedOn ? "toggle.pwa.disable.analysis.button" : "toggle.pwa.enable.analysis.button", new Object[0]);
        return new GotItTooltip("pwa.toggle", text, (Disposable)this).withShowCount(Integer.MAX_VALUE).withHeader(headerText).withHideOnClickOutside().withTimeout(10000).withLink(buttonText, (Function0)new Function0<Unit>(this, turnedOn){
            final /* synthetic */ PwaTooltipService this$0;
            final /* synthetic */ boolean $turnedOn;

            public final void invoke() {
                PwaSettings.Companion.getInstance(PwaTooltipService.access$getProject$p(this.this$0)).setEnabled(PwaTooltipService.access$getProject$p(this.this$0), !this.$turnedOn);
            }
            {
                this.this$0 = pwaTooltipService;
                this.$turnedOn = bl;
                super(0);
            }
        });
    }

    public PwaTooltipService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.disablePwaTooltip = this.createTooltip(true);
        this.enablePwaTooltip = this.createTooltip(false);
    }

    public static final /* synthetic */ Project access$getProject$p(PwaTooltipService $this) {
        return $this.project;
    }
}

