/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.storage.indexes;

import com.intellij.analysis.pwa.analyser.FileIdList;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.HashesList;
import com.intellij.analysis.pwa.analyser.PwaFileOwnState;
import com.intellij.analysis.pwa.analyser.PwaFileState;
import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.storage.PwaFileStateStorage;
import com.intellij.analysis.pwa.storage.PwaFileStateWithId;
import com.intellij.analysis.pwa.storage.PwaPersistentFileWithProblems;
import com.intellij.analysis.pwa.storage.indexes.DeclaredSymbolsHashesListExternalizer;
import com.intellij.analysis.pwa.storage.indexes.FileStateExternalizer;
import com.intellij.analysis.pwa.storage.indexes.PwaDependenciesIndexExtension;
import com.intellij.analysis.pwa.storage.indexes.PwaFileDependencyInfo;
import com.intellij.analysis.pwa.storage.indexes.PwaIndexFileStateStorage;
import com.intellij.analysis.pwa.storage.indexes.PwaIndexFileStateStorage$findFilesWithDependencies$;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.function.IntConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\"\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\n2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u0016\u0010#\u001a\u0004\u0018\u00010\u00122\n\u0010$\u001a\u00060\u0007j\u0002`%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u000bH\u0016J\u0016\u0010.\u001a\u00020\u00142\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\u000b\u0012\u0002\b\u00030\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/analysis/pwa/storage/indexes/PwaIndexFileStateStorage;", "Lcom/intellij/analysis/pwa/storage/PwaFileStateStorage;", "folderPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "dependenciesIndex", "Lcom/intellij/util/indexing/impl/MapReduceIndex;", "", "Lcom/intellij/analysis/pwa/storage/indexes/PwaFileDependencyInfo;", "globalSymbolsMap", "Lcom/intellij/util/io/PersistentHashMap;", "Lcom/intellij/analysis/pwa/declared/SymbolHashesList;", "lock", "", "myFlushingFuture", "Ljava/util/concurrent/ScheduledFuture;", "Lorg/jetbrains/annotations/NotNull;", "stateMap", "Lcom/intellij/analysis/pwa/analyser/PwaFileOwnState;", "clear", "", "close", "createGlobalSymbolsMap", "path", "createMap", "createStateMap", "findFilesWithDependencies", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "nameHashes", "Lcom/intellij/analysis/pwa/analyser/HashesList;", "getAllFilesWithProblems", "", "Lcom/intellij/analysis/pwa/storage/PwaPersistentFileWithProblems;", "getGlobalSymbols", "id", "getState", "fileId", "Lcom/intellij/analysis/pwa/analyser/VFileId;", "getStates", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "fileIds", "Lcom/intellij/analysis/pwa/analyser/FileIdList;", "isEmpty", "", "setGlobalSymbols", "hashes", "updateStates", "changed", "", "Lcom/intellij/analysis/pwa/storage/PwaFileStateWithId;", "Companion", "intellij.pwa.core"})
public final class PwaIndexFileStateStorage
implements PwaFileStateStorage {
    private final Object lock;
    private PersistentHashMap<Integer, PwaFileOwnState> stateMap;
    private PersistentHashMap<Integer, SymbolHashesList> globalSymbolsMap;
    private final MapReduceIndex<Integer, Integer, PwaFileDependencyInfo> dependenciesIndex;
    private final ScheduledFuture<?> myFlushingFuture;
    private final Path folderPath;
    private static final int CACHE_SIZE_BYTES = 16384;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean isEmpty() {
        return this.stateMap.processKeysWithExistingMapping((Processor)isEmpty.1.INSTANCE);
    }

    private final PersistentHashMap<Integer, PwaFileOwnState> createStateMap(Path path) {
        return new PersistentHashMap(path.resolve("state"), (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)FileStateExternalizer.INSTANCE);
    }

    private final PersistentHashMap<Integer, SymbolHashesList> createGlobalSymbolsMap(Path path) {
        return new PersistentHashMap(path.resolve("globalSymbols"), (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)DeclaredSymbolsHashesListExternalizer.INSTANCE);
    }

    private final MapReduceIndex<Integer, Integer, PwaFileDependencyInfo> createMap(Path path) {
        Path storageFile = path.resolve("depsStorage");
        Path mapFile = path.resolve("depsMap");
        MapIndexStorage storage = new MapIndexStorage(storageFile, (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)new IntInlineKeyDescriptor(), 16384, false, true, false, null);
        PersistentMapBasedForwardIndex forwardIndex = new PersistentMapBasedForwardIndex(mapFile, false);
        KeyCollectionForwardIndexAccessor forwardIndexAccessor = new KeyCollectionForwardIndexAccessor((IndexExtension)PwaDependenciesIndexExtension.INSTANCE);
        return (MapReduceIndex)new MapReduceIndex<Integer, Integer, PwaFileDependencyInfo>(storage, forwardIndex, forwardIndexAccessor, (IndexExtension)PwaDependenciesIndexExtension.INSTANCE, (IndexStorage)storage, (ForwardIndex)forwardIndex, (ForwardIndexAccessor)forwardIndexAccessor){
            final /* synthetic */ MapIndexStorage $storage;
            final /* synthetic */ PersistentMapBasedForwardIndex $forwardIndex;
            final /* synthetic */ KeyCollectionForwardIndexAccessor $forwardIndexAccessor;

            public void checkCanceled() {
                ProgressManager.checkCanceled();
            }

            protected void requestRebuild(@NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
            {
                this.$storage = $captured_local_variable$0;
                this.$forwardIndex = $captured_local_variable$1;
                this.$forwardIndexAccessor = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalSymbols(int id, @NotNull SymbolHashesList hashes) {
        Intrinsics.checkNotNullParameter((Object)hashes, (String)"hashes");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.globalSymbolsMap.put((Object)id, (Object)hashes);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SymbolHashesList getGlobalSymbols(int id) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            SymbolHashesList symbolHashesList = (SymbolHashesList)this.globalSymbolsMap.get((Object)id);
            return symbolHashesList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStates(@NotNull Iterable<? extends PwaFileStateWithId> changed) {
        Intrinsics.checkNotNullParameter(changed, (String)"changed");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            for (PwaFileStateWithId pwaFileStateWithId : changed) {
                int fileId = pwaFileStateWithId.getFileId();
                PwaFileState fileState = pwaFileStateWithId.getState();
                if (fileState == null) {
                    this.stateMap.remove((Object)fileId);
                    this.dependenciesIndex.mapInputAndPrepareUpdate(fileId, null).compute();
                    continue;
                }
                this.stateMap.put((Object)fileId, (Object)fileState.getOwnState());
                this.dependenciesIndex.mapInputAndPrepareUpdate(fileId, (Object)new PwaFileDependencyInfo(fileId, fileState.getUsedSymbols())).compute();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FileIdSet findFilesWithDependencies(@NotNull HashesList nameHashes) {
        Intrinsics.checkNotNullParameter((Object)nameHashes, (String)"nameHashes");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            IntOpenHashSet files = new IntOpenHashSet();
            nameHashes.forEach(new IntConsumer(files, this, nameHashes){
                final /* synthetic */ IntOpenHashSet $files;
                final /* synthetic */ PwaIndexFileStateStorage this$0;
                final /* synthetic */ HashesList $nameHashes$inlined;
                {
                    this.$files = intOpenHashSet;
                    this.this$0 = pwaIndexFileStateStorage;
                    this.$nameHashes$inlined = hashesList;
                }

                public final void accept(int dependency) {
                    PwaIndexFileStateStorage.access$getDependenciesIndex$p(this.this$0).getData((Object)dependency).forEach(new ValueContainer.ContainerAction(this){
                        final /* synthetic */ findFilesWithDependencies$$inlined$synchronized$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final boolean perform(int $noName_0, Integer filesUsesDep) {
                            IntOpenHashSet intOpenHashSet = this.this$0.$files;
                            Integer n = filesUsesDep;
                            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"filesUsesDep");
                            intOpenHashSet.add(n.intValue());
                            return true;
                        }
                    });
                }
            });
            FileIdSet fileIdSet = new FileIdSet((IntSet)files);
            return fileIdSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Int2ObjectMap<PwaFileOwnState> getStates(@NotNull FileIdList fileIds) {
        Intrinsics.checkNotNullParameter((Object)fileIds, (String)"fileIds");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Int2ObjectOpenHashMap states = new Int2ObjectOpenHashMap();
            fileIds.forEach(new IntConsumer(states, this, fileIds){
                final /* synthetic */ Int2ObjectOpenHashMap $states;
                final /* synthetic */ PwaIndexFileStateStorage this$0;
                final /* synthetic */ FileIdList $fileIds$inlined;
                {
                    this.$states = int2ObjectOpenHashMap;
                    this.this$0 = pwaIndexFileStateStorage;
                    this.$fileIds$inlined = fileIdList;
                }

                public final void accept(int it) {
                    ((Map)this.$states).put(it, PwaIndexFileStateStorage.access$getStateMap$p(this.this$0).get((Object)it));
                }
            });
            Int2ObjectMap int2ObjectMap = (Int2ObjectMap)states;
            return int2ObjectMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<PwaPersistentFileWithProblems> getAllFilesWithProblems() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            ArrayList filesWithProblems = new ArrayList();
            this.stateMap.processKeysWithExistingMapping(new Processor(filesWithProblems, this){
                final /* synthetic */ ArrayList $filesWithProblems;
                final /* synthetic */ PwaIndexFileStateStorage this$0;
                {
                    this.$filesWithProblems = arrayList;
                    this.this$0 = pwaIndexFileStateStorage;
                }

                public final boolean process(Integer it) {
                    PwaFileOwnState state = (PwaFileOwnState)PwaIndexFileStateStorage.access$getStateMap$p(this.this$0).get((Object)it);
                    Collection collection = state.getProblems();
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        Integer n = it;
                        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"it");
                        this.$filesWithProblems.add(new PwaPersistentFileWithProblems(n, state.getProblems()));
                    }
                    return true;
                }
            });
            List list = filesWithProblems;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PwaFileOwnState getState(int fileId) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            PwaFileOwnState pwaFileOwnState = (PwaFileOwnState)this.stateMap.get((Object)fileId);
            return pwaFileOwnState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.dependenciesIndex.clear();
            this.stateMap.closeAndClean();
            this.stateMap = this.createStateMap(this.folderPath);
            this.globalSymbolsMap.closeAndClean();
            this.globalSymbolsMap = this.createGlobalSymbolsMap(this.folderPath);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.myFlushingFuture.cancel(false);
            try {
                this.dependenciesIndex.flush();
                this.dependenciesIndex.dispose();
                this.stateMap.force();
                this.stateMap.close();
                this.globalSymbolsMap.force();
                this.globalSymbolsMap.close();
            }
            catch (Exception e) {
                logger.warn("Exception occurred while closing PWA state index", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public PwaIndexFileStateStorage(@NotNull Path folderPath) {
        Intrinsics.checkNotNullParameter((Object)folderPath, (String)"folderPath");
        this.folderPath = folderPath;
        this.lock = new Object();
        this.stateMap = this.createStateMap(this.folderPath);
        this.globalSymbolsMap = this.createGlobalSymbolsMap(this.folderPath);
        this.dependenciesIndex = this.createMap(this.folderPath);
        ScheduledFuture scheduledFuture2 = FlushingDaemon.everyFiveSeconds((Runnable)new Runnable(this){
            final /* synthetic */ PwaIndexFileStateStorage this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Object object = PwaIndexFileStateStorage.access$getLock$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    if (PwaIndexFileStateStorage.access$getStateMap$p(this.this$0).isClosed()) {
                        return;
                    }
                    try {
                        PwaIndexFileStateStorage.access$getStateMap$p(this.this$0).force();
                        PwaIndexFileStateStorage.access$getGlobalSymbolsMap$p(this.this$0).force();
                        PwaIndexFileStateStorage.access$getDependenciesIndex$p(this.this$0).flush();
                    }
                    catch (Exception e) {
                        PwaIndexFileStateStorage.access$getLogger$cp().warn("Error while flushing PWA indexes", (Throwable)e);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = pwaIndexFileStateStorage;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)scheduledFuture2, (String)"FlushingDaemon.everyFive\u2026es\", e)\n      }\n    }\n  }");
        this.myFlushingFuture = scheduledFuture2;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaIndexFileStateStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        PwaIndexFileStateStorage.logger = logger;
    }

    public static final /* synthetic */ MapReduceIndex access$getDependenciesIndex$p(PwaIndexFileStateStorage $this) {
        return $this.dependenciesIndex;
    }

    public static final /* synthetic */ PersistentHashMap access$getStateMap$p(PwaIndexFileStateStorage $this) {
        return $this.stateMap;
    }

    public static final /* synthetic */ void access$setStateMap$p(PwaIndexFileStateStorage $this, PersistentHashMap persistentHashMap) {
        $this.stateMap = persistentHashMap;
    }

    public static final /* synthetic */ Object access$getLock$p(PwaIndexFileStateStorage $this) {
        return $this.lock;
    }

    public static final /* synthetic */ PersistentHashMap access$getGlobalSymbolsMap$p(PwaIndexFileStateStorage $this) {
        return $this.globalSymbolsMap;
    }

    public static final /* synthetic */ void access$setGlobalSymbolsMap$p(PwaIndexFileStateStorage $this, PersistentHashMap persistentHashMap) {
        $this.globalSymbolsMap = persistentHashMap;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/analysis/pwa/storage/indexes/PwaIndexFileStateStorage$Companion;", "", "()V", "CACHE_SIZE_BYTES", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "intellij.pwa.core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

