/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.storage.indexes;

import com.intellij.analysis.pwa.analyser.PwaFileOwnState;
import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.storage.PwaPersistentProblem;
import com.intellij.analysis.pwa.storage.indexes.DeclaredSymbolsHashesListExternalizer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/analysis/pwa/storage/indexes/FileStateExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lcom/intellij/analysis/pwa/analyser/PwaFileOwnState;", "()V", "read", "in", "Ljava/io/DataInput;", "readProblem", "Lcom/intellij/analysis/pwa/storage/PwaPersistentProblem;", "input", "save", "", "out", "Ljava/io/DataOutput;", "value", "writeProblem", "problem", "intellij.pwa.core"})
public final class FileStateExternalizer
implements DataExternalizer<PwaFileOwnState> {
    @NotNull
    public static final FileStateExternalizer INSTANCE;

    public void save(@NotNull DataOutput out, @NotNull PwaFileOwnState value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DataInputOutputUtil.writeSeq((DataOutput)out, (Collection)value.getProblems(), (ThrowableConsumer)new ThrowableConsumer(out){
            final /* synthetic */ DataOutput $out;

            public final void consume(PwaPersistentProblem it) {
                PwaPersistentProblem pwaPersistentProblem = it;
                Intrinsics.checkNotNullExpressionValue((Object)pwaPersistentProblem, (String)"it");
                FileStateExternalizer.access$writeProblem(FileStateExternalizer.INSTANCE, this.$out, pwaPersistentProblem);
            }
            {
                this.$out = dataOutput;
            }
        });
        out.writeInt(value.getModCountAtMomentOfAnalysis());
        out.writeInt(value.getProvidersNameHash());
        out.writeInt(value.getProviderVersionFingerprint());
        DeclaredSymbolsHashesListExternalizer.INSTANCE.save(out, value.getDeclaredSymbols());
    }

    @NotNull
    public PwaFileOwnState read(@NotNull DataInput in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        List list = DataInputOutputUtil.readSeq((DataInput)in, (ThrowableComputable)new ThrowableComputable(in){
            final /* synthetic */ DataInput $in;

            public final PwaPersistentProblem compute() {
                return FileStateExternalizer.access$readProblem(FileStateExternalizer.INSTANCE, this.$in);
            }
            {
                this.$in = dataInput;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"DataInputOutputUtil.read\u2026n`) { readProblem(`in`) }");
        List problems2 = list;
        int modCountAtMomentOfAnalysis = in.readInt();
        int providerNameHash = in.readInt();
        int providerVersionFingerprint = in.readInt();
        SymbolHashesList symbolsHashesList = DeclaredSymbolsHashesListExternalizer.INSTANCE.read(in);
        return new PwaFileOwnState(problems2, symbolsHashesList, modCountAtMomentOfAnalysis, providerNameHash, providerVersionFingerprint);
    }

    private final void writeProblem(DataOutput out, PwaPersistentProblem problem) {
        out.writeUTF(problem.getMessage());
        out.writeInt(problem.getOffset());
    }

    private final PwaPersistentProblem readProblem(DataInput input) {
        String message = input.readUTF();
        int offset = input.readInt();
        String string = message;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message");
        return new PwaPersistentProblem(string, offset);
    }

    private FileStateExternalizer() {
    }

    static {
        FileStateExternalizer fileStateExternalizer;
        INSTANCE = fileStateExternalizer = new FileStateExternalizer();
    }

    public static final /* synthetic */ void access$writeProblem(FileStateExternalizer $this, DataOutput out, PwaPersistentProblem problem) {
        $this.writeProblem(out, problem);
    }

    public static final /* synthetic */ PwaPersistentProblem access$readProblem(FileStateExternalizer $this, DataInput input) {
        return $this.readProblem(input);
    }
}

